#ifndef ARRAY_TYPE_TEST_HH
#define ARRAY_TYPE_TEST_HH

#include <cppunit/TestFixture.h>
#include <cppunit/extensions/HelperMacros.h>
#include <string>
using std::string;

class ArrayTypeInfo;
class ArrayType;

class ArrayTypeTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE( ArrayTypeTest);
  CPPUNIT_TEST( testConcatenation );
  CPPUNIT_TEST( testConstructor );
  CPPUNIT_TEST( testInsertion );
  CPPUNIT_TEST( testAnd );
  CPPUNIT_TEST( testNand );
  CPPUNIT_TEST( testOr );
  CPPUNIT_TEST( testNor );
  CPPUNIT_TEST( testNot );
  CPPUNIT_TEST( testXor );
  CPPUNIT_TEST( testXnor );
  CPPUNIT_TEST( testSLL );
  CPPUNIT_TEST( testSRL );
  CPPUNIT_TEST_SUITE_END();

public:

  void setUp();
  void tearDown();

  void testConstructor();
  void testConcatenation();
  void testInsertion();
  void testConcatenationTwoArrays();
  void testAnd();
  void testNand();
  void testOr();
  void testNor();
  void testNot();
  void testXor();
  void testXnor();
  void testSLL();
  void testSRL();

private:

  static const ArrayTypeInfo *getStringTypeInfo();
  static const ArrayTypeInfo *buildStringTypeInfo();
  static const ArrayTypeInfo *getBV4TypeInfo();
  static const ArrayTypeInfo *buildBV4TypeInfo();

  static ArrayType *initBitArray( const string &initPattern );
  static void initBitArray( ArrayType &toInit, const string &initPattern );

  const ArrayType *allOnes;
  const ArrayType *allZeros;
  const ArrayType *middleOnes;
  const ArrayType *middleZeros;

  static void fillArray( const ArrayType &toFill );
};

#endif
