#ifndef SAVANTBIT_VECTORTYPE_HH
#define SAVANTBIT_VECTORTYPE_HH

//---------------------------------------------------------------------------
// Copyright (c) 1995-1996 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//---------------------------------------------------------------------------

#include "ArrayType.hh"
#include "VectorBase.hh"
#include "standard.hh"

#include "Savantbit_vectorType_event.hh"
#include "Savantbit_vectorType_lastevent.hh"
// VHDL:
//    type bit_vector is array(natural range <>) of bit;
// C++:

extern rangeInfo Savantbit_vectorType_rangeInfo[];
extern arrayTypeInfo Savantbit_vectorType_info;

class Savantbit_vectorType : public ArrayType {
public:
  Savantbit_vectorType() : ArrayType () {}
  Savantbit_vectorType(ObjectBase::ObjectType, const TypeInfo& = TypeInfo::NULL_TYPE_INFO);
  Savantbit_vectorType(ObjectBase::ObjectType objType,int left, ArrayDirn_t dirn, int right, const TypeInfo& = TypeInfo::NULL_TYPE_INFO);
  Savantbit_vectorType(const Savantbit_vectorType &tmp);
  Savantbit_vectorType(ObjectBase::ObjectType objType, int left, ArrayDirn_t dirn, int right, char* value, const TypeInfo& = TypeInfo::NULL_TYPE_INFO);
  Savantbit_vectorType(ObjectBase::ObjectType objType, char* value, const TypeInfo& = TypeInfo::NULL_TYPE_INFO);
  Savantbit_vectorType(ObjectBase::ObjectType objType,int left, ArrayDirn_t dirn, int right, const Savantbit_vectorType &tmp);
  Savantbit_vectorType(ObjectBase::ObjectType objType, const Savantbit_vectorType &value);
  //Constructor for aggregate initialization
  Savantbit_vectorType(ObjectBase::ObjectType objType, 
		   int left, ArrayDirn_t dirn, int right,
		   int noofElmntAssns, ...);
//Constructor for alias initialization
  Savantbit_vectorType(bool alias, ObjectBase::ObjectType objType,
		       int left, ArrayDirn_t dirn, int right, 
		       const ArrayType& actual,
		       const ArrayInfo& boundsOfActual);
  virtual ~Savantbit_vectorType();

  Savantbit_vectorType& getSlice(const ArrayInfo& newBounds);

  VHDLType& operator=(const VHDLType& val);
  Savantbit_vectorType& operator=(const Savantbit_vectorType& val);
  VHDLType& operator=(const char *str);

  VHDLType& operator[](const int) const;
  EnumerationType& operator[](const ScalarType&) const;

  void print(ostream& os) const { object->print(os); }

  const IntegerType LEFT_O(const IntegerType& n) const;
  const IntegerType RIGHT_O(const IntegerType& n) const;
  const IntegerType HIGH_O(const IntegerType& n) const;
  const IntegerType LOW_O(const IntegerType& n) const;
  const IntegerType LENGTH_O(const IntegerType& n) const;
  const EnumerationType ASCENDING_O(const IntegerType& n) const;
};

extern Savantbit_vectorType savantAnd(const Savantbit_vectorType&, 
 				      const Savantbit_vectorType&);
extern Savantbit_vectorType savantOr(const Savantbit_vectorType&, 
				     const Savantbit_vectorType&);
extern Savantbit_vectorType savantNand(const Savantbit_vectorType&, 
 				       const Savantbit_vectorType&);
extern Savantbit_vectorType savantNor(const Savantbit_vectorType&, 
				      const Savantbit_vectorType&);
extern Savantbit_vectorType savantXor(const Savantbit_vectorType&, 
				      const Savantbit_vectorType&);
extern Savantbit_vectorType savantXnor(const Savantbit_vectorType&, 
				       const Savantbit_vectorType&);
extern Savantbit_vectorType savantNot(const Savantbit_vectorType&);

extern Savantbit_vectorType savantSLL(const Savantbit_vectorType&,
				      const IntegerType&);

extern Savantbit_vectorType savantSRL(const Savantbit_vectorType&,
				      const IntegerType&);

extern Savantbit_vectorType savantSLA(const Savantbit_vectorType&,
				      const IntegerType&);

extern Savantbit_vectorType savantSRA(const Savantbit_vectorType&,
				      const IntegerType&);

extern Savantbit_vectorType savantROL(const Savantbit_vectorType&,
				      const IntegerType&);

extern Savantbit_vectorType savantROR(const Savantbit_vectorType&,
				      const IntegerType&);
 
extern EnumerationType savantEqual(const Savantbit_vectorType &, 
				     const Savantbit_vectorType &);
extern EnumerationType savantNotEqual(const Savantbit_vectorType &, 
					const Savantbit_vectorType &);
extern EnumerationType savantLessThan(const Savantbit_vectorType &, 
					const Savantbit_vectorType &);
extern EnumerationType savantLessThanOrEqual(const Savantbit_vectorType &, 
					       const Savantbit_vectorType &);
extern EnumerationType savantGreaterThan(const Savantbit_vectorType &, 
					   const Savantbit_vectorType &);
extern EnumerationType savantGreaterThanOrEqual(const Savantbit_vectorType &,
						 const Savantbit_vectorType &);

extern EnumerationType savantEqual(const Savantbit_vectorType &, char *);
extern EnumerationType savantNotEqual(const Savantbit_vectorType &, char *);

extern Savantbit_vectorType savantConcatenate(const Savantbit_vectorType& lhs, 
					      const Savantbit_vectorType& rhs);
extern Savantbit_vectorType
savantConcatenate(const Savantbit_vectorType& lhs, const EnumerationType& rhs);
extern Savantbit_vectorType
savantConcatenate(const EnumerationType& lhs, const Savantbit_vectorType& rhs);
extern Savantbit_vectorType
savantConcatenate(const EnumerationType& lhs, const EnumerationType& rhs, Savantbit_vectorType*);

extern ostream& operator << (ostream& os, const Savantbit_vectorType& bv);
#endif

