#include "HList.hh"

template <class LType> iterator<LType> iterator<LType>::operator++() {
  ptr = ptr->next;
  return *this;
}

template <class LType> list<LType>::list() {
  head = 0;
  tail = head;
}

template <class LType> list<LType>::~list() {
  listelem<LType> *temp1 = head;
  listelem<LType> *temp2;
  while (temp1 != 0) {
    temp2 = temp1->next;
    delete temp1;
    temp1 = temp2;
  }
}

template <class LType> void list<LType>::insert(LType elem) {
  
  listelem<LType> *temp = new listelem<LType>(elem, head);
  if (head == 0) {
    tail = temp;
  }
  head = temp;

}

template <class LType> bool list<LType>::is_empty() {
  return (head == 0);
}

template <class LType> void list<LType>::dump_list() {
  listelem *temp = head;
  while (temp != 0) {
    temp = temp->next;
  }
}

template <class LType> iterator<LType> list<LType>::begin() {
  return iterator<LType>(head);
}

template <class LType> iterator<LType> list<LType>::end() {
  return iterator<LType>(tail);
} 
