#include "entity_elab.hh"
#include <iostream.h>
#include "VHDLType.hh"
#include "TypeKind.hh"

entity_elab::entity_elab() {
  opFanoutinfo = NULL;
}

entity_elab::~entity_elab() {
  if(opFanoutinfo != NULL) {
    delete []opFanoutinfo;
  }
}

void
entity_elab::instantiate() {
  cerr << "Dynamic Instantiation called for an unbounded component/entity/configuration" << endl;

}

void 
entity_elab::createNetInfo() {
  cerr << "Dynamic Elaboration called for an unbounded component/entity/configuration" << endl;

}

void
entity_elab::connect(int NoofSignals, ...) {
  cerr << "Dynamic Elaboration called for an unbounded component/entity/configuration" << endl;

}

void
entity_elab::Add(VHDLType& val, VHDLType& rhs) {
  //Assumes val and rhs are of same types
  switch(val.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    ((SignalNetinfo*)val.object)->Add((SignalNetinfo*)rhs.object);
    break;
  case ARRAY_TYPE:
    for(int i=0; i<numElems; i++) {
      Add(get_element(i), rhs.get_element(i));
    }
    break;
  case RECORD_TYPE:
    for(int i=0; i <nuberOfFields; i++) {
      Add(get_field(i), rhs.get_field(i));
    }
    break;
  }
}

void
entity_elab::Add(VHDLType& val, SignalNetinfo& sig) {
  switch(val.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    ((SignalNetinfo*)val.object)->Add(sig);
    break;
  case ARRAY_TYPE:
    for(int i=0; i<numElems; i++) {
      Add(get_element(i), sig);
    }
    break;
  case RECORD_TYPE:
    for(int i=0; i <nuberOfFields; i++) {
      Add(get_field(i), sig);
    }
    break;
  }
}

void
entity_elab::Add(VHDLType& val, int objid) {
  switch(val.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    ((SignalNetinfo*)val.object)->Add(objid);
    break;
  case ARRAY_TYPE:
    for(int i=0; i<numElems; i++) {
      Add(get_element(i), objid);
    }
    break;
  case RECORD_TYPE:
    for(int i=0; i <nuberOfFields; i++) {
      Add(get_field(i), objid);
    }
    break;
  }
}


void
entity_elab::Add(VHDLType& val, int objid, int sigid) {
  switch(val.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    ((SignalNetinfo*)val.object)->Add(objid, sigid);
    break;
  case ARRAY_TYPE:
    for(int i=0; i<numElems; i++) {
      Add(get_element(i), objid, sigid);
    }
    break;
  case RECORD_TYPE:
    for(int i=0; i <nuberOfFields; i++) {
      Add(get_field(i), objid, sigid);
    }
    break;
  }
}


void
entity_elab::Add(VHDLType& val, SignalNetinfo* ptr) {
  switch(val.get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    ((SignalNetinfo*)val.object)->Add(ptr);
    break;
  case ARRAY_TYPE:
    for(int i=0; i<numElems; i++) {
      Add(get_element(i), ptr);
    }
    break;
  case RECORD_TYPE:
    for(int i=0; i <nuberOfFields; i++) {
      Add(get_field(i), ptr);
    }
    break;
  }
}

