//---------------------------------------------------------------------------
// Copyright (c) 1995 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.


//
// $Id: Wait.cc,v 1.18 1999/03/09 22:52:25 dmartin Exp $
//
//---------------------------------------------------------------------------

#include "Wait.hh"
#include "SignalBase.hh"
#include "VHDLKernelBase.hh"

bool
defaultWaitCond(VHDLKernelBase*) {
  return true;
}


PhysicalType
defaultWaitTimeout(VHDLKernelBase*) {
  return PhysicalType(ObjectBase::VARIABLE, UniversalLongLongInteger(PINFINITY.time), SavanttimeType_info);
}


Wait&
Wait::operator=(const Wait &rhs) {
  sensSize = rhs.sensSize;
  sensList = rhs.sensList;
  cond     = rhs.cond;
  timeout  = rhs.timeout;

  return *this;
}

bool
Wait::sensitiveTo(int sigid) {
  register int i;
  bool retval = false;

  for (i = 0; i < sensSize; i++) {
    retval = INT_TO_BOOL(retval || isSensitive(sigid,sensList[i]));
  }
  return retval;
}

bool
Wait::isSensitive(int sigid, ScalarType* signal) {
  int id = ((SignalBase*)(signal->object))->id;
  return INT_TO_BOOL(id == sigid); 
}

bool
Wait::isSensitive(int sigid, VectorBase* signal) {
  bool retval = false;
  int noOfElements = signal->numElems;
  for(int i=0; i < noOfElements; i++) {
    retval = INT_TO_BOOL(retval || isSensitive(sigid,(VHDLType*)&(signal->get_element(i))));
  }
  return retval; 
}

bool
Wait::isSensitive(int sigid, RecordType* signal) {
  bool retval = false;
  int noOfElements = signal->numberOfFields;
  for(int i=1; i <= noOfElements; i++) {
    retval = INT_TO_BOOL(retval || isSensitive(sigid,(VHDLType*)&(signal->get_field(i))));
  }
  return retval; 
}

bool
Wait::isSensitive(int sigid, VHDLType* signal) {
  bool retval = false;
  switch(signal->get_kind()) {
  case INTEGER_TYPE:
  case REAL_TYPE:
  case ENUMERATION_TYPE:
  case PHYSICAL_TYPE:
    retval = isSensitive(sigid,(ScalarType*)signal);
    break;
  case ARRAY_TYPE:
    retval = isSensitive(sigid,(VectorBase*)((ArrayType*)signal)->object);
    break;
  case RECORD_TYPE:
    retval = isSensitive(sigid,(RecordType*)signal);
    break;
  case VECTOR_BASE:
    retval = isSensitive(sigid,(VectorBase*)signal);
    break;
  default:
    cerr << "Unknowm Type, System Abborted" << endl;
    abort();
  }
  return retval;
}

void
Wait::print(ostream& os) const {
  if (sensSize > 0) {
    os << " signals: ";
    for (register int i = 0; i < sensSize; i++) {
      os << sensList[i] << endl;
      sensList[i]->print(os);
    }
  }
  else {
    os << "(empty senslist)";
  }
}
