//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef BLOCK_HH
#define BLOCK_HH
#include <string.h>
#include "bool.hh"

//This indexes the elements from zero. Be careful while indexing it. Start from
// zero.
class Block {
public:
  Block(int blkFactor = 32);
  ~Block();

  void* getElement(const int index);
  void* operator [](const int index);
  void addElement(void* newElement);
  void removeElement(const int index);
  int getNumberOfElements() const;
  void reset();
  Block& operator=(const Block &);
  
private:

  //The array pointer pointing to Valid Location
  void** expandableArray;

  //The number of Elements that are Valid
  //The size of the block may be more than that
  int numberOfElements;

  //The actual size of the Allocated block
  int size;

  //The block factor for the array
  int blockFactor;

  bool find(void*);
};

#endif


