#ifndef CATWIDS_INCLUDED
#define CATWIDS_INCLUDED

#include "GUI.h"
#include <Xm/PanedW.h>
#include <Xm/RowColumn.h>
#include <Xm/ScrollBar.h>
#include <Xm/CascadeBG.h>

class Cat 
{
private:
    Widget dialogform, mainform, masterform;
    Widget catModeForm;
    Widget rxMode[2], txMode[2];  // TODO: dynamic
    Widget catmodeRX, catmodeTX, catmodeSetup;
    Widget rightform;
    Widget frequencyForm, pluginForm, modeinfoForm;
    Widget pText1, pText2;
    Widget fText1, fText1b, fText2, fText2b, fText3, fText4;
    Widget fText5, fText5a, fText5b;
    Widget iText1, iText1a, iText1b, iText2, iText2a, iText2b;
    Widget sep, sep1, sep2;
    const static int BANDS=10;
    Widget bandRB, bandwids[BANDS];
    Widget freqScroll;

    void buildTitleWidget(Widget shell, AppRes *appRes);
    void buildFreqWidget(Widget shell, AppRes *appRes);
    void buildModeWidget(Widget shell, AppRes *appRes);
    void buildInfoWidget(Widget shell, AppRes *appRes);
    void setWidgetText(Widget w, char *t) {
	XmString xs = XmStringCreateSimple(t);
	XtVaSetValues(w, XmNlabelString, xs, NULL);
	XmStringFree(xs);
    }
    void setModeInfoText(char *t1, char *t2, Widget w1, Widget w2) {
	setWidgetText(w1, t1);
	setWidgetText(w2, t2);
    }
	
public:
    void buildWidgets(Widget shell, AppRes *appRes);
    void setPluginInfoText(char *text) {
	setWidgetText(pText2, text);
    }
    void setStatusInfoText(char *t1, char *t2) {
	setWidgetText(fText5a, t1);
	setWidgetText(fText5b, t2);
    }
    void setRXModeInfoText(char *t1, char *t2) {
	setModeInfoText(t1, t2, iText1a, iText1b);
    }
    void setTXModeInfoText(char *t1, char *t2) {
	setModeInfoText(t1, t2, iText2a, iText2b);
    }
};

#endif
