<?php	// TWIG		Module Framework Processor ?>
<?php
 // These 6 lines allow TWIG to operate with register_globals off
 @extract($_SERVER,EXTR_SKIP);
 @extract($_SESSION,EXTR_SKIP);
 @extract($_COOKIE,EXTR_SKIP);
 @extract($_POST,EXTR_SKIP);
 @extract($_GET,EXTR_SKIP);
 @extract($_FILES,EXTR_OVERWRITE);

 Function getmicrotime()
	{
 	$mtime = microtime();
 	$mtime = explode( " ", $mtime );
 	$mtime = $mtime[1] + $mtime[0];
 	return( $mtime );
	}

 $ts1 = getmicrotime();

 $config_dir = "config/";
 $version = "2.8.3";
 $config = array();
 $dbconfig = array();
 $vhosts = array();
 $img = array();

 if(!ereg("/$", $config_dir)) {$config_dir .= "/";}

 // Load the config options
 require( $config_dir . "config.inc.php3" );	// Global Configuration Variables

 // Load the image source files
 require( $config_dir . "images.inc.php3" );

 // Load the database config file
 require( $config_dir . "dbconfig.inc.php3" );

 // Load virtual host configuration files if they exist
 if( isset($vhosts[$SERVER_NAME] ) )
	{
	if( !ereg("/$",$vhosts[$SERVER_NAME]) ) {$vhosts[$SERVER_NAME] .= "/";}
	if( is_readable( $vhosts[$SERVER_NAME] . "config.inc.php3" ) ) { include( $vhosts[$SERVER_NAME] . "config.inc.php3" ); }
	if( is_readable( $vhosts[$SERVER_NAME] . "dbconfig.inc.php3" ) ) { include( $vhosts[$SERVER_NAME] . "dbconfig.inc.php3" ); }
	if( is_readable( $vhosts[$SERVER_NAME] . "images.inc.php3" ) ) { include( $vhosts[$SERVER_NAME] . "images.inc.php3" ); }
 	}

 // Redirect from http to https if required
 if ( $config["use_https"] == 1 )
	{
	if ( $_SERVER["SERVER_PORT"] == 80 )
		{
		Header("Location: https://" . $_SERVER["SERVER_NAME"] . $_SERVER["REQUEST_URI"]);
		exit;
		}
 	}

 // Set up database
 if( !$dbconfig["sqltype"] ) { $dbconfig["sqltype"] = "mysql"; }
 require( "lib/db/" . $dbconfig["sqltype"] . ".db.inc.php3" );

 if( !$config["imap_servertype"] ) { $config["imap_servertype"] = "php-imap"; }

 // See if imap path has trailing folder delimiter and add it if needed
 if( $config["imap_path"] && !ereg( $config["mail_folder_delimiter"] . "\$", $config["imap_path"] ) ) { $config["imap_path"] .= $config["mail_folder_delimiter"]; }

 require( "lib/mail/" . $config["imap_servertype"] . ".inc.php3" );	// include the mail subsystem

 require( "lib/auth/" . $config["auth"] . ".inc.php3" );		// include the auth system...

 if( !$config["default_feature"] ) { $config["default_feature"] = "main"; }

 // The php4session session handler should not be used--change it if set
 if( !isset($config["session_handler"]) || ($config["session_handler"] == "php4session") ) {$config["session_handler"] = "get2";}
 require( "lib/session/" . $config["session_handler"] . ".session.php3" );	// include the session data handler...

 require( "lib/login/" . $config["login_handler"] . ".login.php3" );	// include the login data handler...
 require( "features/common.inc.php3" );					// include common functions...
 require( "lib/security/" . $config["security"] . ".inc.php3" );	// include security system...

 // Load the prefs code.
 require( "features/shared/prefs.inc.php3" );

 // Set default URL paths
 $config["baseurl"] = $config["basedir"] . "/" . $config["index"];

 // Set default IMAP parameters
 if( !$config["imap_server"] ) { $config["imap_server"] = "localhost"; }
 if( !$config["imap_port"] ) { $config["imap_port"] = "143"; }

 // Tell browsers not to cache us.  The if is a hack to get around a problem in IE, I hate this hack but see no other way
 if( !isset( $attachment ) )
	{
	Header( "Cache-Control: no-cache, must-revalidate" );
	Header( "Pragma: no-cache" );
	Header( "Expires: Tue, Jan 12 1999 01:01:01 GMT" );
	}

 $context = TWIGGetContext();
 $session = TWIGGetSession();
 $login = TWIGGetLogin();

 if( isset( $GoToFeature ) ) { TWIGGoToFeature( $GoToFeature ); parse_str( $context["options"] ); }
 if( isset( $newmailbox ) ) { $session["mailbox"] = $newmailbox; }

 $mbox = TWIGAuth( "TWIG", $logout );

 // Load defaults
 require( $config_dir . "defaults.inc.php3" );
 if( isset( $vhosts[$SERVER_NAME] ) && is_readable( $vhosts[$SERVER_NAME] . "defaults.inc.php3" ) ) { include( $vhosts[$SERVER_NAME] . "defaults.inc.php3" ); }

 // Find out what the preferred language is...
 $config["language"] = GetPref( "language", $dbconfig["global_prefs_table"], $config["defaults"]["global"]["language"] );
 // ...then load the current feature's language strings and the global language strings
 TWIGLoadLanguageFile( "features/" . $context["feature"] . "/strings/", "", $config["language"] );
 TWIGLoadLanguageFile( "lib/strings/", "", $config["language"] );

// -------------------- This section allows TWIG to be invoked from a mailto link
if (isset($_GET["mailto"]) or isset($_GET["to"])) // Get the mailto information from the URL
	{
	if (isset($_GET["to"]))
		{ $to = $_GET["to"]; }
	else
		{
		$to=$_GET["mailto"];
		}
	$subject = $_GET["subject"];
	$cc = $_GET["cc"];
	$bcc = $_GET["bcc"];
	$body = $_GET["body"];
	}
else if (isset($_POST["to"])) // Get the mailto information from the login form
	{
	$to = $_POST["to"];
	$subject = $_POST["subject"];
	$cc = $_POST["cc"];
	$bcc = $_POST["bcc"];
	$body = $_POST["body"];
	}

if (isset ( $to ))
	{
	$context["feature"] = "mail";
	$context["action"] = "compose";
	$form["to"] = $to;
	$form["cc"] = $cc;
	$form["bcc"] = $bcc;
	$form["subject"] = str_replace ("%20", " ", $subject);
	$form["body"] = str_replace ("%20", " ", $body);
	if (strpos($to, "?")) // This is to work with IE because it puts everything on one line
		{
		$parts = explode("?", $to);
		foreach ($parts as $part)
			{
			if (strtolower(substr($part,0,7)) == "mailto:") { $form["to"]=substr(strrchr($part, ":"), 1); }
			if (strtolower(substr($part,0,3)) == "cc=") { $form["cc"]=substr(strrchr($part, "="), 1); }
			if (strtolower(substr($part,0,4)) == "bcc=") { $form["bcc"]=substr(strrchr($part, "="), 1); }
			if (strtolower(substr($part,0,8)) == "subject=") { $form["subject"]=substr(strrchr($part, "="), 1); }
			if (strtolower(substr($part,0,5)) == "body=") { $form["body"]=substr(strrchr($part, "="), 1); }
			}
		}
	}
// --------------------

 // What's this for? Something important we hope...
 $sorted[0] = 1;

 // Set group info
 if( !isset( $config["groups"] ) ) { $config["groups"] = "standard"; }
 require( "lib/groups/" . $config["groups"] . ".groups.inc.php3" );

 // Load the pre-output feature include. Note that for the output of attachments
 // this include may change the header and call exit() at the end, meaning no further output happens
 require( "features/" . $context["feature"] . "/" . $context["feature"] . ".inc.php3" );

 // Load the main menu
 if( isset($vhosts[$SERVER_NAME] ) && is_readable( $vhosts[$SERVER_NAME] . "mainmenu.inc.php3") )
	{
	include( $vhosts[$SERVER_NAME] . "mainmenu.inc.php3");
 	}
 else
	{
	include( $config_dir . "mainmenu.inc.php3" );
	}

 // ----- Output begins here ------

 // Opening <HTML> tag located in config/header.inc.php3

 if( isset( $vhosts[$SERVER_NAME] ) && is_readable($vhosts[$SERVER_NAME] . "header.inc.php3") ) {include($vhosts[$SERVER_NAME] . "header.inc.php3");}
 else {include($config_dir . "header.inc.php3");}

 require( "features/" . $context["feature"] . "/" . $context["feature"] . ".feature.php3" );
 flush();

 TWIGDebug( "Page output time - " . ( getmicrotime() - $ts1 ) );

 if( !$TWIGNoFooter )
   {
   if( isset( $vhosts[$SERVER_NAME] ) && is_readable($vhosts[$SERVER_NAME] . "footer.inc.php3") ) {include($vhosts[$SERVER_NAME] . "footer.inc.php3");}
   else {include($config_dir . "footer.inc.php3");}
   }

 TWIGCloseMB( $mbox );

 // Closing </HTML> tag located in config/footer.inc.php3
?>
