<?php

	Function TWIGMailGetFrom()
		{
		GLOBAL $config, $dbconfig, $login;

		if( TWIGCheckACL( $login["username"], 4014, TWIGConvertAccess( "read" ) ) )
			{
			$from = stripslashes( GetPref( "fromaddress", $dbconfig["prefs_table"], $config["defaults"]["mail"]["fromaddress"] ) );
			$from =  str_replace( "\n", "", $from );

			if( !$from ) { $from = $config["defaults"]["mail"]["fromaddress"]; }
			}
		else
			{ 
			$from = $config["defaults"]["mail"]["fromaddress"]; 
			}

		return $from;
		}

	Function TWIGMailDuplicateAddressCheck( $alist )
		{
		$addresses = imap_rfc822_parse_adrlist( $alist, "" );

		for( $i = 0, $j = count( $addresses ); $i < $j; $i++ )
			{
			$emaila = $addresses[$i]->mailbox . "@" . $addresses[$i]->host;

			if( !$found[$emaila] )
				{
				$found[$emaila] = 1;
				if( $out ) { $out .= ", "; }
				if( $addresses[$i]->personal ) { $out .= "\"" . $addresses[$i]->personal . "\" "; }
				$out .= "<" . $emaila . ">";
				}
			}

		return $out;		
		}
	
 	Function TWIGCloseMB( $mbox ) 
		{
		TWIGDebug( "TWIGCloseMB( \"$mbox\" );" );
		if( $mbox ) { imap_close( $mbox ); }
		}

 	// Open a mailbox without a lot of hassle
 	Function TWIGOpenMB( $mailbox, $oldmbox = FALSE) 
		{
  		global $session, $config, $login;
  		
		TWIGDebug( "TWIGOpenMB( \"" . $mailbox . "\", \"" . $oldmbox . "\" );" );

		if( CheckMBType( MailboxDecode( $mailbox ) ) > 0 ) { $mailbox = "INBOX"; }

  		if( !$config["imap_server"] ) { $config["imap_server"] = "localhost"; }
  		if( !$config["imap_port"] ) { $config["imap_port"] = "143"; }

		if( $oldmbox != FALSE )
			{
			TWIGDebug( "TWIGOpenMB() - MB Already open" );
			$mbox = $oldmbox;
			}
		else
			{
			TWIGDebug( "TWIGOpenMB( \"" . "{" . $config["imap_server"] . ":" . $config["imap_port"] . "}" . $mailbox . "\")" );
	  		$mbox = @imap_open( "{" . $config["imap_server"] . ":" . $config["imap_port"] . "}" . $mailbox, $login["username"], $login["password"] );
			}

  		return $mbox;
 		}

	Function TWIGMailOpenMailbox( $mailbox, $user, $password, $options )
		{
		return imap_open( $mailbox, $user, $password, $options );
		}

	Function TWIGCheckNewMail( $mbox ) 
		{
		TWIGDebug( "TWIGCheckNewMail( \"" . $mbox . "\" );" );
		$check = imap_check( $mbox );

		return $check->Recent;
	 	}

	Function TWIGGetMessageCount( $mbox ) 
		{
		TWIGDebug( "TWIGGetMessageCount( \"" . $mbox . "\" );" );

	  	$check = imap_check( $mbox );
  		return $check->Nmsgs;
	 	}

 	Function MailboxDecode( $mb, $strip = "" ) 
		{ 
  		GLOBAL $config;

  		$mb = str_replace( "!", "/", $mb);

  		if( $strip )
			{
    			return ereg_replace( "^$config[imap_path]", "", $mb );
  			}
  		else 
			{
    			return $mb;
  			}
 		}

 	Function MailboxEncode( $mb ) 
		{ 
		return str_replace( "/", "!", $mb ); 
		}

 	//Check to see what type of mailbox we have, 0 imap, 1 news 2 pop3
 	Function CheckMBType($str) 
		{
   		if( strstr( $str, "/nntp" ) ) { return 1; }
   		else { if( strstr( $str, "/pop3" ) ) { return 2; } 
   		else { return 0; } }
   		}

	Function TWIGMailFetchStructure( $mailbox, $message )
		{
		return imap_fetchstructure( $mailbox, $message );
		}

	Function TWIGMailFetchBody( $mailbox, $message, $section )
		{
		return imap_fetchbody( $mailbox, $message, $section );
		}
	
	Function TWIGMailBoxCheck( $mailbox )
		{
		return imap_check( $mailbox );
		}

	Function TWIGMailCopy( $mailbox, $message, $destination )
		{
		if( imap_mail_copy( $mailbox, $message, $destination ) ) { return TRUE; }
		else
			{
   			TWIGMailCreateFolder( $mailbox, $destination );
			return imap_mail_copy( $mailbox, $message, $destination );
			}
		}

	Function TWIGMailMove( $mailbox, $message, $destination )
		{
		if( imap_mail_move( $mailbox, $message, $destination ) ) { return TRUE; }
		else
			{
   			TWIGMailCreateFolder( $mailbox, $destination );
			return imap_mail_move( $mailbox, $message, $destination );
			}
		}
		
	Function TWIGMailDelete( $mailbox, $item )
		{
		return imap_delete( $mailbox, $item ); 
		}

	Function TWIGMailSubscribedFolders( $mailbox, $path, $filter )
		{
		GLOBAL $config;

		$tempsubscribed = imap_listsubscribed( $mailbox, $path, $filter );
		@usort($tempsubscribed, strcasecmp);
		$subscribed[0] = TWIGMailGetFolderString($config["imap_server"], $config["imap_port"], "", "INBOX");
		for( $i=0, $j=count($tempsubscribed); $i<$j; ++$i )
			{
			if( TWIGMailGetDisplayName( $tempsubscribed[$i] ) != TWIGMailGetDisplayName($subscribed[0]) ) { $subscribed[] = $tempsubscribed[$i]; }
			}
		return $subscribed;
		}

	Function TWIGMailEmptyTrash( $mailbox )
		{
		return imap_expunge( $mailbox );
		}

	Function TWIGMailGetSortedList( $mailbox, $sortedby, $sorteddirection )
		{
		return imap_sort( $mailbox, $sortedby, $sorteddirection );
		}

	Function TWIGMailCreateFolder( $mailbox, $folder )
		{
		$folder = TWIGMailUTF7Encode( $folder );
		if( imap_createmailbox( $mailbox, $folder ) )
			{
			imap_subscribe( $mailbox, $folder );
			return TRUE;
			}
		else { return FALSE; }
		}

	Function TWIGMailSubscribeFolder( $mailbox, $folder )
		{
	  	return imap_subscribe( $mailbox, $folder );
		}
	
	Function TWIGMailUnSubscribeFolder( $mailbox, $folder )
		{
    		return imap_unsubscribe( $mailbox, $folder );
		}

	Function TWIGMailDeleteFolder( $mailbox, $folder )
		{
    		return imap_deletemailbox( $mailbox, $folder );
		}

	Function TWIGMailRenameFolder( $mailbox, $folder, $newname )
		{
		return imap_renamemailbox( $mailbox, $folder, TWIGMailUTF7Encode( $newname ) );	
		}

	Function TWIGMailFolderList( $mailbox, $startingfolder, $filter )
		{
		GLOBAL $config;

		$tempfolders = imap_listmailbox( $mailbox, $startingfolder, $filter );
		@usort($tempfolders, strcasecmp);
		$folders[0] = TWIGMailGetFolderString($config["imap_server"], $config["imap_port"], "", "INBOX");
		for( $i=0, $j=count($tempfolders); $i<$j; ++$i )
			{
			if( TWIGMailGetDisplayName( $tempfolders[$i] ) != TWIGMailGetDisplayName($folders[0]) ) { $folders[] = $tempfolders[$i]; }
			}
		return $folders;
		}

	Function TWIGMailFolderInfo( $mailbox )
		{
		return imap_mailboxmsginfo( $mailbox );
		}

	Function TWIGMailHeader( $mailbox, $message, $fromlength, $subjectlength, $defaultdomain )
		{
		return imap_header( $mailbox, $message, $fromlength, $subjectlength, $defaultdomain );
		}

	Function TWIGMailSetMessageFlag( $mailbox, $message, $flag )
		{
		return imap_setflag_full( $mailbox, $message, $flag );
		}

	Function TWIGMailUnSetMessageFlag( $mailbox, $message, $flag )
		{
		return imap_clearflag_full( $mailbox, $message, $flag );
		}

	Function TWIGMailAppendMessage( $mailbox, $folder, $message, $flags )
		{
		if( imap_append( $mailbox, $folder, $message, $flags ) ) { return TRUE; }
		else
			{
   			imap_createmailbox( $mailbox, $folder );
			return imap_append( $mailbox, $folder, $message, $flags );
			}
		}

	Function TWIGMailUndelete( $mailbox, $message )
		{
		return imap_undelete( $mailbox, $message ); 
		}

	Function TWIGMailFetchHeader( $mailbox, $message )
		{
		return imap_fetchheader( $mailbox, $message );
		}

	Function TWIGMailParseAddresssList( $list, $defaultdomain )
		{		
		return imap_rfc822_parse_adrlist( $list, $defaultdomain );
		}

	Function TWIGMailDecodeBase64( $text )
		{
		return imap_base64( $text );
		}

	Function TWIGMailDecodeQuotedPrintable( $text )
		{
		// Strip out the 76th character MIME wrap and decode
		return quoted_printable_decode( str_replace( "=\r\n", "", $text ) );
		}

	Function TWIGMailGetFolderString( $server, $port, $type, $folder, $user = "", $pass = "" )
		{
		return "{" . $server . $type . ":" . $port . "}" . TWIGProcessGPCString( $folder );
		}

	Function TWIGMailParseFolderString( $FolderString )
		{
    		$foldersplit = explode( "}", $FolderString );
		if( count( $foldersplit ) > 1 ) { $mbfolder = $foldersplit[1]; }

		$portsplit = explode( ":", $foldersplit[0] );
		if( count( $portsplit ) > 1 ) { $mbport = $portsplit[1]; }
			
		$typesplit = explode( "/", $portsplit[0] );
		if( count( $typesplit ) > 1 ) { $mbtype = $typesplit[1]; }

		$serversplit = explode( "{", $typesplit[0] );
		if( count( $serversplit ) > 1 ) { $mbserver = $serversplit[1]; }

		return array( $mbserver, $mbport, $mbtype, $mbfolder, $mbuser, $mbpass );
		}

	Function TWIGMailGetDisplayName( $Folder )
		{
		GLOBAL $config;

      		return ereg_replace( "^" . $config["imap_path"], "", TWIGMailUTF7Decode( $Folder ) );
		}

	Function TWIGMailSearch( $mailbox, $criteria, $flags = "" )
		{
		// Valid values for flags are SE_UID, which causes the returned array to contain UIDs instead of
		// messages sequence numbers.
      		return imap_search( $mailbox, $criteria, $flags );
		}

	Function TWIGMailMIMEHeaderDecode( $text )
		{
		// This function only exists in 3.0.17 and higher
		if( function_exists( 'imap_mime_header_decode' ) )
			{
			$decoded = imap_mime_header_decode( $text );
			$text = "";
			while( list( $key, $val ) = each( $decoded ) )
				{
				$text .= $val->text;
				}
			}
		return( $text );
		}

	Function TWIGMailUTF7Decode( $text )
		{
		// This function only exists in 3.0.15 and higher
		if( function_exists( 'imap_utf7_decode' ) )
			{
			$text = imap_utf7_decode( $text );
			}
		return( $text );
		}

	Function TWIGMailUTF7Encode( $text )
		{
		// This function only exists in 3.0.15 and higher
		if( function_exists( 'imap_utf7_encode' ) )
			{
			$text = imap_utf7_encode( $text );
			}
		return( $text );
		}

?>
