/*
	TuxPuck - player.h
	Copyright (C) 2001-2002 Jacob Kroon

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

	Jacob Kroon - d00jkr@efd.lth.se
*/

#ifndef _PLAYER_H
#define _PLAYER_H

/* includes */
#include <SDL_video.h>
#include "entity.h"

/* defines */
#define PLAYER_STATE_IDLE		1
#define PLAYER_STATE_SERVE		2
#define PLAYER_STATE_AIM		3
#define PLAYER_STATE_HIT		4
#define PLAYER_STATE_BACKUP		5
#define PLAYER_STATE_WIN_POINT		6
#define PLAYER_STATE_LOOSE_POINT	7
#define PLAYER_STATE_WIN_GAME		8
#define PLAYER_STATE_LOOSE_GAME		9

/* structs */
typedef struct _HumanPlayer HumanPlayer;
typedef struct _AIPlayer AIPlayer;
typedef struct _Strategy Strategy;

struct _Strategy
{
  void (*idle) (AIPlayer *, Uint32);
  void (*serve) (AIPlayer *, Uint32);
  void (*backup) (AIPlayer *, Uint32);
  void (*aim) (AIPlayer *, Uint32);
  void (*hit) (AIPlayer *, Uint32);
};

struct _AIPlayer
{
  char *name;
  SDL_Surface *sdl_image;
  SDL_Rect rect;
  Pad *pad;
  Puck *puck;
  float speed, hit_power;
  Uint8 state, points;
  void (*free) (AIPlayer *);
    Uint8(*reblit) (AIPlayer *, Uint32);
  void (*set_state) (AIPlayer *, Uint8);
    Uint8(*ready) (void);
  Strategy strategy;
};

/* functions */
HumanPlayer *human_create(Pad *, char *);
void human_free(HumanPlayer *);
void human_set_speed(HumanPlayer *, Uint8);
void human_give_point(HumanPlayer *);
Uint8 human_get_points(HumanPlayer *);
void human_update(HumanPlayer *, Uint32);
void aiplayer_blit(AIPlayer *);
void aiplayer_erase(AIPlayer *);
void aiplayer_update(AIPlayer *, Uint32);
void aiplayer_set_alpha(AIPlayer *, Uint8);

/* dumb strategy */
void dumb_idle(AIPlayer *, Uint32);
void dumb_serve(AIPlayer *, Uint32);
void dumb_backup(AIPlayer *, Uint32);
void dumb_aim(AIPlayer *, Uint32);
void dumb_hit(AIPlayer *, Uint32);

#endif /* _PLAYER_H */
