# vim: noai et ts=4 tw=0

!define PKG_DATE        "2004.09.27"
!define PKG_PREFIX      "tuxpaint-stamps"

!define MAIN_APP_TITLE  "TuxPaint"
!define APP_TITLE       "TuxPaint-Stamps"
!define APP_EXE         "${APP_TITLE}.exe"

SetCompressor   lzma
OutFile     "${PKG_PREFIX}-${PKG_DATE}-win32-installer.exe"
Name        "${APP_TITLE}"
Caption     ""
CRCCheck    on
WindowIcon  off
BGGradient  off
Icon        "tuxpaint-installer.ico"

# Default to not silent
SilentInstall   normal
SilentUnInstall normal

# Various default text options
MiscButtonText
InstallButtonText
FileErrorText

# Default installation dir and registry key of install directory
InstallDir  "$PROGRAMFILES\${MAIN_APP_TITLE}"
InstallDirRegKey HKLM SOFTWARE\${MAIN_APP_TITLE} "Install_Dir"

# Licence text
LicenseText "You must agree to this license before installing ${APP_TITLE}"
LicenseData "../docs/copying.txt"

# Directory browsing
DirText             "Choose a directory to install ${APP_TITLE} in to:"
AllowRootDirInstall false

# Install page stuff
InstProgressFlags   smooth
AutoCloseWindow     true

Section
!include "filelist.inc"
SectionEnd

Function .onInit
  ReadRegStr $0 HKLM SOFTWARE\${MAIN_APP_TITLE} "Install_Dir"
  StrCmp $0 "" 0 NoAbort
    MessageBox MB_OK "Please install ${MAIN_APP_TITLE} first, then run this installer again."
    Abort ; causes installer to quit.
  NoAbort:
FunctionEnd

