/*
 * Decompiled with CFR 0.152.
 */
package jargs.test.gnu;

import jargs.gnu.CmdLineParser;
import java.util.Locale;
import junit.framework.TestCase;

public class CmdLineParserTestCase
extends TestCase {
    public CmdLineParserTestCase(String name) {
        super(name);
    }

    public void testStandardOptions() throws Exception {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option verbose = parser.addBooleanOption('v', "verbose");
        CmdLineParser.Option size = parser.addIntegerOption('s', "size");
        CmdLineParser.Option name = parser.addStringOption('n', "name");
        CmdLineParser.Option fraction = parser.addDoubleOption('f', "fraction");
        CmdLineParser.Option missing = parser.addBooleanOption('m', "missing");
        CmdLineParser.Option careful = parser.addBooleanOption("careful");
        CmdLineParser.Option bignum = parser.addLongOption('b', "bignum");
        CmdLineParserTestCase.assertEquals(null, (Object)parser.getOptionValue(size));
        Long longValue = new Long(new Long(Integer.MAX_VALUE) + 1L);
        parser.parse(new String[]{"-v", "--size=100", "-b", longValue.toString(), "-n", "foo", "-f", "0.1", "rest"}, Locale.US);
        CmdLineParserTestCase.assertEquals(null, (Object)parser.getOptionValue(missing));
        CmdLineParserTestCase.assertEquals((Object)Boolean.TRUE, (Object)parser.getOptionValue(verbose));
        CmdLineParserTestCase.assertEquals((int)100, (int)((Integer)parser.getOptionValue(size)));
        CmdLineParserTestCase.assertEquals((Object)"foo", (Object)parser.getOptionValue(name));
        CmdLineParserTestCase.assertEquals((Object)longValue, (Object)parser.getOptionValue(bignum));
        CmdLineParserTestCase.assertEquals((double)0.1, (double)((Double)parser.getOptionValue(fraction)), (double)1.0E-7);
        String[] otherArgs = parser.getRemainingArgs();
        CmdLineParserTestCase.assertEquals((int)1, (int)otherArgs.length);
        CmdLineParserTestCase.assertEquals((String)"rest", (String)otherArgs[0]);
    }

    public void testBadFormat() throws Exception {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option size = parser.addIntegerOption('s', "size");
        try {
            parser.parse(new String[]{"--size=blah"});
            CmdLineParserTestCase.fail((String)"Expected IllegalOptionValueException");
        }
        catch (CmdLineParser.IllegalOptionValueException illegalOptionValueException) {
            // empty catch block
        }
    }

    public void testResetBetweenParse() throws Exception {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option verbose = parser.addBooleanOption('v', "verbose");
        parser.parse(new String[]{"-v"});
        CmdLineParserTestCase.assertEquals((Object)Boolean.TRUE, (Object)parser.getOptionValue(verbose));
        parser.parse(new String[0]);
        CmdLineParserTestCase.assertEquals(null, (Object)parser.getOptionValue(verbose));
    }

    public void testLocale() throws Exception {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option fraction = parser.addDoubleOption('f', "fraction");
        parser.parse(new String[]{"--fraction=0.2"}, Locale.US);
        CmdLineParserTestCase.assertEquals((double)0.2, (double)((Double)parser.getOptionValue(fraction)), (double)1.0E-7);
        parser.parse(new String[]{"--fraction=0,2"}, Locale.GERMANY);
        CmdLineParserTestCase.assertEquals((double)0.2, (double)((Double)parser.getOptionValue(fraction)), (double)1.0E-7);
    }

    public void testDetachedOption() throws Exception {
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option.BooleanOption detached = new CmdLineParser.Option.BooleanOption('v', "verbose");
        CmdLineParserTestCase.assertEquals(null, (Object)parser.getOptionValue(detached));
        try {
            parser.parse(new String[]{"-v"});
            CmdLineParserTestCase.fail((String)"UnknownOptionException expected");
        }
        catch (CmdLineParser.UnknownOptionException unknownOptionException) {
            // empty catch block
        }
        CmdLineParserTestCase.assertEquals(null, (Object)parser.getOptionValue(detached));
    }
}

