//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef Tulip_RENDERINGPARAMETERSDIALOG_H
#define Tulip_RENDERINGPARAMETERSDIALOG_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <tulip/tulipconf.h>

#include "tulip/RenderingParametersDialogData.h"

#include <QtGui/QTreeWidgetItem>

namespace tlp {

  class GlScene;
  class GlLayer;
  class GlComposite;
  class GlGraphComposite;
  class GlMainView;
  class GlMainWidget;

  class TLP_QT_SCOPE RenderingParametersDialog : public QDialog, public Ui::RenderingParametersDialogData {
    Q_OBJECT

    GlMainView *mainView;
    GlMainWidget* observedMainWidget;
    bool holdUpdateView;

  public:
    RenderingParametersDialog(QWidget* parent);
    void windowActivationChange(bool oldActive);

    void setGlMainView(GlMainView *view);
    void attachMainWidget(GlMainWidget *graphWidget);

    void addLayer(tlp::GlScene*, const std::string&, tlp::GlLayer*);
    void addComposite(tlp::GlComposite *composite,QTreeWidgetItem *parent);
    void createGraphCompositeItem(tlp::GlGraphComposite *glGraphComposite,QTreeWidgetItem *item);
    void updateLayer(const std::string& name,tlp::GlLayer* layer);
    void delLayer(tlp::GlScene*, const std::string&, tlp::GlLayer*);

  public slots:

    void updateView();
    void backColor();
    void setBackgroundColor(QColor tmp);
    virtual void accept();

  protected slots:

    void itemClicked(QTreeWidgetItem *,int);
    void applyVisibility();
    void applyVisibility(QTreeWidgetItem *item,GlComposite *composite);
  };

}

#endif // Tulip_RENDERINGPARAMETERSDIALOG_H
