//-*-c++-*-

#include <float.h>
#include "tulip/SizesProxy.h"
#include "tulip/PluginContext.h"
#include "tulip/Observable.h"
#include "tulip/Sizes.h"
#include "tulip/PropertyProxy.h"

using namespace std;

//==============================
SizesProxy::SizesProxy (SuperGraph *graph):
  PropertyProxy<SizeType,SizeType, Sizes>(graph) {
}
//==============================
SizesProxy::~SizesProxy() {
  notifyDestroy();
}
//====================================================================
void SizesProxy::reset_handler() {
  resetMinMax();
}
//====================================================================
void SizesProxy::scale(const tlp::Vector<float,3>& v, Iterator<node> *itN, Iterator<edge> *itE) {
  Observable::holdObservers();
  while (itN->hasNext()) {
    node itn = itN->next();
    Size tmpSize(getNodeValue(itn));
    tmpSize *= v;
    setNodeValue(itn,tmpSize);
  }
  while (itE->hasNext()) {
    edge ite=itE->next();
    Size tmpSize(getEdgeValue(ite));
    tmpSize *= v;
    setEdgeValue(ite,tmpSize);
  }
  resetMinMax();
  Observable::unholdObservers();
}
//=============================================================================
void SizesProxy::scale( const tlp::Vector<float,3>& v, SuperGraph *graph ) {
  if (graph==0) graph = superGraph;
  if (graph->numberOfNodes()==0) return;
  Iterator<node> *itN = graph->getNodes();
  Iterator<edge> *itE = graph->getEdges();
  scale(v, itN, itE);
  delete itN;
  delete itE;
}
//=============================================================================
Size SizesProxy::getMax(SuperGraph *sg) {
  if (sg==0) sg=superGraph;
  unsigned long sgi=(unsigned long)sg;
  if (minMaxOk.find(sgi)==minMaxOk.end()) minMaxOk[sgi]=false;
  if (!minMaxOk[sgi]) computeMinMax(sg);
  return max[sgi];
}
//=============================================================================
Size  SizesProxy::getMin(SuperGraph *sg) {
  if (sg==0) sg=superGraph;
  unsigned long sgi=(unsigned long)sg;
  if (minMaxOk.find(sgi)==minMaxOk.end()) minMaxOk[sgi]=false;
  if (!minMaxOk[sgi]) computeMinMax(sg);
  return min[sgi];
}
//=============================================================================
void SizesProxy::computeMinMax(SuperGraph *sg) {
  Size tmpSize;
  Size maxS,minS;
  Iterator<node> *itN=sg->getNodes();
  if  (itN->hasNext()) {
    node itn=itN->next();
    tmpSize=getNodeValue(itn);
    for (int i=0;i<3;++i) {
      maxS[i]=tmpSize[i];
      minS[i]=tmpSize[i];
    }
  }
  while (itN->hasNext()) {
    node itn=itN->next();
    tmpSize=getNodeValue(itn);
    for (int i=0;i<3;++i) {
      maxS[i] = std::max(maxS[i], tmpSize[i]);
      minS[i] = std::min(minS[i], tmpSize[i]);
    }
  }delete itN;
  unsigned long sgi=(unsigned long)sg;
  minMaxOk[sgi]=true;  
  min[sgi]=minS;
  max[sgi]=maxS;
}
//=============================================================================
void SizesProxy::resetMinMax() {
  minMaxOk.clear();
  min.clear();
  max.clear();
}
//=============================================================================
void SizesProxy::setNodeValue_handler(const node n, const SizeType::RealType &){resetMinMax();}
//=============================================================================
void SizesProxy::setEdgeValue_handler(const edge e, const SizeType::RealType &){resetMinMax();}
//=============================================================================
void SizesProxy::setAllNodeValue_handler(const SizeType::RealType &){resetMinMax();}
//=============================================================================
void SizesProxy::setAllEdgeValue_handler(const SizeType::RealType &){resetMinMax();}
//=============================================================================
PProxy* SizesProxy::clonePrototype(SuperGraph * g, std::string n) {
  if( !g )
    return 0;
  SizesProxy * p = g->getLocalProperty<SizesProxy>( n );
  p->setAllNodeValue( getNodeDefaultValue() );
  p->setAllEdgeValue( getEdgeDefaultValue() );
  return p;
}
//=============================================================
void SizesProxy::copy( const node n0, const node n1, PProxy * p ) {
  if( !p )
    return;
  SizesProxy * tp = dynamic_cast<SizesProxy*>(p);
  assert( tp );
  setNodeValue( n0, tp->getNodeValue(n1) );
}
//=============================================================
void SizesProxy::copy( const edge e0, const edge e1, PProxy * p ) {
  if( !p )
    return;
  SizesProxy * tp = dynamic_cast<SizesProxy*>(p);
  assert( tp );
  setEdgeValue( e0, tp->getEdgeValue(e1) );
}
//=============================================================
