#include "tulip/PluginsCreation.h"

#ifdef _WIN32
#include <windows.h>
#else
#include <dlfcn.h>
#include <dirent.h>
#endif

#ifdef _WIN32

bool PluginIterator::loadPlugin(const std::string & filename, PluginLoader *loader) {
  HINSTANCE hDLL = LoadLibrary(filename.c_str());
  if (hDLL == NULL) { 
    if (loader!=0) 
      loader->aborted(filename, "Error during the plugin loading");
    return false;
  }
  return true;
}

struct IteratorInfos {
#define BUFSIZE 70
  HANDLE hFind;
  WIN32_FIND_DATA FindData; 
  TCHAR currentDirectory[BUFSIZE];
};

PluginIterator::PluginIterator(std::string _pluginPath, PluginLoader *) {
  DWORD dwRet;
  IteratorInfos *_infos = new IteratorInfos();

  dwRet = GetCurrentDirectory(BUFSIZE, _infos ->currentDirectory);
  n = 0;
  pluginPath = _pluginPath;
  pluginLoaded = false;
  if(dwRet == 0) {
    n = -1;
    msg = std::string("Scandir error");//perror("scandir");
    delete _infos;
  } else {
    SetCurrentDirectory (_pluginPath.c_str()); 
    _infos->hFind = FindFirstFile ("*.dll", &_infos->FindData);
    infos = (void *) _infos;
  }
}

bool PluginIterator::nextPlugin(PluginLoader *loader) {
  bool pluginFound = false;
  IteratorInfos *_infos = (IteratorInfos *) infos;
  if (_infos->hFind != INVALID_HANDLE_VALUE) {
    pluginFound = true;
    if (pluginLoaded)
      pluginFound = FindNextFile (_infos->hFind, &_infos->FindData);
    if (pluginFound) {
      n++;	
      std::string tmpStr = pluginPath +"/"+ _infos->FindData.cFileName;
      if (loader)
	loader->loading(_infos->FindData.cFileName);
      pluginLoaded = loadPlugin(tmpStr, loader);
    }
  }
  if (!pluginFound) {
    pluginLoaded = false;
    SetCurrentDirectory(_infos->currentDirectory);
    delete _infos;
  }
  return pluginLoaded;
}

#else

bool PluginIterator::loadPlugin(const std::string &filename, PluginLoader *loader) {
  char *error;
  void *handle = dlopen (filename.c_str() , RTLD_NOW);
  if (!handle) { 
    if (loader!=0) 
      loader->aborted(filename, std::string(dlerror()));
    return false;
  }
  return true;
}

// accepts only file names ending with ".so"
int __tulip_selectSO(struct dirent *ent) {
  const char *SO = ".so";
  int idx = strlen(ent->d_name) - 3;
  if (idx < 0) return 0;
  
  for (int i=0; i<3; ++i) {
    if ((ent->d_name[idx + i]) != SO[i]) return 0;
  }
  return 1;
}

PluginIterator::PluginIterator(std::string _pluginPath,
			       PluginLoader *loader) {
  struct dirent **namelist;
  n = scandir((const char *) _pluginPath.c_str(),
	      &namelist,
#if !defined(__APPLE__)
	      (int (*) (const dirent *))
#endif
	      __tulip_selectSO,
	      alphasort);
  pluginPath = _pluginPath;
  pluginLoaded = false;
  if (loader!=0)
    loader->numberOfFile(n);
  if (n < 0) {
    msg=std::string("Scandir error");//perror("scandir");
    return;
  }
  infos = (void *) namelist;
}

bool PluginIterator::nextPlugin(PluginLoader *loader) {
  if (n > 0) {
    struct dirent **namelist = (struct dirent **) infos;
    std::string tmpStr;
    n--;
    tmpStr= pluginPath +"/"+ std::string(namelist[n]->d_name);
    if (loader!=0) loader->loading(std::string(namelist[n]->d_name));
    pluginLoaded = loadPlugin(tmpStr, loader);
  } else {
    pluginLoaded = false;
   }
  return pluginLoaded;
}

#endif
