#ifndef CLUSTERTREE_H
#define CLUSTERTREE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <QtCore/qobject.h>
#include <QtCore/qpoint.h>
#include "tulip/Qt3ForTulip.h"

#include <tulip/tulipconf.h>
#include <tulip/MutableContainer.h>
#include "ClusterTreeData.h"

class SuperGraph;
class Q3ListViewItem;
class Q3ListView;
class Q3PopupMenu;
/** \addtogroup Tulip_Widgets */ 
/*@{*/
class TLP_QT_SIMPLE_SCOPE ClusterTree : public ClusterTreeData { 
  Q_OBJECT;
  
public:
  ClusterTree(SuperGraph *rootGraph, QWidget* parent = 0, const char* name = 0, Qt::WFlags fl = 0);
  ClusterTree(QWidget* parent = 0, const char *name = 0, Qt::WFlags fl = 0);
  SuperGraph *getSuperGraph() const;
  
public slots:
  void setSuperGraph(SuperGraph *);
  void update();

signals:
  void aboutToRemoveView(SuperGraph *);
  void aboutToRemoveAllView(SuperGraph *);
  void supergraphChanged(SuperGraph *);

private slots:
  void contextRemoveCluster();
  void contextRemoveAllCluster();
  void contextCloneSubgraphCluster();
  void contextMoveUpCluster();
  void contextRenameCluster();
  void contextCloneCluster();
  void currentGraphChanged(const SuperGraph *);
  void rightButtonClusterTree(Q3ListViewItem *item, const QPoint &p, int c);
  void changeSuperGraph(Q3ListViewItem *item,const QPoint &p, int i);
  void changeSuperGraph(Q3ListViewItem *item);

 protected:
  void buildTreeView(Q3ListView *item,SuperGraph *p);
  void buildTreeView(Q3ListViewItem *item,SuperGraph *p);
  void removeSubgraph(SuperGraph *graph, bool recursive);

private:
  MutableContainer<Q3ListViewItem *> graphItems;
  SuperGraph *_currentGraph;
};
/*@}*/
#endif // CLUSTERTREE_H
