/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.resolver;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public class CatalogManager {
    private static String pFiles = "xml.catalog.files";
    private static String pVerbosity = "xml.catalog.verbosity";
    private static String pPrefer = "xml.catalog.prefer";
    private static String pStatic = "xml.catalog.staticCatalog";
    private static String pAllowPI = "xml.catalog.allowPI";
    private static String pClassname = "xml.catalog.className";
    private static String pIgnoreMissing = "xml.catalog.ignoreMissing";
    private static boolean ignoreMissingProperties = System.getProperty(pIgnoreMissing) != null || System.getProperty(pFiles) != null;
    private static ResourceBundle resources;
    private static String propertyFile;
    private static URL propertyFileURI;
    private static String defaultCatalogFiles;
    private static int defaultVerbosity;
    private static boolean defaultPreferPublic;
    private static boolean defaultStaticCatalog;
    private static boolean defaultOasisXMLCatalogPI;
    private static boolean defaultRelativeCatalogs;
    static /* synthetic */ Class class$org$apache$xml$resolver$CatalogManager;

    private static synchronized void readProperties() {
        block6: {
            try {
                propertyFileURI = (class$org$apache$xml$resolver$CatalogManager == null ? (class$org$apache$xml$resolver$CatalogManager = CatalogManager.class$("org.apache.xml.resolver.CatalogManager")) : class$org$apache$xml$resolver$CatalogManager).getResource("/" + propertyFile);
                InputStream inputStream = (class$org$apache$xml$resolver$CatalogManager == null ? (class$org$apache$xml$resolver$CatalogManager = CatalogManager.class$("org.apache.xml.resolver.CatalogManager")) : class$org$apache$xml$resolver$CatalogManager).getResourceAsStream("/" + propertyFile);
                if (inputStream == null) {
                    if (!ignoreMissingProperties) {
                        System.err.println("Cannot find " + propertyFile);
                    }
                    return;
                }
                resources = new PropertyResourceBundle(inputStream);
            }
            catch (MissingResourceException missingResourceException) {
                if (!ignoreMissingProperties) {
                    System.err.println("Cannot read " + propertyFile);
                }
            }
            catch (IOException iOException) {
                if (ignoreMissingProperties) break block6;
                System.err.println("Failure trying to read " + propertyFile);
            }
        }
    }

    public static void ignoreMissingProperties(boolean bl) {
        ignoreMissingProperties = bl;
    }

    public static int verbosity() {
        String string = System.getProperty(pVerbosity);
        if (string == null) {
            if (resources == null) {
                CatalogManager.readProperties();
            }
            if (resources == null) {
                return defaultVerbosity;
            }
            try {
                string = resources.getString("verbosity");
            }
            catch (MissingResourceException missingResourceException) {
                return defaultVerbosity;
            }
        }
        try {
            int n = Integer.parseInt(string.trim());
            return n;
        }
        catch (Exception exception) {
            System.err.println("Cannot parse verbosity: \"" + string + "\"");
            return defaultVerbosity;
        }
    }

    public static boolean relativeCatalogs() {
        if (resources == null) {
            CatalogManager.readProperties();
        }
        if (resources == null) {
            return defaultRelativeCatalogs;
        }
        try {
            String string = resources.getString("relative-catalogs");
            return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("1");
        }
        catch (MissingResourceException missingResourceException) {
            return defaultRelativeCatalogs;
        }
    }

    public static Vector catalogFiles() {
        String string = System.getProperty(pFiles);
        boolean bl = false;
        if (string == null) {
            if (resources == null) {
                CatalogManager.readProperties();
            }
            if (resources != null) {
                try {
                    string = resources.getString("catalogs");
                    bl = true;
                }
                catch (MissingResourceException missingResourceException) {
                    System.err.println(propertyFile + ": catalogs not found.");
                    string = null;
                }
            }
        }
        if (string == null) {
            string = defaultCatalogFiles;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            URL uRL = null;
            if (bl && !CatalogManager.relativeCatalogs()) {
                try {
                    uRL = new URL(propertyFileURI, string2);
                    string2 = uRL.toString();
                }
                catch (MalformedURLException malformedURLException) {
                    uRL = null;
                }
            }
            vector.add(string2);
        }
        return vector;
    }

    public static boolean preferPublic() {
        String string = System.getProperty(pPrefer);
        if (string == null) {
            if (resources == null) {
                CatalogManager.readProperties();
            }
            if (resources == null) {
                return defaultPreferPublic;
            }
            try {
                string = resources.getString("prefer");
            }
            catch (MissingResourceException missingResourceException) {
                return defaultPreferPublic;
            }
        }
        if (string == null) {
            return defaultPreferPublic;
        }
        return string.equalsIgnoreCase("public");
    }

    public static boolean staticCatalog() {
        String string = System.getProperty(pStatic);
        if (string == null) {
            if (resources == null) {
                CatalogManager.readProperties();
            }
            if (resources == null) {
                return defaultStaticCatalog;
            }
            try {
                string = resources.getString("static-catalog");
            }
            catch (MissingResourceException missingResourceException) {
                return defaultStaticCatalog;
            }
        }
        if (string == null) {
            return defaultStaticCatalog;
        }
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("1");
    }

    public static boolean allowOasisXMLCatalogPI() {
        String string = System.getProperty(pAllowPI);
        if (string == null) {
            if (resources == null) {
                CatalogManager.readProperties();
            }
            if (resources == null) {
                return defaultOasisXMLCatalogPI;
            }
            try {
                string = resources.getString("allow-oasis-xml-catalog-pi");
            }
            catch (MissingResourceException missingResourceException) {
                return defaultOasisXMLCatalogPI;
            }
        }
        if (string == null) {
            return defaultOasisXMLCatalogPI;
        }
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("1");
    }

    public static String catalogClassName() {
        String string = System.getProperty(pClassname);
        if (string == null) {
            if (resources == null) {
                CatalogManager.readProperties();
            }
            if (resources == null) {
                return null;
            }
            try {
                return resources.getString("catalog-class-name");
            }
            catch (MissingResourceException missingResourceException) {
                return null;
            }
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        propertyFile = "CatalogManager.properties";
        propertyFileURI = null;
        defaultCatalogFiles = "./xcatalog";
        defaultVerbosity = 1;
        defaultPreferPublic = true;
        defaultStaticCatalog = true;
        defaultOasisXMLCatalogPI = true;
        defaultRelativeCatalogs = true;
    }
}

