/*********************************************************************************
 *  TTCN-3 Parser - A Java based TTCN-3 Parser using ANTLR
 *  Copyright (C) 2000, 2001 Testing Technologies IST GmbH
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *********************************************************************************/
/* -----------------------------------------------------------------------------
 *  DESCRIPTION: TTCN3 Parser, v1.11 Grammer for ANTLR
 *
 *  AUTHOR:      Ina Schieferdecker, Theofanis Vassiliou-Gioles
 *  DATE:        2000, 2001
 *
 *  REVISION INFO:
 *      $Revision: 2.2 $ $Date: 2001/06/26 17:11:40 $
 *
 *  Open Issues: 
 *          - CSTRING and FreeText are handled identically
 *          - Static Semantics - comes with the muTTCN Parser
 * -----------------------------------------------------------------------------
 */


class TTCN3Parser extends Parser;
options 
    {
        importVocab=TTCN3Lexer;
        exportVocab=TTCN3Parser;
        buildAST = true;
        defaultErrorHandler=true;
        ASTLabelType = "ColumnAST";
        k=2;
    }

pr_TTCN3File:
		col:pr_TTCN3Module ( endcol:pr_TTCN3Module )*
{
    ## = #([TTCN3File,"TTCN3File"], ##);
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};


//------------------------------------------------------
// 1.1 TTCN Module
// -----------------------------------------------------

pr_TTCN3Module{ColumnAST endCol = null;}:
	(
	col:pr_TTCN3ModuleKeyword!
        pr_TTCN3ModuleId
        ( pr_ModuleParList )?
        pr_BeginChar!
        (   pr_ModuleDefinitionsPart ( pr_ModuleControlPart )?
            |
            pr_ModuleControlPart
			|
        )
        enda:pr_EndChar!{endCol = #enda;}
        (   endb:pr_SemiColon!{endCol = #endb;} )?
        (   endc:pr_WithStatement{endCol = #endc;} )?
	)
{
    ## = #([TTCN3Module,"TTCN3Module"], ##);
	if(## != null) ##.setLocation(#col, endCol);
};


pr_TTCN3ModuleKeyword:
		col:MODULE
{
	if(## != null) ##.setLocation(#col);
	if(## != null) ##.setEndLocation(#col);
};

pr_TTCN3ModuleId:
		(
			col:pr_ModuleIdentifier
			( 		
					(pr_DefinitiveIdentifier)  =>
				endcol:pr_DefinitiveIdentifier  
			)?
		)
{ 
    ## = #([TTCN3ModuleId,"TTCN3ModuleId"], ##); 
	if(## != null) ##.setLocation(#col, #endcol == null?#col:#endcol);
};

pr_ModuleIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_DefinitiveIdentifier:
		(
			col: pr_Dot! pr_ObjectIdentifierKeyword!
			pr_DefIdentOpen!     
			pr_DefinitiveObjIdComponentList
			endcol:pr_DefIdentClose!
		)
{
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_DefIdentOpen:
		BEGINCHAR
;

pr_DefIdentClose:
		ENDCHAR
;

pr_DefinitiveObjIdComponentList:
        ( col:pr_DefinitiveObjIdComponent )+
{ 
    ## = #([DefinitiveObjIdComponentList,"DefinitiveObjIdComponentList"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};

pr_DefinitiveObjIdComponent{ColumnAST col=null;}:
        (   
			a:pr_NameForm{ col = #a;}
		|
			b:pr_DefinitiveNumberForm{ col = #b;}
		|
			c:pr_DefinitiveNameAndNumberForm{ col = #c;}
        )
{ 
    ## = #([DefinitiveObjIdComponent,"DefinitiveObjIdComponent"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_NameForm:
        pr_Identifier
;


pr_DefinitiveNumberForm:
        NUMBER
;

pr_DefinitiveNameAndNumberForm:
		(
        col:pr_DefinitiveNameAndNumberFormId
        pr_LParen!
        pr_DefinitiveNumberForm
        endcol:pr_RParen!
		)
{ 
    ## = #([DefinitiveNameAndNumberForm,"DefinitiveNameAndNumberForm"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_DefinitiveNameAndNumberFormId:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};


pr_ModuleParList:
		(
        	col:pr_LParen!
        	pr_ModulePar
        	(
            	pr_Comma!
            	pr_ModulePar
        	)*
        	endcol:pr_RParen!
		)
{
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ModulePar{ ColumnAST endcol=null;}:
		(
        ( a:pr_InParKeyword )?
        b:pr_ModuleParType 
        c:pr_ModuleParIdentifier {endcol= #c;}
		(
			ASSIGNMENTCHAR 
			endcol: pr_ConstantExpression
		)?
		)
{ 
    ## = #([ModulePar,"ModulePar"], ##); 
	if(## != null) ##.setLocation(#a==null?#b:#a, #endcol);
};


pr_ModuleParType:
        col:pr_Type
{ 
            if(## != null) ##.setLocation(#col, #col); 
};


pr_ModuleParIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};

// ------------------------------------------------------
// 1.2 Module Definitions Part
// ------------------------------------------------------
pr_ModuleDefinitionsPart:
        col:pr_ModuleDefinitionsList
{
    ## = #([ModuleDefinitionsPart,"ModuleDefinitionsPart"], ##); 
	if(## != null) ##.setLocation(#col, #col); 
};


pr_ModuleDefinitionsList:
	(
	        col:pr_ModuleDefinition ( pr_SemiColon! )?
        	(
            	(
			pr_TypeDefKeyword | pr_ConstKeyword | pr_TemplateKeyword |
                	pr_FunctionKeyword | pr_SignatureKeyword | 
                	pr_TestcaseKeyword | pr_NamedKeyword | pr_ImportKeyword |
                	pr_GroupKeyword | pr_ExtKeyword 
            	) => 
				endcol:pr_ModuleDefinitionsList 
			|
        	)
	)
{
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};




pr_ModuleDefinition{ ColumnAST col=null; ColumnAST endcol=null;}:
	(
        (
            a:pr_TypeDef { col = #a; }
            |
            b:pr_ConstDef { col = #b; }
            |
            c:pr_TemplateDef { col = #c; }
            |
            d:pr_FunctionDef { col = #d; }
            |
            e:pr_SignatureDef { col = #e; }
            |
            f:pr_TestcaseDef { col = #f; }
            |
            g:pr_NamedAltDef { col = #g; }
            |
            h:pr_ImportDef { col = #h; }
            |
            i:pr_GroupDef { col = #i; }
            |
            j:pr_ExtFunctionDef { col = #j; }
            |
            k:pr_ExtConstDef { col = #k; }
        )
			(
				endcol: pr_WithStatement 
			)?
	)
{
    ## = #([ModuleDefinition,"ModuleDefinition"], ##); 
	if(## != null) ##.setLocation(col, endcol==null?col:endcol);
};


//------------------------------------------------------
// 1.2.1 Typdef Definitions
// -----------------------------------------------------
pr_TypeDef:
        (
            col:pr_TypeDefKeyword!
            endcol:pr_TypeDefBody
        )
{
    ## = #([TypeDef,"TypeDef"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_TypeDefBody {ColumnAST col = null;}:
        (
            ( 
                pr_RecordKeyword | pr_UnionKeyword | 
                pr_SetKeyword    | pr_EnumKeyword  | 
                pr_PortKeyword   | pr_ComponentKeyword 
            ) => a:pr_StructuredTypeDef { col = #a;}
            |
            b:pr_SubTypeDef { col = #b;}
        )
{ 
    if(## != null) ##.setLocation(col, col);
};


pr_TypeDefKeyword:
        col:TYPE
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_StructuredTypeDef{ ColumnAST col=null;}:
        (
            a:pr_RecordDef { col = #a; }
            |
            b:pr_UnionDef { col = #b; }
            |
            c:pr_SetDef { col = #c; }
            |
            d:pr_RecordOfDef { col = #d; }
            |
            e:pr_SetOfDef { col = #e; }
            |
            f:pr_EnumDef { col = #f; }
            |
            g:pr_PortDef { col = #g; }
            |
            h:pr_ComponentDef { col = #h; }
        )
{ 
    ## = #([StructuredTypeDef,"StructuredTypeDef"], ##); 
    if(col != null) ##.setLocation(col, col);
};

pr_RecordDef:
        (
            col:pr_RecordKeyword!
            endcol:pr_StructDefBody
        )
{ 
    ## = #([RecordDef,"RecordDef"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_RecordKeyword:
        col:RECORD
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_StructDefBody{ ColumnAST col=null;}:
        (
            (( 	
		a:pr_StructTypeIdentifier {col= #a;}
                ( pr_StructDefFormalParList )?
	     )
             |   
                b: pr_AddressKeyword  {col= #b;}
            )
            pr_BeginChar!
            (
                pr_StructFieldDef
                (
                    pr_Comma!
                    pr_StructFieldDef
                )*
            )?
            endcol:pr_EndChar!
        )
{
     ## = #([StructDefBody,"StructDefBody"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_StructTypeIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_StructDefFormalParList:
		(
	        col:pr_LParen!
        	pr_StructDefFormalPar
        	( pr_Comma! pr_StructDefFormalPar )*
        	endcol:pr_RParen!
		)
{ 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_StructDefFormalPar{ ColumnAST col=null;}:
		(
			(  	pr_InOutParKeyword 
			| 
				pr_OutParKeyword 
			| 
				( pr_Type IDENTIFIER ) 
			) =>
			a:pr_FormalValuePar { col = #a;}
		|
			( 
				(pr_InParKeyword)?
				IDENTIFIER ( pr_Comma | pr_RParen) 
			) =>
			c:pr_FormalTypePar { col = #c;}
		| 
			b:pr_ValueParOrTypePar { col = #b;} // should be removed later. Just for safety reasons.
		)
{ 
	if( ## != null) ##.setLocation(col, col);
} ;

pr_ValueParOrTypePar:
		(        
			(  cola:pr_InParKeyword )?
        	(  colb:pr_Type  )?
        	col:pr_ValueParOrTypeParIdentifier 
		)
{ 
    ## = #([ValueParOrTypePar,"ValueParOrTypePar"], ##); 

    if(#cola != null) {
	if(## != null) ##.setLocation(#cola, #col);
    } else if(#colb != null) { 
	if(## != null) ##.setLocation(#colb, #col);
    } else { 
	if(## != null) ##.setLocation(#col, #col); 
	}
} ;


pr_ValueParOrTypeParIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_StructFieldDef{ColumnAST endcol = null;}: 
        (
            col:pr_Type 
            a:pr_StructFieldIdentifier { endcol = #a;} 
            ( b:pr_ArrayDef { endcol = #b;} )?  
            ( c:pr_SubTypeSpec { endcol = #c;} )? 
            ( d:pr_OptionalKeyword { endcol = #d;} )? 
        )
{
    ## = #([StructFieldDef,"StructFieldDef"], ##); 
	if(## != null) ##.setLocation(#col, endcol);
};

pr_StructFieldIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_OptionalKeyword:
        col:OPTIONAL!
{
    ## = #([OptionalKeyword,"OptionalKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};

pr_UnionDef:
		(
			col:pr_UnionKeyword!
			endcol:pr_UnionDefBody
		)
{ 
    ## = #([UnionDef,"UnionDef"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_UnionKeyword:
        col:UNION
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_UnionDefBody{ ColumnAST col=null;}:
        (
            ( a:pr_StructTypeIdentifier { col = #a; }
                ( pr_StructDefFormalParList )?
            )
            |
            b:pr_AddressKeyword { col = #b; }
        )
        (   
            pr_BeginChar!
            pr_UnionFieldDef
            (
                pr_Comma!
                pr_UnionFieldDef
            )*
            endcol:pr_EndChar!
        )
{ 
    ## = #([UnionDefBody,"UnionDefBody"], ##);
	if(## != null) ##.setLocation(col, #endcol); 
};

pr_UnionFieldDef:
		(
	        col:pr_Type
        	cola:pr_StructFieldIdentifier
        	( colb:pr_ArrayDef )? 
        	( colc:pr_SubTypeSpec )?
		)
{ 
    ## = #([UnionFieldDef,"UnionFieldDef"], ##); 
	if(#colc != null) {
	if(## != null) ##.setLocation(#col, #colc);
	} else if(#colb != null) {
	if(## != null) ##.setLocation(#col, #colb); 
	} else { 
	if(## != null) ##.setLocation(#col, #cola);
	}
};

pr_SetDef:
        (
            col:pr_SetKeyword!  
            endcol:pr_StructDefBody
        )
{
    ## = #([SetDef,"SetDef"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_SetKeyword:
        col:SET
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_RecordOfDef:
		(
        col:pr_RecordKeyword!
        pr_OfKeyword!
	( pr_StringLength )?
        endcol:pr_StructOfDefBody
		)
{ 
    ## = #([RecordOfDef,"RecordOfDef"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_OfKeyword:
        col:OF
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_StructOfDefBody{ColumnAST endcol = null;}:
	(        
			col:pr_Type
        	(
            	a:pr_StructTypeIdentifier{ endcol = #a; }
            	|
            	b:pr_AddressKeyword{ endcol = #b; }
        	)
        	( c:pr_SubTypeSpec { endcol = #c; } )?
	)
{ 
    ## = #([StructOfDefBody,"StructOfDefBody"], ##); 
	if(## != null) ##.setLocation(#col, endcol);
};

pr_SetOfDef:
		(
			col:pr_SetKeyword!
			pr_OfKeyword!
			( pr_StringLength )?
			endcol:pr_StructOfDefBody
		)
{ 
    ## = #([SetOfDef,"SetOfDef"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_EnumDef:
        (
            col:pr_EnumKeyword!
            (
                pr_EnumTypeIdentifier
                |
                pr_AddressKeyword
            )
            pr_BeginChar!
            pr_NamedValueList
            endcol:pr_EndChar!
        )
{
    ## = #([EnumDef,"EnumDef"], ##);
	if(## != null) ##.setLocation(#col, #endcol);
} ;


pr_EnumKeyword:
        col:ENUMERATED
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_EnumTypeIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};


pr_NamedValueList:
		(
			col:pr_NamedValue
			(
				pr_Comma!
				endcol:pr_NamedValue
			)*
		)
{
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_NamedValue:
        (
            col:pr_NamedValueIdentifier
            (
                pr_LParen!
                pr_NumberForm
                endcol:pr_RParen!
            )?
        )
{
    ## = #([NamedValue,"NamedValue"], ##); 
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
} ;

pr_NamedValueIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_SubTypeDef{ ColumnAST endcol=null;}:
        (
            col:pr_Type 
            (
                a:pr_SubTypeIdentifier { endcol = #a; } 
                | 
                b:pr_AddressKeyword { endcol = #b; } 
            )  
            ( c:pr_ArrayDef { endcol = #c; }  )?  
            ( d:pr_SubTypeSpec { endcol = #d; }  )?
        )
{ 
     ## = #([SubTypeDef,"SubTypeDef"], ##); 
	if(## != null) ##.setLocation(#col, endcol);      
};

pr_SubTypeIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_SubTypeSpec{ ColumnAST col=null;}:
        (
			(pr_AllowedValues) =>
            a:pr_AllowedValues { col = #a; }
		|
            b:pr_StringLength { col = #b; }
        )
{ 
     ## = #([SubTypeSpec,"SubTypeSpec"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_AllowedValues:
        (
            col:pr_LParen!
            pr_ValueOrRange 
            (
                pr_Comma!
                pr_ValueOrRange 
            )*
            endcol:pr_RParen!
        )
{ 
    ## = #([AllowedValues,"AllowedValues"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ValueOrRange{ColumnAST col=null;}:
		(
        		( pr_LowerBound RANGEOP ) => 
			a:pr_IntegerRangeDef{ col = #a;}
        	|
			b:pr_SingleConstExpression{ col = #b;}
		)
{ 
    ## = #([ValueOrRange,"ValueOrRange"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_IntegerRangeDef:
		(
			col:pr_LowerBound
			pr_RangeOp!
			endcol:pr_UpperBound
		)
{ 
    ## = #([IntegerRangeDef,"IntegerRangeDef"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_StringLength:
        (
            col:pr_LengthKeyword!
            pr_LParen!
            pr_SingleConstExpression
            (
                pr_RangeOp!
                pr_UpperBound
            )?
            endcol:pr_RParen!
        )   
{ 
    ## = #([StringLength,"StringLength"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_LengthKeyword:
        col:LENGTH
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_PortType:
        (
            cola:pr_GlobalModuleId
            colb:pr_Dot!
        )?
        endcol:pr_PortTypeIdentifier
{
    ## = #([PortType,"PortType"], ##); 
    if(#cola != null) {
	if(## != null) ##.setLocation(#cola, #endcol);
	} else if (#colb != null) {
	if(## != null) ##.setLocation(#colb, #endcol);
	} else {
	if(## != null) ##.setLocation(#endcol, #endcol); 
	}
};

pr_PortDef:
        (  
            col:pr_PortKeyword!
            endcol:pr_PortDefBody
        )
{
    ## = #([PortDef,"PortDef"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_PortDefBody:
		(
			col:pr_PortTypeIdentifier
			endcol:pr_PortDefAttribs
		)
{
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_PortKeyword:
        col:PORT
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_PortTypeIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_PortDefAttribs{ ColumnAST col=null;}:
        (
            a:pr_MessageAttribs { col = #a; }
        	|   
            b:pr_ProcedureAttribs { col = #b; }
        	|
            c:pr_MixedAttribs { col = #c; }
        )
{
    ## = #([PortDefAttribs,"PortDefAttribs"], ##);
	if(## != null) ##.setLocation(col, col);
};

pr_MessageAttribs:
	(
	        col:pr_MessageKeyword!
        	pr_BeginChar!
        	pr_MessageList
              	( pr_SemiColon! )?
            	(
			pr_MessageList
        		( pr_SemiColon! )?
        	)*
        	endcol:pr_EndChar!
	)
{
    ## = #([MessageAttribs,"MessageAttribs"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_MessageList:
        (
            col:pr_Direction
            endcol:pr_AllOrTypeList
        )
{
    ## = #([MessageList,"MessageList"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_Direction{ ColumnAST col=null;}:
        (
            a:pr_InParKeyword { col = #a; }
            |
            b:pr_OutParKeyword { col = #b; }
            |
            c:pr_InOutParKeyword { col = #c; }
        )
{
    ## = #([Direction,"Direction"], ##); 
	if(## != null) ##.setLocation(col, col);
};


pr_MessageKeyword:
        col:MESSAGE
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_AllOrTypeList{ ColumnAST col=null;}:
        (
            a:pr_AllKeyword { col = #a; }
            |
            b:pr_TypeList { col = #b; }
        )
{
    ## = #([AllOrTypeList,"AllOrTypeList"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_AllKeyword:
        col:ALL!
{
    ## = #([AllKeyword,"AllKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_TypeList:
		(
			col:pr_Type
			(
				pr_Comma!
				endcol:pr_Type
			)*
		)
{
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_ProcedureAttribs:
		(
	        col:pr_ProcedureKeyword!
        	pr_BeginChar!
        	pr_ProcedureList
        	( pr_SemiColon! )?
        	(
        	  pr_ProcedureList
        	  ( pr_SemiColon! )?
        	)*
        	endcol:pr_EndChar!
		)
{ 
    ## = #([ProcedureAttribs,"ProcedureAttribs"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ProcedureKeyword:
        col:PROCEDURE
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_ProcedureList:
		(
			col:pr_Direction
			endcol:pr_AllOrSignatureList
		)
{ 
    ## = #([ProcedureList,"ProcedureList"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_AllOrSignatureList{ColumnAST col=null;}:
        (
            a:pr_AllKeyword{ col = #a;}
            |
            b:pr_SignatureList{ col = #b;}
        )
{ 
    ## = #([AllOrSignatureList,"AllOrSignatureList"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_SignatureList:
		(
	        col:pr_Signature
        	(
            	pr_Comma!
            	endcol:pr_Signature
        	)*
		)
{ 
    ## = #([SignatureList,"SignatureList"], ##); 
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_MixedAttribs:
		(        
		col:pr_MixedKeyword!
        	pr_BeginChar!
        	pr_MixedList
        	( pr_SemiColon! )?
        	(
        	    pr_MixedList
       		    ( pr_SemiColon! )?
        	)*
        	endcol:pr_EndChar!
		)
{ 
    ## = #([MixedAttribs,"MixedAttribs"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_MixedKeyword:
        col:MIXED
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_MixedList:
		(
			col:pr_Direction
			endcol:pr_ProcOrTypeList
		)
{ 
    ## = #([MixedList,"MixedList"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ProcOrTypeList{ColumnAST col=null;}:
        (
            a:pr_AllKeyword{col = #a;}
		|
            (
                b:pr_ProcOrType{col = #b;}
                (
                    pr_Comma!
                    pr_ProcOrType
                )*
            )
        )
{ 
    ## = #([ProcOrTypeList,"ProcOrTypeList"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_ProcOrType:
        col:pr_Type
{ 
    ## = #([ProcOrType,"ProcOrType"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};

pr_ComponentDef:
		(
	        col:pr_ComponentKeyword!
        	pr_ComponentTypeIdentifier
        	pr_BeginChar!
        	( pr_ComponentDefList )?
        	endcol:pr_EndChar!
		)
 {
    ## = #([ComponentDef,"ComponentDef"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_ComponentKeyword:
        col:COMPONENT
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_ComponentType:
        (
            (
		( pr_GlobalModuleId pr_Dot ) => 
		( pr_GlobalModuleId pr_Dot! )
		|
            )
            col:pr_ComponentTypeIdentifier
        )
{
    ## = #([ComponentType,"ComponentType"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};


pr_ComponentTypeIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};


pr_ComponentDefList:
		(
	        col:pr_ComponentElementDef
		( pr_SemiColon! )?
        	(  
		  endcol:pr_ComponentElementDef
		  ( pr_SemiColon! )?
        	)*
		)
{
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
}
;
pr_ComponentElementDef{ ColumnAST col=null;}:
        (
            a:pr_PortInstance   { col = #a; }
            |
            b:pr_VarInstance    { col = #b; }
            |
            c:pr_TimerInstance  { col = #c; }
            |
            d:pr_ConstDef       { col = #d; }
        )
{ 
    ## = #([ComponentElementDef,"ComponentElementDef"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_PortInstance:
	(
		col:pr_PortKeyword!
	        pr_PortType
        	endcola:pr_PortElement
        	(
            		pr_Comma!
            		endcolb:pr_PortElement
        	)*
	)
{
    ## = #([PortInstance,"PortInstance"], ##); 
	if(## != null) ##.setLocation(#col, #endcolb==null?#endcola:#endcolb);
};

pr_PortElement:
		(
	        col:pr_PortIdentifier
        	( endcol:pr_ArrayDef )?
		)
{
    ## = #([PortElement,"PortElement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};


pr_PortIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};


//------------------------------------------------------
// 1.2.2 Constant Definitions
// -----------------------------------------------------
pr_ConstDef:
		(
			col:pr_ConstKeyword!
			pr_Type
			endcol:pr_ConstList
		)
{ 
    ## = #([ConstDef,"ConstDef"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_ConstList:
		(
	        col:pr_SingleConstDef
        	endcol:(
        	    pr_Comma!
        	    pr_SingleConstDef
        	)*
		)
{
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_SingleConstDef:
		(
			col:pr_ConstIdentifier
			( pr_ArrayDef   )?
			pr_AssignmentChar!
			endcol:pr_ConstantExpression
		)
{ 
    ## = #([SingleConstDef,"SingleConstDef"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_ConstKeyword:
        col:CONST
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_ConstIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};

//------------------------------------------------------
// 1.2.3 Template Definitions
// -----------------------------------------------------
pr_TemplateDef:
        (
            col:pr_TemplateKeyword!
            pr_BaseTemplate 
            ( pr_DerivedDef )?
			pr_AssignmentChar!
            endcol:pr_TemplateBody   
        )   
{
    ## = #([TemplateDef,"TemplateDef"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_BaseTemplate:
		(
	        col:pr_Type
        	endcola:pr_TemplateIdentifier
        	(
        	    pr_LParen!
        	    pr_TemplateFormalParList
        	    endcolb:pr_RParen!
        	)?
		)
{
    ## = #([BaseTemplate,"BaseTemplate"], ##); 
	if(## != null) ##.setLocation(#col, #endcolb==null?#endcola:#endcolb);
};


pr_TemplateKeyword:
        col:TEMPLATE!
{
    ## = #([TemplateKeyword,"TemplateKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_TemplateIdentifier:
        col:pr_Identifier
{
	if( ## != null) ##.setLocation(#col, #col);
};

pr_DerivedDef:
		(
			col:pr_ModifiesKeyword!
			endcol:pr_TemplateRef
		)
{ 
    ## = #([DerivedDef,"DerivedDef"], ##);
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_ModifiesKeyword:
        col:MODIFIES!
{
    ## = #([ModifiesKeyword,"ModifiesKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};



pr_TemplateFormalParList:
		(
	        col:pr_TemplateFormalPar
        	(
        	    pr_Comma!
        	    endcol:pr_TemplateFormalPar
        	)*
		)
{
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};


pr_TemplateFormalPar{ColumnAST col=null;}:
		(  
			( pr_FormalValuePar ) => 
			a:pr_FormalValuePar{ col = #a;}
		|
			( pr_FormalTemplatePar ) => 
			b:pr_FormalTemplatePar{ col = #b;}
		)
{
	if(## != null) ##.setLocation(col, col);
}
;

pr_TemplateBody{ ColumnAST col=null;}:
        (
            a:pr_SimpleSpec { col = #a; }
            | ( pr_BeginChar ) => 
            b:pr_FieldSpecList { col = #b; }
            |
            c:pr_ArrayValueOrAttrib { col = #c; }
        )
{
    ## = #([TemplateBody,"TemplateBody"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_SimpleSpec:
        col:pr_SingleValueOrAttrib
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_FieldSpecList:
        (
            col:pr_BeginChar!
            (
                pr_FieldSpec
                (
                    pr_Comma!
                    pr_FieldSpec
                )*
            )?
            endcol:pr_EndChar!
        )
{
    ## = #([FieldSpecList,"FieldSpecList"], ##);
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_FieldSpec:
        (
            col:pr_FieldReference
            pr_AssignmentChar!
            endcol:pr_TemplateBody
        )
{
    ## = #([FieldSpec,"FieldSpec"], ##);
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_FieldReference{ ColumnAST col=null;}:
        (
            a:pr_Identifier { col = #a; } // this sums up RecordRef AND ParRef
            |
            b:pr_ArrayOrBitRef { col = #b; }
        )
{
    ## = #([FieldReference,"FieldReference"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_ArrayOrBitRef:
		(
			col:pr_SquareOpen!
			pr_FieldOrBitNumber
			endcol:pr_SquareClose!
		)
{ 
    ## = #([ArrayOrBitRef,"ArrayOrBitRef"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_FieldOrBitNumber:
        col:pr_SingleExpression
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_SingleValueOrAttrib{ ColumnAST col=null;}:
        (
    	    ( pr_MatchingSymbol ) =>
	    (
              a: pr_MatchingSymbol  { col = #a; }
	      ( pr_ExtraMatchingAttributes )?
	    )  
	|
    	    ( pr_SingleExpression ) =>
            ( 
	      b:pr_SingleExpression { col = #b; } 
	      ( pr_ExtraMatchingAttributes )? 
	    )
        |
    	    ( pr_TemplateRefWithParList ) =>
            ( 
	      c:pr_TemplateRefWithParList { col = #c; } 
   	     ( pr_ExtraMatchingAttributes )? 
 	    )
        )
{
    ## = #([SingleValueOrAttrib,"SingleValueOrAttrib"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_ArrayValueOrAttrib:
        (
            col:pr_BeginChar!
            pr_ArrayElementSpecList
            endcol:pr_EndChar!
	)
{ 
    ## = #([ArrayValueOrAttrib,"ArrayValueOrAttrib"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_ArrayElementSpecList:
	(
        	col:pr_ArrayElementSpec
        	(
            	pr_Comma!
            	endcol:pr_ArrayElementSpec
		)*
	)
{ 

	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};


pr_ArrayElementSpec{ColumnAST col=null;}:
        (
            ( pr_TemplateBody ) => 
            a:pr_TemplateBody { col = #a;}
            |
            b:pr_NotUsedSymbol{ col = #b;}
        )
{ 
    ## = #([ArrayElementSpec,"ArrayElementSpec"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_NotUsedSymbol:
		col:pr_Dash!
{
    ## = #([NotUsedSymbol,"NotUsedSymbol"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};

pr_MatchingSymbol{ ColumnAST col=null;}:
        (
                ( pr_Complement ) =>
            a:pr_Complement { col = #a; }
            |
                ( pr_Omit ) =>
            b:pr_Omit { col = #b; }
            |
                ( pr_AnyValue ) =>
            c:pr_AnyValue { col = #c; }
            |
                ( pr_AnyOrOmit ) =>
            d:pr_AnyOrOmit { col = #d; }
            |
                ( pr_LParen pr_LowerBound RANGEOP ) => 
            e:pr_IntegerRange { col = #e; }
            |
                ( pr_ValueList ) =>
            f:pr_ValueList { col = #f; }
            |
                ( pr_BitStringMatch ) =>
            g:pr_BitStringMatch { col = #g; }
            |
                ( pr_HexStringMatch ) =>
            h:pr_HexStringMatch { col = #h; }
            |
                ( pr_OctetStringMatch ) =>
            i:pr_OctetStringMatch { col = #i; }
            |
            j:pr_CharStringMatch { col = #j; }
        )
{
    ## = #([MatchingSymbol,"MatchingSymbol"], ##);
	if(## != null) ##.setLocation(col, col);
};

pr_ExtraMatchingAttributes{ ColumnAST col=null;}:
        (
            a:pr_LengthMatch { col = #a; }
		| 
            b:pr_IfPresentMatch{ col = #b; }
        )
{
    ## = #([ExtraMatchingAttributes,"ExtraMatchingAttributes"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_BitStringMatch:
        (
            col:pr_SingleQuote!
            ( pr_BinOrMatch )*
            pr_SingleQuote!
            endcol:"B"
        )
{ 
    ## = #([BitStringMatch,"BitStringMatch"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_BinOrMatch{ColumnAST col=null;}:
        (
            a:pr_BinOrMatchId{ col = #a;}
            |
            b:pr_AnyValue{ col = #b;}
            |
            c:pr_AnyOrOmit{ col = #c;}
        )
{ 
	## = #([BinOrMatch,"BinOrMatch"], ##);
	if(## != null) ##.setLocation(col, col);
};


pr_BinOrMatchId:
        col:BIN
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_HexStringMatch:
        (
            col:pr_SingleQuote!
            ( pr_HexOrMatch )*
            endcol:pr_SingleQuote!
            "H"!
        )
{ 
    ## = #([HexStringMatch,"HexStringMatch"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};
   

pr_HexOrMatch{ColumnAST col=null;}:
        (
            a:pr_HexOrMatchId{ col = #a;}
            |
            b:pr_AnyValue{ col = #b;}
            |
            c:pr_AnyOrOmit{ col = #c;}
        )
{ 
    ## = #([HexOrMatch,"HexOrMatch"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_HexOrMatchId:
		col:HEX
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_OctetStringMatch:
		(
			col:pr_SingleQuote!
			( pr_OctOrMatch )*
			endcol:pr_SingleQuote!
			"O"
		)
{ 
    ## = #([OctetStringMatch,"OctetStringMatch"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_OctOrMatch{ColumnAST col=null;}:
        (
            a:pr_OctOrMatchId{ col = #a;}
		|
            b:pr_AnyValue{ col = #b;}
		|
            c:pr_AnyOrOmit{ col = #c;}
        )
{ 
	## = #([OctOrMatch,"OctOrMatch"], ##); 
	if(## != null) ##.setLocation(col, col);
};


pr_OctOrMatchId:
        col:OCT
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_CharStringMatch{ ColumnAST col = null, endcol = null; }:
	(
	  col: pr_PatternKeyword! 
	  a: pr_CharStringPattern {endcol= #a;}
	  ( 
		pr_StringOp  
		b: pr_CharStringPattern  {endcol= #b;}
	  )*
        )
{
    ## = #([CharStringMatch,"CharStringMatch"], ##); 
	if(## != null) ##.setLocation(col, endcol);
};

pr_PatternKeyword:
	PATTERNKEYWORD
;

pr_CharStringPattern { ColumnAST col = null; }:
	( 
	  a: pr_CharStringValue {col= #a; }
	| 
	  b: TemplateRefWithParList {col= #b; }
	)
	{
    	## = #([CharStringPattern,"CharStringPattern"], ##);
	if(## != null) ##.setLocation(col, col);
	}
;


pr_Complement{ColumnAST endcol = null;}:
		(
	        col:pr_ComplementKeyword!
        	( 
				( pr_ValueList ) => 
        	    a:pr_ValueList { endcol = #a; } 
			| 
        	    b:pr_SingleConstExpression { endcol = #b; }
        	)
		)
{
    ## = #([Complement,"Complement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ComplementKeyword:
        col: COMPLEMENTKEYWORD!
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_Omit:
        col:pr_OmitKeyword!
{ 
    ## = #([OmitKeyword,"OmitKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};


pr_OmitKeyword:
        col:OMIT
{ 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_AnyValue:
        col:pr_QuestionMark!
{
    ## = #([AnyValue,"AnyValue"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};


pr_AnyOrOmit:
        col:pr_Star!
{
    ## = #([AnyOrOmit,"AnyOrOmit"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};

pr_ValueList:
		(
	        col:pr_LParen!
	        pr_SingleConstExpression
	        (
	            pr_Comma!
	            pr_SingleConstExpression
	        )+
	        endcol:pr_RParen!
		)
{ 
    ## = #([ValueList,"ValueList"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_LengthMatch:
        col:pr_StringLength
{
    ## = #([LengthMatch,"LengthMatch"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};

pr_IfPresentMatch:
        col:IFPRESENT!
{
    ## = #([IfPresentMatch,"IfPresentMatch"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_IntegerRange:
        (
            col:pr_LParen!
            pr_LowerBound
            pr_RangeOp!
            pr_UpperBound
            endcol:pr_RParen!
        )
{ 
    ## = #([IntegerRange,"IntegerRange"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_LowerBound{ColumnAST col=null;}:
        (
            a:pr_SingleConstExpression { col = #a;}
            |
            (
                b:pr_Minus! { col = #b;}
                pr_InfinityKeyword
            )
        )
{ 
    ## = #([LowerBound,"LowerBound"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_UpperBound{ColumnAST col=null;}:
        (
            a:pr_SingleConstExpression { col = #a;}
            |
            b:pr_InfinityKeyword { col = #b;}
        )
{ 
    ## = #([UpperBound,"UpperBound"], ##); 
	if(## != null) ##.setLocation(col, col);
};


pr_InfinityKeyword:
        col:INFINITY!
{
    ## = #([Infinity,"InfinityKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
}
;

pr_TemplateInstance:
        col:pr_InLineTemplate
{
    ## = #([TemplateInstance,"TemplateInstance"], ##);
	if(## != null) ##.setLocation(#col, #col);
};

pr_TemplateRefWithParList{ColumnAST col = null;ColumnAST endcol = null;}:
        (
	  (
            (
                a:pr_GlobalModuleId {col= #a; }
                pr_Dot!
            )?
            b:pr_TemplateIdentifier {if (#col==null) col= #b;} 
					// covers also | pr_TemplateParIdentifier
            (
                c:pr_TemplateActualParList {endcol= #c; }
            )?
	  )
        )
{
    ## = #([TemplateRefWithParList,"TemplateRefWithParList"], ##); 
	if(## != null) ##.setLocation(col,#endcol==null?col:endcol);
};

pr_TemplateRef:
        (
            (
                cola:pr_GlobalModuleId
                pr_Dot!
            )?
            col:pr_TemplateIdentifier
		)
{ 
	if(## != null) ##.setLocation(#cola==null?#col:#cola, #col);
};

pr_InLineTemplate{ ColumnAST col=null;}:
		(
        	  (   
		    ( pr_Type pr_Colon! ) => 
        	    a:pr_Type { col = #a; } 
        	    pr_Colon!  			// covers also | pr_Signature pr_Colon!
        	  )?
        	  (
        	    b:pr_DerivedDef { col = #b; }
        	    pr_AssignmentChar!
        	  )?
		  col: pr_TemplateBody
		)	
{
    ## = #([InLineTemplate,"InLineTemplate"], ##);
    if(#a != null) {
	if(## != null) ##.setLocation(#a, #a);
    } else if(#b != null) { 
	if(## != null) ##.setLocation(#b, #b);
    }
    if((#a == null) && (#b == null) && (col != null)) { 
	if(## != null) ##.setLocation(col, col);
    }
};

pr_TemplateActualParList:
		(
	        col:pr_LParen!
        	pr_TemplateActualPar
        	(
        	    pr_Comma!
        	    pr_TemplateActualPar
        	)*
        	endcol:pr_RParen!
		)
{
    ## = #([TemplateActualParList,"TemplateActualParList"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_TemplateActualPar:
        col:pr_TemplateInstance
{
    ## = #([TemplateActualPar,"TemplateActualPar"], ##);
	if(## != null) ##.setLocation(#col, #col);
};

pr_TemplateOps{ ColumnAST col=null;}:
		(
			a:pr_MatchOp{ col = #a;}
		| 
			b:pr_ValueofOp{ col = #b;}
		)
{
	## = #([TemplateOps, "TemplateOps"], ##);
	if(## != null) ##.setLocation(col, col);
};

pr_MatchOp:
		(
			col:pr_MatchKeyword!
			pr_LParen!
			pr_Expression
			pr_Comma!
			pr_TemplateInstance
			endcol:pr_RParen!
		)
{
	## = #([MatchOp, "MatchOp"], ##);
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_MatchKeyword:
		col:MATCH
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_ValueofOp:
		(
			col:pr_ValueofKeyword 
			pr_LParen 
			pr_TemplateInstance
			endcol:pr_RParen
		)
{
	## = #([ValueofOp, "ValueofOp"], ##);
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ValueofKeyword:
	col:VALUEOF
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};



//------------------------------------------------------
// 1.2.4 Function Definitions
// -----------------------------------------------------
pr_FunctionDef:
		(
	        col:pr_FunctionKeyword!
        	pr_FunctionIdentifier
        	pr_LParen!
        	( pr_FunctionFormalParList )?
        	pr_RParen!
        	( pr_RunsOnSpec )?
        	( pr_ReturnType )?
        	pr_BeginChar!
        	pr_FunctionBody
        	endcol:pr_EndChar!
		)
{
    ## = #([FunctionDef,"FunctionDef"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_FunctionKeyword:
        col:FUNCTION
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_FunctionIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_FunctionFormalParList:
		(
	        col:pr_FunctionFormalPar
        	endcol:(
        	    pr_Comma!
        	    pr_FunctionFormalPar
        	)*
		)
{
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};


pr_FunctionFormalPar{ColumnAST col=null;}:
        (
                ( pr_FormalValuePar ) =>
            a:pr_FormalValuePar{ col = #a;}
            |   
                ( pr_FormalTimerPar ) =>
            b:pr_FormalTimerPar{ col = #b;}
            |
                ( pr_FormalTemplatePar ) =>
            c:pr_FormalTemplatePar{ col = #c;}
            |
            d:pr_FormalPortPar{ col = #d;}
        )
{
    if(## != null) ##.setLocation(col, col);
};

pr_ReturnType:
		(
			col:pr_ReturnKeyword!
			endcol:pr_Type
		)
{
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_ReturnKeyword:
        col:RETURN

{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_RunsOnSpec{ ColumnAST endcol=null;}:
		(
	        col:pr_RunsKeyword!
        	pr_OnKeyword!
        	(   
        	    a:pr_ComponentType { endcol = #a; }
        	    |   
        	    b:pr_MTCKeyword { endcol = #b; }
        	)
		)
{
    ## = #([RunsOnSpec,"RunsOnSpec"], ##); 
	if(## != null) ##.setLocation(#col, endcol);
};

pr_RunsKeyword:
        col:RUNS
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_OnKeyword:
        col:ON
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_MTCKeyword:
        col:MTC
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_FunctionBody:
	(
		( col:pr_FunctionStatementOrDefList )?
	)
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_FunctionStatementOrDefList  { ColumnAST endcol = null; }:
        col:pr_FunctionStatementOrDef 
	( a: pr_SemiColon {endcol= #a;} )?
	( 
	  b: pr_FunctionStatementOrDef {endcol= #b;}
	  ( c: pr_SemiColon {endcol= #c;})?
	)*
{ 
    ## = #([FunctionStatementOrDefList,"FunctionStatementOrDefList"], ##);
	if(## != null) ##.setLocation(#col, endcol==null?#col:endcol);
};

pr_FunctionStatementOrDef{ ColumnAST col=null;}:
        (
            a:pr_FunctionLocalDef { col = #a; }
            |
            b:pr_FunctionLocalInst { col = #b; }
            |
            c:pr_FunctionStatement { col = #c; }
        )
{
    ## = #([FunctionStatementOrDef,"FunctionStatementOrDef"], ##);
	if(## != null) ##.setLocation(col, col);
};

pr_FunctionLocalInst{ ColumnAST col=null;}:
        (
            a:pr_VarInstance { col = #a; }
            |
            b:pr_TimerInstance { col = #b; }
        )
{
    ## = #([FunctionLocalInst,"FunctionLocalInst"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_FunctionLocalDef:
        col:pr_ConstDef
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_FunctionStatement{ ColumnAST col=null;}:
        (
                ( pr_ConnectKeyword | pr_MapKeyword | 
                    ( pr_ComponentId pr_Dot 
                        ( 
                            ( pr_StartKeyword pr_LParen pr_FunctionInstance pr_RParen ) | pr_DoneKeyword  
                        )
                    ) 
                | pr_StopKeyword | pr_DisconnectKeyword | pr_UnmapKeyword ) =>
            a:pr_ConfigurationStatements { col = #a; }
            |
                ( pr_TimerRef pr_Dot ( pr_StartKeyword |  pr_StopKeyword | pr_TimeoutKeyword ) | 
                    pr_AnyKeyword pr_TimerKeyword | pr_AllKeyword pr_TimerKeyword  ) =>
            b:pr_TimerStatements { col = #b; }
            |
                ( 
                    ( pr_Port pr_Dot ( pr_SendOpKeyword | pr_CallOpKeyword | 
                        pr_ReplyKeyword | pr_RaiseKeyword | 
                        pr_ReceiveOpKeyword | pr_TriggerOpKeyword |
                        pr_GetCallOpKeyword | pr_GetReplyOpKeyword |
                        pr_CatchOpKeyword | pr_CheckOpKeyword |
                        pr_ClearOpKeyword | pr_StartKeyword | pr_StopKeyword)
                    ) 
                    | 
                    ( pr_AnyKeyword pr_Dot ( pr_ReceiveOpKeyword | pr_TriggerOpKeyword |
                        pr_GetCallOpKeyword | pr_GetReplyOpKeyword |
                        pr_CatchOpKeyword | pr_CheckOpKeyword |
                        pr_ClearOpKeyword | pr_StartKeyword | pr_StopKeyword )
                    ) 
                ) =>
            c:pr_CommunicationStatements { col = #c; }
            |
                ( pr_ExecuteKeyword | pr_FunctionRef pr_LParen  | pr_ReturnKeyword | 
                    pr_AltKeyword | pr_InterleavedKeyword | pr_LabelKeyword | 
                pr_GotoKeyword | pr_ActivateKeyword | pr_DeactivateKeyword ) =>
            d:pr_BehaviourStatements { col = #d; }
            |
                ( pr_SetVerdictKeyword ) =>
            e:pr_VerdictStatements { col = #e; }
            |
                ( pr_SUTAction ) =>
            f:pr_SUTStatements { col = #f; }
            |
            g:pr_BasicStatements { col = #g; }
        )
{
    ## = #([FunctionStatement,"FunctionStatement"], ##);
	if(## != null) ##.setLocation(col, col);
};

pr_FunctionInstance:
		(
	        col:pr_FunctionRef
	        pr_LParen!
	        ( pr_FunctionActualParList )?
	        endcol:pr_RParen!
		)
{
    ## = #([FunctionInstance,"FunctionInstance"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_FunctionRef:
        (
            (
                cola:pr_GlobalModuleId
                pr_Dot!
            )?
            col:pr_FunctionIdentifier
        )
{
    ## = #([FunctionRef,"FunctionRef"], ##); 
	if(## != null) ##.setLocation(#cola==null?#col:#cola, #col);
};

pr_FunctionActualParList:
        (
            col:pr_FunctionActualPar
            (
                pr_Comma!
                endcol:pr_FunctionActualPar
            )*
        )
{
    ## = #([FunctionActualParList,"FunctionActualParList"], ##);
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_FunctionActualPar{ ColumnAST col=null;}: 
        (
                ( pr_TimerRef ) =>
            a:pr_TimerRef { col = #a; }
            |
                ( pr_TemplateInstance ) =>
            b:pr_TemplateInstance { col = #b; }
            |
                ( pr_Port ) =>
            c:pr_Port { col = #c; }
            |
            d:pr_ComponentRef { col = #d; }
        )
{
    ## = #([FunctionActualPar,"FunctionActualPar"], ##); 
	if(## != null) ##.setLocation(col, col);
};

//------------------------------------------------------
// 1.2.5 Signature Definitions
// -----------------------------------------------------
pr_SignatureDef{ ColumnAST endcol=null;}:
	(
	    col:pr_SignatureKeyword!
	    	pr_SignatureIdentifier
	        pr_LParen!
	        ( pr_SignatureFormalParList )?
	        a:pr_RParen! { endcol = #a; }
	        ( b:pr_ReturnType { endcol = #b; } )?
	        ( c:pr_ExceptionSpec { endcol = #c; } )?
	)
{ 
    ## = #([SignatureDef,"SignatureDef"], ##); 
	if(## != null) ##.setLocation(#col, endcol);
};

pr_SignatureKeyword:
        col:SIGNATURE
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_SignatureIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_SignatureFormalParList:
		(
	        col:pr_SignatureFormalPar
        	(
        	    pr_Comma!
        	    endcol:pr_SignatureFormalPar
        	)*
		)
{ 

	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_SignatureFormalPar{ColumnAST col=null;}:
        (
            col:pr_FormalValuePar
        )
{ 
	if(## != null) ##.setLocation(col, col);
};

pr_ExceptionSpec:
		(
	        col:pr_ExceptionKeyword!
	        pr_LParen!
	        pr_ExceptionTypeList
	        endcol:pr_RParen!
		)
{ 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_ExceptionKeyword:
        col:EXCEPTION
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_ExceptionTypeList:
		(
	        col:pr_Type
	        (
	            pr_Comma!
	            endcol:pr_Type
	        )*
		)
{ 
    ## = #([ExceptionTypeList,"ExceptionTypeList"], ##); 
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_Signature:
		(
	        (
	            cola:pr_GlobalModuleId
	            pr_Dot!
	        )?
	        col:pr_SignatureIdentifier
		)
{ 
    ## = #([Signature,"Signature"], ##); 
	if(## != null) ##.setLocation(#cola==null?#col:#cola, #col);
};


//------------------------------------------------------
// 1.2.6 Testcase Definitions
// -----------------------------------------------------
pr_TestcaseDef:
		(
	        col:pr_TestcaseKeyword!
	        pr_TestcaseIdentifier
	        pr_LParen!
	        ( pr_TestcaseFormalParList )?
	        pr_RParen!
	        pr_ConfigSpec
	        pr_BeginChar!
	        pr_FunctionBody
	        endcol:pr_EndChar!
		)
{
    ## = #([TestcaseDef,"TestcaseDef"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_TestcaseKeyword:
        col:TESTCASE
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_TestcaseIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_TestcaseFormalParList:
		(
	        col:pr_TestcaseFormalPar
	        (
	            pr_Comma!
				endcol:pr_TestcaseFormalPar
	        )*
		)
{ 
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_TestcaseFormalPar{ColumnAST col=null;}:
        (
                ( pr_FormalTemplatePar ) =>
            a:pr_FormalTemplatePar{ col=#a;}
            |
            b:pr_FormalValuePar{ col=#b;}
        )
{ 
	if(## != null) ##.setLocation(col, col);
};

pr_ConfigSpec:
		(
			col:pr_RunsOnSpec
			( endcol:pr_SystemSpec )?
		)
{
    ## = #([ConfigSpec,"ConfigSpec"], ##);
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};


pr_SystemSpec:
		(
			col:pr_SystemKeyword!
			endcol:pr_ComponentType
		)
{
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_SystemKeyword:
        col:SYSTEM
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_TestcaseInstance:
		(
	        col:pr_ExecuteKeyword!
	        pr_LParen!
	        pr_TestcaseRef
	        pr_LParen!
	        ( pr_TestcaseActualParList )?
	        pr_RParen!
	        (
	            pr_Comma!
	            pr_TimerValue
	        )?
	        endcol:pr_RParen!
		)
{ 
    ## = #([TestcaseInstance,"TestcaseInstance"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ExecuteKeyword:
        col:EXECUTE
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_TestcaseRef:
		(
	        (
	            cola:pr_GlobalModuleId
	            pr_Dot!
	        )?
	        col:pr_TestcaseIdentifier
		)
{ 
    ## = #([TestcaseRef,"TestcaseRef"], ##); 
	if(## != null) ##.setLocation(#cola==null?#col:#cola, #col);
};

pr_TestcaseActualParList:
		(
	        col:pr_TestcaseActualPar
	        (
	            pr_Comma!
	            endcol:pr_TestcaseActualPar
	        )*
		)
{ 
    ## = #([TestcaseActualParList,"TestcaseActualParList"], ##); 
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_TestcaseActualPar:
        col:pr_TemplateInstance
{ 
    ## = #([TestcaseActualPar,"TestcaseActualPar"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};


//------------------------------------------------------
// 1.2.7 NamedAlt Definitions
// -----------------------------------------------------
pr_NamedAltDef:
		(
	        col:pr_NamedKeyword!
	        pr_AltKeyword!
	        pr_NamedAltIdentifier
	        (
	            pr_LParen!
	            ( pr_NamedAltFormalParList )?
	            pr_RParen!
	        )?
	        pr_BeginChar!
	        pr_AltGuardList
	        endcol:pr_EndChar!
		)
{
    ## = #([NamedAltDef,"NamedAltDef"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_NamedKeyword:
        col:NAMED!
{
    ## = #([NamedKeyword,"NamedKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_NamedAltIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};


pr_NamedAltFormalParList:
		(
	        col:pr_NamedAltFormalPar
        	(
        	    pr_Comma!
        	    endcol:pr_NamedAltFormalPar
        	)*
		)
{
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_NamedAltFormalPar{ ColumnAST col=null;}:
        (
            ( pr_FormalTemplatePar ) =>
            a:pr_FormalTemplatePar { col = #a; }
            |
            ( pr_FormalValuePar ) =>
            b:pr_FormalValuePar { col = #b; }
            |
            ( pr_FormalTimerPar ) =>
            c:pr_FormalTimerPar { col = #c; }
            |
            d:pr_FormalPortPar { col = #d; }
        )
{
    ## = #([NamedAltFormalPar,"NamedAltFormalPar"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_NamedAltInstance:
        (
            col:pr_NamedAltRef
            pr_LParen!
            ( pr_NamedAltActualParList )?
            endcol:pr_RParen!
        )
{
    ## = #([NamedAltInstance,"NamedAltInstance"], ##); 
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_NamedAltRef:
	(
         (
	   ( pr_GlobalModuleId ) =>
           cola:pr_GlobalModuleId
           pr_Dot!
          )?
          col:pr_NamedAltIdentifier
	)
{
    ## = #([NamedAltRef,"NamedAltRef"], ##); 
	if(## != null) ##.setLocation(#cola==null?#col:#cola, #col);
};

pr_NamedAltActualParList:
		(
	        col:pr_NamedAltActualPar
	        (
	            pr_Comma!
	            endcol:pr_NamedAltActualPar
	        )*
		)
{
    ## = #([NamedAltActualParList,"NamedAltActualParList"], ##); 
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_NamedAltActualPar{ ColumnAST col=null;}:
        (
                ( pr_TimerRef ) =>
            a:pr_TimerRef { col = #a; }
            |
                ( pr_TemplateInstance ) =>
            b:pr_TemplateInstance { col = #b; }
            |
                ( pr_Port ) =>
            c:pr_Port { col = #c; }
            |
            d:pr_ComponentRef { col = #d; }
        )
{
    ## = #([NamedAltActualPar,"NamedAltActualPar"], ##); 
	if(## != null) ##.setLocation(col, col);
};


//------------------------------------------------------
// 1.2.8 Import Definitions
// -----------------------------------------------------
pr_ImportDef:
		(
			col:pr_ImportKeyword!
			endcol:pr_ImportSpec
		)
{ 
    ## = #([ImportDef,"ImportDef"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ImportKeyword:
        col:IMPORT
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_ImportSpec{ColumnAST col=null;}:
        (
            a:pr_ImportAllSpec{ col = #a;}
            |
            b:pr_ImportGroupSpec{ col = #b;}
            |
            c:pr_ImportTypeDefSpec{ col = #c;}
            |
            d:pr_ImportTemplateSpec{ col = #d;}
            |
            e:pr_ImportConstSpec{ col = #e;}
            |
            f:pr_ImportTestcaseSpec{ col = #f;}
            |
            g:pr_ImportNamedAltSpec{ col = #g;}
            |
            h:pr_ImportFunctionSpec{ col = #h;}
            |
            i:pr_ImportSignatureSpec{ col = #i;}
        )
{ 
    ## = #([ImportSpec,"ImportSpec"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_ImportAllSpec:
		(
	        col:pr_AllKeyword!
	        ( pr_DefKeyword )?
	        endcol:pr_ImportFromSpec
		)
{ 
	## = #([ImportAllSpec,"ImportAllSpec"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ImportFromSpec:
		(
	        col:pr_FromKeyword!
	        pr_ModuleId
	        ( endcol:NONRECURSIVE )?
		)
{ 
    ## = #([ImportFromSpec,"ImportFromSpec"], ##); 
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_ModuleId{ColumnAST endcol=null;}:
		(
	        col:pr_GlobalModuleId
	        ( b:pr_LanguageSpec { endcol =#b; } )?
		)
{ 
    ## = #([ModuleId,"ModuleId"], ##); 
	if(## != null) ##.setLocation(#col, endcol==null?#col:endcol);
};

pr_LanguageKeyword:
        col:LANGUAGE
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_LanguageSpec:
		(
			col:pr_LanguageKeyword!
			endcol:pr_FreeText
		)
{ 
    ## = #([LanguageSpec,"LanguageSpec"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_GlobalModuleId:
		(
			col:pr_GlobalModuleIdId
			( ( pr_Dot ) =>
			  endcol: pr_Dot pr_ObjectIdentifierValue  )?
		)
{ 
    ## = #([GlobalModuleId,"GlobalModuleId"], ##); 
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_GlobalModuleIdId:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_DefKeyword{ColumnAST col=null;ColumnAST endcol=null;}:
        (
            a:pr_TypeDefKeyword{ col = #a;}
            |
            b:pr_ConstKeyword{ col = #b;}
            |
            c:pr_TemplateKeyword{ col = #c;}
            |
            d:pr_TestcaseKeyword{ col = #d;}
            |
            e:pr_FunctionKeyword{ col = #e;}
            |
            f:pr_SignatureKeyword{ col = #f;}
            |
            (   
                g:pr_NamedKeyword{ col = #g;}
                endcol:pr_AltKeyword 
            )
        )
{ 
    ## = #([DefKeyword,"DefKeyword"], ##); 
	if(## != null) ##.setLocation(col, endcol==null?col:endcol);
};

pr_ImportGroupSpec:
		(
	        col:pr_GroupKeyword!
        	pr_GroupIdentifier
        	(
        	    pr_Comma!
        	    pr_GroupIdentifier
        	)*
        	endcol:pr_ImportFromSpec
		)
{ 
    ## = #([ImportGroupSpec,"ImportGroupSpec"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ImportTypeDefSpec:
		(
	        col:pr_TypeDefKeyword!
        	pr_TypeDefIdentifier
        	(
        	    pr_Comma!
        	    pr_TypeDefIdentifier
        	)*
        	endcol:pr_ImportFromSpec
		)
{ 
    ## = #([ImportTypeDefSpec,"ImportTypeDefSpec"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_TypeDefIdentifier:
        col:pr_Identifier
	/* covers all cases: 
		StructTypeIdentifier |
		EnumTypeIdentifier |
		PortTypeIdentifier |
		ComponentTypeIdentifier |
		SubTypeIdentifier */
{ 
	if( ## != null) ##.setLocation(#col, #col);
};
    
pr_ImportTemplateSpec:
		(
			col:pr_TemplateKeyword!
			pr_TemplateIdentifier 
			( 
			  pr_Colon!
			  pr_TemplateIdentifier 
			)*
			endcol:pr_ImportFromSpec
		)
{ 
    ## = #([ImportTemplateSpec,"ImportTemplateSpec"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ImportConstSpec:
		(
			col:pr_ConstKeyword
			pr_ConstIdentifier
			(
				pr_Comma!
				pr_ConstIdentifier
			)*
			endcol:pr_ImportFromSpec
		)
{
    ## = #([ImportConstSpec,"ImportConstSpec"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ImportTestcaseSpec:
		(
	        col:pr_TestcaseKeyword
	        pr_TestcaseIdentifier
	        (
	            pr_Comma!
	            pr_TestcaseIdentifier
	        )*
	        endcol:pr_ImportFromSpec
		)
{ 
    ## = #([ImportTestcaseSpec,"ImportTestcaseSpec"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ImportFunctionSpec:
		(
	        col:pr_FunctionKeyword!
	        pr_FunctionIdentifier
	        (
	            pr_Comma!
	            pr_FunctionIdentifier
	        )*
	        endcol:pr_ImportFromSpec
		)
{ 
    ## = #([ImportFunctionSpec,"ImportFunctionSpec"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ImportSignatureSpec:
		(
	        col:pr_SignatureKeyword
	        pr_SignatureIdentifier
	        (
	            pr_Comma!
	            pr_SignatureIdentifier
	        )*
	        endcol:pr_ImportFromSpec
		)
{ 
    ## = #([ImportSignatureSpec,"ImportSignatureSpec"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ImportNamedAltSpec:
		(
	        col:pr_NamedKeyword!
	        pr_AltKeyword!
	        pr_NamedAltIdentifier
	        (
	            pr_Comma!
	            pr_NamedAltIdentifier
	        )*
	        endcol:pr_ImportFromSpec
		)
		{ 
    ## = #([ImportNamedAltSpec,"ImportNamedAltSpec"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


//------------------------------------------------------
// 1.2.9 Group Definitions
// -----------------------------------------------------
pr_GroupDef:
        (
            col:pr_GroupKeyword!
            pr_GroupIdentifier
            pr_BeginChar!
            ( pr_ModuleDefinitionsPart )?
            endcol:pr_EndChar!
        )
{ 
    ## = #([GroupDef,"GroupDef"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_GroupKeyword:
        col:GROUP
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_GroupIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};

//------------------------------------------------------
// 1.2.10 External Function Definitions
// -----------------------------------------------------
pr_ExtFunctionDef{ColumnAST endCol = null;}:
        (
            col:pr_ExtKeyword!
            pr_FunctionKeyword!
            pr_ExtFunctionIdentifier
            pr_LParen!
            ( pr_FunctionFormalParList )?
            enda:pr_RParen!{endCol = #enda;}
            ( endb:pr_ReturnType{endCol = #endb;} )?
        )
{
    ## = #([ExtFunctionDef,"ExtFunctionDef"], ##); 
	if(## != null) ##.setLocation(#col, endCol);
};

pr_ExtKeyword:
        col:EXTERNAL
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_ExtFunctionIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};

//------------------------------------------------------
// 1.2.11 External Constant Definitions
// -----------------------------------------------------
pr_ExtConstDef:
		(
	        col:pr_ExtKeyword!
			pr_ConstKeyword!
			pr_Type
			endcol:pr_ExtConstIdentifier
		)
{ 
    ## = #([ExtConstDef,"ExtConstDef"], ##);
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_ExtConstIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};

//------------------------------------------------------
// 1.3 Control Part
// -----------------------------------------------------
pr_ModuleControlPart{ColumnAST endcol = null; }:
	(
	        col:pr_ControlKeyword!
	        pr_BeginChar!
	        pr_ModuleControlBody
	        enda:pr_EndChar!{endcol = #enda;}
	        ( endb:pr_WithStatement{endcol = #endb;} )?
	        ( endc:pr_SemiColon!{endcol = #endc;} )?
	)
{
    ## = #([ModuleControlPart,"ModuleControlPart"], ##); 
	if(## != null) ##.setLocation(#col, endcol);
};


pr_ControlKeyword:
        col:CONTROL
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_ModuleControlBody:
        ( col:pr_ControlStatementOrDefList )?
{
	if(## != null ) ##.setLocation(#col, #col);
};

pr_ControlStatementOrDefList{ColumnAST endcol = null; }:
	col: pr_ControlStatementOrDef 
	( a: pr_SemiColon {endcol= #a;} )?
	( 
	  b: pr_ControlStatementOrDef {endcol= #b;} 
	  ( c: pr_SemiColon  {endcol= #c;} )?
	)*
{
    ## = #([ControlStatementOrDefList,"ControlStatementOrDefList"], ##);
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_ControlStatementOrDef{ ColumnAST col=null;}:
        (
            a:pr_FunctionLocalInst { col = #a; }
            |
            b:pr_ControlStatement { col = #b; }
            |
            c:pr_FunctionLocalDef { col = #c; }
        )
{ 
    ## = #([ControlStatementOrDef,"ControlStatementOrDef"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_ControlStatement{ ColumnAST col=null;}:
        (
                (  pr_VariableRef pr_AssignmentChar! | pr_LogKeyword | 
                    pr_ForKeyword | pr_WhileKeyword | pr_DoKeyword | 
                    pr_IfKeyword ) =>
            a:pr_BasicStatements { col = #a; }
            |
                ( pr_SUTKeyword ) =>
            b:pr_SUTStatements { col = #b; }
            |
                ( pr_TimerRef pr_Dot ( pr_StartKeyword |  pr_StopKeyword | pr_TimeoutKeyword ) 
                | 
                pr_AnyKeyword pr_TimerKeyword | pr_AllKeyword pr_TimerKeyword  ) =>
            c:pr_TimerStatements { col = #c; }
            |
            d:pr_BehaviourStatements  { col = #d; }
        )
{
    ## = #([ControlStatement,"ControlStatement"], ##);
	if(## != null) ##.setLocation(col, col);
};

//------------------------------------------------------
// 1.3.1 Variable Instantiation
// -----------------------------------------------------
pr_VarInstance:
		(
			col:pr_VarKeyword!
			pr_Type
			endcol:pr_VarList
		)
{ 
    ## = #([VarInstance,"VarInstance"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_VarList:
		(
	        col:pr_SingleVarInstance
	        (
				endcol:(
					pr_Comma!
					pr_SingleVarInstance
				)*
			)
		)
{
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_SingleVarInstance{ColumnAST endcol=null;}:
		(
	        col:pr_VarIdentifier
	        ( a:pr_ArrayDef { endcol=#a; })?
	        (
	            pr_AssignmentChar!
	            b:pr_VarInitialValue {endcol=#b;}
	        )?
		)
{
    ## = #([SingleVarInstance,"SingleVarInstance"], ##); 
	if(## != null) ##.setLocation(#col, endcol==null?#col:endcol);
};


pr_VarInitialValue:
        col:pr_Expression
{
	if(## != null) ##.setLocation(#col, #col);
};


pr_VarKeyword:
        col:VAR
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
			
};


pr_VarIdentifier:
        col:pr_Identifier  	// covers both VarIdentifier | ValueParIdentifier
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_VariableRef:
        (
            col:pr_VarIdentifier 
            ( 
                    ( pr_Dot  | pr_SquareOpen | pr_LParen ) => 
                endcol:pr_ExtendedFieldReference
                |
            )
        )
{
    ## = #([VariableRef,"VariableRef"], ##);
	if(## != null) ##.setLocation(#col, #endcol == null?#col:#endcol);
};

pr_VariableRefId:
        col:pr_Identifier
{
    if(## != null) ##.setLocation(#col, #col);
};

//------------------------------------------------------
// 1.3.2 Timer Instantiation
// -----------------------------------------------------
pr_TimerInstance{ColumnAST endcol = null;}:
		(
	        col:pr_TimerKeyword!
	        a:pr_TimerIdentifier { endcol = #a; }
	        ( b:pr_ArrayDef { endcol = #b; } )?
	        (
	            pr_AssignmentChar!
	            c:pr_TimerValue { endcol = #c; }
	        )?
		)
{
    ## = #([TimerInstance,"TimerInstance"], ##); 
	if(## != null) ##.setLocation(#col, endcol);
};


pr_TimerKeyword:
        col:TIMER
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_TimerIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};


pr_TimerValue:
        col:pr_SingleExpression
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_TimerRef:
		(
			col:pr_TimerRefId
			( endcol:pr_ArrayOrBitRef )?
		)
{
    ## = #([TimerRef,"TimerRef"], ##); 
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_TimerRefId:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};

//------------------------------------------------------
// 1.3.3 Component Operations
// -----------------------------------------------------
pr_ConfigurationStatements{ ColumnAST col=null;}:
        (
            a:pr_ConnectStatement { col = #a; }
            |
            b:pr_MapStatement { col = #b; }
            |
                ( pr_ComponentIdentifier pr_Dot pr_StartKeyword ) =>
            c:pr_StartTCStatement { col = #c; }
            |
                ( pr_ComponentIdentifier pr_Dot pr_StopKeyword ) =>
            d:pr_StopTCStatement { col = #d; }
            |
            e:pr_DisconnectStatement { col = #e; }
            |
            f:pr_UnmapStatement { col = #f; }
            |
            g:pr_DoneStatement { col = #g; }
        )
{
    ## = #([ConfigurationStatements,"ConfigurationStatements"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_ConfigurationOps{ ColumnAST col=null;}:
        (
                ( pr_ComponentType pr_Dot pr_CreateKeyword ) =>
            a:pr_CreateOp { col = #a; }
            |
            b:pr_SelfOp { col = #b; }
            |
            c:pr_SystemOp { col = #c; }
            |
            d:pr_MTCOp { col = #d; }
            |
		( pr_RunningOp) =>
            e:pr_RunningOp { col = #e; }
        )
{
    ## = #([ConfigurationOps,"ConfigurationOps"], ##);
	if(## != null) ##.setLocation(col, col);
};

pr_CreateOp:
		(
			col:pr_ComponentType
			pr_Dot!
			endcol:pr_CreateKeyword!
		)
{ 
    ## = #([CreateOp,"CreateOp"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_SystemOp:
        col:SYSTEM!
{ 
    ## = #([SystemOp,"SystemOp"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_SelfOp:
        col:SELF!
{
    ## = #([SelfOp,"SelfOp"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_MTCOp:
        col:MTC!
{
    ## = #([MTCOp,"MTCOp"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_DoneStatement:
		(
			col:pr_ComponentId 
			pr_Dot!
			endcol:pr_DoneKeyword!
		)
{ 
    ## = #([DoneStatement,"DoneStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ComponentId{ColumnAST col=null;}:
		(
	        a:pr_ComponentIdentifier{ col =#a;}
		| 
	        ( 
	            (
					b:pr_AnyKeyword{ col = #b;}
				| 
					c:pr_AllKeyword{ col = #c;}
				)
				pr_ComponentKeyword! 
	        )
		)
{
    ## = #([ComponentId,"ComponentId"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_RunningOp:
		(
			col:pr_ComponentId 
			pr_Dot! 
			endcol:pr_RunningKeyword!
		)
{
    ## = #([RunningOp,"RunningOp"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};
pr_RunningKeyword:
        col:RUNNING
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_DoneKeyword:
        col:DONE
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_CreateKeyword:
        col:CREATE
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_ConnectStatement:
        (
            col:pr_ConnectKeyword!
            endcol:pr_PortSpec
        )
{
    ## = #([ConnectStatement,"ConnectStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_ConnectKeyword:
        col:CONNECT
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_PortSpec:
		(
	        col:pr_LParen!
	        pr_PortRef
	        pr_Comma!
	        pr_PortRef
	        endcol:pr_RParen!
		)
{
    ## = #([PortSpec,"PortSpec"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_PortRef:
		(
			col:pr_ComponentRef
			pr_Colon!
			endcol:pr_Port
		)
{
    ## = #([PortRef,"PortRef"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ComponentRef{ ColumnAST col=null;}:
        (
            a:pr_ComponentIdentifier { col = #a; }
            |
            b:pr_SystemOp { col = #b; }
            |
            c:pr_SelfOp { col = #c; }
            |
            d:pr_MTCOp { col = #d; }
        )
{
    ## = #([ComponentRef,"ComponentRef"], ##); 
	if(## != null) ##.setLocation(col, col);
};


pr_DisconnectStatement:
		(
			col:pr_DisconnectKeyword!
			endcol:pr_PortSpec 
		)
{
    ## = #([DisconnectStatement,"DisconnectStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_DisconnectKeyword:
		col:DISCONNECT
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
}; 


pr_MapStatement:
        (
            col:pr_MapKeyword!
            endcol:pr_PortSpec
        )
{
    ## = #([MapStatement,"MapStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_MapKeyword:
        col:MAP
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_UnmapStatement:
		(
			col:pr_UnmapKeyword! 
			endcol:pr_PortSpec 
		)
{
    ## = #([UnmapStatement,"UnmapStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_UnmapKeyword:
        col:UNMAP
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};
	
pr_StartTCStatement:
        (
            col:pr_ComponentIdentifier
            pr_Dot!
            pr_StartKeyword!
            pr_LParen!
            pr_FunctionInstance
            endcol:pr_RParen!
        )
{
    ## = #([StartTCStatement,"StartTCStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};



pr_StartKeyword:
        col:START
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_StopTCStatement:
        col:pr_StopKeyword!
{
    ## = #([StopTCStatement,"StopTCStatement"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};


pr_ComponentIdentifier{ColumnAST col=null;}:
        (
			( pr_FunctionInstance ) =>
			a:pr_FunctionInstance { col = #a;}
		|
			b:pr_VariableRef { col = #b;}
        )
{
	if(## != null) ##.setLocation(col, col);
};

//------------------------------------------------------
// 1.3.4 Port Operations
// -----------------------------------------------------
pr_Port:
		(
			col:pr_PortId
			( endcol:pr_ArrayOrBitRef )?
		)
{
    ## = #([Port,"Port"], ##); 
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};


pr_PortId:
        col:pr_Identifier 
{
	if(## != null) ##.setLocation(#col, #col);
};


pr_CommunicationStatements{ ColumnAST col=null;}:
        (
                ( pr_Port pr_Dot pr_SendOpKeyword ) =>
            a:pr_SendStatement { col = #a; }
            |
                ( pr_Port pr_Dot pr_CallOpKeyword ) =>
            b:pr_CallStatement { col = #b; }
            |
                ( pr_Port pr_Dot pr_ReplyKeyword ) =>
            c:pr_ReplyStatement { col = #c; }
            |
                ( pr_Port pr_Dot pr_RaiseKeyword ) =>
            d:pr_RaiseStatement { col = #d; }
            |
                ( pr_PortOrAny pr_Dot pr_ReceiveOpKeyword ) =>
            e:pr_ReceiveStatement { col = #e; }
            |
                ( pr_PortOrAny pr_Dot pr_TriggerOpKeyword  ) =>
            f:pr_TriggerStatement { col = #f; }
            |
                ( pr_PortOrAny pr_Dot pr_GetCallOpKeyword ) =>
            g:pr_GetCallStatement { col = #g; }
            |
                ( pr_PortOrAny pr_Dot pr_GetReplyOpKeyword ) =>
            h:pr_GetReplyStatement { col = #h; }
            |
                ( pr_PortOrAny pr_Dot pr_CatchOpKeyword ) =>
            i:pr_CatchStatement { col = #i; }
            |
                ( pr_PortOrAny pr_Dot pr_CheckOpKeyword ) =>
            j:pr_CheckStatement { col = #j; }
            |
                ( pr_PortOrAny pr_Dot pr_ClearOpKeyword ) =>
            k:pr_ClearStatement { col = #k; }
            |
                ( pr_PortOrAny pr_Dot pr_StartKeyword ) =>
            l:pr_StartStatement { col = #l; }
            |
            m:pr_StopStatement { col = #m; }
        )
{
    ## = #([CommunicationStatements,"CommunicationStatements"], ##);
	if(## != null) ##.setLocation(col, col);
};

pr_SendStatement:
		(        
			col:pr_Port
			pr_Dot!
			endcol:pr_PortSendOp
		)
{
    ## = #([SendStatement,"SendStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_PortSendOp:
		(
			col:pr_SendOpKeyword!
			pr_LParen!
			pr_SendParameter
			pr_RParen!
			( pr_ToClause )?
		)
{
    ## = #([PortSendOp,"PortSendOp"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};

pr_SendOpKeyword:
        col:SEND
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_SendParameter:
        col:pr_TemplateInstance
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_ToClause:
		(
			col:pr_ToKeyword!
			endcol:pr_AddressRef
		)
{ 
    ## = #([ToClause,"ToClause"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ToKeyword:
        col:TO
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_AddressRef{ColumnAST col=null;}:
        (
                ( pr_FunctionInstance ) =>
            a:pr_FunctionInstance{ col = #a;}
            |
            b:pr_VariableRef{ col = #b;}
        )
{ 
    ## = #([AddressRef,"AddressRef"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_CallStatement{ColumnAST endcol = null;}:
		(
			col:pr_Port
			pr_Dot!
			a: pr_PortCallOp {endcol = #a;} 
			( b:pr_PortCallBody {endcol = #b;} )?
		)
{ 
    ## = #([CallStatement,"CallStatement"], ##); 
	if(## != null) ##.setLocation(#col, endcol);
};

pr_PortCallOp{ColumnAST endcol = null;}:
		(
			col:pr_CallOpKeyword!
			pr_LParen!
			pr_CallParameters
			a:pr_RParen! { endcol = #a; }
			( b:pr_ToClause { endcol = #b; } )?
		)
{ 
    ## = #([PortCallOp,"PortCallOp"], ##); 
	if(## != null) ##.setLocation(#col, endcol);
};

pr_CallOpKeyword:
        col:CALL
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_CallParameters:
		(
			col:pr_TemplateInstance
			(
				pr_Comma!
				endcol:pr_CallTimerValue
			)?
		)
{ 
    ## = #([CallParameters,"CallParameters"], ##); 
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_CallTimerValue{ColumnAST col=null;}:
        (
            a:pr_TimerValue{ col = #a;}
            |
            b:pr_NowaitKeyword{ col = #b;}
        )
{ 
    ## = #([CallTimerValue,"CallTimerValue"], ##); 
	if(## != null) ##.setLocation(col, col);
};


pr_NowaitKeyword:
        col:NOWAIT!
{
    ## = #([NowaitKeyword,"NowaitKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_PortCallBody:
		(
			col:pr_BeginChar!
			pr_CallBodyStatementList
			endcol:pr_EndChar!
		)
{ 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_CallBodyStatementList{ColumnAST endcol=null;}:
		(
	          col:pr_CallBodyStatement
		  ( a: pr_SemiColon {endcol= #a; } )?
		  ( 
	             b:pr_CallBodyStatement {endcol= #b; }
		     ( c:pr_SemiColon {endcol= #c; })?
		  )*
		)
{ 
    ## = #([CallBodyStatementList,"CallBodyStatementList"], ##); 
	if(## != null) ##.setLocation(#col, endcol==null?#col:endcol);
};

pr_CallBodyStatement:
		(
			col:pr_CallBodyGuard
			endcol:pr_StatementBlock
		)
{ 
    ## = #([CallBodyStatement,"CallBodyStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_CallBodyGuard:
		(
			col:pr_AltGuardChar
			endcol:pr_CallBodyOps
		)
{ 
    ## = #([CallBodyGuard,"CallBodyGuard"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_CallBodyOps{ColumnAST col=null;}:
        (
                ( pr_PortOrAny pr_Dot pr_GetReplyOpKeyword ) =>
            a:pr_GetReplyStatement{ col = #a;}
            |
            b:pr_CatchStatement{ col = #b;}
        )
{ 
    ## = #([CallBodyOps,"CallBodyOps"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_ReplyStatement:
		(
			col:pr_Port
			pr_Dot!
			endcol:pr_PortReplyOp
		)
{ 
    ## = #([ReplyStatement,"ReplyStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_PortReplyOp{ColumnAST endcol=null;}:
		(
			col:pr_ReplyKeyword!
			pr_LParen!
			pr_TemplateInstance
			( pr_ReplyValue )?
			a:pr_RParen! { endcol = #a; }
			( b:pr_ToClause { endcol = #b; } )?
		)
{ 
    ## = #([PortReplyOp,"PortReplyOp"], ##); 
	if(## != null) ##.setLocation(#col, endcol);
};


pr_ReplyKeyword:
        col:REPLY
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_ReplyValue:
		(
			col:pr_ValueKeyword!
			endcol:pr_Expression
		)
{ 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_RaiseStatement:
		(
			col:pr_Port
			pr_Dot!
			endcol:pr_PortRaiseOp
		)
{ 
    ## = #([RaiseStatement,"RaiseStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_PortRaiseOp{ColumnAST endcol=null;}:
		(
			col:pr_RaiseKeyword!
			pr_LParen!
			pr_Signature
			pr_Comma!
			pr_TemplateInstance
			a:pr_RParen! { endcol = #a; }
			( b:pr_ToClause { endcol = #b; } )?
		)
{ 
    ## = #([PortRaiseOp,"PortRaiseOp"], ##); 
	if(## != null) ##.setLocation(#col, endcol);
};


pr_RaiseKeyword:
        col:RAISE
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_ReceiveStatement:
        (
            col:pr_PortOrAny
            pr_Dot!
            endcol:pr_PortReceiveOp
        )
{
    ## = #([ReceiveStatement,"ReceiveStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_PortOrAny{ ColumnAST col=null; ColumnAST endcol=null;}:
        (
            a:pr_Port { col = #a; }
            |
            b:pr_AnyKeyword  { col = #b; } 

	    x:pr_PortKeyword! { endcol =#x; }
        )
{
    ## = #([PortOrAny,"PortOrAny"], ##); 
	if(## != null) ##.setLocation(col, endcol==null?col:endcol);
};

pr_PortReceiveOp{ColumnAST endcol=null;}:
        (
            col:pr_ReceiveOpKeyword!
            (
                (
                    pr_LParen!
                    pr_ReceiveParameter
                    a:pr_RParen! { endcol =#a; }
                )
            )? 
            ( b:pr_FromClause { endcol =#b; } )? 
            ( c:pr_PortRedirect { endcol =#c; } )? 
        )
{ 
    ## = #([PortReceiveOp,"PortReceiveOp"], ##); 
	if(## != null) ##.setLocation(#col, endcol==null?#col:endcol);
};


pr_ReceiveOpKeyword:
        col:RECEIVE
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_ReceiveParameter:
        col:pr_TemplateInstance
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_FromClause:
		(
			col:pr_FromKeyword!
			endcol:pr_AddressRef
		)
{ 
    ## = #([FromClause,"FromClause"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_FromKeyword:
        col:FROM
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_PortRedirect{ColumnAST endcol = null;}:
        (
            col:pr_PortRedirectSymbol!
            (
                (
                    a:pr_ValueSpec {endcol = #a;}
                    ( b:pr_SenderSpec {endcol = #b;})?
                )
                |
                c:pr_SenderSpec {endcol = #c;}
            )
        )
{ 
    ## = #([PortRedirect,"PortRedirect"], ##); 
	if(## != null) ##.setLocation(#col, endcol);
};


pr_PortRedirectSymbol:
        col:PORTREDIRECTSYMBOL
{
    if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_ValueSpec:
		(
			col:pr_ValueKeyword!
			endcol:pr_VariableRef
		)
{ 
    ## = #([ValueSpec,"ValueSpec"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_ValueKeyword:
        col:VALUE
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_SenderSpec:
		(
			col:pr_SenderKeyword!
			endcol:pr_VariableRef
		)
{ 
    ## = #([SenderSpec,"SenderSpec"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_SenderKeyword:
        col:SENDER
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_TriggerStatement:
		(
			col:pr_PortOrAny
			pr_Dot!
			endcol:pr_PortTriggerOp
		)
{ 
    ## = #([TriggerStatement,"TriggerStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_PortTriggerOp{ColumnAST endcol = null;}:
		(
			col:pr_TriggerOpKeyword
			(
				pr_LParen!
				pr_ReceiveParameter
				a:pr_RParen! {endcol = #a;}
			)?
			( b:pr_FromClause )? {endcol = #b;}
			( c:pr_PortRedirect )? {endcol = #c;}
		)
{ 
    ## = #([PortTriggerOp,"PortTriggerOp"], ##); 
	if(## != null) ##.setLocation(#col, endcol==null?#col:endcol);
};


pr_TriggerOpKeyword:
        col:TRIGGER
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_GetCallStatement:
		(
			col:pr_PortOrAny
			pr_Dot!
			endcol:pr_PortGetCallOp
		)
{ 
    ## = #([GetCallStatement,"GetCallStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_PortGetCallOp{ColumnAST endcol=null;}:
		(
			col:pr_GetCallOpKeyword!
			(
				pr_LParen!
				pr_ReceiveParameter
				a:pr_RParen! { endcol =#a; }
			)?
			( b:pr_FromClause { endcol =#b; } )?
			( c:pr_PortRedirectWithParam { endcol =#c; } )?
		)
{ 
    ## = #([PortGetCallOp,"PortGetCallOp"], ##); 
	if(## != null) ##.setLocation(#col, endcol==null?#col:endcol);
};


pr_GetCallOpKeyword:
        col:GETCALL
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_PortRedirectWithParam:
		(
			col:pr_PortRedirectSymbol!
			endcol:pr_RedirectSpec
		)
{
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_RedirectSpec{ColumnAST bcol=null; ColumnAST ecol = null;}:
		(
			(
				cola:pr_ValueSpec {bcol=#cola; ecol=#cola;}
				( colc:pr_ParaSpec {ecol=#colc;} )?
				( cold:pr_SenderSpec {ecol=#cold;} )?
			)
        	|
			(
				colb:pr_ParaSpec{bcol=#colb; ecol=#colb;}
				( cole:pr_SenderSpec {ecol=#cole;} )?
			)
		)
{ 
    ## = #([RedirectSpec,"RedirectSpec"], ##); 
	if(## != null) ##.setLocation(bcol, ecol);
};



pr_ParaSpec:
		(
			col:pr_ParaKeyword!
			endcol:pr_ParaAssignmentList
		)
{ 
    ## = #([ParaSpec,"ParaSpec"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_ParaKeyword:
        col:PARAM
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_ParaAssignmentList:
		(
        	col:pr_LParen!
        	(
        	        ( pr_VariableRef pr_AssignmentChar! ) =>
        	    pr_AssignmentList
        	    |
        	    pr_VariableList
        	)
        	endcol:pr_RParen!
		)
{
    ## = #([ParaAssignmentList,"ParaAssignmentList"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_AssignmentList:
		(
	        col:pr_VariableAssignment
	        (
	            pr_Comma!
	            endcol:pr_VariableAssignment
	        )*
		)
{ 
	if( ## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_VariableAssignment:
		(
			col:pr_VariableRef
			pr_AssignmentChar!
			endcol:pr_ParameterIdentifier
		)
{ 
    ## = #([VariableAssignment,"VariableAssignment"], ##);
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_ParameterIdentifier:
		col:pr_Identifier
		/* covers all cases
		   ValueParIdentifier |
		   TimerParIdentifier |
		   TemplateParIdentifier |
		   PortParIdentifier */
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_VariableList:
		(
			col:pr_VariableEntry
			(
				pr_Comma!
				endcol:pr_VariableEntry
			)*
		)
{ 
	if(## != null) ##.setLocation(#col, #endcol == null?#col:#endcol);
};

pr_VariableEntry{ColumnAST col=null;}:
        (
            a:pr_VariableRef{ col = #a;}
            |
            b:pr_NotUsedSymbol{ col = #b;}
        )
{
    ## = #([VariableEntry,"VariableEntry"], ##);
	if(## != null) ##.setLocation(col, col);
};


pr_GetReplyStatement:
		(
			col:pr_PortOrAny
			pr_Dot!
			endcol:pr_PortGetReplyOp
		)
{ 
    ## = #([GetReplyStatement,"GetReplyStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_PortGetReplyOp{ColumnAST endcol=null;}:
		(
			col:pr_GetReplyOpKeyword!
			(
				pr_LParen!
				pr_ReceiveParameter
				( pr_ValueMatchSpec )?
				a:pr_RParen! { endcol =#a; }
			)?
			( b:pr_FromClause { endcol =#b; } )?
			( c:pr_PortRedirectWithParam { endcol =#c; } )?
		)
{ 
    ## = #([PortGetReplyOp,"PortGetReplyOp"], ##);
	if(## != null) ##.setLocation(#col, endcol==null?#col:endcol);
};


pr_GetReplyOpKeyword:
        col:GETREPLY
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_ValueMatchSpec:
		(
			col:pr_ValueKeyword!
			endcol:pr_TemplateInstance
		)
{ 
    ## = #([ValueMatchSpec,"ValueMatchSpec"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_CheckStatement:
		(
			col:pr_PortOrAny
			pr_Dot!
			endcol:pr_PortCheckOp
		)
{ 
    ## = #([CheckStatement,"CheckStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_PortCheckOp:
		(
			col:pr_CheckOpKeyword!
			(
				pr_LParen!
				pr_CheckParameter
				endcol:pr_RParen!
			)?
		)
{ 
    ## = #([PortCheckOp,"PortCheckOp"], ##); 
	if(## != null) ##.setLocation(#col, #endcol == null?#col:#endcol);
};


pr_CheckOpKeyword:
        col:CHECK
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_CheckParameter{ColumnAST col=null;ColumnAST endcol=null;}:
        (
            a:pr_PortReceiveOp{ col = #a;}
            |
            b:pr_PortGetCallOp{ col = #b;}
            |
            c:pr_PortGetReplyOp{ col = #c;}
            |
            d:pr_PortCatchOp{ col = #d;}
	    |
	     (	
               ( e: pr_FromClause { col = #e;})?
               (
                 f: pr_PortRedirectSymbol! { col = #f;}
                 g: pr_SenderSpec { endcol = #g;}
               )?
	     )
        )
{ 
    ## = #([CheckParameter,"CheckParameter"], ##); 
	if(## != null) ##.setLocation(col,endcol==null?col:endcol);
};

pr_CatchStatement:
		(
			col:pr_PortOrAny
			pr_Dot!
			endcol:pr_PortCatchOp
		)
{ 
    ## = #([CatchStatement,"CatchStatement"], ##);
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_PortCatchOp{ColumnAST endcol=null;}:
		(
		 col:pr_CatchOpKeyword!
		 (
			pr_LParen!
			pr_CatchOpParameter
			a:pr_RParen! { endcol =#a; }
		 )?
		 ( b:pr_FromClause { endcol =#b; } )?
  		 ( c:pr_PortRedirect { endcol =#c; } )?
		)
{ 
    ## = #([PortCatchOp,"PortCatchOp"], ##);
	if(## != null) ##.setLocation(#col, endcol==null?#col:endcol);
};

pr_CatchOpKeyword:
        col:CATCH
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_CatchOpParameter:
	(
            ( 
                begcol:pr_Signature
                pr_Comma!
				endcol:pr_TemplateInstance
			)
		|	
			( col:pr_TimeoutKeyword )
	)
{ 
    ## = #([CatchOpParameter,"CatchOpParameter"], ##); 
	if(#begcol != null) {
	if(## != null) ##.setLocation(#begcol, #endcol);
	} else
	if(## != null) ##.setLocation(#col, #col);
};

pr_ClearStatement:
		(
			col:pr_PortOrAll
			pr_Dot!
			endcol:pr_PortClearOp
		)
{ 
    ## = #([ClearStatement,"ClearStatement"], ##);
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_PortOrAll{ColumnAST col=null;}:
        (
            a:pr_Port{ col = #a;}
            |
            b:pr_AllPort{ col = #b;}
        )
{ 
    ## = #([PortOrAll,"PortOrAll"], ##);
	if(## != null) ##.setLocation(col, col);
};

pr_AllPort:
		(
			col:pr_AllKeyword!
			endcol:pr_PortKeyword!
		)
{ 
    ## = #([AllPort,"AllPort"], ##);
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_PortClearOp: 
		col:pr_ClearOpKeyword!
{ 
    ## = #([PortClearOp,"PortClearOp"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};


pr_ClearOpKeyword:
        col:CLEAR
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_StartStatement:
		(
			col:pr_PortOrAll
			pr_Dot!
			endcol:pr_PortStartOp
		)
{ 
    ## = #([StartStatement,"StartStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_PortStartOp:
        col:pr_StartKeyword!
{ 
    ## = #([PortStartOp,"PortStartOp"], ##);
	if(## != null) ##.setLocation(#col, #col);
};

pr_StopStatement:
		(
			col:pr_PortOrAll
			pr_Dot!
			endcol:pr_PortStopOp
		)
{ 
    ## = #([StopStatement,"StopStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_PortStopOp:
        col:pr_StopKeyword!
{
    ## = #([PortStopOp,"PortStopOp"], ##);
	if(## != null) ##.setLocation(#col, #col);
};


pr_StopKeyword:
        col:STOP
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_AnyKeyword:
        col:ANY!
{
    ## = #([AnyKeyword,"AnyKeyword"], ##);
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

//------------------------------------------------------
// 1.3.5 Timer Operations
// -----------------------------------------------------
pr_TimerStatements{ ColumnAST col=null;}:
        (
                ( pr_TimerRef pr_Dot pr_StartKeyword ) =>
            a:pr_StartTimerStatement { col = #a; }
            |
                ( pr_TimerRef pr_Dot pr_StopKeyword ) =>
            b:pr_StopTimerStatement { col = #b; }
            |
		( pr_TimeoutStatement ) =>
            c:pr_TimeoutStatement { col = #c; }
        )
{
    ## = #([TimerStatements,"TimerStatements"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_TimerOps{ ColumnAST col=null;}:
        (
                ( pr_ReadTimerOp ) =>
            a:pr_ReadTimerOp { col = #a; }
            |
            b:pr_RunningTimerOp { col = #b; }
        )
{
    ## = #([TimerOps,"TimerOps"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_StartTimerStatement:
		(
			col:pr_TimerRef
			pr_Dot!
			pr_StartKeyword!
			(
				pr_LParen!
				pr_TimerValue
				pr_RParen!
			)?
		)
{
    ## = #([StartTimerStatement,"StartTimerStatement"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};

pr_StopTimerStatement:
		(
			col:pr_TimerRefOrAll
			pr_Dot!
			endcol:pr_StopKeyword!
		)
{
    ## = #([StopTimerStatement,"StopTimerStatement"], ##);
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_TimerRefOrAll{ ColumnAST col=null;}:
		(
		  a: pr_TimerRef {col= #a;}
		| 
		  ( 
	 	    b: AllKeyword {col= #b;}
		    endcol: TimerKeyword 
		  )
		)
{
    ## = #([TimerRefOrAll,"TimerRefOrAll"], ##);
	if(## != null) ##.setLocation(#col, #endcol==null?col:#endcol);
};

pr_ReadTimerOp:
		(
			col:pr_TimerRef
			pr_Dot!
			endcol:pr_ReadKeyword!
		)
{
    ## = #([ReadTimerOp,"ReadTimerOp"], ##);
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_ReadKeyword:
        col:READ
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_RunningTimerOp:
		(
			col:pr_TimerRefOrAny
			pr_Dot!
			endcol:pr_RunningKeyword!
		)
{
    ## = #([RunningTimerOp,"RunningTimerOp"], ##);
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_TimeoutStatement:
		( 
		  col:pr_TimerRefOrAny
		  pr_Dot!
	    	  endcol:pr_TimeoutKeyword!
		)
{
	## = #([TimeoutStatement,"TimeoutStatement"], ##);
	if(## != null) ##.setLocation(#col, #endcol!=null?#col:#endcol);
};

pr_TimerRefOrAny{ ColumnAST col=null;}:
		(
		  a: pr_TimerRef {col= #a;}
		| 
		  ( 
	 	    b: pr_AnyKeyword {col= #b;}
		    endcol: pr_TimerKeyword 
		  )
		)
{
    ## = #([TimerRefOrAny,"TimerRefOrAny"], ##);
	if(## != null) ##.setLocation(#col, #endcol==null?col:#endcol);
};

pr_TimeoutKeyword:
        col:TIMEOUT!
{
	## = #([TimeoutKeyword,"TimeoutKeyword"], ##);
	if(## != null) ##.setLocation(#col, #col);
};

//------------------------------------------------------
// 1.4 Type
// -----------------------------------------------------
pr_Type {ColumnAST col=null;}:
        (
            a:pr_PredefinedType{ col = #a;}
            |
            b:pr_ReferencedType{ col = #b;}
        )
{ 
    ## = #([Type,"Type"], ##);
	if(## != null) ##.setLocation(col, col);
};

pr_PredefinedType { ColumnAST col=null;}:
        (
            a:pr_BitStringKeyword { col = #a; }
            |
            b:pr_HexStringKeyword { col = #b; }
            |
            c:pr_OctetStringKeyword { col = #c; }
            |
            d:pr_BooleanKeyword { col = #d; }
            |
            e:pr_CharStringKeyword { col = #e; }
            |
            f:pr_UniversalCharString { col = #f; }
            |
            g:pr_CharKeyword { col = #g; }
            |
            h:pr_UniversalChar { col = #h; }
            |
            i:pr_IntegerKeyword { col = #i; }
            |
            j:pr_ObjectIdentifierKeyword { col = #j; }
            |
            k:pr_VerdictTypeKeyword { col = #k; }
            |
            l:pr_FloatKeyword { col = #l; }
            |
            m:pr_AddressKeyword { col = #m; }
        )
{ 
    ## = #([PredefinedType,"PredefinedType"], ##); 
	if(## != null) ##.setLocation(col, col);
};


pr_BitStringKeyword:
        col:BITSTRING!
{
	## = #([BitStringKeyword,"BitStringKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
	
};


pr_BooleanKeyword:
        col:BOOLEAN!
{ 
    ## = #([BooleanKeyword,"BooleanKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_IntegerKeyword:
        col:INTEGER!
{ 
    ## = #([IntegerKeyword,"IntegerKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_OctetStringKeyword:
        col:OCTETSTRING!
{ 
    ## = #([OctetStringKeyword,"OctetStringKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_ObjectIdentifierKeyword:
        col:OBJECTIDENTIFIER!
{ 
    ## = #([ObjectIdentifierKeyword,"ObjectIdentifierKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_HexStringKeyword:
        col:HEXSTRING!
{ 
    ## = #([HexStringKeyword,"HexStringKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_VerdictKeyword:
        col:VERDICT!
{
    ## = #([VerdictKeyword,"VerdictKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_VerdictTypeKeyword:
        col:VERDICTTYPE!
{
    ## = #([VerdictTypeKeyword,"VerdictTypeKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_FloatKeyword:
        col:FLOAT!
{ 
    ## = #([FloatKeyword,"FloatKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_AddressKeyword:
        col:ADDRESS!
{ 
    ## = #([AddressKeyword,"AddressKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_CharStringKeyword:
        col:CHARSTRING!
{ 
    ## = #([CharStringKeyword,"CharStringKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_UniversalCharString:
		(
			col:pr_UniversalKeyword
			endcol:pr_CharStringKeyword
		)
{ 
    ## = #([UniversalCharString,"UniversalCharString"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_CharKeyword:
        col:CHARKEYWORD!
{ 
    ## = #([CharKeyword,"CharKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_UniversalChar:
		(
			col:pr_UniversalKeyword
			endcol:pr_CharKeyword
		)
{ 
    ## = #([UniversalChar,"UniversalChar"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_UniversalKeyword:
        col:UNIVERSAL!
{ 
    ## = #([UniversalKeyword,"UniversalKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_ReferencedType:
        (
            (
                    ( pr_GlobalModuleId pr_Dot ) =>
                cola:pr_GlobalModuleId
                pr_Dot!
                |
            )
			col:pr_TypeReference
            (
                    ( pr_Dot | pr_SquareOpen | pr_LParen ) =>
                colb:pr_ExtendedFieldReference
                |
            )
        )
{ 
    ## = #([ReferencedType,"ReferencedType"], ##); 
	if(## != null) ##.setLocation(#cola==null?#col:#cola, #colb==null?#col:#colb);
};

pr_TypeReference:
        (   
            col:pr_TypeReferenceId
            (
                    ( pr_LParen ) =>
                endcol:pr_TypeActualParList
                |   
            )
        )
{ 
    ## = #([TypeReference,"TypeReference"], ##); 
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_TypeReferenceId:
		col:pr_Identifier 
		/* covers all cases
		   StructTypeIdentifier |
		   EnumTypeIdentifier |
		   SubTypeIdentifier |
		   TypeParIdentifier |
	 	   ComponentTypeIdentifier */
		( ( pr_TypeActualParList ) =>
		  endcol: pr_TypeActualParList )?
{
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_TypeActualParList:
		(
	        col:pr_LParen!
	        pr_TypeActualPar
	        (
	            pr_Comma!
	            pr_TypeActualPar
	        )*
	        endcol:pr_RParen!
		)
{ 
    ## = #([TypeActualParList,"TypeActualParList"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_TypeActualPar{ColumnAST col=null;}:
        (
                ( pr_SingleConstExpression ) =>
            a:pr_SingleConstExpression{ col = #a;}
            |
            b:pr_Type{ col = #b;}
        )
{ 
    ## = #([TypeActualPar,"TypeActualPar"], ##); 
	if(## != null) ##.setLocation(col, col);
};

//------------------------------------------------------
// 1.4.1 Array Types
// -----------------------------------------------------
pr_ArrayDef:
        (
            col:pr_SquareOpen!
            pr_ArrayBounds
            (
                pr_RangeOp!
                pr_ArrayBounds
            )?
            endcol:pr_SquareClose!
        )+
{ 
    ## = #([ArrayDef,"ArrayDef"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ArrayBounds:
        col:pr_SingleConstExpression
{ 
    ## = #([ArrayBounds,"ArrayBounds"], ##);
	if(## != null) ##.setLocation(#col, #col);
};

//------------------------------------------------------
// 1.5 Value
// -----------------------------------------------------
pr_Value{ColumnAST col=null;}:
        (
                ( pr_PredefinedValue ) =>
            a:pr_PredefinedValue { col = #a; }
            |
            b:pr_ReferencedValue { col = #b; }
        )
{
    ## = #([Value,"Value"], ##); 
	if(## != null) ##.setLocation(col, col);
};


pr_PredefinedValue{ ColumnAST col=null; }:
        (  
            a1:pr_HexStringValue { col = #a1; }
            |
            a2:pr_BitStringValue { col = #a2; }
            |
            a3:pr_OctetStringValue { col = #a3; }
            |
                ( pr_BooleanValue ) => 
            b:pr_BooleanValue { col = #b; }
            |
                ( pr_CharStringValue ) =>
            c:pr_CharStringValue { col = #c; }
            |
            d:pr_IntegerValue { col = #d; }
            |
            e:pr_ObjectIdentifierValue { col = #e; }
            |
            f:pr_VerdictValue { col = #f; }
            |
            g:pr_EnumeratedValue { col = #g; }
            |
            h:pr_FloatValue { col = #h; }
            |
            i:pr_AddressValue { col = #i; }
        )
{ 
    ## = #([PredefinedValue,"PredefinedValue"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_BitStringValue:
        col:BSTRING 
{ 
    ## = #([BitStringValue,"BitStringValue"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_OctetStringValue:
        col:OSTRING
{ 
    ## = #([OctetStringValue,"OctetStringValue"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_HexStringValue:
        col:HSTRING
{ 
    ## = #([HexStringValue,"HexStringValue"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_BooleanValue{ ColumnAST col=null;}:
        (
            a:pr_True { col = #a; }
            |
            b:pr_False { col = #b; }
        )
{ 
    ## = #([BooleanValue,"BooleanValue"], ##); 
	if(## != null) ##.setLocation(col, col);
};


pr_True:
        col:TRUE!
{ 
    ## = #([True,"True"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};



pr_False:
        col:FALSE!
{ 
    ## = #([False,"False"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_IntegerValue:
        col:pr_Number
{
	if(## != null) ##.setLocation(#col, #col);
};


pr_ObjectIdentifierValue:
		(
			col:pr_ObjectIdentifierKeyword 
			pr_BeginChar
			pr_ObjIdComponentList
			endcol:pr_EndChar!
		)
{
    ## = #([ObjectIdentifierValue,"ObjectIdentifierValue"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ObjIdComponentList:
		(
	        col:pr_ObjIdComponent
	        (
	            pr_Dot!
	            endcol:pr_ObjIdComponent
	        )*
		)
{
	if(## != null) ##.setLocation(#col, #endcol == null?#col:#endcol);
};

pr_ObjIdComponent{ ColumnAST col=null;}:
        (
                ( pr_NameAndNumberForm ) =>
            a:pr_NameAndNumberForm { col = #a; }
            |
            b:pr_NumberForm { col = #b; }
        )
{
    ## = #([ObjIdComponent,"ObjIdComponent"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_NumberForm{ ColumnAST col=null;}:
        (
            a:pr_Number { col = #a; }
            |
            b:pr_ReferencedValue { col = #b; }
        )
{
    ## = #([NumberForm,"NumberForm"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_Number:
        col: NUMBER
{
    ## = #([Number,"Number"], ##);
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_NameAndNumberForm:
		(
			col:pr_Identifier
			endcol:pr_NumberForm
		)
{
    ## = #([NameAndNumberForm,"NameAndNumberForm"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_VerdictValue{ ColumnAST col=null;}:
        (
            a:pr_Pass { col = #a; }
            |
            b:pr_Fail { col = #b; }
            |
            c:pr_Inconc { col = #c; }
            |
            d:pr_None { col = #d; }
            |
            e:pr_Error { col = #e; }
        )
{
    ## = #([VerdictValue,"VerdictValue"], ##);
	if(## != null) ##.setLocation(col, col);
};

pr_Pass:
        col:PASS!
{
    ## = #([Pass,"Pass"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_Fail:
        col:FAIL!
{
    ## = #([Fail,"Fail"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_Inconc:
		col:INCONC!
{
    ## = #([Inconc,"Inconc"], ##);
    if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_None:
		col:NONE!
{
    ## = #([None,"None"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_Error:
		col:ERROR!
{
    ## = #([Error,"Error"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_EnumeratedValue:
        col:pr_NamedValueIdentifier
{ 
    ## = #([EnumeratedValue,"EnumeratedValue"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};

pr_CharStringValue{ ColumnAST col=null;}:
        (
            a:CSTRING { col = #a; }
            |
            b:pr_Quadruple { col = #b; }
            |
            c:pr_ReferencedValue { col = #c; }
        )
{
    	## = #([CharStringValue,"CharStringValue"], ##); 
	if(## != null) ##.setLocation(col,col);
};

pr_CharStringValueId:
        col:CSTRING
{ 
    ## = #([CharStringValueId,"CharStringValueId"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_Quadruple:
		(
			col:pr_LParen!
			pr_Group
			pr_Comma!
			pr_Plane
			pr_Comma!
			pr_Row
			pr_Comma!
			pr_Cell
			endcol:pr_RParen!
		)
{ 
    ## = #([Quadruple,"Quadruple"], ##); 

	if(## != null) ##.setLocation(#col, #endcol);
};

pr_Group:
        col:NUMBER
{ 
    ## = #([Group,"Group"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_Plane:
        col:NUMBER
{ 
    ## = #([Plane,"Plane"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_Row:
        col:NUMBER
{ 
    ## = #([Row,"Row"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_Cell:
        col:NUMBER
{ 
    ## = #([Cell,"Cell"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_FloatValue:
        col:FLOATVALUE
{
    ## = #([FloatValue,"FloatValue"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_ReferencedValue:
		(
			col:pr_ValueReference
			(
                ( pr_Dot | pr_SquareOpen | pr_LParen ) =>
				endcol:pr_ExtendedFieldReference
            	|
			)
		)
{
    ## = #([ReferencedValue,"ReferencedValue"], ##); 
	if(## != null) ##.setLocation(#col, #endcol == null?#col:#endcol);
};

pr_ValueReference{ColumnAST col = null;}:
		(
            	 ( 
	   	   (pr_GlobalModuleId DOT ) => 
	   	   a:pr_GlobalModuleId DOT!
		 | 
               	 ) 
            	 b:pr_Identifier
		 /* covers all cases
		    ConstIdentifier |
		    ExtConstIdentifier |
   		    ValueParIdentifier |
   		    ModuleParIdentifier |
		    VarIdentifier */

		)
{
    ## = #([ValueReference,"ValueReference"], ##);
    if(#a != null) {
	if(## != null) ##.setLocation(#a); 
    } else {
	if(## != null) ##.setLocation(#b); 
    }
};

pr_AddressValue:
        col:pr_Null
{ 
    ## = #([AddressValue,"AddressValue"], ##);
	if(## != null) ##.setLocation(#col, #col);
};


pr_Null:
        col:NULL!
{ 
    ## = #([Null,"Null"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


//------------------------------------------------------
// 1.6 Parameterisation
// -----------------------------------------------------
pr_InParKeyword:
        col:IN!
{ 
    ## = #([InParKeyword,"InParKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_OutParKeyword:
        col:OUT!
{
    ## = #([OutParKeyword,"OutParKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_InOutParKeyword:
     col:INOUT!
{ 
    ## = #([InOutParKeyword,"InOutParKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_FormalValuePar{ColumnAST bcol = null;}:
        (
            (
                cola:pr_InParKeyword {bcol = #cola;} 
			| 
				colb:pr_InOutParKeyword {bcol = #colb;} 
			| 
				colc:pr_OutParKeyword {bcol = #colc;}
            )?
            col:pr_Type
            endcol:pr_ValueParIdentifier
        )
{
    ## = #([FormalValuePar,"FormalValuePar"], ##); 
	if(## != null) ##.setLocation(bcol!=null?bcol:#col, #endcol);
};


pr_ValueParIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_FormalTypePar:
		(
			( cola:pr_InParKeyword )?
			col:pr_TypeParIdentifier
		)
{ 
    ## = #([FormalTypePar,"FormalTypePar"], ##); 
	if(## != null) ##.setLocation(#col==null?#col:#cola, #col);
};


pr_TypeParIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_FormalPortPar:
		(
			( cola:pr_InOutParKeyword )?
			col:pr_PortTypeIdentifier
			endcol:pr_PortParIdentifier
		)
{ 
    ## = #([FormalPortPar,"FormalPortPar"], ##); 
	if(## != null) ##.setLocation(#cola==null?#col:#cola, #endcol);
};


pr_PortParIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_FormalTimerPar:
		(
			( cola:pr_InOutParKeyword )?
			col:pr_TimerKeyword!
			endcol:pr_TimerParIdentifier
		)
{ 
    ## = #([FormalTimerPar,"FormalTimerPar"], ##); 
	if(## != null) ##.setLocation(#cola==null?#col:#cola, #endcol);
};


pr_TimerParIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_FormalTemplatePar:
		(
			( cola:pr_InParKeyword )?
			col:pr_TemplateKeyword!
			pr_Type
			endcol:pr_TemplateParIdentifier
		)
{
    	## = #([FormalTemplatePar,"FormalTemplatePar"], ##); 
	if(## != null) ##.setLocation(#cola==null?#col:#cola, #endcol);
};


pr_TemplateParIdentifier:
        col:pr_Identifier
{
	if(## != null) ##.setLocation(#col, #col);
};

//------------------------------------------------------
// 1.7 With Statement
// -----------------------------------------------------
pr_WithStatement:
        (
            col:pr_WithKeyword!
            endcol:pr_WithAttribList
        )
{
    	## = #([WithStatement,"WithStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_WithKeyword:
        col:WITH!
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_WithAttribList:
        (
                col:pr_BeginChar!
                pr_MultiWithAttrib
                endcol:pr_EndChar!
         )
{
    	## = #([WithAttribList,"WithAttribList"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_MultiWithAttrib{ColumnAST endcol = null;}:
		(
			col:pr_SingleWithAttrib
			( a:pr_SemiColon! { endcol = #a; } )?
			(
			  b:pr_SingleWithAttrib{ endcol = #b; }
			  ( c:pr_SemiColon! { endcol = #c; })?
			)*
		)
{ 
    ## = #([MultiWithAttrib,"MultiWithAttrib"], ##); 
	if(## != null) ##.setLocation(#col, endcol);
};

pr_SingleWithAttrib:
        (
            col:pr_AttribKeyword
	    ( pr_OverrideKeyword )?
            ( pr_AttribQualifier )?
            endcol:pr_AttribSpec
        )
{
    ## = #([SingleWithAttrib,"SingleWithAttrib"], ##);
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_AttribKeyword{ ColumnAST col=null;}:
        (
            a:pr_EncodeKeyword { col = #a; }
            |
            b:pr_DisplayKeyword { col = #b; }
            |
            c:pr_ExtensionKeyword { col = #c; }
        )
{
    ## = #([AttribKeyword,"AttribKeyword"], ##);
	if(## != null) ##.setLocation(col, col);
};


pr_EncodeKeyword:
        col:ENCODE!
{   
	## = #([EncodeKeyword,"EncodeKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_DisplayKeyword:
        col:DISPLAY!
{
    ## = #([DisplayKeyword,"DisplayKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_ExtensionKeyword:
        col:EXTENSION!
{    
	## = #([ExtensionKeyword,"ExtensionKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_OverrideKeyword:
        col:OVERRIDEKEYWORD!
{    
	## = #([OverrideKeyword ,"OverrideKeyword "], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_AttribQualifier:
		(
			col:pr_LParen!
			pr_DefOrFieldRefList
			endcol:pr_RParen!
		)
{ 
    ## = #([AttribQualifier,"AttribQualifier"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_DefOrFieldRefList:
		(
			col:pr_DefOrFieldRef
			(
				pr_Comma!
				endcol:pr_DefOrFieldRef
			)*
		)
{
	if(## != null) ##.setLocation(#col, #endcol == null?#col:#endcol);
};

pr_DefOrFieldRef:
        col:pr_FieldReference
{ 
    ## = #([DefOrFieldRef,"DefOrFieldRef"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};

pr_DefinitionRef:
        col:pr_Identifier
	/* covers all cases
	   StructTypeIdentifier |
	   EnumTypeIdentifier |
	   PortTypeIdentifier |
	   ComponentTypeIdentifier |
	   SubTypeIdentifier |
	   ConstIdentifier |
	   TemplateIdentifier |
	   NamedAltIdentifier |
	   TestcaseIdentifier |
	   FunctionIdentifier |
	   SignatureIdentifier */
{
	if(## != null) ##.setLocation(#col, #col);
};


pr_AttribSpec:
        col:CSTRING
{
    ## = #([AttribSpec, "AttribSpec"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

//------------------------------------------------------
// 1.8 Behaviour Statements
// -----------------------------------------------------
pr_BehaviourStatements{ ColumnAST col=null;}:
        (
            a:pr_TestcaseInstance { col = #a; }
            |
            b:pr_FunctionInstance { col = #b; }
            |
            c:pr_ReturnStatement { col = #c; }
            |
            d:pr_AltConstruct { col = #d; }
            |
            e:pr_InterleavedConstruct { col = #e; }
            |
            g:pr_LabelStatement { col = #g; }
            |
            h:pr_GotoStatement { col = #h; }
            |
            i:pr_ActivateStatement { col = #i; }
            |
            j:pr_DeactivateStatement { col = #j; }
	    |
            k:NamedAltInstance  { col = #k; }
        )
{
    ## = #([BehaviourStatements,"BehaviourStatements"], ##);
	if(## != null) ##.setLocation(col, col);
};

pr_VerdictStatements:
        col:pr_SetLocalVerdict
{
    ## = #([VerdictStatements,"VerdictStatements"], ##);
	if(## != null) ##.setLocation(#col, #col);
};

pr_VerdictOps:
        col:pr_GetLocalVerdict!
{
    ## = #([VerdictOps,"VerdictOps"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};

pr_SetLocalVerdict:
		(
			col:pr_SetVerdictKeyword!
			pr_LParen!
			pr_SingleExpression
			endcol:pr_RParen!
		)
{
    ## = #([SetLocalVerdict,"SetLocalVerdict"], ##);
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_SetVerdictKeyword:
		(
			col:pr_VerdictKeyword
			pr_Dot!
			endcol:pr_SetKeyword
		)
{
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_GetLocalVerdict:
		(
			col:pr_VerdictKeyword
			pr_Dot!
			endcol:pr_GetKeyword
		)
{
    ## = #([GetLocalVerdict,"GetLocalVerdict"], ##);
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_GetKeyword:
        col:GET
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_SUTStatements:
		(
	        col:pr_SUTAction!
	        pr_LParen!
	        (
	            pr_FreeText
			|
	            pr_TemplateRefWithParList
	        )
	        endcol:pr_RParen!
		)
{ 
    ## = #([SUTStatements,"SUTStatements"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_SUTAction:
		(
			col:pr_SUTKeyword
			pr_Dot!
			endcol:pr_ActionKeyword
		)
{
    ## = #([SUTAction,"SUTAction"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_SUTKeyword:
        col:SUT
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_ActionKeyword:
        col:ACTION
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_ReturnStatement:
		(
			col:pr_ReturnKeyword!
			( (pr_Expression) => endcol: pr_Expression )?
		)
{ 
    ## = #([ReturnStatement,"ReturnStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol == null?#col:#endcol);
};

pr_AltConstruct:
		(
			col:pr_AltKeyword!
			pr_BeginChar!
			pr_AltGuardList
			endcol:pr_EndChar!
		)
{
    ## = #([AltConstruct,"AltConstruct"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_AltKeyword:
        col:ALT!
{
    ## = #([AltKeyword,"AltKeyword"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_AltGuardList{ ColumnAST endcol=null;}:
		(
		  col:pr_AltGuardElement
		  ( a:pr_SemiColon {endcol= #a; })?
		  (  options { greedy = true; } :   
		     // necessary due to optional semicolons
			b: pr_AltGuardElement  {endcol= #b; }
			( c:pr_SemiColon {endcol= #c; })?
		  )*
		  ( 
		    d:pr_ElseStatement  {endcol= #d; }
		    ( e: pr_SemiColon  {endcol= #e; })? 
		  )?
		)
{
    ## = #([AltGuardList,"AltGuardList"], ##); 
	if(## != null) ##.setLocation(#col, endcol==null?#col:#endcol);
};

pr_AltGuardElement{ ColumnAST col=null;}:
        (
            a:pr_GuardStatement { col = #a; }
            |
            b:pr_ExpandStatement { col = #b; }
        )
{
    ## = #([AltGuardElement,"AltGuardElement"], ##);
	if(## != null) ##.setLocation(col, col);
};

pr_GuardStatement:
		(
			col:pr_AltGuardChar
			pr_GuardOp
			endcol:pr_StatementBlock
		)
{
    ## = #([GuardStatement,"GuardStatement"], ##);
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ExpandStatement:
		(
			col:pr_SquareOpen!
			pr_ExpandKeyword!
			pr_SquareClose!
			endcol:pr_NamedAltInstance
		)
{
    ## = #([ExpandStatement,"ExpandStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ElseStatement:
		(
			col:pr_SquareOpen!
			pr_ElseKeyword!
			pr_SquareClose!
			endcol:pr_StatementBlock
		)
{ 
    ## = #([ElseStatement,"ElseStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ExpandKeyword:
        col:EXPAND
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_AltGuardChar:
		(
			col:pr_SquareOpen!
			( pr_BooleanExpression )?
			endcol:pr_SquareClose!
		)
{ 
    ## = #([AltGuardChar,"AltGuardChar"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_GuardOp{ ColumnAST col=null; }:
        (
                ( pr_TimeoutStatement ) =>
            a:pr_TimeoutStatement { col = #a; }
            |
                ( pr_PortOrAny pr_Dot pr_ReceiveOpKeyword ) =>
            b:pr_ReceiveStatement { col = #b; }
            |
                ( pr_PortOrAny pr_Dot pr_TriggerOpKeyword  ) =>
            c:pr_TriggerStatement { col = #c; }
            |
                ( pr_PortOrAny pr_Dot pr_GetCallOpKeyword ) =>
            d:pr_GetCallStatement { col = #d; }
            |
                ( pr_PortOrAny pr_Dot pr_CatchOpKeyword ) =>
            e:pr_CatchStatement { col = #e; }
            |
                ( pr_PortOrAny pr_Dot pr_CheckOpKeyword ) =>
            f:pr_CheckStatement { col = #f; }
            |
                ( pr_PortOrAny pr_Dot pr_GetReplyOpKeyword ) =>
            g:pr_GetReplyStatement { col = #g; }
            |
            h:pr_DoneStatement { col = #h; }
        )
{
    ## = #([GuardOp,"GuardOp"], ##); 
	if(## != null) ##.setLocation(col, col);
};


pr_StatementBlock:
        (
                col:pr_BeginChar!
                (
                    pr_FunctionStatementOrDefList
                )?
                endcol:pr_EndChar!
        )
{ 
    ## = #([StatementBlock,"StatementBlock"], ##); 
	if(## != null) ##.setLocation(#col,#endcol);
};

pr_InterleavedConstruct:
		(
			col:pr_InterleavedKeyword!
			pr_BeginChar!
			pr_InterleavedGuardList
			endcol:pr_EndChar!
		)
{
    ## = #([InterleavedConstruct,"InterleavedConstruct"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_InterleavedKeyword:
        col:INTERLEAVE
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_InterleavedGuardList{ ColumnAST endcol=null; }:
		(
			col:pr_InterleavedGuardElement
			( a:pr_SemiColon {endcol= #a;} )?
			( 
			  b:pr_InterleavedGuardElement  {endcol= #b;}
			  ( c:pr_SemiColon  {endcol= #c;} )?
			)*
		)
{
    if(## != null) ##.setLocation(#col, endcol==null?#col:endcol);
};

pr_InterleavedGuardElement:
		(
			col:pr_InterleavedGuard
			endcol:pr_InterleavedAction
		)
{
    ## = #([InterleavedGuardElement,"InterleavedGuardElement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_InterleavedGuard:
        (
            col:pr_SquareOpen!
            pr_SquareClose!
            endcol:pr_GuardOp
        )
{
    ## = #([InterleavedGuard,"InterleavedGuard"], ##);
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_InterleavedAction:
        col:pr_StatementBlock
{
    ## = #([InterleavedAction,"InterleavedAction"], ##);
	if(## != null) ##.setLocation(#col, #col);
};

pr_LabelStatement:
		(
			col:pr_LabelKeyword!
			endcol:pr_LabelIdentifier
		)
{ 
    ## = #([LabelStatement,"LabelStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_LabelKeyword:
        col:LABEL
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_LabelIdentifier:
        col:pr_Identifier
{
    if(## != null) ##.setLocation(#col, #col);
};

pr_GotoStatement{ColumnAST endcol=null;}:
        (
            col:pr_GotoKeyword!
            (
				a:pr_LabelIdentifier { endcol = #a; }
            	|
				b:pr_AltKeyword { endcol = #b; }
			)
        )
{
    ## = #([GotoStatement,"GotoStatement"], ##);
	if(## != null) ##.setLocation(#col,  endcol==null?#col:endcol);
};

pr_GotoKeyword:
		col:GOTO
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_ActivateStatement:
		(
			col:pr_ActivateKeyword!
			pr_LParen!
			pr_NamedAltList
			endcol:pr_RParen!
		)
{
    ## = #([ActivateStatement,"ActivateStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ActivateKeyword:
        col:ACTIVATE
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_NamedAltList:
		(
			col:pr_NamedAltInstance
			(
				pr_Comma!
				pr_NamedAltInstance
			)*
		)
{
    ## = #([NamedAltList,"NamedAltList"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};

pr_DeactivateStatement:
		(
			col:pr_DeactivateKeyword!
			(
				pr_LParen!
				pr_NamedAltRefList
				endcol:pr_RParen   !
			)?
		)
{ 
    ## = #([DeactivateStatement,"DeactivateStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};


pr_DeactivateKeyword:
        col:DEACTIVATE
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_NamedAltRefList:
		(
			col:pr_NamedAltRef
			(
				pr_Comma!
				pr_NamedAltRef
			)*
		)
{ 
    ## = #([NamedAltRefList,"NamedAltRefList"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};

//------------------------------------------------------
// 1.9 Basic Statements
// -----------------------------------------------------
pr_BasicStatements{ColumnAST col=null;}:
        (
            a:pr_Assignment{ col = #a; }
            |
            b:pr_LogStatement{ col = #b; }
            |
            c:pr_LoopConstruct{ col = #c; }
            |
            d:pr_ConditionalConstruct{ col = #d; }
        )
{
    ## = #([BasicStatements,"BasicStatements"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_Expression{ ColumnAST col=null;}:
        (
            a:pr_SingleExpression { col = #a; }
            |
            b:pr_CompoundExpression { col = #b; }
        )
{
    ## = #([Expression,"Expression"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_CompoundExpression{ColumnAST col=null;}:
        (
                ( pr_BeginChar! pr_FieldReference pr_AssignmentChar) =>
            a:pr_FieldExpressionList{ col = #a;}
            |
            b:pr_ArrayExpression{ col = #b;}
        )
{ 
    ## = #([CompoundExpression,"CompoundExpression"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_FieldExpressionList:
		(
	        col:pr_BeginChar!
	        pr_FieldExpressionSpec
	        (   
	            pr_Comma!
	            pr_FieldExpressionSpec
	        )*
	        endcol:pr_EndChar!
		)
{ 
    ## = #([FieldExpressionList,"FieldExpressionList"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_FieldExpressionSpec:
		(
			col:pr_FieldReference
			pr_AssignmentChar!
			endcol:pr_Expression
		)
		{ 
    ## = #([FieldExpressionSpec,"FieldExpressionSpec"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ArrayExpression:
		(
			col:pr_BeginChar!
			( pr_ArrayElementExpressionList )?
			endcol:pr_EndChar!
		)
{
    ## = #([ArrayExpression,"ArrayExpression"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ArrayElementExpressionList:
		(
			col:pr_NotUsedOrExpression
			(
				pr_Comma!
				pr_NotUsedOrExpression
			)*
		)
{ 
    ## = #([ArrayElementExpressionList,"ArrayElementExpressionList"], ##);
	if(## != null) ##.setLocation(#col, #col);
};

pr_NotUsedOrExpression{ ColumnAST col=null;}:
        (
                ( pr_Expression ) => 
            a:pr_Expression { col = #a; }
            |
            b:pr_NotUsedSymbol { col = #b; }
        )
{ 
    ## = #([NotUsedOrExpression,"NotUsedOrExpression"], ##);
	if(## != null) ##.setLocation(col, col);
};

pr_ConstantExpression{ ColumnAST col=null;}:
        (
            a:pr_SingleConstExpression { col = #a; }
            |
            b:pr_CompoundConstExpression { col = #b; }
        )
{
    ## = #([ConstantExpression,"ConstantExpression"], ##); 
	if(## != null) ##.setLocation(col, col);
};


pr_SingleConstExpression:
        col:pr_SingleExpression
{
	if(## != null) ##.setLocation(#col, #col);
};

pr_BooleanExpression:
        col:pr_SingleExpression
{
    ## = #([BooleanExpression,"BooleanExpression"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};

pr_CompoundConstExpression{ColumnAST col=null;}:
        (
                ( pr_BeginChar! pr_FieldReference pr_AssignmentChar) =>
            a:pr_FieldConstExpressionList{ col = #a;}
            |
            b:pr_ArrayConstExpression{ col = #b;}
        )
{
	if(## != null) ##.setLocation(col, col);
};

pr_FieldConstExpressionList:
		(
	        col:pr_BeginChar!
	        pr_FieldConstExpressionSpec
	        (
	            pr_Comma!
	            pr_FieldConstExpressionSpec
	        )*
	        endcol:pr_EndChar!
		)
{ 
    ## = #([FieldConstExpressionList,"FieldConstExpressionList"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_FieldConstExpressionSpec:
		(
			col:pr_FieldReference
			pr_AssignmentChar!
			endcol:pr_ConstantExpression
		)
{ 
    ## = #([FieldConstExpressionSpec,"FieldConstExpressionSpec"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ArrayConstExpression:
		(
			col:pr_BeginChar!
			( pr_ArrayElementConstExpressionList )?
			endcol:pr_EndChar!
		)
{
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ArrayElementConstExpressionList:
		(
			col:pr_ConstantExpression
			(
				pr_Comma!
				pr_ConstantExpression
			)*
		)
{ 
    ## = #([ArrayElementConstExpressionList,"ArrayElementConstExpressionList"], ##);
	if(## != null) ##.setLocation(#col, #col);
};

pr_Assignment:
		(
			col:pr_VariableRef
			pr_AssignmentChar!
			endcol:pr_Expression
		)
{
    ## = #([Assignment,"Assignment"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_SingleExpression:
        (
            col:pr_SimpleExpression
            ( 
                    ( pr_BitOp ) =>
                ( pr_BitOp pr_SimpleExpressions )
                |
            )
        )
{ 
    ## = #([SingleExpression,"SingleExpression"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};

pr_SimpleExpressions:
	(
		col:pr_SimpleExpression
		( 
                ( pr_BitOp ) =>
		( pr_BitOp pr_SimpleExpressions )
        	|
		)
	)
{
	if(## != null) ##.setLocation(#col, #col);
};  

pr_SimpleExpression:
		(
			col:pr_SubExpression 
			( 
					(pr_RelOp) => 
				( 
					pr_RelOp 
					endcol:pr_SubExpression
				) 
            	| 	
			)
		)
{
     ## = #([SimpleExpression,"SimpleExpression"], ##); 
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_SubExpression:
		(
			col:pr_Product 
			(
				pr_ShiftOp 
				endcol:pr_Product
			)?
		)
{
     ## = #([SubExpression,"SubExpression"], ##); 
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_Product:
        (
            col:pr_Term
            (   options { greedy = true; } :   
		// necessary due to optional semicolons
                pr_AddOp
                endcol:pr_Term
	    )*
        )
{
     ## = #([Product,"Product"], ##); 
	if(## != null) ##.setLocation(#col, #endcol==null?#col:#endcol);
};

pr_Term:
        (
            col:pr_Factor
            ( 
                pr_MultiplyOp
                pr_Factor 
            )*
        )
{ 
    ## = #([Term,"Term"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};


pr_Factor:
        (     
            ( cola:pr_UnaryOp)?
            col:pr_Primary
        )
{
    ## = #([Factor,"Factor"], ##); 
	if(## != null) ##.setLocation(#cola==null?#col:#cola, #col);
};

pr_Primary{ ColumnAST col=null;}:
        (
                ( pr_OpCall ) =>
            a:pr_OpCall { col = #a; }
            |
                ( pr_Value ) =>
            b:pr_Value { col = #b; }
            |
            c:pr_LParen! pr_SingleExpression pr_RParen! { col = #c; }
        )
{ 
    ## = #([Primary,"Primary"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_ExtendedFieldReference{ ColumnAST col=null; ColumnAST endcol=null;}:
        (
            options { greedy = true ; } : 
			( 
                a:pr_Dot!  { col = #a; }
                pr_StructFieldIdentifier
            )
            |
	    (	
	            b:pr_ArrayOrBitRef { col = #b; }
	    )
        )+
{
    ## = #([ExtendedFieldReference,"ExtendedFieldReference"], ##); 
	if(## != null) ##.setLocation(col, endcol);
};

pr_OpCall{ ColumnAST col=null;}:
        (
                ( pr_FunctionInstance ) =>
            a:pr_FunctionInstance { col = #a; }
            |
                ( pr_ConfigurationOps ) =>
            b:pr_ConfigurationOps { col = #b; }
            |
                ( pr_VerdictOps ) =>
            c:pr_VerdictOps { col = #c; }
            |
            d:pr_TimerOps { col = #d; }
            |
            e:pr_TestcaseInstance { col = #e; }
	    |
	    f:pr_TemplateOps { col = #f; }
        )
{
    ## = #([OpCall,"OpCall"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_AddOp{ColumnAST col=null;}:
        (
            a:pr_Plus{ col = #a;}
            |
            b:pr_Minus{ col = #b;}
        )
{ 
    ## = #([AddOp,"AddOp"], ##);
	if(## != null) ##.setLocation(col, col);
};

pr_MultiplyOp{ ColumnAST col=null;}:
        (
            a:pr_Star { col = #a; }
            |
            b:pr_Slash { col = #b; }
            |
            c:pr_Mod { col = #c; }
            |
            d:pr_Rem { col = #d; }
        )
{
    ## = #([MultiplyOp,"MultiplyOp"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_UnaryOp{ ColumnAST col=null;}:
        (
            a:pr_Plus { col = #a; }
            |
            b:pr_Minus { col = #b; }
            |
            c:pr_Not { col = #c; }
            |
            d:pr_Not4b { col = #d; }
        )
{
    ## = #([UnaryOp,"UnaryOp"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_Not:
        col:NOT!
{
    ## = #([Not,"Not"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_Not4b:
        col:NOT4B!
{
    ## = #([Not4b,"Not4b"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_RelOp{ ColumnAST col=null;}:
        (
            a:pr_Equal{ col = #a; }
            |
            b:pr_Lessthan{ col = #b; }
            |
            c:pr_Morethan{ col = #c; }
            |
            d:pr_Notequals{ col = #d; }
            |
            e:pr_Moreorequal{ col = #e; }
            |
            f:pr_Lessorequal{ col = #f; } 
        )
{ 
    ## = #([RelOp,"RelOp"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_Equal: 
        col:EQUAL!
{
    ## = #([Equal,"Equal"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_Lessthan: 
        col:LESSTHAN!
{ 
    ## = #([Lessthan,"Lessthan"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_Morethan: 
        col:MORETHAN!
{ 
    ## = #([Morethan,"Morethan"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_Notequals: 
        col:NOTEQUALS!
{ 
    ## = #([Notequals,"Notequals"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_Moreorequal: 
        col:MOREOREQUAL!
{ 
    ## = #([Moreorequal,"Moreorequal"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_Lessorequal:
        col:LESSOREQUAL!
{ 
    ## = #([Lessorequal,"Lessorequal"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_BitOp{ ColumnAST col=null;}:
        (
            a:pr_And4b{ col = #a; }  
            | 
            b:pr_Xor4b{ col = #b; }  
            |
            c:pr_Or4b{ col = #c; }  
            | 
            d:pr_And{ col = #d; } 
            | 
            e:pr_Xor{ col = #e; }  
            | 
            f:pr_Or{ col = #f; } 
            | 
            g:pr_StringOp{ col = #g; } 
        )
{ 
    ## = #([BitOp,"BitOp"], ##); 
	if(## != null) ##.setLocation(col, col);
};

pr_And4b:
        col:AND4B!
{ 
    ## = #([And4b,"And4b"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_Xor4b:
        col:XOR4B!
{ 
    ## = #([Xor4b,"Xor4b"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_Or4b:
        col:OR4B!
{ 
    ## = #([Or4b,"Or4b"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_And:
        col:AND!
{ 
    ## = #([And,"And"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_Xor:
        col:XOR!
{ 
    ## = #([Xor,"Xor"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_StringOp:
        col:STRINGOP!
{ 
    ## = #([StringOp,"StringOp"], ##); 
	if(## != null) ##.setLocation(#col, #col);
};

pr_ShiftOp{ColumnAST col=null;}:
		(
			a:SHIFTLEFT{ col = #a; } 
		| 
			b:SHIFTRIGHT{ col = #b; }  
		|
			c:ROTATELEFT{ col = #c; } 
		| 
			d:ROTATERIGHT{ col = #d; }  
		)
{ 
    ## = #([ShiftOp,"ShiftOp"], ##);
	if(## != null) ##.setLocation(col, col); 
};


pr_LogStatement:
		(
			col:pr_LogKeyword!
			pr_LParen!
			( pr_FreeText )?
			endcol:pr_RParen!
		)
{
    ## = #([LogStatement,"LogStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_LogKeyword:
        col:LOG
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_LoopConstruct{ColumnAST col=null;}:
        (
            a:pr_ForStatement{ col = #a;}
            |
            b:pr_WhileStatement{ col = #b;}
            |
            c:pr_DoWhileStatement{ col =#c;}
        )
{ 
    ## = #([LoopConstruct,"LoopConstruct"], ##);
	if(## != null) ##.setLocation(col, col);
};

pr_ForStatement:
		(
			col:pr_ForKeyword!
			pr_LParen!
			pr_Initial
			( pr_SemiColon! )?
			pr_Final
			( pr_SemiColon! )?
			pr_Step
			pr_RParen!
			endcol:pr_StatementBlock
		)
{ 
    ## = #([ForStatement,"ForStatement"], ##);
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_ForKeyword:
        col:FOR
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_Initial{ColumnAST col=null;}:
		(
			a:pr_VarInstance {col= #a;}
		| 
			b:pr_Assignment {col= #b;}
		)
{ 
    ## = #([Initial,"Initial"], ##);
	if(## != null) ##.setLocation(#col, #col);
};

pr_Final:
        col:pr_BooleanExpression
{ 
	if( ## != null) ##.setLocation(#col, #col);
};

pr_Step:
		(
			col:pr_Assignment
		)
{ 
    ## = #([Step,"Step"], ##);
	if(## != null) ##.setLocation(#col, #col);
};

pr_WhileStatement:
		(
			col:pr_WhileKeyword!
			pr_LParen!
			pr_BooleanExpression
			pr_RParen!
			endcol:pr_StatementBlock
		)
{ 
    ## = #([WhileStatement,"WhileStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_WhileKeyword:
        col:WHILE
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_DoWhileStatement:
		(
			col:pr_DoKeyword!
			pr_StatementBlock
			pr_WhileKeyword!
			pr_LParen!
			pr_BooleanExpression
			endcol:pr_RParen!
		)
{ 
    ## = #([DoWhileStatement,"DoWhileStatement"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_DoKeyword:
        col:DO
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_ConditionalConstruct{ColumnAST endcol = null;}:
	(
	     	col:pr_IfKeyword!
	        pr_LParen!
	        pr_BooleanExpression
            	pr_RParen!
	        a:pr_StatementBlock{ endcol = #a; }
		( options { greedy = true; } :
		  b:pr_ElseIfClause { endcol = #b; } )*
		( (pr_ElseClause)=> c:pr_ElseClause { endcol = #c; } )?
	)
{
    ## = #([ConditionalConstruct,"ConditionalConstruct"], ##); 
	if(## != null) ##.setLocation(#col, endcol==null?#col:endcol);
};


pr_IfKeyword:
        col:IF
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_ElseIfClauses:
        (
                ( pr_ElseKeyword pr_IfKeyword ) => 
            col:pr_ElseIfClause
            endcol:pr_ElseIfClauses
            |
        )
{
	if(## != null) ##.setLocation(#col, #endcol);
};

pr_ElseIfClause:
		(
			col:pr_ElseKeyword!
			pr_IfKeyword!
			pr_LParen! pr_BooleanExpression pr_RParen!
			endcol:pr_StatementBlock
		)
{ 
    ## = #([ElseIfClause,"ElseIfClause"], ##); 
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_ElseKeyword:
        col:ELSE
{
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_ElseClause:
		(
			col:pr_ElseKeyword!
			endcol:pr_StatementBlock
		)
{
    ## = #([ElseClause,"ElseClause"], ##);
	if(## != null) ##.setLocation(#col, #endcol);
};


pr_Identifier:
        col:IDENTIFIER
{ 
    ## = #([Identifier,"Identifier"], ##);
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_FreeText:
		col:CSTRING
;


//------------------------------------------------------
// 1.11 Miscellaneous productions
// -----------------------------------------------------
pr_Dot:
		col:DOT!
{ 
    ## = #([Dot,"Dot"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_Dash:
        col:MINUS!
{ 
    ## = #([Dash,"Dash"], ##);
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_Minus:
        col:MINUS!
{ 
    ## = #([Minus,"Minus"], ##);
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_SemiColon:
        col:SEMICOLON!
{
    ## = #([SemiColon,"SemiColon"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_Colon:
        col:COLON!
{ 
    ## = #([Colon,"Colon"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_Comma:
        col:COMMA!
{ 
    ## = #([Comma,"Comma"], ##);
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_Underscore:
        col:UNDERSCORE!
{ 
    ## = #([Underscore,"Underscore"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_BeginChar:
        col:BEGINCHAR!
{ 
    ## = #([BeginChar,"BeginChar"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_EndChar:
        col:ENDCHAR!
{ 
    ## = #([EndChar,"EndChar"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_AssignmentChar:
        col:ASSIGNMENTCHAR!
{ 
    ## = #([AssignmentChar,"AssignmentChar"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_DefIndentOpen:
        col:DEFIDENTOPEN!
{ 
    ## = #([DefIndentOpen,"DefindentOpen"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_DefIndentClose:
        col:DEFIDENTCLOSE!
{ 
    ## = #([DefIndentClose,"DefindentClose"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_LParen:
        col:LPAREN!
{ 
    ## = #([LParen,"LParen"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_RParen:
        col:RPAREN!
{ 
    ## = #([RParen,"RParen"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};



pr_SquareOpen:
        col:SQUAREOPEN!
{ 
    ## = #([SquareOpen,"SquareOpen"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_SquareClose:
        col:SQUARECLOSE!
{ 
    ## = #([SquareClose,"SquareClose"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_SingleQuote:
        col:SINGLEQUOTE!
{ 
    ## = #([SingleQuote,"SingleQuote"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_RangeOp:
        col:RANGEOP!
{ 
    ## = #([RangeOp,"RangeOp"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_Star:
        col:STAR!
{ 
    ## = #([Star,"Star"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};

pr_QuestionMark:
        col:QUESTIONMARK!
{ 
    ## = #([QuestionMark,"QuestionMark"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_Plus:
        col:PLUS!
{ 
    ## = #([Plus,"Plus"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};



pr_Or:
        col:OR!
{ 
    ## = #([Or,"Or"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_Slash:
        col:SLASH!
{ 
    ## = #([Slash,"Slash"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_Mod:
        col:MOD!
{ 
    ## = #([Mod,"Mod"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};


pr_Rem:
        col:REM!
{ 
    ## = #([Rem,"Rem"], ##); 
	if(## != null) ##.setLocation(#col, #col);
	if(## != null) ##.setEndLocation(#col);
};
