/*********************************************************************************
 *  TTCN-3 Parser - A Java based TTCN-3 Parser using ANTLR
 *  Copyright (C) 2000, 2001 Testing Technologies IST GmbH
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *********************************************************************************/
/* -----------------------------------------------------------------------------
 *  DESCRIPTION: A Lexer handling column information
 *
 *  AUTHOR:      Theofanis Vassiliou-Gioles
 *  DATE:        October, 2000
 *
 *  REVISION INFO:
 *      $Revision: 1.4 $ $Date: 2000/10/31 13:01:54 $
 *
 * -----------------------------------------------------------------------------
 */

import java.io.*;
import antlr.Token;
import antlr.CharStreamException;
import antlr.LexerSharedInputState;

    public class L extends TTCN3Lexer
    {
	protected int tokColumn = 1;
	protected int column = 1;

	public L(Reader in) {
	    super(in);
	}

	public L(InputStream in) {
	    super(in);
	}
	public L(LexerSharedInputState state)
	{
	    super(state);
	}

	public void consume() throws CharStreamException  {
	    if ( inputState.guessing==0 ) 
	    {
		if (text.length()==0) 
		{
		    // remember token start column
		    tokColumn = column;
		}
		if (LA(1)=='\n') 
		{ 
		    column = 1; 
		}
		else 
		{ 	
		    column++; 
		}
	    }	
	    super.consume();
	}

	public void newline() {
	    super.newline();
	    column = 1;
	}

	protected Token makeToken(int t) {
	    Token tok = super.makeToken(t);
	    tok.setColumn(tokColumn);
	    return tok;
	}


    }

