#include "ttfprint.h"
#include <stdio.h>
#include <malloc.h>
#include <string.h>

#define __max(a,b) ( a >= b ? a : b )

#define BOOL short
#define FALSE 0
#define TRUE 1
#define EM 1024 /*It is better to get em from file */

static struct SUBHD
       {
       unsigned short fstcode, ecnt, ioff;
       short idlt;
       } *subheader = NULL;

typedef short fixp; /* May use long to prevent overflow */
/* Fix point : S_############.## bit, range +-4096 with 1/4 precision */

static struct SCANLINE
     {
     short max, cur;
     fixp *grid;
     } *rowarray, *colarray;
     

/*static unsigned long cmap, loca, glyf, head, loca_size;
static unsigned short subheadkey[256], *glyfarray, *epts_ctr, num_pts;
static short num_ctr;
static fixp *xcoor, *ycoor;
static unsigned char *flag;
static BOOL first_run=TRUE;
*/

unsigned long cmap, loca, glyf, head, loca_size;
unsigned short subheadkey[256], *glyfarray, *epts_ctr, num_pts;
short num_ctr;
fixp *xcoor, *ycoor;
unsigned char *flag;
BOOL first_run=TRUE;


void load_table(FILE *ttf_file);
void load_cmap(FILE *ttf_file);
short font_index(unsigned char *str);
BOOL load_font(FILE *ttf_file,short idx);
void init_row();
void convert();
void clear_data();

unsigned short get16(FILE *ttf_file)
     {
     unsigned char c1 = getc(ttf_file);
     unsigned char c2 = getc(ttf_file);
     return ((unsigned short)c1)*256+c2;
     }

unsigned long get32(FILE *ttf_file)
     {
     unsigned short s1 = get16(ttf_file);
     unsigned short s2 = get16(ttf_file);
     return ((unsigned long)s1)*65536L+s2;
     }

static unsigned char startc[3] = {0xa4,0x40,0};
static short ymin, ymax, xmax, xmin, xsize;
#define ysize ymax
/*static short xfrwd, yfrwd, pgfrwd;*/
static unsigned char *font_buf;
#define res	256

void PSCurveto(fixp x, fixp y, int s, int t);

void ttf2ps();
static count;
extern char *psf_buffer;
extern FILE *ttf_file;
extern q_prog();

void ttf2ps(char inp[])
     { 
     short i;
     static short cidx;
/*     char texnum[10], c;*/
/*     char c; */
/*     int j, bufsiz, k, start_offpt, end_offpt, fst;*/
     int j,start_offpt,end_offpt,fst;
     int seq_num;
     unsigned char hi, lo;
     int area;
     hi = inp[0];
     lo = inp[1];
     count = 0;
     
     if ((hi > 0xa3) && (hi < 0xc7) && (lo > 0x3f) && (lo <0x7f))
       area = 1;
     else 
     if ((hi > 0xa3) && (hi < 0xc6) && (lo > 0xa0) && (lo < 0xff))  
       area = 2;
     else 
     if ((hi > 0xc8) && (hi < 0xfa) &&(lo > 0x3f) && (lo < 0x7f))
       area = 3;
     else
     if ((hi > 0xc8) && (hi < 0xfa) &&(lo > 0xa0) && (lo < 0xff))
       area = 4;
     else 
     if ((hi > 0xa0) && (hi < 0xa4) && (lo > 0x3f) &&(lo < 0x7f))
       area = 5;
     else 
     if ((hi > 0xa0) && (hi < 0xa4) &&(lo > 0xa0) && (lo < 0xff))
       area = 6;
/*     else 
     if ((hi > 0xc5) && (hi < 0xc9) &&(lo > 0xa0) && (lo < 0xff))
       area = 7;*/
     else 
       area = 0;
    
  switch (area)
    {
    case 0	: /*puts ("wrong code \n");*/
    		  seq_num = 13184;
    		  break;
    case 1 	: seq_num = (hi - 0xa4) * 157 + (lo - 0x40);
    		  break;
    case 2	: seq_num = (hi - 0xa4) * 157 + (lo - 0xa1) + 63;
    		  break;
    case 3	: seq_num = (hi - 0xc9) * 157 + (lo - 0x40) + 5401;
    		  break;
    case 4	: seq_num = (hi - 0xc9) * 157 + (lo - 0xa1) + 5464;
    		  break;
    case 5	: seq_num = (hi - 0xa1) * 157 + (lo - 0x40) + 13094;
    		  break;
    case 6	: seq_num = (hi - 0xa1) * 157 + (lo - 0xa1) + 13157;    		  
    		  break;
/*    case 7	: seq_num = (hi - 0xc6) * 157 + (lo - 0xa1) + 13535;
    		  break;*/
    } 
    
     /* Restricting because show_buf need four times space for VGA IO */
/*     if (first_run == TRUE)
       {*/
       load_table(ttf_file);
       load_cmap(ttf_file);
       init_row();
       cidx = font_index(startc);
/*       first_run = FALSE;
       }*/
     
     do {

	 if (!load_font(ttf_file,cidx+seq_num))
	    { printf("Font error or composite font\n"); break;}

	 convert();

     for (i = 0, j = 0; i < num_ctr; i++)
	 {
	 fst = j;	 
	 count = count +  sprintf (&psf_buffer[count],"%d %d M\n",xcoor[j],ycoor[j]); 
	 start_offpt = 0; /*start at least 1*/

/* data pts for all contours stored in one array.
   each round j init at last j + 1 */

/* start_offpt means start of off points. 
   0 means no off points in record.
   N means the position of the off point.
   end_offpt means the ending off point.
   lastx, lasty is the last ON point from which Curve and Line 
   shall start.
*/

/* start with j=0. into loop, j=1. 
   if pt[1] off, if start_offpt == 0, toggle start_offpt
   next j=2. if on, now start_off != 0, run Curveto.
   if pt[1] on, start_off == 0, will run Lineto.
*/	
	 for (j++; j <= epts_ctr[i]; j++)
	     {
	     if (!(flag[j]&1))
		{ /*Off curve*/
		if (!start_offpt) { start_offpt = end_offpt = j; }
		else end_offpt++;
		}
	     else { /*On Curve*/
		  if (start_offpt)
		     {
/* start_offpt stuck at j, end_offpt++. 
   end_offpt - start_offpt gives no of off pts.
   start_offpt gives start of sequence.
   why need xcoor[j] ycoor[j]?
*/
		     PSCurveto(xcoor[j],ycoor[j],start_offpt,end_offpt);
		     start_offpt = 0;

/* also use start_offpt as indicator to save one variable!! */
/* after curveto, reset condition. */

		     }
		  else 
 		    count=count +  sprintf(&psf_buffer[count],"%d %d L\n",xcoor[j],ycoor[j]);
/* uses lastx, lasty */
/*Lineto(xcoor[j],ycoor[j]);*/
		  }
	     }
/* looks like closepath 
   fst = first, i.e. go back to first */
	 if (start_offpt) PSCurveto(xcoor[fst],ycoor[fst],start_offpt,end_offpt);
	 else 
	   count = count +  sprintf(&psf_buffer[count],"%d %d L\n",xcoor[fst],ycoor[fst]);
	 }
	 clear_data();
	} while(0);
     }

void PSCurveto(fixp x, fixp y, int s, int t)
{
     int N, i;
     double sx[3], sy[3], cx[4], cy[4];

     N = t-s+2;
     for(i=0; i<N-1; i++) {
     sx[0] = i==0?xcoor[s-1]:(xcoor[i+s]+xcoor[i+s-1])/2;
     sy[0] = i==0?ycoor[s-1]:(ycoor[i+s]+ycoor[i+s-1])/2;
     sx[1] = xcoor[s+i];
     sy[1] = ycoor[s+i];
     sx[2] = i==N-2?x:(xcoor[s+i]+xcoor[s+i+1])/2;
     sy[2] = i==N-2?y:(ycoor[s+i]+ycoor[s+i+1])/2;
     cx[3] = sx[2];
     cy[3] = sy[2];
     cx[1] = (2*(sx[1])+sx[0])/3;
     cy[1] = (2*(sy[1])+sy[0])/3;
     cx[2] = (sx[2]+ 2*(sx[1]))/3;
     cy[2] = (sy[2]+ 2*(sy[1]))/3;
     count = count +  sprintf (&psf_buffer[count],"%.0f %.0f %.0f %.0f %.0f %.0f C\n",cx[1],cy[1],cx[2],cy[2],cx[3],cy[3]);
     }
}

void load_table(FILE *ttf_file)
     {
     char buf[5];
     short i, cnt;

     fseek(ttf_file,4L,SEEK_SET);
     cnt = get16(ttf_file);
     fseek(ttf_file,12L,SEEK_SET);
     for (i = 0; i < cnt; i++)
	 {
	 fread(buf,1,4,ttf_file);
	 buf[4] = 0;
	 if (!strcmp(buf,"cmap")) { get32(ttf_file); cmap = get32(ttf_file); get32(ttf_file); }
	 else if (!strcmp(buf,"loca"))
	      { get32(ttf_file); loca = get32(ttf_file); loca_size = get32(ttf_file); }
	 else if (!strcmp(buf,"glyf"))
	      { get32(ttf_file); glyf = get32(ttf_file); get32(ttf_file); }
	 else if (!strcmp(buf,"head"))
	      { get32(ttf_file); head = get32(ttf_file); get32(ttf_file); }
	 else { get32(ttf_file); get32(ttf_file); get32(ttf_file); } /*skip*/
	 }
     }

void load_cmap(FILE *ttf_file)
     {
     unsigned short i, j, cnt, fmt, len, num_var = 0;
     unsigned long *off;
     fseek(ttf_file,cmap+2,SEEK_SET);
     cnt = get16(ttf_file);
     off = (unsigned long *)calloc(sizeof(unsigned long),cnt);
     for (i = 0; i < cnt; i++) { get16(ttf_file); get16(ttf_file); off[i] = get32(ttf_file); }
     for (i = 0; i < cnt; i++)
	 {
	 fseek(ttf_file,cmap+off[i],SEEK_SET);
	 fmt = get16(ttf_file);
	 if (fmt != 2) continue;
	 len = get16(ttf_file); get16(ttf_file);
	 for (j = 0; j < 256; j++)
	     {
	     subheadkey[j] = get16(ttf_file)/8;
	     if (subheadkey[j] > num_var) num_var = subheadkey[j];
	     }
	 subheader = (struct SUBHD *)calloc(sizeof(struct SUBHD),++num_var);
	 for (j = 0; j < num_var; j++)
	     {
	     subheader[j].fstcode = get16(ttf_file);
	     subheader[j].ecnt = get16(ttf_file);
	     subheader[j].idlt = (short)get16(ttf_file);
	     subheader[j].ioff = get16(ttf_file) - (num_var-j-1)*8-2;
	     }
	 len -= 6+2*256+num_var*8;
	 glyfarray = (unsigned short *)calloc(sizeof(unsigned short), len/2);
	 for (j = 0; j < len/2; j++) glyfarray[j] = get16(ttf_file);
	 break;
	 }
     free(off);
     if (!subheader) 
       { 
       printf("Not found format 2 mapping\n"); 
       q_prog(E_TTF2PS,"");
/*       exit(-1); */
       }

     /* Get ymax ymin from head */
     fseek(ttf_file,head+36L,SEEK_SET);
     xmin = (short)get16(ttf_file);  /* usual negtive or 0 */
     ymin = (short)get16(ttf_file);
     xmax = (short)get16(ttf_file) - xmin; /* shift to original (0,0) */
     ymax = (short)get16(ttf_file) - ymin;
     xmax = (short)(((long)xmax)*res/EM);
     ymax = (short)(((long)ymax)*res/EM);
     
     }

void init_row() /* Initial the data space */
     {
     short i;
     xsize = (xmax+7)/8;       /* in byte */
     rowarray = (struct SCANLINE *)calloc(sizeof(struct SCANLINE),ysize);
     if (rowarray == NULL)
	{ 
	printf("Memory error when initial.\n"); 
	q_prog(E_MALLOC,"ttf2ps");
/*	exit(1); */
	}
     colarray = (struct SCANLINE *)calloc(sizeof(struct SCANLINE),xmax);
     if (colarray == NULL)
	{ printf("Memory error when initial.\n"); 
	q_prog(E_MALLOC,"ttf2ps");
/*	exit(1); */
	}
     for (i = 0; i < ysize; i++)
	 {
	 rowarray[i].max = 32;  /* from max of NTU_MM */
	 rowarray[i].cur = 0;
	 rowarray[i].grid = (fixp *)calloc(sizeof(fixp),32);
	 if (rowarray[i].grid == NULL)
	    { 
	    printf("Memory overflow when init rowarray.\n"); 
	    q_prog (E_MALLOC,"ttf2ps");
/*	    exit(2); */
	    }
	 }
     for (i = 0; i < xmax; i++)
	 {
	 colarray[i].max = 32;
	 colarray[i].cur = 0;
	 colarray[i].grid = (fixp *)calloc(sizeof(fixp),32);
	 if (colarray[i].grid == NULL)
	    { 
	    printf("Memory overflow when init colarray.\n"); 
	    q_prog(E_MALLOC,"ttf2ps");
/*	    exit(2); */
	    }
	 }
     font_buf = (unsigned char *)calloc(xsize,ysize+1);
     if (font_buf == NULL)
	{ 
	printf("Memory overflow when init font_buf\n"); 
	q_prog(E_MALLOC,"ttf2ps");
/*	exit(3); */
	}
     }
/* Must free all and allocate new ones when resize the resolution. */

void clear_data()
     {
     short i;
     for (i = 0; i < ysize; i++) rowarray[i].cur = 0;
     for (i = 0; i < xmax; i++) colarray[i].cur = 0;
     memset(font_buf,0,xsize*ysize);
     free(subheader);
     free(glyfarray);
     free(font_buf);
     for (i = 0; i < ysize; i++)
       free (rowarray[i].grid);
     for (i = 0; i < xmax; i++)
       free (colarray[i].grid);
     free (rowarray);
     free (colarray);
     free(epts_ctr);
     free(flag);
     free(xcoor);
     free(ycoor);
     }

short font_index(unsigned char *str)
      {
      unsigned short idx = subheadkey[str[0]];
      short ridx = subheader[idx].idlt;
      short code = str[1] - subheader[idx].fstcode;

      if (code > subheader[idx].ecnt) return 0; /*Error*/
      ridx += glyfarray[subheader[idx].ioff/2+code];
      return ridx;
      }

BOOL load_font(FILE *ttf_file, short idx)
     {
     long off;
     short i;
     unsigned short j;
     unsigned char c, ct;

     fseek(ttf_file,loca+(long)idx*4L,SEEK_SET);
     off = get32(ttf_file);
     fseek(ttf_file,glyf+off,SEEK_SET);
     num_ctr = (short)get16(ttf_file);
     if (num_ctr < 0) return FALSE;
     get16(ttf_file); get16(ttf_file); get16(ttf_file); get16(ttf_file);
     epts_ctr = (unsigned short *)calloc(sizeof(unsigned short),num_ctr);
     for (i = 0; i < num_ctr; i++) epts_ctr[i] = get16(ttf_file);
     num_pts = epts_ctr[num_ctr-1]+1; /*zero base*/
     j = get16(ttf_file);
     while (j--) getc(ttf_file); /*skip instruction*/
     flag = (unsigned char *)calloc(1,num_pts);
     xcoor = (fixp *)calloc(sizeof(fixp),num_pts);
     ycoor = (fixp *)calloc(sizeof(fixp),num_pts);
     for (j = 0; j < num_pts;)
	 {
	 flag[j++] = c = getc(ttf_file);
	 if ( c&8) { ct = getc(ttf_file); while (ct--) flag[j++] = c; }
	 }
     for (j = 0; j < num_pts; j++)
	 {
	 if (flag[j] & 2)
	    {
	    c = getc(ttf_file);
	    xcoor[j] = (flag[j] & 0x10)?((short)c):(-1*(short)c);
	    }
	 else if (flag[j] & 0x10) xcoor[j] = 0;
	 else xcoor[j] = (short)get16(ttf_file);
	 }
     for (j = 0; j < num_pts; j++)
	 {
	 if (flag[j] & 4)
	    {
	    c = getc(ttf_file);
	    ycoor[j] =(flag[j] & 0x20)?((short)c):(-1*(short)c);
	    }
	 else if (flag[j] & 0x20) ycoor[j] = 0;
	 else ycoor[j] = (short)get16(ttf_file);
	 }
     for (j = 1; j < num_pts; j++)
	 { xcoor[j] += xcoor[j-1]; ycoor[j] += ycoor[j-1]; }
     for (j = 0; j < num_pts; j++)
	 {  /* Scale maybe loose precision in old version */
	 xcoor[j] = (fixp)(((long)(xcoor[j]-xmin))*res/(EM/4))-2; /* Modify */
	 ycoor[j] = (fixp)(((long)(ycoor[j]-ymin))*res/(EM/4))-2;
	 } /*res x res, 1/4 precision, ** must shift coor before scale */
     return TRUE;
     }

fixp lastx, lasty;

#define Moveto(x, y)  {lastx = (x); lasty = (y);}
void Lineto(fixp x, fixp y);
void Curveto(fixp x, fixp y,unsigned short ctrl_fst,unsigned short ctrl_last);
void SplitCurve(fixp x1, fixp y1, fixp x2, fixp y2); /* Modify */

void convert()
     {
     short i;
     unsigned short j, start_offpt, end_offpt, fst;

     for (i = 0, j = 0; i < num_ctr; i++)
	 {
	 fst = j;
	 Moveto(xcoor[j],ycoor[j]);
	 start_offpt = 0; /*start at least 1*/

/* data pts for all contours stored in one array.
   each round j init at last j + 1 */

	 for (j++; j <= epts_ctr[i]; j++)
	     {
	     if (!(flag[j]&1))
		{ /*Off curve*/
		if (!start_offpt) { start_offpt = end_offpt = j; }
		else end_offpt++;
		}
	     else { /*On Curve*/
		  if (start_offpt)
		     {
		     Curveto(xcoor[j],ycoor[j],start_offpt,end_offpt);
		     start_offpt = 0;
		     }
		  else Lineto(xcoor[j],ycoor[j]);
		  }

	     }
	 if (start_offpt) Curveto(xcoor[fst],ycoor[fst],start_offpt,end_offpt);
	 else Lineto(xcoor[fst],ycoor[fst]);
	 }
     }

void Lineto(fixp x, fixp y)
     {
     short start, end;
     long delta, sy, sx; /* 10 bit point */
     fixp *tmp;

     if (x != lastx) /* usual apply under 96X96 */
	{
	delta = ((long)(y-lasty))*1024/((long)(x-lastx));
	if (x < lastx)
	   {
	   start = (x+3)/4;
	   end = (lastx+3)/4;
	   sy = ((long)y)*256 + (((long)start)*4-((long)x))*delta/4;
	   }
	else {
	     start = (lastx+3)/4;
	     end = (x+3)/4;
	     sy = ((long)lasty)*256 + ((long)(start*4-lastx))*delta/4;
	     }
	if (start < 0) { sy += delta*(-start); start = 0;}
	if (end >= xmax) end = xmax-1;
	for (; start < end; start++, sy += delta)
	    { /* xadd(start,(fixp)(sy/256));*/
	    if (colarray[start].cur == colarray[start].max)
	       { /* Growth 8 each time */
	       tmp = (fixp *)realloc(colarray[start].grid,
				  (colarray[start].max+8)*sizeof(fixp));
	       if (tmp == NULL) { printf("Memory over.\n"); continue; }
	       colarray[start].grid = tmp;
	       colarray[start].max += 8;
	       }
	    colarray[start].grid[colarray[start].cur++] = (fixp)(sy/256);
	    }
	}
     if (y != lasty)
	{
	delta = ((long)(x-lastx))*1024/((long)(y-lasty));
	if (y < lasty)
	   {
	   start = (y+3)/4;
	   end = (lasty+3)/4;
	   sx = ((long)x)*256 + (((long)start)*4-((long)y))*delta/4;
	   }
	else {
	     start = (lasty+3)/4;
	     end = (y+3)/4;
	     sx = ((long)lastx)*256 + ((long)(start*4-lasty))*delta/4;
	     }
	if (start < 0) { sx += delta*(-start); start = 0;}
	if (end >= ymax) end = ymax-1;
	for (; start < end; start++, sx += delta)
	    { /* yadd(start,(fixp)(sx/256));*/
	    if (rowarray[start].cur == rowarray[start].max)
	       { /* Growth 8 each time */
	       tmp = (fixp *)realloc(rowarray[start].grid,
				  (rowarray[start].max+8)*sizeof(fixp));
	       if (tmp == NULL) { printf("Memory over.\n"); continue; }
	       rowarray[start].grid = tmp;
	       rowarray[start].max += 8;
	       }
	    rowarray[start].grid[rowarray[start].cur++] = (fixp)(sx/256);
	    }
	}
     lastx = x; lasty = y;
     }

void Curveto(fixp x, fixp y,unsigned short ctrl_fst,unsigned short ctrl_last)
     {
     unsigned short ctrl_next = ctrl_fst+1;
     fixp _x = xcoor[ctrl_fst], _y = ycoor[ctrl_fst];
     fixp tx, ty;

     Lineto((lastx+_x)/2, (lasty+_y)/2); /*Uniform B-spline*/
     for (; ctrl_fst <= ctrl_last; ctrl_fst++, ctrl_next++)
	 {
	 if (ctrl_next <= ctrl_last)
	    { tx = xcoor[ctrl_next]; ty = ycoor[ctrl_next]; }
	 else { tx = x; ty = y; }
	 SplitCurve(_x, _y, (_x+tx)/2, (_y+ty)/2);
	 _x = tx;
	 _y = ty;
	 }
     Lineto(x, y);
     }

void SplitCurve(fixp x1, fixp y1, fixp x2, fixp y2) /* Great Modify */
     { /*Delta routine for split nonuniform part of B-spline*/
     short n, i, m;
     long p1x = ((long)lastx-2*(long)x1+(long)x2) << 8;
     long p1y = ((long)lasty-2*(long)y1+(long)y2) << 8;
     long ddx, ddy, p2x, p2y, fx, fy, dx, dy;
     long ratio = __max(labs(p1x),labs(p1y)); /* 10 bit point */

     for (n = 0; ratio >= 512L; n++) ratio >>= 2; /* Compute coef. of spline */
     if (n)
	{                                       /* delta = 1/2^n */
	p2x = ((long)x1 - (long)lastx) << 9;
	p2y = ((long)y1 - (long)lasty) << 9;
	ddx = ((p1x*2) >> (2*n)); /* 2 order */
	ddy = ((p1y*2) >> (2*n));
	dx = (p2x >> n)+(p1x >> (2*n));
	dy = (p2y >> n)+(p1y >> (2*n));
	fx = dx + ((long)lastx << 8);
	fy = dy + ((long)lasty << 8);
	for (m = (1 << n), i = 1; i < m; i++)
	    {
	    Lineto((fixp)(fx/256),(fixp)(fy/256));
	    dx += ddx; fx += dx;
	    dy += ddy; fy += dy;
	    }
	}
     Lineto(x2,y2);
     }

/* short ycur;*/

