/*
 * @(#)plt/Alsa.h 3.00 12 October 2000
 *
 * Copyright (c) 2000 Pete Goodliffe (pete.goodliffe@pace.co.uk)
 *
 * This file is part of TSE3 - the Trax Sequencer Engine version 3.00.
 *
 * This library is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef TSE3_PLT_ALSA_H
#define TSE3_PLT_ALSA_H

#include "tse3/MidiScheduler.h"

namespace TSE3
{
    namespace Plt
    {
        /**
         * This is the Alsa @ref MidiScheduler implementation.
         *
         * @short   Alsa MidiScheduler implementation
         * @author  Pete Goodliffe
         * @version 0.00
         * @see     MidiScheduler
         * @see     AlsaMidiSchedulerFactory
         */
        class AlsaMidiScheduler : public MidiScheduler
        {
            public:

                /**
                 * @throws TSE3::MidiSchedulerError
                 */
                AlsaMidiScheduler();
                virtual ~AlsaMidiScheduler();

                /**
                 * @reimplemented
                 */
                virtual const char *implementationName();

                /**
                 * @reimplemented
                 */
                virtual size_t ports() const;

                /**
                 * @reimplemented
                 */
                virtual const char *portName(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual const char *portType(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual bool portReadable(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual bool portWriteable(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual void tx(MidiCommand mc);

                /**
                 * @reimplemented
                 */
                virtual void start(Clock startTime);

                /**
                 * @reimplemented
                 */
                virtual void stop(Clock stopTime);

                /**
                 * @reimplemented
                 */
                virtual void moveTo(Clock moveTime, Clock newTime);

                /**
                 * @reimplemented
                 */
                virtual Clock clock();

                /**
                 * @reimplemented
                 */
                virtual int msecs();

                /**
                 * @reimplemented
                 */
                virtual void setTempo(int newTempo, Clock changeTime);

                /**
                 * @reimplemented
                 */
                virtual bool eventWaiting();

                /**
                 * @reimplemented
                 */
                virtual MidiEvent rx();

                /**
                 * @reimplemented
                 */
                virtual void tx(MidiEvent event);

                /**
                 * @reimplemented
                 */
                virtual void txSysEx(const unsigned char *data, size_t size);

            private:

                AlsaMidiScheduler(const AlsaMidiScheduler &);
                AlsaMidiScheduler &operator=(const AlsaMidiScheduler &);

                size_t           noports;
                class AlsaImpl  *pimpl;
        };

        /**
         * This is the Alsa version of the @ref MidiSchedulerFactory. It makes
         * appropriate decisions to deliver you a @ref MidiScheduler that will
         * run under Alsa.
         *
         * @short   Alsa MidiScheduler class factory
         * @author  Pete Goodliffe
         * @version 1.00
         */
        class AlsaMidiSchedulerFactory : public MidiSchedulerFactory
        {
            public:

                AlsaMidiSchedulerFactory();
                virtual ~AlsaMidiSchedulerFactory();

                /**
                 * @reimplemented
                 */
                virtual AlsaMidiScheduler *createScheduler();

            private:
        };
    }
}

#endif
