/*
 * @(#)plt/RiscOS.h 3.00 20 July 1999
 *
 * Copyright (c) 2000 Pete Goodliffe (pete.goodliffe@pace.co.uk)
 *
 * This file is part of TSE3 - the Trax Sequencer Engine version 3.00.
 *
 * This library is modifiable/redistributable under the terms of the GNU
 * General Public License.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; see the file COPYING. If not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef TSE3_PLT_RISCOS_H
#define TSE3_PLT_RISCOS_H

#include "tse3/MidiScheduler.h"

namespace TSE3
{
    namespace Plt
    {
        /**
         * This is the RISC OS version of the @ref MidiSchedulerFactory. It
         * makes appropriate decisions to deliver you a @ref MidiScheduler that
         * will run under RISC OS.
         *
         * @short   RISC OS MidiScheduler class factory
         * @author  Pete Goodliffe
         * @version 3.00
         */
        class RiscOsMidiSchedulerFactory : public MidiSchedulerFactory
        {
            public:

                RiscOSMidiSchedulerFactory();
                virtual ~RiscOSMidiSchedulerFactory();

                /**
                 * @reimplemented
                 */
                virtual MidiScheduler *createScheduler();
        };


        /**
         * This is the RISC OS standard MIDI @ref MidiScheduler implementation.
         *
         * @short   RISC OS MidiScheduler implementation
         * @author  Pete Goodliffe
         * @version 3.00
         * @see     MidiScheduler
         * @see     MidiSchedulerFactory
         */
        class RiscOsMidiScheduler : public MidiScheduler
        {
            public:

                RiscOsMidiScheduler();
                virtual ~RiscOsMidiScheduler();

                /**
                 * @reimplemented
                 */
                virtual const char *implementationName();

                /**
                 * @reimplemented
                 */
                virtual size_t ports() const;

                /**
                 * @reimplemented
                 */
                virtual const char *portName(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual const char *portType(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual bool portReadable(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual bool portWriteable(size_t port) const;

                /**
                 * @reimplemented
                 */
                virtual void tx(MidiCommand mc);

                /**
                 * @reimplemented
                 */
                virtual void start(Clock startTime);

                /**
                 * @reimplemented
                 */
                virtual void stop();

                /**
                 * @reimplemented
                 */
                virtual void moveTo(Clock moveTime, Clock newTime);

                /**
                 * @reimplemented
                 */
                virtual Clock clock();

                /**
                 * @reimplemented
                 */
                virtual int msecs();

                /**
                 * @reimplemented
                 */
                virtual void setTempo(int newTempo, Clock changeTime);

                /**
                 * @reimplemented
                 */
                virtual bool eventWaiting();

                /**
                 * @reimplemented
                 */
                virtual MidiEvent rx();

                /**
                 * @reimplemented
                 */
                virtual void tx(MidiEvent event);

                /**
                 * @reimplemented
                 */
                virtual void txByte(int byte);

            private:

                int maxPort;
        };
    }
}

#endif
