// vax_rcnt.c - Register Count Table for Multi-Stack Instructions
//
// Copyright (c) 2001, Timothy M. Stark
//
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
// TIMOTHY M STARK BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
// IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// Except as contained in this notice, the name of Timothy M Stark shall not
// be used in advertising or otherwise to promote the sale, use or other 
// dealings in this Software without prior written authorization from
// Timothy M Stark.

// That table is used by following instructions:
//
//   CALLG   Call Procedure with General Argument List
//   CALLS   Call Procedure with Stack Argument List
//   PUSHR   Push Registers
//   POPR    Pop Registers
//   RET     Return from Procedure
//
// DO NOT EDIT THAT BELOW - That is generated by rcnt program.

#include "emu/defs.h"

const uchar vax_rcntTable[] = {
	 0, 4, 4, 8, 4, 8, 8,12, 4, 8, 8,12, 8,12,12,16, // 0000-000F
	 4, 8, 8,12, 8,12,12,16, 8,12,12,16,12,16,16,20, // 0010-001F
	 4, 8, 8,12, 8,12,12,16, 8,12,12,16,12,16,16,20, // 0020-002F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0030-003F
	 4, 8, 8,12, 8,12,12,16, 8,12,12,16,12,16,16,20, // 0040-004F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0050-005F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0060-006F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0070-007F
	 4, 8, 8,12, 8,12,12,16, 8,12,12,16,12,16,16,20, // 0080-008F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0090-009F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 00A0-00AF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 00B0-00BF
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 00C0-00CF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 00D0-00DF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 00E0-00EF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 00F0-00FF
	 4, 8, 8,12, 8,12,12,16, 8,12,12,16,12,16,16,20, // 0100-010F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0110-011F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0120-012F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0130-013F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0140-014F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0150-015F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0160-016F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0170-017F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0180-018F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0190-019F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 01A0-01AF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 01B0-01BF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 01C0-01CF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 01D0-01DF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 01E0-01EF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 01F0-01FF
	 4, 8, 8,12, 8,12,12,16, 8,12,12,16,12,16,16,20, // 0200-020F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0210-021F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0220-022F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0230-023F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0240-024F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0250-025F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0260-026F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0270-027F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0280-028F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0290-029F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 02A0-02AF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 02B0-02BF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 02C0-02CF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 02D0-02DF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 02E0-02EF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 02F0-02FF
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0300-030F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0310-031F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0320-032F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0330-033F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0340-034F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0350-035F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0360-036F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0370-037F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0380-038F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0390-039F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 03A0-03AF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 03B0-03BF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 03C0-03CF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 03D0-03DF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 03E0-03EF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 03F0-03FF
	 4, 8, 8,12, 8,12,12,16, 8,12,12,16,12,16,16,20, // 0400-040F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0410-041F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0420-042F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0430-043F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0440-044F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0450-045F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0460-046F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0470-047F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0480-048F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0490-049F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 04A0-04AF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 04B0-04BF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 04C0-04CF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 04D0-04DF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 04E0-04EF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 04F0-04FF
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0500-050F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0510-051F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0520-052F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0530-053F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0540-054F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0550-055F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0560-056F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0570-057F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0580-058F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0590-059F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 05A0-05AF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 05B0-05BF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 05C0-05CF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 05D0-05DF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 05E0-05EF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 05F0-05FF
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0600-060F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0610-061F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0620-062F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0630-063F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0640-064F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0650-065F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0660-066F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0670-067F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0680-068F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0690-069F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 06A0-06AF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 06B0-06BF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 06C0-06CF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 06D0-06DF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 06E0-06EF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 06F0-06FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0700-070F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0710-071F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0720-072F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0730-073F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0740-074F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0750-075F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0760-076F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 0770-077F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0780-078F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0790-079F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 07A0-07AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 07B0-07BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 07C0-07CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 07D0-07DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 07E0-07EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 07F0-07FF
	 4, 8, 8,12, 8,12,12,16, 8,12,12,16,12,16,16,20, // 0800-080F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0810-081F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0820-082F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0830-083F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0840-084F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0850-085F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0860-086F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0870-087F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0880-088F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0890-089F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 08A0-08AF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 08B0-08BF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 08C0-08CF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 08D0-08DF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 08E0-08EF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 08F0-08FF
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0900-090F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0910-091F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0920-092F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0930-093F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0940-094F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0950-095F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0960-096F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0970-097F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0980-098F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0990-099F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 09A0-09AF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 09B0-09BF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 09C0-09CF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 09D0-09DF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 09E0-09EF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 09F0-09FF
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0A00-0A0F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0A10-0A1F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0A20-0A2F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0A30-0A3F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0A40-0A4F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0A50-0A5F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0A60-0A6F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0A70-0A7F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0A80-0A8F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0A90-0A9F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0AA0-0AAF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0AB0-0ABF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0AC0-0ACF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0AD0-0ADF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0AE0-0AEF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 0AF0-0AFF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0B00-0B0F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0B10-0B1F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0B20-0B2F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0B30-0B3F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0B40-0B4F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0B50-0B5F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0B60-0B6F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 0B70-0B7F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0B80-0B8F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0B90-0B9F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0BA0-0BAF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 0BB0-0BBF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0BC0-0BCF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 0BD0-0BDF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 0BE0-0BEF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 0BF0-0BFF
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 0C00-0C0F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0C10-0C1F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0C20-0C2F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0C30-0C3F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0C40-0C4F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0C50-0C5F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0C60-0C6F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0C70-0C7F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0C80-0C8F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0C90-0C9F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0CA0-0CAF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0CB0-0CBF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0CC0-0CCF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0CD0-0CDF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0CE0-0CEF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 0CF0-0CFF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0D00-0D0F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0D10-0D1F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0D20-0D2F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0D30-0D3F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0D40-0D4F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0D50-0D5F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0D60-0D6F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 0D70-0D7F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0D80-0D8F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0D90-0D9F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0DA0-0DAF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 0DB0-0DBF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0DC0-0DCF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 0DD0-0DDF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 0DE0-0DEF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 0DF0-0DFF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 0E00-0E0F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0E10-0E1F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0E20-0E2F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0E30-0E3F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0E40-0E4F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0E50-0E5F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0E60-0E6F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 0E70-0E7F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0E80-0E8F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0E90-0E9F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0EA0-0EAF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 0EB0-0EBF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0EC0-0ECF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 0ED0-0EDF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 0EE0-0EEF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 0EF0-0EFF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 0F00-0F0F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0F10-0F1F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0F20-0F2F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 0F30-0F3F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0F40-0F4F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 0F50-0F5F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 0F60-0F6F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 0F70-0F7F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 0F80-0F8F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 0F90-0F9F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 0FA0-0FAF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 0FB0-0FBF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 0FC0-0FCF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 0FD0-0FDF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 0FE0-0FEF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 0FF0-0FFF
	 4, 8, 8,12, 8,12,12,16, 8,12,12,16,12,16,16,20, // 1000-100F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 1010-101F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 1020-102F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1030-103F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 1040-104F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1050-105F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1060-106F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1070-107F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 1080-108F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1090-109F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 10A0-10AF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 10B0-10BF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 10C0-10CF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 10D0-10DF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 10E0-10EF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 10F0-10FF
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 1100-110F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1110-111F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1120-112F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1130-113F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1140-114F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1150-115F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1160-116F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1170-117F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1180-118F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1190-119F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 11A0-11AF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 11B0-11BF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 11C0-11CF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 11D0-11DF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 11E0-11EF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 11F0-11FF
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 1200-120F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1210-121F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1220-122F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1230-123F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1240-124F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1250-125F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1260-126F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1270-127F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1280-128F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1290-129F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 12A0-12AF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 12B0-12BF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 12C0-12CF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 12D0-12DF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 12E0-12EF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 12F0-12FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1300-130F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1310-131F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1320-132F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1330-133F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1340-134F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1350-135F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1360-136F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1370-137F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1380-138F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1390-139F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 13A0-13AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 13B0-13BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 13C0-13CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 13D0-13DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 13E0-13EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 13F0-13FF
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 1400-140F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1410-141F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1420-142F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1430-143F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1440-144F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1450-145F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1460-146F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1470-147F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1480-148F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1490-149F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 14A0-14AF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 14B0-14BF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 14C0-14CF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 14D0-14DF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 14E0-14EF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 14F0-14FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1500-150F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1510-151F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1520-152F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1530-153F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1540-154F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1550-155F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1560-156F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1570-157F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1580-158F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1590-159F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 15A0-15AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 15B0-15BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 15C0-15CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 15D0-15DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 15E0-15EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 15F0-15FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1600-160F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1610-161F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1620-162F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1630-163F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1640-164F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1650-165F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1660-166F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1670-167F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1680-168F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1690-169F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 16A0-16AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 16B0-16BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 16C0-16CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 16D0-16DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 16E0-16EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 16F0-16FF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1700-170F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1710-171F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1720-172F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1730-173F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1740-174F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1750-175F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1760-176F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 1770-177F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1780-178F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1790-179F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 17A0-17AF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 17B0-17BF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 17C0-17CF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 17D0-17DF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 17E0-17EF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 17F0-17FF
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 1800-180F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1810-181F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1820-182F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1830-183F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1840-184F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1850-185F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1860-186F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1870-187F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1880-188F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1890-189F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 18A0-18AF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 18B0-18BF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 18C0-18CF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 18D0-18DF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 18E0-18EF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 18F0-18FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1900-190F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1910-191F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1920-192F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1930-193F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1940-194F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1950-195F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1960-196F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1970-197F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1980-198F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1990-199F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 19A0-19AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 19B0-19BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 19C0-19CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 19D0-19DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 19E0-19EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 19F0-19FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1A00-1A0F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1A10-1A1F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1A20-1A2F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1A30-1A3F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1A40-1A4F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1A50-1A5F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1A60-1A6F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1A70-1A7F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1A80-1A8F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1A90-1A9F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1AA0-1AAF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1AB0-1ABF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1AC0-1ACF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1AD0-1ADF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1AE0-1AEF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 1AF0-1AFF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1B00-1B0F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1B10-1B1F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1B20-1B2F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1B30-1B3F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1B40-1B4F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1B50-1B5F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1B60-1B6F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 1B70-1B7F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1B80-1B8F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1B90-1B9F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1BA0-1BAF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 1BB0-1BBF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1BC0-1BCF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 1BD0-1BDF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 1BE0-1BEF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 1BF0-1BFF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 1C00-1C0F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1C10-1C1F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1C20-1C2F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1C30-1C3F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1C40-1C4F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1C50-1C5F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1C60-1C6F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1C70-1C7F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1C80-1C8F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1C90-1C9F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1CA0-1CAF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1CB0-1CBF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1CC0-1CCF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1CD0-1CDF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1CE0-1CEF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 1CF0-1CFF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1D00-1D0F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1D10-1D1F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1D20-1D2F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1D30-1D3F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1D40-1D4F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1D50-1D5F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1D60-1D6F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 1D70-1D7F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1D80-1D8F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1D90-1D9F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1DA0-1DAF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 1DB0-1DBF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1DC0-1DCF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 1DD0-1DDF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 1DE0-1DEF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 1DF0-1DFF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 1E00-1E0F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1E10-1E1F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1E20-1E2F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1E30-1E3F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1E40-1E4F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1E50-1E5F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1E60-1E6F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 1E70-1E7F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1E80-1E8F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1E90-1E9F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1EA0-1EAF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 1EB0-1EBF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1EC0-1ECF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 1ED0-1EDF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 1EE0-1EEF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 1EF0-1EFF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 1F00-1F0F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1F10-1F1F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1F20-1F2F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 1F30-1F3F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1F40-1F4F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 1F50-1F5F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 1F60-1F6F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 1F70-1F7F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 1F80-1F8F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 1F90-1F9F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 1FA0-1FAF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 1FB0-1FBF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 1FC0-1FCF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 1FD0-1FDF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 1FE0-1FEF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 1FF0-1FFF
	 4, 8, 8,12, 8,12,12,16, 8,12,12,16,12,16,16,20, // 2000-200F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 2010-201F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 2020-202F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2030-203F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 2040-204F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2050-205F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2060-206F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2070-207F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 2080-208F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2090-209F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 20A0-20AF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 20B0-20BF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 20C0-20CF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 20D0-20DF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 20E0-20EF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 20F0-20FF
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 2100-210F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2110-211F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2120-212F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2130-213F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2140-214F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2150-215F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2160-216F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2170-217F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2180-218F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2190-219F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 21A0-21AF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 21B0-21BF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 21C0-21CF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 21D0-21DF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 21E0-21EF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 21F0-21FF
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 2200-220F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2210-221F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2220-222F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2230-223F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2240-224F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2250-225F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2260-226F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2270-227F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2280-228F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2290-229F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 22A0-22AF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 22B0-22BF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 22C0-22CF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 22D0-22DF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 22E0-22EF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 22F0-22FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2300-230F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2310-231F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2320-232F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2330-233F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2340-234F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2350-235F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2360-236F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2370-237F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2380-238F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2390-239F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 23A0-23AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 23B0-23BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 23C0-23CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 23D0-23DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 23E0-23EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 23F0-23FF
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 2400-240F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2410-241F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2420-242F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2430-243F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2440-244F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2450-245F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2460-246F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2470-247F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2480-248F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2490-249F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 24A0-24AF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 24B0-24BF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 24C0-24CF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 24D0-24DF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 24E0-24EF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 24F0-24FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2500-250F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2510-251F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2520-252F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2530-253F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2540-254F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2550-255F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2560-256F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2570-257F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2580-258F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2590-259F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 25A0-25AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 25B0-25BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 25C0-25CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 25D0-25DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 25E0-25EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 25F0-25FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2600-260F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2610-261F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2620-262F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2630-263F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2640-264F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2650-265F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2660-266F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2670-267F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2680-268F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2690-269F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 26A0-26AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 26B0-26BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 26C0-26CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 26D0-26DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 26E0-26EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 26F0-26FF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2700-270F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2710-271F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2720-272F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2730-273F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2740-274F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2750-275F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2760-276F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 2770-277F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2780-278F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2790-279F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 27A0-27AF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 27B0-27BF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 27C0-27CF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 27D0-27DF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 27E0-27EF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 27F0-27FF
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 2800-280F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2810-281F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2820-282F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2830-283F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2840-284F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2850-285F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2860-286F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2870-287F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2880-288F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2890-289F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 28A0-28AF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 28B0-28BF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 28C0-28CF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 28D0-28DF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 28E0-28EF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 28F0-28FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2900-290F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2910-291F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2920-292F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2930-293F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2940-294F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2950-295F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2960-296F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2970-297F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2980-298F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2990-299F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 29A0-29AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 29B0-29BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 29C0-29CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 29D0-29DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 29E0-29EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 29F0-29FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2A00-2A0F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2A10-2A1F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2A20-2A2F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2A30-2A3F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2A40-2A4F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2A50-2A5F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2A60-2A6F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2A70-2A7F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2A80-2A8F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2A90-2A9F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2AA0-2AAF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2AB0-2ABF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2AC0-2ACF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2AD0-2ADF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2AE0-2AEF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 2AF0-2AFF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2B00-2B0F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2B10-2B1F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2B20-2B2F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2B30-2B3F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2B40-2B4F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2B50-2B5F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2B60-2B6F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 2B70-2B7F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2B80-2B8F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2B90-2B9F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2BA0-2BAF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 2BB0-2BBF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2BC0-2BCF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 2BD0-2BDF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 2BE0-2BEF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 2BF0-2BFF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 2C00-2C0F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2C10-2C1F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2C20-2C2F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2C30-2C3F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2C40-2C4F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2C50-2C5F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2C60-2C6F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2C70-2C7F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2C80-2C8F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2C90-2C9F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2CA0-2CAF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2CB0-2CBF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2CC0-2CCF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2CD0-2CDF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2CE0-2CEF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 2CF0-2CFF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2D00-2D0F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2D10-2D1F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2D20-2D2F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2D30-2D3F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2D40-2D4F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2D50-2D5F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2D60-2D6F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 2D70-2D7F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2D80-2D8F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2D90-2D9F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2DA0-2DAF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 2DB0-2DBF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2DC0-2DCF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 2DD0-2DDF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 2DE0-2DEF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 2DF0-2DFF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 2E00-2E0F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2E10-2E1F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2E20-2E2F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2E30-2E3F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2E40-2E4F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2E50-2E5F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2E60-2E6F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 2E70-2E7F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2E80-2E8F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2E90-2E9F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2EA0-2EAF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 2EB0-2EBF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2EC0-2ECF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 2ED0-2EDF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 2EE0-2EEF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 2EF0-2EFF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 2F00-2F0F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2F10-2F1F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2F20-2F2F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 2F30-2F3F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2F40-2F4F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 2F50-2F5F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 2F60-2F6F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 2F70-2F7F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 2F80-2F8F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 2F90-2F9F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 2FA0-2FAF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 2FB0-2FBF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 2FC0-2FCF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 2FD0-2FDF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 2FE0-2FEF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 2FF0-2FFF
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 3000-300F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 3010-301F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 3020-302F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3030-303F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 3040-304F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3050-305F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3060-306F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3070-307F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 3080-308F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3090-309F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 30A0-30AF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 30B0-30BF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 30C0-30CF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 30D0-30DF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 30E0-30EF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 30F0-30FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 3100-310F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3110-311F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3120-312F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3130-313F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3140-314F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3150-315F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3160-316F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3170-317F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3180-318F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3190-319F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 31A0-31AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 31B0-31BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 31C0-31CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 31D0-31DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 31E0-31EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 31F0-31FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 3200-320F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3210-321F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3220-322F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3230-323F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3240-324F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3250-325F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3260-326F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3270-327F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3280-328F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3290-329F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 32A0-32AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 32B0-32BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 32C0-32CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 32D0-32DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 32E0-32EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 32F0-32FF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3300-330F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3310-331F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3320-332F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3330-333F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3340-334F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3350-335F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3360-336F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3370-337F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3380-338F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3390-339F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 33A0-33AF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 33B0-33BF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 33C0-33CF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 33D0-33DF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 33E0-33EF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 33F0-33FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 3400-340F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3410-341F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3420-342F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3430-343F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3440-344F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3450-345F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3460-346F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3470-347F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3480-348F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3490-349F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 34A0-34AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 34B0-34BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 34C0-34CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 34D0-34DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 34E0-34EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 34F0-34FF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3500-350F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3510-351F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3520-352F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3530-353F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3540-354F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3550-355F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3560-356F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3570-357F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3580-358F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3590-359F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 35A0-35AF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 35B0-35BF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 35C0-35CF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 35D0-35DF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 35E0-35EF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 35F0-35FF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3600-360F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3610-361F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3620-362F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3630-363F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3640-364F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3650-365F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3660-366F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3670-367F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3680-368F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3690-369F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 36A0-36AF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 36B0-36BF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 36C0-36CF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 36D0-36DF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 36E0-36EF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 36F0-36FF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3700-370F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3710-371F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3720-372F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3730-373F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3740-374F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3750-375F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3760-376F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 3770-377F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3780-378F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3790-379F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 37A0-37AF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 37B0-37BF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 37C0-37CF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 37D0-37DF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 37E0-37EF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 37F0-37FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 3800-380F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3810-381F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3820-382F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3830-383F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3840-384F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3850-385F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3860-386F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3870-387F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3880-388F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3890-389F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 38A0-38AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 38B0-38BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 38C0-38CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 38D0-38DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 38E0-38EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 38F0-38FF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3900-390F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3910-391F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3920-392F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3930-393F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3940-394F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3950-395F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3960-396F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3970-397F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3980-398F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3990-399F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 39A0-39AF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 39B0-39BF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 39C0-39CF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 39D0-39DF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 39E0-39EF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 39F0-39FF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3A00-3A0F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3A10-3A1F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3A20-3A2F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3A30-3A3F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3A40-3A4F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3A50-3A5F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3A60-3A6F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3A70-3A7F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3A80-3A8F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3A90-3A9F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3AA0-3AAF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3AB0-3ABF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3AC0-3ACF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3AD0-3ADF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3AE0-3AEF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 3AF0-3AFF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3B00-3B0F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3B10-3B1F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3B20-3B2F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3B30-3B3F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3B40-3B4F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3B50-3B5F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3B60-3B6F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 3B70-3B7F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3B80-3B8F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3B90-3B9F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3BA0-3BAF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 3BB0-3BBF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3BC0-3BCF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 3BD0-3BDF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 3BE0-3BEF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 3BF0-3BFF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 3C00-3C0F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3C10-3C1F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3C20-3C2F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3C30-3C3F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3C40-3C4F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3C50-3C5F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3C60-3C6F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3C70-3C7F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3C80-3C8F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3C90-3C9F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3CA0-3CAF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3CB0-3CBF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3CC0-3CCF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3CD0-3CDF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3CE0-3CEF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 3CF0-3CFF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3D00-3D0F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3D10-3D1F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3D20-3D2F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3D30-3D3F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3D40-3D4F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3D50-3D5F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3D60-3D6F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 3D70-3D7F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3D80-3D8F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3D90-3D9F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3DA0-3DAF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 3DB0-3DBF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3DC0-3DCF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 3DD0-3DDF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 3DE0-3DEF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 3DF0-3DFF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 3E00-3E0F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3E10-3E1F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3E20-3E2F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3E30-3E3F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3E40-3E4F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3E50-3E5F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3E60-3E6F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 3E70-3E7F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3E80-3E8F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3E90-3E9F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3EA0-3EAF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 3EB0-3EBF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3EC0-3ECF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 3ED0-3EDF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 3EE0-3EEF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 3EF0-3EFF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 3F00-3F0F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3F10-3F1F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3F20-3F2F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 3F30-3F3F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3F40-3F4F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 3F50-3F5F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 3F60-3F6F
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 3F70-3F7F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 3F80-3F8F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 3F90-3F9F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 3FA0-3FAF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 3FB0-3FBF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 3FC0-3FCF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 3FD0-3FDF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 3FE0-3FEF
	40,44,44,48,44,48,48,52,44,48,48,52,48,52,52,56, // 3FF0-3FFF
	 4, 8, 8,12, 8,12,12,16, 8,12,12,16,12,16,16,20, // 4000-400F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 4010-401F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 4020-402F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4030-403F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 4040-404F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4050-405F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4060-406F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4070-407F
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 4080-408F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4090-409F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 40A0-40AF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 40B0-40BF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 40C0-40CF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 40D0-40DF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 40E0-40EF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 40F0-40FF
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 4100-410F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4110-411F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4120-412F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4130-413F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4140-414F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4150-415F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4160-416F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4170-417F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4180-418F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4190-419F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 41A0-41AF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 41B0-41BF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 41C0-41CF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 41D0-41DF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 41E0-41EF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 41F0-41FF
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 4200-420F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4210-421F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4220-422F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4230-423F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4240-424F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4250-425F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4260-426F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4270-427F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4280-428F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4290-429F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 42A0-42AF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 42B0-42BF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 42C0-42CF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 42D0-42DF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 42E0-42EF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 42F0-42FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4300-430F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4310-431F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4320-432F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4330-433F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4340-434F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4350-435F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4360-436F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4370-437F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4380-438F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4390-439F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 43A0-43AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 43B0-43BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 43C0-43CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 43D0-43DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 43E0-43EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 43F0-43FF
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 4400-440F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4410-441F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4420-442F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4430-443F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4440-444F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4450-445F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4460-446F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4470-447F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4480-448F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4490-449F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 44A0-44AF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 44B0-44BF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 44C0-44CF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 44D0-44DF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 44E0-44EF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 44F0-44FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4500-450F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4510-451F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4520-452F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4530-453F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4540-454F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4550-455F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4560-456F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4570-457F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4580-458F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4590-459F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 45A0-45AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 45B0-45BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 45C0-45CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 45D0-45DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 45E0-45EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 45F0-45FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4600-460F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4610-461F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4620-462F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4630-463F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4640-464F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4650-465F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4660-466F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4670-467F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4680-468F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4690-469F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 46A0-46AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 46B0-46BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 46C0-46CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 46D0-46DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 46E0-46EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 46F0-46FF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4700-470F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4710-471F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4720-472F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4730-473F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4740-474F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4750-475F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4760-476F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 4770-477F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4780-478F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4790-479F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 47A0-47AF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 47B0-47BF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 47C0-47CF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 47D0-47DF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 47E0-47EF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 47F0-47FF
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 4800-480F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4810-481F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4820-482F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4830-483F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4840-484F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4850-485F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4860-486F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4870-487F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4880-488F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4890-489F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 48A0-48AF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 48B0-48BF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 48C0-48CF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 48D0-48DF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 48E0-48EF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 48F0-48FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4900-490F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4910-491F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4920-492F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4930-493F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4940-494F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4950-495F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4960-496F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4970-497F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4980-498F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4990-499F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 49A0-49AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 49B0-49BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 49C0-49CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 49D0-49DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 49E0-49EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 49F0-49FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4A00-4A0F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4A10-4A1F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4A20-4A2F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4A30-4A3F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4A40-4A4F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4A50-4A5F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4A60-4A6F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4A70-4A7F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4A80-4A8F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4A90-4A9F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4AA0-4AAF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4AB0-4ABF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4AC0-4ACF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4AD0-4ADF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4AE0-4AEF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 4AF0-4AFF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4B00-4B0F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4B10-4B1F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4B20-4B2F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4B30-4B3F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4B40-4B4F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4B50-4B5F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4B60-4B6F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 4B70-4B7F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4B80-4B8F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4B90-4B9F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4BA0-4BAF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 4BB0-4BBF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4BC0-4BCF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 4BD0-4BDF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 4BE0-4BEF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 4BF0-4BFF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 4C00-4C0F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4C10-4C1F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4C20-4C2F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4C30-4C3F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4C40-4C4F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4C50-4C5F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4C60-4C6F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4C70-4C7F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4C80-4C8F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4C90-4C9F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4CA0-4CAF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4CB0-4CBF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4CC0-4CCF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4CD0-4CDF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4CE0-4CEF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 4CF0-4CFF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4D00-4D0F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4D10-4D1F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4D20-4D2F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4D30-4D3F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4D40-4D4F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4D50-4D5F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4D60-4D6F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 4D70-4D7F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4D80-4D8F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4D90-4D9F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4DA0-4DAF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 4DB0-4DBF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4DC0-4DCF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 4DD0-4DDF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 4DE0-4DEF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 4DF0-4DFF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 4E00-4E0F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4E10-4E1F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4E20-4E2F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4E30-4E3F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4E40-4E4F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4E50-4E5F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4E60-4E6F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 4E70-4E7F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4E80-4E8F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4E90-4E9F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4EA0-4EAF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 4EB0-4EBF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4EC0-4ECF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 4ED0-4EDF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 4EE0-4EEF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 4EF0-4EFF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 4F00-4F0F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4F10-4F1F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4F20-4F2F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 4F30-4F3F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4F40-4F4F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 4F50-4F5F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 4F60-4F6F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 4F70-4F7F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 4F80-4F8F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 4F90-4F9F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 4FA0-4FAF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 4FB0-4FBF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 4FC0-4FCF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 4FD0-4FDF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 4FE0-4FEF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 4FF0-4FFF
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 5000-500F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 5010-501F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 5020-502F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5030-503F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 5040-504F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5050-505F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5060-506F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5070-507F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 5080-508F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5090-509F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 50A0-50AF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 50B0-50BF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 50C0-50CF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 50D0-50DF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 50E0-50EF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 50F0-50FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 5100-510F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5110-511F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5120-512F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5130-513F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5140-514F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5150-515F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5160-516F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5170-517F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5180-518F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5190-519F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 51A0-51AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 51B0-51BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 51C0-51CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 51D0-51DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 51E0-51EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 51F0-51FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 5200-520F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5210-521F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5220-522F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5230-523F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5240-524F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5250-525F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5260-526F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5270-527F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5280-528F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5290-529F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 52A0-52AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 52B0-52BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 52C0-52CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 52D0-52DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 52E0-52EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 52F0-52FF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5300-530F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5310-531F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5320-532F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5330-533F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5340-534F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5350-535F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5360-536F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5370-537F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5380-538F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5390-539F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 53A0-53AF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 53B0-53BF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 53C0-53CF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 53D0-53DF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 53E0-53EF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 53F0-53FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 5400-540F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5410-541F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5420-542F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5430-543F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5440-544F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5450-545F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5460-546F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5470-547F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5480-548F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5490-549F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 54A0-54AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 54B0-54BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 54C0-54CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 54D0-54DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 54E0-54EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 54F0-54FF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5500-550F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5510-551F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5520-552F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5530-553F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5540-554F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5550-555F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5560-556F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5570-557F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5580-558F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5590-559F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 55A0-55AF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 55B0-55BF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 55C0-55CF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 55D0-55DF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 55E0-55EF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 55F0-55FF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5600-560F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5610-561F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5620-562F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5630-563F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5640-564F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5650-565F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5660-566F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5670-567F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5680-568F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5690-569F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 56A0-56AF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 56B0-56BF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 56C0-56CF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 56D0-56DF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 56E0-56EF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 56F0-56FF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5700-570F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5710-571F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5720-572F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5730-573F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5740-574F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5750-575F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5760-576F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 5770-577F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5780-578F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5790-579F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 57A0-57AF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 57B0-57BF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 57C0-57CF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 57D0-57DF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 57E0-57EF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 57F0-57FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 5800-580F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5810-581F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5820-582F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5830-583F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5840-584F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5850-585F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5860-586F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5870-587F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5880-588F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5890-589F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 58A0-58AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 58B0-58BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 58C0-58CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 58D0-58DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 58E0-58EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 58F0-58FF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5900-590F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5910-591F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5920-592F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5930-593F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5940-594F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5950-595F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5960-596F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5970-597F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5980-598F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5990-599F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 59A0-59AF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 59B0-59BF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 59C0-59CF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 59D0-59DF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 59E0-59EF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 59F0-59FF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5A00-5A0F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5A10-5A1F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5A20-5A2F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5A30-5A3F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5A40-5A4F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5A50-5A5F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5A60-5A6F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5A70-5A7F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5A80-5A8F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5A90-5A9F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5AA0-5AAF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5AB0-5ABF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5AC0-5ACF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5AD0-5ADF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5AE0-5AEF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 5AF0-5AFF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5B00-5B0F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5B10-5B1F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5B20-5B2F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5B30-5B3F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5B40-5B4F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5B50-5B5F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5B60-5B6F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 5B70-5B7F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5B80-5B8F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5B90-5B9F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5BA0-5BAF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 5BB0-5BBF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5BC0-5BCF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 5BD0-5BDF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 5BE0-5BEF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 5BF0-5BFF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 5C00-5C0F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5C10-5C1F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5C20-5C2F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5C30-5C3F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5C40-5C4F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5C50-5C5F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5C60-5C6F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5C70-5C7F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5C80-5C8F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5C90-5C9F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5CA0-5CAF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5CB0-5CBF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5CC0-5CCF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5CD0-5CDF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5CE0-5CEF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 5CF0-5CFF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5D00-5D0F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5D10-5D1F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5D20-5D2F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5D30-5D3F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5D40-5D4F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5D50-5D5F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5D60-5D6F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 5D70-5D7F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5D80-5D8F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5D90-5D9F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5DA0-5DAF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 5DB0-5DBF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5DC0-5DCF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 5DD0-5DDF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 5DE0-5DEF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 5DF0-5DFF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 5E00-5E0F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5E10-5E1F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5E20-5E2F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5E30-5E3F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5E40-5E4F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5E50-5E5F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5E60-5E6F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 5E70-5E7F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5E80-5E8F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5E90-5E9F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5EA0-5EAF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 5EB0-5EBF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5EC0-5ECF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 5ED0-5EDF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 5EE0-5EEF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 5EF0-5EFF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 5F00-5F0F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5F10-5F1F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5F20-5F2F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 5F30-5F3F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5F40-5F4F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 5F50-5F5F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 5F60-5F6F
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 5F70-5F7F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 5F80-5F8F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 5F90-5F9F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 5FA0-5FAF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 5FB0-5FBF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 5FC0-5FCF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 5FD0-5FDF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 5FE0-5FEF
	40,44,44,48,44,48,48,52,44,48,48,52,48,52,52,56, // 5FF0-5FFF
	 8,12,12,16,12,16,16,20,12,16,16,20,16,20,20,24, // 6000-600F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 6010-601F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 6020-602F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6030-603F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 6040-604F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6050-605F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6060-606F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6070-607F
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 6080-608F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6090-609F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 60A0-60AF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 60B0-60BF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 60C0-60CF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 60D0-60DF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 60E0-60EF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 60F0-60FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 6100-610F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6110-611F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6120-612F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6130-613F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6140-614F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6150-615F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6160-616F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6170-617F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6180-618F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6190-619F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 61A0-61AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 61B0-61BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 61C0-61CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 61D0-61DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 61E0-61EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 61F0-61FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 6200-620F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6210-621F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6220-622F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6230-623F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6240-624F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6250-625F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6260-626F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6270-627F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6280-628F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6290-629F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 62A0-62AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 62B0-62BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 62C0-62CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 62D0-62DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 62E0-62EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 62F0-62FF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6300-630F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6310-631F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6320-632F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6330-633F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6340-634F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6350-635F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6360-636F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6370-637F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6380-638F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6390-639F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 63A0-63AF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 63B0-63BF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 63C0-63CF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 63D0-63DF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 63E0-63EF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 63F0-63FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 6400-640F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6410-641F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6420-642F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6430-643F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6440-644F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6450-645F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6460-646F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6470-647F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6480-648F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6490-649F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 64A0-64AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 64B0-64BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 64C0-64CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 64D0-64DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 64E0-64EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 64F0-64FF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6500-650F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6510-651F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6520-652F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6530-653F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6540-654F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6550-655F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6560-656F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6570-657F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6580-658F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6590-659F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 65A0-65AF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 65B0-65BF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 65C0-65CF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 65D0-65DF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 65E0-65EF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 65F0-65FF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6600-660F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6610-661F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6620-662F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6630-663F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6640-664F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6650-665F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6660-666F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6670-667F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6680-668F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6690-669F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 66A0-66AF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 66B0-66BF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 66C0-66CF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 66D0-66DF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 66E0-66EF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 66F0-66FF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6700-670F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6710-671F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6720-672F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6730-673F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6740-674F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6750-675F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6760-676F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 6770-677F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6780-678F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6790-679F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 67A0-67AF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 67B0-67BF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 67C0-67CF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 67D0-67DF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 67E0-67EF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 67F0-67FF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 6800-680F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6810-681F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6820-682F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6830-683F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6840-684F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6850-685F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6860-686F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6870-687F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6880-688F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6890-689F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 68A0-68AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 68B0-68BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 68C0-68CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 68D0-68DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 68E0-68EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 68F0-68FF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6900-690F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6910-691F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6920-692F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6930-693F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6940-694F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6950-695F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6960-696F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6970-697F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6980-698F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6990-699F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 69A0-69AF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 69B0-69BF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 69C0-69CF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 69D0-69DF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 69E0-69EF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 69F0-69FF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6A00-6A0F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6A10-6A1F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6A20-6A2F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6A30-6A3F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6A40-6A4F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6A50-6A5F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6A60-6A6F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6A70-6A7F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6A80-6A8F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6A90-6A9F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6AA0-6AAF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6AB0-6ABF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6AC0-6ACF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6AD0-6ADF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6AE0-6AEF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 6AF0-6AFF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6B00-6B0F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6B10-6B1F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6B20-6B2F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6B30-6B3F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6B40-6B4F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6B50-6B5F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6B60-6B6F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 6B70-6B7F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6B80-6B8F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6B90-6B9F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6BA0-6BAF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 6BB0-6BBF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6BC0-6BCF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 6BD0-6BDF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 6BE0-6BEF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 6BF0-6BFF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 6C00-6C0F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6C10-6C1F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6C20-6C2F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6C30-6C3F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6C40-6C4F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6C50-6C5F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6C60-6C6F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6C70-6C7F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6C80-6C8F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6C90-6C9F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6CA0-6CAF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6CB0-6CBF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6CC0-6CCF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6CD0-6CDF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6CE0-6CEF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 6CF0-6CFF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6D00-6D0F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6D10-6D1F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6D20-6D2F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6D30-6D3F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6D40-6D4F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6D50-6D5F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6D60-6D6F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 6D70-6D7F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6D80-6D8F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6D90-6D9F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6DA0-6DAF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 6DB0-6DBF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6DC0-6DCF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 6DD0-6DDF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 6DE0-6DEF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 6DF0-6DFF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 6E00-6E0F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6E10-6E1F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6E20-6E2F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6E30-6E3F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6E40-6E4F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6E50-6E5F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6E60-6E6F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 6E70-6E7F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6E80-6E8F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6E90-6E9F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6EA0-6EAF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 6EB0-6EBF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6EC0-6ECF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 6ED0-6EDF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 6EE0-6EEF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 6EF0-6EFF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 6F00-6F0F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6F10-6F1F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6F20-6F2F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 6F30-6F3F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6F40-6F4F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 6F50-6F5F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 6F60-6F6F
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 6F70-6F7F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 6F80-6F8F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 6F90-6F9F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 6FA0-6FAF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 6FB0-6FBF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 6FC0-6FCF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 6FD0-6FDF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 6FE0-6FEF
	40,44,44,48,44,48,48,52,44,48,48,52,48,52,52,56, // 6FF0-6FFF
	12,16,16,20,16,20,20,24,16,20,20,24,20,24,24,28, // 7000-700F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 7010-701F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 7020-702F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7030-703F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 7040-704F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7050-705F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7060-706F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7070-707F
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 7080-708F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7090-709F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 70A0-70AF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 70B0-70BF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 70C0-70CF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 70D0-70DF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 70E0-70EF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 70F0-70FF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 7100-710F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7110-711F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7120-712F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7130-713F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7140-714F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7150-715F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7160-716F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7170-717F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7180-718F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7190-719F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 71A0-71AF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 71B0-71BF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 71C0-71CF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 71D0-71DF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 71E0-71EF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 71F0-71FF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 7200-720F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7210-721F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7220-722F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7230-723F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7240-724F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7250-725F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7260-726F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7270-727F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7280-728F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7290-729F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 72A0-72AF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 72B0-72BF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 72C0-72CF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 72D0-72DF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 72E0-72EF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 72F0-72FF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7300-730F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7310-731F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7320-732F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7330-733F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7340-734F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7350-735F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7360-736F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7370-737F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7380-738F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7390-739F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 73A0-73AF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 73B0-73BF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 73C0-73CF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 73D0-73DF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 73E0-73EF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 73F0-73FF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 7400-740F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7410-741F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7420-742F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7430-743F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7440-744F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7450-745F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7460-746F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7470-747F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7480-748F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7490-749F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 74A0-74AF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 74B0-74BF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 74C0-74CF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 74D0-74DF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 74E0-74EF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 74F0-74FF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7500-750F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7510-751F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7520-752F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7530-753F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7540-754F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7550-755F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7560-756F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7570-757F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7580-758F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7590-759F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 75A0-75AF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 75B0-75BF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 75C0-75CF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 75D0-75DF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 75E0-75EF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 75F0-75FF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7600-760F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7610-761F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7620-762F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7630-763F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7640-764F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7650-765F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7660-766F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7670-767F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7680-768F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7690-769F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 76A0-76AF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 76B0-76BF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 76C0-76CF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 76D0-76DF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 76E0-76EF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 76F0-76FF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7700-770F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7710-771F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7720-772F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7730-773F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7740-774F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7750-775F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7760-776F
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 7770-777F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7780-778F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7790-779F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 77A0-77AF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 77B0-77BF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 77C0-77CF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 77D0-77DF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 77E0-77EF
	40,44,44,48,44,48,48,52,44,48,48,52,48,52,52,56, // 77F0-77FF
	16,20,20,24,20,24,24,28,20,24,24,28,24,28,28,32, // 7800-780F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7810-781F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7820-782F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7830-783F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7840-784F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7850-785F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7860-786F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7870-787F
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7880-788F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7890-789F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 78A0-78AF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 78B0-78BF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 78C0-78CF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 78D0-78DF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 78E0-78EF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 78F0-78FF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7900-790F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7910-791F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7920-792F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7930-793F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7940-794F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7950-795F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7960-796F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7970-797F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7980-798F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7990-799F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 79A0-79AF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 79B0-79BF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 79C0-79CF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 79D0-79DF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 79E0-79EF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 79F0-79FF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7A00-7A0F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7A10-7A1F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7A20-7A2F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7A30-7A3F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7A40-7A4F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7A50-7A5F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7A60-7A6F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7A70-7A7F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7A80-7A8F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7A90-7A9F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7AA0-7AAF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7AB0-7ABF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7AC0-7ACF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7AD0-7ADF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7AE0-7AEF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 7AF0-7AFF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7B00-7B0F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7B10-7B1F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7B20-7B2F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7B30-7B3F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7B40-7B4F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7B50-7B5F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7B60-7B6F
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 7B70-7B7F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7B80-7B8F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7B90-7B9F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7BA0-7BAF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 7BB0-7BBF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7BC0-7BCF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 7BD0-7BDF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 7BE0-7BEF
	40,44,44,48,44,48,48,52,44,48,48,52,48,52,52,56, // 7BF0-7BFF
	20,24,24,28,24,28,28,32,24,28,28,32,28,32,32,36, // 7C00-7C0F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7C10-7C1F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7C20-7C2F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7C30-7C3F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7C40-7C4F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7C50-7C5F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7C60-7C6F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7C70-7C7F
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7C80-7C8F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7C90-7C9F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7CA0-7CAF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7CB0-7CBF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7CC0-7CCF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7CD0-7CDF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7CE0-7CEF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 7CF0-7CFF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7D00-7D0F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7D10-7D1F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7D20-7D2F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7D30-7D3F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7D40-7D4F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7D50-7D5F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7D60-7D6F
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 7D70-7D7F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7D80-7D8F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7D90-7D9F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7DA0-7DAF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 7DB0-7DBF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7DC0-7DCF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 7DD0-7DDF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 7DE0-7DEF
	40,44,44,48,44,48,48,52,44,48,48,52,48,52,52,56, // 7DF0-7DFF
	24,28,28,32,28,32,32,36,28,32,32,36,32,36,36,40, // 7E00-7E0F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7E10-7E1F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7E20-7E2F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7E30-7E3F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7E40-7E4F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7E50-7E5F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7E60-7E6F
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 7E70-7E7F
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7E80-7E8F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7E90-7E9F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7EA0-7EAF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 7EB0-7EBF
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7EC0-7ECF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 7ED0-7EDF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 7EE0-7EEF
	40,44,44,48,44,48,48,52,44,48,48,52,48,52,52,56, // 7EF0-7EFF
	28,32,32,36,32,36,36,40,32,36,36,40,36,40,40,44, // 7F00-7F0F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7F10-7F1F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7F20-7F2F
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 7F30-7F3F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7F40-7F4F
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 7F50-7F5F
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 7F60-7F6F
	40,44,44,48,44,48,48,52,44,48,48,52,48,52,52,56, // 7F70-7F7F
	32,36,36,40,36,40,40,44,36,40,40,44,40,44,44,48, // 7F80-7F8F
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 7F90-7F9F
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 7FA0-7FAF
	40,44,44,48,44,48,48,52,44,48,48,52,48,52,52,56, // 7FB0-7FBF
	36,40,40,44,40,44,44,48,40,44,44,48,44,48,48,52, // 7FC0-7FCF
	40,44,44,48,44,48,48,52,44,48,48,52,48,52,52,56, // 7FD0-7FDF
	40,44,44,48,44,48,48,52,44,48,48,52,48,52,52,56, // 7FE0-7FEF
	44,48,48,52,48,52,52,56,48,52,52,56,52,56,56,60, // 7FF0-7FFF
};
