// system.c - VAX System Configurations
//
// Written by
//  Timothy Stark <sword7@speakeasy.org>
//
// This file is part of the TS10 Emulator.
// See ReadMe for copyright notice.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// ACTION: Port that to C++ class statement

#include "emu/socket.h"

// Console TTY defintions (OPA0:)
#define CTY_PORT      5000 // Default CTY port
#define CTY_ESCAPE    0x1C // ASCII Control-Backslash
#define CTY_HALT      0x10 // ASCII Control-P
#define CTY_RDELAY    200  // Default countdown - Receive
#define CTY_TDELAY    200  // Default countdown - Transmit
#define CTY_QDELAY    50   // Default countdown - Queue
#define CTY_BUFFER    65536 // Stream buffer in bytes

// ********************************************************
// ********** IPR Registers for MicroVAX Series ***********
// ********************************************************

// RXCS - Console Receive Control and Status Register

#define RXCS_ACT   0x00000800 // (R)   Receive Active
#define RXCS_RDY   0x00000080 // (R)   Ready/Done
#define RXCS_IE    0x00000040 // (R/W) Interrupt Enable
#define RXCS_WMASK 0x00000040 // Write Mask

#define nRXCS_INT  22
#define RXCS_INT   (1u << nRXCS_INT)

// RXDB - Console Receive Data Buffer Register

#define RXDB_ERR   0x00008000 // (R)   Error
#define RXDB_OVR   0x00004000 // (R)   Overrun Error
#define RXDB_FRM   0x00002000 // (R)   Framing Error
#define RXDB_BRK   0x00000800 // (R)   Receive Break
#define RXDB_CHAR  0x000000FF // (R)   Data 

// TXCS - Console Transmit Control and Status Register

#define TXCS_RDY   0x00000080 // (R)   Ready/Done
#define TXCS_IE    0x00000040 // (R/W) Interrupt Enable
#define TXCS_MAINT 0x00000004 // (R/W) Maintenance
#define TXCS_BRK   0x00000001 // (R/W) Transmit Break

#define TXCS_WMASK 0x00000045 // Write Mask

#define nTXCS_INT  23
#define TXCS_INT   (1u << nTXCS_INT)

// TXDB - Console Transmit Data Buffer Register

#define TXDB_CHAR  0x000000FF // (W)   Data 

// ***************************************************

//typedef struct Console VAX_CONSOLE;

struct vax_Console {
	// Belong to its processor.
	VAX_CPU *Processor;

	// Delayed I/O per a few instructions (50 to 100)
	// KA630 VMB rom complaint about instanteous I/O
	// access during test #3.
	CLK_QUEUE *rxTimer; // Receive Timer
	CLK_QUEUE *txTimer; // Transmit Timer
	CLK_QUEUE *qTimer;  // Queue Timer

	// Socket slot
	SOCKET  *Server; // CTY Listening Socket
	SOCKET  *Socket; // CTY Client Socket

	// Console TTY Buffer
	int     mCount; // Maintenance Test
	uchar   inBuffer[CTY_BUFFER];
	char    outBuffer[CTY_BUFFER];
	int     idxInQueue, idxOutQueue;
	int     idxOutBuffer;
	char    lastSeen;
};
