// proto.h - Prototypes for all .c files.
//
// Written by
//  Timothy Stark <sword7@speakeasy.org>
//
// This file is part of the TS-10 Emulator.
// See README for copyright notice.
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

// cpu_intexc.c
int32 vax_EvaluateIRQ(void);
int32 vax_GetVector(void);
void  vax_DoIntexc(int32, int32, int32, ...);
void  vax_Emulate(int32);

// cpu_main.c
char *vax_DisplayCondition(void);
//void vax_DecodeOperand(INSTRUCTION *, int32 *);
void vax_DecodeOperand(uint32 *, int32 *);
int  vax_Execute(MAP_DEVICE *);

// cpu_mm.c
TLBENT  vax_Fill(uint32, int32, int32, int32 *);
void    vax_ClearTBTable(boolean);
void    vax_ClearTBEntry(uint32);
boolean vax_CheckTBEntry(uint32);
int     vax_ShowTLB(void *, int, char **);

// dev_cty.c
VAX_CONSOLE *vax_ConsoleInit(VAX_CPU *);
void vax_ConsoleCleanup(VAX_CONSOLE *);
uint32 vax_ReadRXCS(VAX_CONSOLE *);
uint32 vax_ReadRXDB(VAX_CONSOLE *);
uint32 vax_ReadTXCS(VAX_CONSOLE *);
uint32 vax_ReadTXDB(VAX_CONSOLE *);
void   vax_WriteRXCS(VAX_CONSOLE *, uint32);
void   vax_WriteRXDB(VAX_CONSOLE *, uint32);
void   vax_WriteTXCS(VAX_CONSOLE *, uint32);
void   vax_WriteTXDB(VAX_CONSOLE *, uint32);

// memory.c
int    vax_InitMemory(VAX_CPU *, int);
int    vax_FreeMemory(VAX_CPU *);
int32  vax_ReadInst(int32);
uint32 vax_ReadAligned(uint32, int32);
uint32 vax_Read(uint32, int32, int32);
void   vax_WriteAligned(uint32, uint32, int32);
void   vax_Write(uint32, uint32, int32, int32);
int32  vax_Test(uint32, int32, int32 *);

// system.c
int  vax_LoadFile(VAX_CPU *, char *, uint32, uint32 *);
int  vax_LoadROM(VAX_CPU *, char *, uint32);
void vax_CheckInstructions(void);

// ka780.c (KA780 System Configurations)
int32 ka780_prRead(int32);
void  ka780_prWrite(int32, int32);
void  ka780_Initialize(VAX_CPU *);

// Instruction Function Calls
INSDEF(vax, ACBB);
INSDEF(vax, ACBD);
INSDEF(vax, ACBF);
INSDEF(vax, ACBG);
INSDEF(vax, ACBL);
INSDEF(vax, ACBW);
INSDEF(vax, ADAWI);
INSDEF(vax, ADDB);
INSDEF(vax, ADDD);
INSDEF(vax, ADDF);
INSDEF(vax, ADDG);
INSDEF(vax, ADDL);
INSDEF(vax, ADDW);
INSDEF(vax, ADWC);
INSDEF(vax, AOBLEQ);
INSDEF(vax, AOBLSS);
INSDEF(vax, ASHL);
INSDEF(vax, ASHQ);
INSDEF(vax, BBC);
INSDEF(vax, BBCC);
INSDEF(vax, BBCS);
INSDEF(vax, BBS);
INSDEF(vax, BBSC);
INSDEF(vax, BBSS);
INSDEF(vax, BCC);
INSDEF(vax, BCS);
INSDEF(vax, BEQL);
INSDEF(vax, BGEQ);
INSDEF(vax, BGTR);
INSDEF(vax, BGTRU);
INSDEF(vax, BICB);
INSDEF(vax, BICL);
INSDEF(vax, BICPSW);
INSDEF(vax, BICW);
INSDEF(vax, BISB);
INSDEF(vax, BISL);
INSDEF(vax, BISPSW);
INSDEF(vax, BISW);
INSDEF(vax, BITB);
INSDEF(vax, BITL);
INSDEF(vax, BITW);
INSDEF(vax, BLBC);
INSDEF(vax, BLBS);
INSDEF(vax, BLEQ);
INSDEF(vax, BLEQU);
INSDEF(vax, BLSS);
INSDEF(vax, BNEQ);
INSDEF(vax, BPT);
INSDEF(vax, BRB);
INSDEF(vax, BRW);
INSDEF(vax, BSBB);
INSDEF(vax, BSBW);
INSDEF(vax, BUGL);
INSDEF(vax, BUGW);
INSDEF(vax, BVC);
INSDEF(vax, BVS);
INSDEF(vax, CALLG);
INSDEF(vax, CALLS);
INSDEF(vax, CASEB);
INSDEF(vax, CASEL);
INSDEF(vax, CASEW);
INSDEF(vax, CHME);
INSDEF(vax, CHMK);
INSDEF(vax, CHMS);
INSDEF(vax, CHMU);
INSDEF(vax, CLRB);
INSDEF(vax, CLRL);
INSDEF(vax, CLRQ);
INSDEF(vax, CLRW);
INSDEF(vax, CMPB);
INSDEF(vax, CMPC3);
INSDEF(vax, CMPC5);
INSDEF(vax, CMPD);
INSDEF(vax, CMPF);
INSDEF(vax, CMPG);
INSDEF(vax, CMPL);
INSDEF(vax, CMPV);
INSDEF(vax, CMPW);
INSDEF(vax, CMPZV);
INSDEF(vax, CVTBD);
INSDEF(vax, CVTBF);
INSDEF(vax, CVTBG);
INSDEF(vax, CVTBL);
INSDEF(vax, CVTBW);
INSDEF(vax, CVTDB);
INSDEF(vax, CVTDF);
INSDEF(vax, CVTDL);
INSDEF(vax, CVTDW);
INSDEF(vax, CVTFB);
INSDEF(vax, CVTFD);
INSDEF(vax, CVTFG);
INSDEF(vax, CVTFL);
INSDEF(vax, CVTFW);
INSDEF(vax, CVTGB);
INSDEF(vax, CVTGF);
INSDEF(vax, CVTGL);
INSDEF(vax, CVTGW);
INSDEF(vax, CVTLB);
INSDEF(vax, CVTLD);
INSDEF(vax, CVTLF);
INSDEF(vax, CVTLG);
INSDEF(vax, CVTLW);
INSDEF(vax, CVTRDL);
INSDEF(vax, CVTRFL);
INSDEF(vax, CVTRGL);
INSDEF(vax, CVTWB);
INSDEF(vax, CVTWD);
INSDEF(vax, CVTWF);
INSDEF(vax, CVTWG);
INSDEF(vax, CVTWL);
INSDEF(vax, DECB);
INSDEF(vax, DECL);
INSDEF(vax, DECW);
INSDEF(vax, DIVB);
INSDEF(vax, DIVD);
INSDEF(vax, DIVF);
INSDEF(vax, DIVG);
INSDEF(vax, DIVL);
INSDEF(vax, DIVW);
INSDEF(vax, EDIV);
INSDEF(vax, EMODD);
INSDEF(vax, EMODF);
INSDEF(vax, EMODG);
INSDEF(vax, EMUL);
INSDEF(vax, EXTV);
INSDEF(vax, EXTZV);
INSDEF(vax, FFC);
INSDEF(vax, FFS);
INSDEF(vax, HALT);
INSDEF(vax, INCB);
INSDEF(vax, INCL);
INSDEF(vax, INCW);
INSDEF(vax, INDEX);
INSDEF(vax, INSQHI);
INSDEF(vax, INSQTI);
INSDEF(vax, INSQUE);
INSDEF(vax, INSV);
INSDEF(vax, JMP);
INSDEF(vax, JSB);
INSDEF(vax, LDPCTX);
INSDEF(vax, LOCC);
INSDEF(vax, MCOMB);
INSDEF(vax, MCOML);
INSDEF(vax, MCOMW);
INSDEF(vax, MFPR);
INSDEF(vax, MNEGB);
INSDEF(vax, MNEGD);
INSDEF(vax, MNEGF);
INSDEF(vax, MNEGG);
INSDEF(vax, MNEGL);
INSDEF(vax, MNEGW);
INSDEF(vax, MOVB);
INSDEF(vax, MOVC3);
INSDEF(vax, MOVC5);
INSDEF(vax, MOVD);
INSDEF(vax, MOVF);
INSDEF(vax, MOVG);
INSDEF(vax, MOVL);
INSDEF(vax, MOVPSL);
INSDEF(vax, MOVQ);
INSDEF(vax, MOVW);
INSDEF(vax, MOVZBL);
INSDEF(vax, MOVZBW);
INSDEF(vax, MOVZWL);
INSDEF(vax, MTPR);
INSDEF(vax, MULB);
INSDEF(vax, MULD);
INSDEF(vax, MULF);
INSDEF(vax, MULG);
INSDEF(vax, MULL);
INSDEF(vax, MULW);
INSDEF(vax, NOP);
INSDEF(vax, POLYD);
INSDEF(vax, POLYF);
INSDEF(vax, POLYG);
INSDEF(vax, POPR);
INSDEF(vax, PROBER);
INSDEF(vax, PROBEW);
INSDEF(vax, PUSHL);
INSDEF(vax, PUSHR);
INSDEF(vax, REI);
INSDEF(vax, REMQHI);
INSDEF(vax, REMQTI);
INSDEF(vax, REMQUE);
INSDEF(vax, RET);
INSDEF(vax, ROTL);
INSDEF(vax, RSB);
INSDEF(vax, SBWC);
INSDEF(vax, SCANC);
INSDEF(vax, SKPC);
INSDEF(vax, SOBGEQ);
INSDEF(vax, SOBGTR);
INSDEF(vax, SPANC);
INSDEF(vax, SUBB);
INSDEF(vax, SUBD);
INSDEF(vax, SUBF);
INSDEF(vax, SUBG);
INSDEF(vax, SUBL);
INSDEF(vax, SUBW);
INSDEF(vax, SVPCTX);
INSDEF(vax, TSTB);
INSDEF(vax, TSTD);
INSDEF(vax, TSTF);
INSDEF(vax, TSTG);
INSDEF(vax, TSTL);
INSDEF(vax, TSTW);
INSDEF(vax, XFC);
INSDEF(vax, XORB);
INSDEF(vax, XORL);
INSDEF(vax, XORW);
INSDEF(vax, Emulate);
INSDEF(vax, Illegal);
INSDEF(vax, Unimplemented);
