/*
 * Decompiled with CFR 0.152.
 */
package com.trilead.ssh2.util;

import com.trilead.ssh2.log.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.LinkedList;

public class TimeoutService {
    private static final Logger log;
    private static final LinkedList todolist;
    private static Thread timeoutThread;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trilead.ssh2.util.TimeoutService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger(clazz);
        todolist = new LinkedList();
        timeoutThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final TimeoutToken addTimeoutHandler(long runTime, Runnable handler) {
        TimeoutToken token = new TimeoutToken(runTime, handler);
        LinkedList linkedList = todolist;
        synchronized (linkedList) {
            todolist.add(token);
            Collections.sort(todolist);
            if (timeoutThread != null) {
                timeoutThread.interrupt();
            } else {
                timeoutThread = new TimeoutThread();
                timeoutThread.setDaemon(true);
                timeoutThread.start();
            }
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void cancelTimeoutHandler(TimeoutToken token) {
        LinkedList linkedList = todolist;
        synchronized (linkedList) {
            todolist.remove(token);
            if (timeoutThread != null) {
                timeoutThread.interrupt();
            }
        }
    }

    public static class TimeoutToken
    implements Comparable {
        private long runTime;
        private Runnable handler;

        private TimeoutToken(long runTime, Runnable handler) {
            this.runTime = runTime;
            this.handler = handler;
        }

        public int compareTo(Object o) {
            TimeoutToken t = (TimeoutToken)o;
            if (this.runTime > t.runTime) {
                return 1;
            }
            if (this.runTime == t.runTime) {
                return 0;
            }
            return -1;
        }
    }

    private static class TimeoutThread
    extends Thread {
        private TimeoutThread() {
        }

        public void run() {
            LinkedList linkedList = todolist;
            synchronized (linkedList) {
                while (true) {
                    if (todolist.size() == 0) {
                        timeoutThread = null;
                        return;
                    }
                    long now = System.currentTimeMillis();
                    TimeoutToken tt = (TimeoutToken)todolist.getFirst();
                    if (tt.runTime > now) {
                        try {
                            todolist.wait(tt.runTime - now);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    todolist.removeFirst();
                    try {
                        tt.handler.run();
                    }
                    catch (Exception e) {
                        StringWriter sw = new StringWriter();
                        e.printStackTrace(new PrintWriter(sw));
                        log.log(20, "Exeception in Timeout handler:" + e.getMessage() + "(" + sw.toString() + ")");
                    }
                }
            }
        }
    }
}

