#include "tra.h"

/*
  setlabel and gotolabel don't save and restore the argument
  registers, so we pass fn and arg on the stack as the seventh and
  eigth arguments to a trampoline.  We could also use the assembler.
*/

static void
tramp(int a0, int a1, int a2, int a3, int a4, int a5,
      void (*fn)(void*), void *arg)
{
	USED(a0); USED(a1); USED(a2);
	USED(a3); USED(a4); USED(a5);
	fn(arg);
	abort();
}

void
initctxt(Ctxt *l, void (*fn)(void*), void *arg)
{
	ulong *stk;
	int n;

	n = 2*sizeof(ulong);
	l->stk = emalloc(n);
	stk = (ulong*)((uchar*)l->stk + n);

	*--stk = (ulong)arg;
	*--stk = (ulong)fn;

	l->label.pc = (ulong)tramp+LABELDPC;
	l->label.sp = mainlabel.sp-n;
	l->label.pv = l->label.pc;

	return;
}
