#include "os.h"

ulong
fastrand(void)
{
	int fd, seed;
	static int first = 1;
	static char state[256];

	if(first){
		if((fd = open("/dev/random", OREAD)) != 0 ||
		   read(fd, &seed, sizeof(seed)) != sizeof(seed))
			seed = getpid(); /* Man page says 1 is default */
		initstate(seed, state, sizeof(state));
		setstate(state);
		first = 0;
	}
	return random();
}

