[comment {-*- tcl -*- doctools manpage}]
[manpage_begin widget_dateentry n 0.96]
[moddesc   {Various megawidgets}]
[titledesc {Date Entry Megawidget}]
[category Widget]
[keywords megawidget snit widget dateentry date]
[require Tcl 8.4]
[require Tk 8.4]
[require widget [opt 3.0]]
[require widget::dateentry [opt 0.96]]
[description]

This package provides a dateentry megawidget (snidget).
It is based on an ttk::entry. All widget commands of the ttk::entry
are available for the dateentry.

[para]

[list_begin definitions]

[call [cmd widget::dateentry] [arg pathname] [opt options]]

[list_end]

[section "WIDGET OPTIONS"]

[para]
[list_begin options]

[opt_def -command]

A script to evaluate when a date was selected.

[opt_def -dateformat]

The format of the date that is returned. Default: %m/%d/%Y.

[opt_def -firstday]

See the calendar man page.

[opt_def -font]

Select the font used in the widget. It defaults to Helvetica 9.

[opt_def -highlightcolor]

See the calendar man page.

[opt_def -language]

See the calendar man page.

[opt_def -shadecolor]

See the calendar man page.

[opt_def -showpast]

See the calendar man page.

[opt_def -textvariable]

Specifies the name of a variable whose value is linked to the entry widget's contents.
Whenever the variable changes value, the widget's contents are updated, and
vice versa.


[list_end]

[section "WIDGET COMMAND"]

[arg pathname] [cmd get]

Returns the selected date.

[section "DEFAULT BINDINGS"]

On creation of the dateentry widget the following bindings are installed.
For navigation within the calendar, see its manpage.
[list_begin itemized]
[item]
Button-1 - Accept and select the date and close the calendar window.
[item]
Return, space - Accept the selected date and close the calendar window
[item]
Escape - Close calendar window
[item]
Control-space - Show calendar window
[list_end]

[section EXAMPLE]

[example {
    package require widget::dateentry; # or widget::all
    set t [widget::dateentry .de]
    pack $t -fill x -expand 1
}]

[manpage_end]
