/****************************************************************************
    Copyright (C) 1987-2001 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
****************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "gsim.h"

#define MUX_Z	0
#define MUX_S	1
#define MUX_I	2

#define MUX_DELAY_SZ	0
#define MUX_DELAY_IZ	1

static void Mux_processEvent(SGate*,EvQueue*,SEvent*);
static int Mux_checkGate(SGate*);

static SGateInfo mux_info = {
  0,
  "mux",0x0,
  3,{{"Z",GIO_OUT,0},
       {"S",GIO_IN,0},
       {"I",GIO_IN,PF_MULTI}},

  {{"S-Z",bit(1),0},
   {"I-Z",bit(2),0},
   0},

  Generic_copyGate,
  Mux_processEvent,
  Mux_checkGate,
  Nop_initGate,
  0,
  0,
  0,
  Generic_propFrwdDelay,
  Generic_propBackDelay,
  Generic_delay,
};

void init_mux()
{
  SGateInfo_register(&mux_info,0);
}

static int Mux_checkGate(SGate *g)
{
  SPort *Z = g->g_ports.port[MUX_Z];
  SPort *S = g->g_ports.port[MUX_S];
  int sn = S->p_net->n_nbits;
  int in = g->g_ports.num - MUX_I;
  int i;

  if ( (1<<sn) < in) {
    errorGate(g->g_name,"Too few bits on select line.");
    return -1;
  }
  if ( (1<<(sn-1)) >= in) {
    errorGate(g->g_name,"Too many bits on select line.");
    return -1;
  }

#if 0
  printf("echo mux %s: S=%s[%d:0] Z=%s[%d:0]",g->g_name
	 ,S->p_net->n_name,S->p_net->n_nbits
	 ,Z->p_net->n_name,Z->p_net->n_nbits);
#endif

  for (i = MUX_I;i < g->g_ports.num;i++) {
    SPort *I = g->g_ports.port[i];

#if 0
    printf(" I%d=%s[%d:0]",i-MUX_I
	   ,I->p_net->n_name,I->p_net->n_nbits);
#endif
    if (Z->p_net->n_nbits != I->p_net->n_nbits) {
      printf("\n");
      errorGate(g->g_name,"Inputs must be same bit width as output.");
      return -1;
    }
  }
#if 0
  printf("\n");
#endif
  return 0;
}

static void Mux_processEvent(SGate *g,EvQueue *Q,SEvent *E)
{
  SPort *Z = g->g_ports.port[MUX_Z];
  SPort *pS = g->g_ports.port[MUX_S];
  SState *S = SGate_allocPortState(g,MUX_S);
  unsigned smask = (1<<(pS->p_state.nbits & SSBITMASK))-1;
  unsigned sel = S->one[0]&smask;
  SState *out = alloc_SState();
  int delay;

  SState_reinit(out,Z->p_state.nbits);

  if ((S->flt[0]&smask))
    SState_unknown(out);
  else {
    if (sel+MUX_I < g->g_ports.num) {
      SState *I = SGate_allocPortState(g,sel+MUX_I);
      SState_buf(out,I);
      free_SState(I);
    } else
      SState_unknown(out);
  }

  if (IsChangeOn(E,g,MUX_S))
    delay = g->g_delayParms[MUX_DELAY_SZ];
  else
    delay = g->g_delayParms[MUX_DELAY_IZ];

  EvQueue_setPort(Q,Z,out,delay);
  free_SState(out);
  free_SState(S);
}
