# $Id: draw_timestamp.tcl,v 1.3 2003/11/08 20:10:31 aleksey Exp $

custom::defvar options(timestamp_format) {[%R]} \
    [::msgcat::mc "Format of timestamp in chat message.\
Refer to Tcl documentation of 'clock' command for description of format.

Examles:
  \[%R\] \u2013 \[20:37\]
  \[%T\] \u2013 \[20:37:12\]
  \[%a %b %d %H:%M:%S %Z %Y\] \u2013 \[Thu Jan 01 03:00:00 MSK 1970\]"] \
    -type string -group Chat
custom::defvar options(delayed_timestamp_format) {[%m/%d %R]} \
    [::msgcat::mc "Format of timestamp in delayed chat messages delayed\
for more than 24 hours."] \
    -type string -group Chat

proc draw_timestamp {chatid from type body x} {
    variable options

    set chatw [chat::chat_win $chatid]

    set seconds [clock seconds]
    set format $options(timestamp_format)

    set seconds1 [clock scan "-23 hours 59 minutes" -base $seconds]
    foreach xelem $x {
	jlib::wrapper:splitxml $xelem tag vars isempty chdata children
	
	if {[cequal [jlib::wrapper:getattr $vars xmlns] jabber:x:delay]} {
	    set seconds [clock scan [jlib::wrapper:getattr $vars stamp] -gmt 1]
	    if {$seconds <= $seconds1} {
		set format $options(delayed_timestamp_format)
	    }
	}
    }

    $chatw insert end [clock format $seconds -format $format]
}
hook::add draw_message_hook [namespace current]::draw_timestamp 15
