# $Id: draw_normal_message.tcl,v 1.11 2005/11/13 22:29:58 aleksey Exp $

proc draw_normal_message {chatid from type body x} {
    if {[chat::is_our_jid $chatid $from]} {
	set tag me
    } else {
	set tag they
    }

    set connid [chat::get_connid $chatid]
    set chatw [chat::chat_win $chatid]
    set nick [chat::get_nick $connid $from $type]
    set cw [chat::winid $chatid]

    $chatw insert end "<$nick>" [list $tag NICK-$nick] " "

    $chatw mark set MSGLEFT "end - 1 char"
    $chatw mark gravity MSGLEFT left

    if {[cequal $type groupchat]} {
	set myjid [chat::our_jid $chatid]
	set mynick [chat::get_nick $connid $myjid $type]

	lassign [check_message $mynick $body] mymessage mylist
	chat::add_emoteiconed_text $chatw $body "" $mylist
	if {$mymessage} {
	    tab_set_updated $cw 1 mesg_to_user
	} else {
	    tab_set_updated $cw 1 message
	}
    } else {
	chat::add_emoteiconed_text $chatw $body ""
	tab_set_updated $cw 1 mesg_to_user
    }

    $chatw tag add MSG-$nick MSGLEFT "end - 1 char"

    return stop
}
hook::add draw_message_hook [namespace current]::draw_normal_message 87
