# $Id: hooks.tcl,v 1.7 2004/09/17 20:30:19 aleksey Exp $

namespace eval hook {
}

proc hook::add {hook func {seq 50}} {
    variable $hook

    lappend $hook [list $func $seq]
    set $hook [lsort -integer -index 1 [lsort -unique [set $hook]]]
}

proc hook::set_flag {hook flag} {
    variable F
    set idx [lsearch -exact $F(flags,$hook) $flag]
    set F(flags,$hook) [lreplace $F(flags,$hook) $idx $idx]
}

proc hook::unset_flag {hook flag} {
    variable F
    if {![lcontain $F(flags,$hook) $flag]} {
	lappend F(flags,$hook) $flag
    }
}

proc hook::is_flag {hook flag} {
    variable F
    return [expr ![lcontain $F(flags,$hook) $flag]]
}

proc hook::run {hook args} {
    variable F
    variable $hook

    if {![info exists $hook]} {
	return
    }

    set F(flags,$hook) {}

    foreach func [set $hook] {
	set func [lindex $func 0]
	set code [catch { eval $func $args } state]
        debugmsg hook "$hook: [lindex $func 0] -> $state (code $code)"
	if {$code && ![winfo exists .hook_err]} {
	    MessageDlg .hook_err -aspect 50000 -icon error \
		-message "Hook $hook failed: $code\n$::errorInfo" \
		-type user -buttons ok -default 0 -cancel 0
	}
	if {(!$code) && ([cequal $state stop])} {
	    break
	}
    }
}

proc hook::foldl {hook acc0 args} {
    variable F
    variable $hook

    if {![info exists $hook]} {
	return $acc0
    }

    set F(flags,$hook) {}

    set acc $acc0
    foreach func [set $hook] {
	set func [lindex $func 0]
	set code [catch { eval $func [list $acc] $args } state]
        debugmsg hook "$hook: [lindex $func 0] -> $state (code $code)"
	if {$code} {
	    if {![winfo exists .hook_err]} {
		MessageDlg .hook_err -aspect 50000 -icon error \
		    -message "Hook $hook failed: $code\n$::errorInfo" \
		    -type user -buttons ok -default 0 -cancel 0
	    }
	} else {
	    set acc $state
	}
    }
    return $acc
}

