# $Id: sound.tcl,v 1.13 2003/11/04 20:59:01 aleksey Exp $

namespace eval sound {
    custom::defgroup Sound [::msgcat::mc "Sound options."] -group Tkabber

    variable options
    variable groupchat_may_notify
    # Sound is on by default
    set options(sound) 1
    custom::defvar options(mute) 0 \
	    [::msgcat::mc "Mute sound notification."] -group Sound -type boolean
    custom::defvar options(notify_online) 1 \
	    [::msgcat::mc "Use sound notification only when being available."] \
	    -group Sound -type boolean
    variable mute 0
    custom::defvar options(mute_groupchat_delayed) 1 \
	    [::msgcat::mc "Mute sound when displaying delayed groupchat messages."] -group Sound -type boolean
    custom::defvar options(mute_chat_delayed) 0 \
	    [::msgcat::mc "Mute sound when displaying delayed personal chat messages."] -group Sound -type boolean
    # One could use external play program instead of Snack (default for unix)
    custom::defvar options(external_play_program) \
	    [expr {($::tcl_platform(platform) == "unix") ? "esdplay" : ""}] \
	    [::msgcat::mc "External program, which is to be executed to play sound. If empty, Snack library is required to play sound."] \
	    -group Sound -type string
    # Params for external play program
    custom::defvar options(external_play_program_options) "" \
	[::msgcat::mc "Options for external play program"] \
	-group Sound -type string
    # Sound theme
    custom::defvar options(theme) "default" \
	    [::msgcat::mc "Sound theme. If it starts with \"/\" or \"~\" then it is considered as theme directory. Otherwise theme is loaded from \"sounds\" directory of Tkabber tree."] -group Sound -type string
    variable play_id ""
    variable play_priority 0
    # Do not allow play sound very often
    custom::defvar options(delay) 200 \
	    [::msgcat::mc "Time interval before playing next sound (in milliseconds)."] -group Sound \
	    -type integer
}

proc sound::sound_setup {} {
    variable options
    variable groupchat_may_notify
    variable sounds

    if {!$options(sound)} return

    set names [list groupchat_server_message groupchat_my_message \
		    groupchat_their_message chat_my_message \
		    chat_their_message connected \
		    presence_available presence_unavailable \
		    groupchat_their_message_to_me]

    foreach name $names {
	if {[regexp {^[/~]} $options(theme)]} {
	    set fname [file nativename [file join $options(theme) $name.wav]]
	} else {
	    set fname [fullpath sounds $options(theme) $name.wav]
	}
	if {[file exist $fname]} {
	    set sounds($name) $fname
	} else {
	    set sounds($name) ""
	}
    }

    if {$options(external_play_program) == ""} {
	if {[catch { package require snack 2.0 }]} {
	    debugmsg tkabber \
		"unable to load the Snack package, so no sound support!\n\nThe Snack package is available at http://www.speech.kth.se/snack/index.html"
	    set options(sound) 0
	    return
	}

	foreach name $names {
	    if {$sounds($name) != ""} {
		snack::sound $sounds($name) -file $sounds($name)
	    }
	}
    }
}

proc sound::play {name {priority 0}} {
    global userstatus
    variable options
    variable play_id
    variable play_priority

    if {$name == ""} return

    if {$play_id != ""} {
	if {$priority >= $play_priority} {
	    return
	} else {
	    after cancel $play_id
	}
    }
    if {$options(delay) > 0} {
	set play_id [after $options(delay) [list set [namespace current]::play_id {}]]
    }
    set play_priority $priority

    if {$options(external_play_program) == ""} {
	catch { $name play -block 0 }
    } else {
	catch { eval "exec $options(external_play_program) $options(external_play_program_options) [list $name] &" }
    }
}

proc sound::chat_message_notify {chatid from type body extras} {
    variable options
    variable sounds
    variable mute

    if {!$options(sound) || $options(mute) || $mute} return

    set delayed 0
    foreach xelem $extras {
	jlib::wrapper:splitxml $xelem tag vars isempty chdata children

	if {[cequal [jlib::wrapper:getattr $vars xmlns] jabber:x:delay]} {
	    set delayed 1
	}
    }

    switch -- $type {
	groupchat {
	    if {$delayed && $options(mute_groupchat_delayed)} {
		return
	    }
	    if {[cequal [chat::get_jid $chatid] $from]} {
		play $sounds(groupchat_server_message)
	    } elseif {[chat::is_our_jid $chatid $from]} {
		play $sounds(groupchat_my_message)
	    } else {
		set mynick [chat::get_nick [chat::our_jid $chatid] $type]
		if {[lindex [check_message $mynick $body] 0]} {
		    play $sounds(groupchat_their_message_to_me) -1
		} else {
		    play $sounds(groupchat_their_message)
		}
	    }
	}
	chat {
	    if {$delayed && $options(mute_chat_delayed)} {
		return
	    }
	    if {[chat::is_our_jid $chatid $from]} {
		play $sounds(chat_my_message)
	    } else {
		play $sounds(chat_their_message) -1
	    }
	}
    }
}

proc sound::presence_notify {name status} {
    variable options
    variable sounds
    variable mute

    if {!$options(sound) || $options(mute) || $mute} return

    if {$status == "unavailable"} {
	play $sounds(presence_unavailable)
    } else {
	play $sounds(presence_available)
    }
}

proc sound::mute_setup {status} {
    variable options
    variable mute

    if {$options(notify_online)} {
	switch -- $status {
	    available -
	    chat {
		set mute 0
	    }
	    default {
		set mute 1
	    }
	}
    } else {
	set mute 0
    }
}

proc sound::connected_notify {args} {
    variable options
    variable sounds
    variable mute

    if {!$options(sound) || $options(mute) || $mute} return

    play $sounds(connected) 1
}

hook::add on_change_user_presence_hook \
    [namespace current]::sound::presence_notify 100
hook::add change_our_presence_post_hook [namespace current]::sound::mute_setup 100
hook::add connected_hook [namespace current]::sound::connected_notify 100
hook::add postload_hook [namespace current]::sound::sound_setup 100
hook::add draw_message_hook [namespace current]::sound::chat_message_notify 19

