# $Id: si.tcl,v 1.3 2004/07/10 20:05:04 aleksey Exp $

namespace eval si {
    set transport(list) {}
}

set ::NS(si) http://jabber.org/protocol/si

proc si::connect {connid jid id mimetype profile profile_el} {
    variable connection
    variable transport

    set connection(connid,$id) $connid
    set connection(jid,$id) $jid

    set trans [lsort -unique -index 1 $transport(list)]
    set options {}
    foreach t $trans {
	set name [lindex $t 0]
	if {![info exists transport(allowed,$name)] || \
		$transport(allowed,$name)} {
	    lappend options $transport(oppos,$name)
	}
    }

    set opttags {}
    foreach opt $options {
	lappend opttags [jlib::wrapper:createtag option \
			     -subtags [list [jlib::wrapper:createtag value \
						 -chdata $opt]]]
    }

    set feature \
	[jlib::wrapper:createtag feature \
	     -vars [list xmlns http://jabber.org/protocol/feature-neg] \
	     -subtags \
	     [list [jlib::wrapper:createtag x \
			-vars [list xmlns jabber:x:data type form] \
			-subtags \
			[list [jlib::wrapper:createtag \
				   field \
				   -vars [list var stream-method \
					      type list-single] \
				   -subtags $opttags]]]]]


    set_status [::msgcat::mc "Opening SI connection"]

    jlib::send_iq set \
	[jlib::wrapper:createtag si \
	     -vars [list xmlns $::NS(si) \
			id $id \
			mime-type $mimetype \
			profile $profile] \
	     -subtags [list $profile_el $feature]] \
	-to $jid \
	-command [list si::connect_response $connid $jid $id $profile] \
	-connection $connid

    vwait [namespace current]::connection(status,$id)
    return $connection(status,$id)
}

proc si::connect_response {connid jid id profile res child} {
    variable connection
    variable transport

    if {$res != "OK"} {
	set connection(status,$id) [list 0 [error_to_string $child]]
	return
    }

    jlib::wrapper:splitxml $child tag vars isempty chdata children

    set trans [lsort -unique -index 1 $transport(list)]
    set options {}
    foreach t $trans {
	set name [lindex $t 0]
	if {![info exists transport(allowed,$name)] || \
		$transport(allowed,$name)} {
	    lappend options $transport(oppos,$name)
	}
    }


    set opts {}

    foreach item $children {
	jlib::wrapper:splitxml $item tag1 vars1 isempty1 chdata1 children1
	set xmlns [jlib::wrapper:getattr $vars1 xmlns]
	    if {[string equal $xmlns $profile]} {
		# TODO
	    } elseif {[string equal $xmlns \
			   http://jabber.org/protocol/feature-neg]} {
		set opts [parse_negotiation_res $item]
	    }
    }

    if {[llength $opts] == 1 && [lcontain $options [lindex $opts 0]]} {
	set name [lindex $opts 0]
	set connection(transport,$id) $name
	set connection(status,$id) \
	    [eval $transport(connect,$name) [list $connid $jid $id]]
	return
    }
    set connection(status,$id) \
	[list 0 [::msgcat::mc "Stream method negotiation failed"]]
}


proc si::set_readable_handler {id handler} {
    variable connection
    set connection(readable_handler,$id) $handler
}

proc si::set_closed_handler {id handler} {
    variable connection
    set connection(closed_handler,$id) $handler
}

proc si::send_data {id data} {
    variable connection
    variable transport
    eval $transport(send,$connection(transport,$id)) [list $id $data]
}

proc si::recv_data {id data} {
    variable connection
    debugmsg si "RECV_DATA [list $id $data]"

    append connection(data,$id) $data
    if {[info exists connection(readable_handler,$id)]} {
	eval $connection(readable_handler,$id) [list $id]
    }
}

proc si::read_data {id} {
    variable connection

    set data $connection(data,$id)
    set connection(data,$id) {}
    return $data
}

proc si::close {id} {
    variable connection
    variable transport
    eval $transport(close,$connection(transport,$id)) [list $id]
    set_status [::msgcat::mc "SI connection closed"]
}

proc si::closed {id} {
    variable connection
    if {[info exists connection(closed_handler,$id)]} {
	eval $connection(closed_handler,$id) [list $id]
    }
}


proc si::parse_negotiation {child} {
    jlib::wrapper:splitxml $child tag vars isempty chdata children

    set options {}
    foreach item $children {
	jlib::wrapper:splitxml $item tag1 vars1 isempty1 chdata1 children1
	set xmlns [jlib::wrapper:getattr $vars1 xmlns]
	if {[string equal $xmlns jabber:x:data]} {
	    foreach item $children1 {
		jlib::wrapper:splitxml $item \
		    tag2 vars2 isempty2 chdata2 children2
		set var [jlib::wrapper:getattr $vars2 var]
		if {[string equal $var stream-method]} {
		    foreach item $children2 {
			jlib::wrapper:splitxml $item \
			    tag3 vars3 isempty3 chdata3 children3
			foreach item $children3 {
			    jlib::wrapper:splitxml $item \
				tag4 vars4 isempty4 chdata4 children4
			    lappend options $chdata4
			}
		    }
		}
	    }
	}
    }
    return $options
}

proc si::parse_negotiation_res {child} {
    jlib::wrapper:splitxml $child tag vars isempty chdata children

    set options {}
    foreach item $children {
	jlib::wrapper:splitxml $item tag1 vars1 isempty1 chdata1 children1
	set xmlns [jlib::wrapper:getattr $vars1 xmlns]
	if {[string equal $xmlns jabber:x:data]} {
	    foreach item $children1 {
		jlib::wrapper:splitxml $item \
		    tag2 vars2 isempty2 chdata2 children2
		set var [jlib::wrapper:getattr $vars2 var]
		if {[string equal $var stream-method]} {
		    foreach item $children2 {
			jlib::wrapper:splitxml $item \
			    tag3 vars3 isempty3 chdata3 children3
			lappend options $chdata3
		    }
		}
	    }
	}
    }
    return $options
}

proc si::negotiate_handler {from type options} {
    variable transport

    set trans [lsort -unique -index 1 $transport(list)]
    set myoptions {}
    foreach t $trans {
	set name [lindex $t 0]
	if {![info exists transport(allowed,$name)] || \
		$transport(allowed,$name)} {
	    lappend myoptions $transport(oppos,$name)
	}
    }

    if {$options == {}} {
	return $myoptions
    }

    foreach opt $options {
	if {[lcontain $myoptions $opt]} {
	    return [list $opt]
	}
    }
    return {}
}

negotiate::register_handler jabber:iq:si si::negotiate_handler


proc si::set_handler {connid from child} {
    variable profiledata
    variable transport

    jlib::wrapper:splitxml $child tag vars isempty chdata children

    set id [jlib::wrapper:getattr $vars id]
    set mimetype [jlib::wrapper:getattr $vars mime-type]
    set profile [jlib::wrapper:getattr $vars profile]
    set stream {}
    set profile_res {}

    if {[info exists profiledata($profile)]} {
	foreach item $children {
	    jlib::wrapper:splitxml $item tag1 vars1 isempty1 chdata1 children1
	    set xmlns [jlib::wrapper:getattr $vars1 xmlns]
	    if {[string equal $xmlns $profile]} {
		set profile_res [$profiledata($profile) \
				     $from $id $mimetype $item]
	    } elseif {[string equal $xmlns \
			   http://jabber.org/protocol/feature-neg]} {
		set options [parse_negotiation $item]

		set trans [lsort -unique -index 1 $transport(list)]
		set myoptions {}
		foreach t $trans {
		    set name [lindex $t 0]
		    if {![info exists transport(allowed,$name)] || \
			    $transport(allowed,$name)} {
			lappend myoptions $transport(oppos,$name)
		    }
		}

		foreach opt $options {
		    if {[lcontain $myoptions $opt]} {
			set stream $opt
			break
		    }
		}
	    }
	}
	
	if {[lindex $profile_res 0] == "error"} {
	    return $profile_res
	}
	if {$stream == {}} {
	    # no-valid-streams
	    return [list error modify bad-request]
	}
	set res_childs {}
	if {$profile_res != {}} {
	    lappend res_childs $profile_res
	}
	set opttags \
	    [list [jlib::wrapper:createtag value \
		       -chdata $opt]]
	lappend res_childs \
	    [jlib::wrapper:createtag feature \
		 -vars [list xmlns http://jabber.org/protocol/feature-neg] \
		 -subtags \
		 [list [jlib::wrapper:createtag x \
			    -vars [list xmlns jabber:x:data type submit] \
			    -subtags \
			    [list [jlib::wrapper:createtag \
				       field \
				       -vars [list var stream-method] \
				       -subtags $opttags]]]]]
	set res [jlib::wrapper:createtag si \
		     -vars [list xmlns $::NS(si)] \
		     -subtags $res_childs]
	return [list result $res]
    } else {
	# bad-profile
	return [list error modify bad-request]
    }
}

iq::register_handler set "" $::NS(si) si::set_handler


proc si::register_transport {name oppos prio connect send close} {
    variable transport

    lappend transport(list) [list $name $prio]
    set transport(oppos,$name) $oppos
    set transport(connect,$name) $connect
    set transport(send,$name) $send
    set transport(close,$name) $close
}

namespace eval si {
    plugins::load [file join plugins si] -uplevel 1
}

proc si::register_profile {profile handler} {
    variable profiledata
    set profiledata($profile) $handler
}


proc si::setup_customize {} {
    variable transport

    set trans [lsort -unique -index 1 $transport(list)]

    foreach t $trans {
	lassign $t name prio

	custom::defvar transport(allowed,$name) 1 \
	[format [::msgcat::mc "Enable SI transport %s."] $name] \
	-type boolean -group SI
    }
}

hook::add finload_hook si::setup_customize 40

