/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dirs.H"
#include <wx/wx.h>
#include <wx/txtstrm.h>

#ifndef COMMONELEMENTS_H
#define COMMONELEMENTS_H

enum {
  BTN_ADD = wxID_HIGHEST + 1000,
  BTN_DEL,
  BTN_EDIT
};

namespace common {
  /* Sizer with Add/Delete/Edit button (vertical)
   * Use the id labels above to refer to them.
   */
  wxSizer* listChangeButtons (wxWindow* parent);

  /* Work around a bug in wxURL file protocol
   * An alternative would be to fix the wx library.
   */
  wxInputStream* getInputStream (wxURL& url);

  /* Loads the logo bitmap from the elsewhere
   * specified source and makes a wxBitmap from it.
   * The * has to be deleted.
   * Returns 0 if the file cannot be loaded.
   */
  wxBitmap* getLogo ();
  wxBitmap* getBitmap (UrlFile& file);

  /* Use this function instead of
   *          wxBITMAP_TYPE_ANY
   * hints for the parameters:
   * mime: wxProtocol::GetContentType() after
   *       you requested the stream (see getLogo())
   * fileExt: UrlFile::getFileExt()
   */
  long getBitmapType (const wxString& mime,
		      const wxString& fileExt);

  /* Loads an index file
   */
  wxArrayString getIndexFile (wxInputStream& stream, wxMBConv& charset = wxConvUTF8);
  wxArrayString getIndexFile (wxInputStream& stream, const wxString& charset);

  /* Reads a single text line
   */
  wxString readTextLine (wxInputStream& stream, wxMBConv& charset = wxConvUTF8);
  wxString readTextLine (wxInputStream& stream, const wxString& charset);
  wxString readTextLine (wxTextInputStream& stream, wxMBConv& charset = wxConvUTF8);
  wxString readTextLine (wxTextInputStream& stream, const wxString& charset);

  /* Reads the complete stream into a string
   */
  wxString readTextAll (wxInputStream& stream, wxMBConv& charset = wxConvUTF8,
			const wxString& lineEnding = _T("\n"));
  wxString readTextAll (wxInputStream& stream, const wxString& charset,
			const wxString& lineEnding = _T("\n"));

  /* Links the wxArrayString to a wxString*[]
   * They are not copied, so the wxArrayString _must_ stay valid
   * Depends on how you use it, it may have to be deleted.
   * This is only needed because wx should allow wxArrayString everywhere
   * it allows wxString[] but it doesn't :-(
   */
  wxString* toStringPtr(wxArrayString& input);

  /* returns the special line end character (plicrow sign)
   * if supported by charset
   * else 0
   */
  wxUChar specialLineEnd (wxFontEncoding charset);

};

#endif
