/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONTESTRANKINGDLG_H
#define CONTESTRANKINGDLG_H

#include "LEntry.H"
#include <vector>
#include <wx/wx.h>
#include <wx/filename.h>
#include <wx/listctrl.h>
#include <wx/wfstream.h>

class ContestEntry {
public:
  ContestEntry (double weight) : weight(weight) {};
  wxString name;
  LEntry entry;

  //the maximum values of all contest entries
  static double promilleMax;
  static double apmMax;

  double getRankingPoints () const;

private:
  double weight;

};
bool operator< (const ContestEntry& a, const ContestEntry& b);

class ContestRankingDlg : public wxDialog {
public:
  ContestRankingDlg(wxWindow* parent, const wxString& title,
		    const wxFileName& dataFile, const double weight);

private:
  wxListCtrl* getListingControl (const wxFileName& dataFile, const double weight);
  std::vector<ContestEntry>* getEntries (wxFileInputStream& filestream,
					 const double weight);
  wxListCtrl* createListingControl (std::vector<ContestEntry>* listing);
};

#endif
