/***************************************************************************
                          outputcontrol.cpp  -  description                              
                             -------------------                                         
    begin                : Wed Dec 22 22:07:57 MET 1999 
                                           
    copyright            : (C) 1999 by Daniel Reith                         
    email                : DanR@gmx.de
	
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "outputcontrol.h"
#include <iostream>
#include <fstream>
#include <wx/config.h>

//**************************************************************************
//* Zuordnung der Events
//**************************************************************************

BEGIN_EVENT_TABLE(wxOutputControl, wxTextCtrl)
  EVT_SET_FOCUS(wxOutputControl::OnSetFocus)
  EVT_LEFT_DOWN(wxOutputControl::OnMouse)
  EVT_LEFT_DCLICK(wxOutputControl::OnMouse)
  EVT_RIGHT_DOWN(wxOutputControl::OnMouse)
  EVT_RIGHT_DCLICK(wxOutputControl::OnMouse)
  EVT_MIDDLE_DOWN(wxOutputControl::OnMouse)
  EVT_MIDDLE_DCLICK(wxOutputControl::OnMouse)
END_EVENT_TABLE()


//**************************************************************************
//* Konstruktor wxOutputControl::wxOutputControl(wxWindow *parent)
//**************************************************************************
wxOutputControl::wxOutputControl(wxWindow *parent) : wxTextCtrl(parent, 5, "", wxDefaultPosition, wxDefaultSize, wxNO_BORDER|wxTE_MULTILINE)
{

  // gtkctrl erzeugen
  gtkctrl =  GetConnectWidget();
  // neue Schrift laden
  //m_fontname = "-misc-fixed-medium-r-normal-*-*-200-*-*-c-*-iso8859-1";
  wxConfigBase *pConfig = wxConfigBase::Get();
  m_fontname = pConfig->Read("/Hauptfenster/Schrift","-misc-fixed-medium-r-normal-*-*-200-*-*-c-*-iso8859-1");
  m_font = gdk_font_load (m_fontname);
  // Schrift zuweisen
  gtk_text_insert (GTK_TEXT (gtkctrl), m_font , &gtkctrl->style->black, NULL,"h" , -1);
  gtk_text_backward_delete(GTK_TEXT(gtkctrl), 1);
}

//**************************************************************************
//* Destruktor wxOutputControl::~wxOutputControl()
//**************************************************************************
wxOutputControl::~wxOutputControl()
{

}

//**************************************************************************
//* Das Fenster darf keinen Focus erhalten!
//**************************************************************************

void wxOutputControl::OnSetFocus(wxFocusEvent *event)
{
  // kein Event-Skip, daher wird Ereignis verworfen
}

//***************************************************************************
//*
//***************************************************************************

void wxOutputControl::OnMouse(wxMouseEvent *event)
{
  // kein Event-Skip, daher wird Ereignis verworfen
}

//***************************************************************************
//*
//***************************************************************************

bool wxOutputControl::SetGTKFont(wxString fontname)
{
  m_font = gdk_font_load(fontname);
  m_fontname = fontname;
  std::cout << m_fontname << endl;
  gtkctrl =  GetConnectWidget();
  gtk_text_insert (GTK_TEXT (gtkctrl), m_font , &gtkctrl->style->black, NULL,"h" , -1);
  gtk_text_backward_delete(GTK_TEXT(gtkctrl), 1);
}

//**********************************************************
//*
//**********************************************************

void wxOutputControl::Clear()
{
  //gtkctrl =  GetConnectWidget();
  SetValue("");
  //gtk_text_insert (GTK_TEXT (gtkctrl), m_font , &gtkctrl->style->black, NULL,"keine Lektion geladen" , -1);
  //gtk_text_backward_delete(GTK_TEXT(gtkctrl), 1);
}

//***********************************************************
//*
//***********************************************************

bool wxOutputControl::LoadFile(const wxString& filename)
{
  SetValue("");
  ifstream is(filename.c_str());
  char zeile[256];
  if (is)
    {
      gtk_text_freeze(GTK_TEXT(gtkctrl));
      while (!is.eof())
	{
	  is.getline(zeile, 256, '\n');
	  wxString z;
	  z << zeile << char(182) << "\n";
	  gtk_text_insert (GTK_TEXT (gtkctrl), m_font , &gtkctrl->style->black, NULL,z , -1) ;
	}
      gtk_text_thaw (GTK_TEXT (gtkctrl));
      return true;
    }
  else
    return false;
}
