/***************************************************************************
                          lektion.h  -  description                              
                             -------------------                                         
    begin                : Mon Dec 27 15:01:16 MET 1999 
                                           
    copyright            : (C) 1999 by Daniel Reith                         
    email                : DanR@gmx.de
	
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef LEKTION_H
#define LEKTION_H

#include <wx/wx.h>
#include <wx/time.h>
#include <wx/textctrl.h>
#include <wx/timer.h>
#include <wx/config.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "stoppuhr.h"
#include "fehler.h"
#include "kurs.h"

class Kurs;

class Lektion : public wxTimer
{
 private:
  int m_lektion;
    int m_pos;
  int m_fehler;
  int m_richtig;
  int m_return;
  // m_falsch wird bentigt, um zu registieren, ob der aktuelle Buchstabe schonmal falsch eingeben wurde, um diesen dann rot darzustellen
  bool m_falsch;
  
  // m_eb wird bentigt um zu speichern ob die Lektion bis zum Ende abgearbeitet wurde, oder ob sie vorher abgebrochen wurde
  bool m_eb;

  // ist eine Lektion geladen?
  bool m_geladen;

  stoppuhr* m_stoppuhr;

  wxTextCtrl* m_input;
  wxTextCtrl* m_output;

  wxWindow* m_parent;
  Kurs* m_kurs;
  // Speichern des Ergebnisses
  bool ErgebnisSpeichern();
  // Anschlge pro Sekunde ermitteln
  int apm(int a, int s);
  // Lektionsanweisung anzeigen
  bool Lektionsanweisung(int l);
 public:
  // Konstruktor
  Lektion(wxWindow* parent, int Lektion=0, Kurs* kurs=0);
  // Destruktor
  ~Lektion();
  // Laden der Lektion
  bool SetLektion(int Lektion);
  // welche Lektion ist eigentlich geladen?
  inline int GetLektion() {return m_lektion;}; 
   // Ein neues Zeichen wurde eingegeben
  bool Eingabe(char c);
  // An welcher Postition befinden wir uns gerade
  inline int GetPos() {return m_pos;};
  // Wieviele Anschlaege
  inline int GetAnschlaege() {return (m_pos - m_return);};
  // Wieviele Fehler?
  inline int GetFehler() {return m_fehler;};
  // Fehler in Promille
  inline double GetFP() {if (m_fehler==0) return 0; else return ((double)(((double)m_fehler)/((double)GetAnschlaege())) * 1000);};
  inline wxString GetZeit() {return m_stoppuhr->GetZeit();};
  inline int GetUnixZeit() {return m_stoppuhr->GetSek();};
  // GetParent()
  inline wxWindow* GetParent() {return m_parent;};
  // Ist das aktuelle Zeichen schonmal falsch eingeben worden?
  inline bool GetFalsch() {return m_falsch;};
  // Timer Ereignis
  void Notify();
  // Pause
  bool Pause();
  // Benutzer ist am Ende der Lektion angelangt
  bool LektionEnde();
  // Lektion abbrechen
  bool LektionAbbrechen();
  // Wirkliches Ende der Lektion?
  inline bool SetEnde() {m_eb = true; return true;};
  // Lektion wird ausgewertet
  bool LektionAuswertung();
  // Lektion laden
  bool LektionLaden(int Lektion);
  // Ist eine Lektion geladen?
  inline bool GetGeladen() {return m_geladen;};
  // Der Buchstabe wurde das erste Mal richtig getippt ++m_richtig
  bool Richtig();
  // Wieviele Buchstaben wurden auf Anhieb richtig getippt?
  inline int GetRichtig() {return m_richtig;};
  inline double GetApM() {return apm(GetAnschlaege(), m_stoppuhr->GetSek());};
  
  

  

};
#endif // ifndef LEKTION_H
