/***************************************************************************
                          kurs.cpp  -  description                              
                             -------------------                                         
    begin                : Sat Apr 29 18:27:00 MEST 2000 
                                           
    copyright            : (C) 1999 by Daniel Reith                         
    email                : DanR@gmx.de
	
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <iostream>
#include <fstream>
#include <string>

#include <unistd.h>
#include <ctime>
#include <cstdlib>

#include <wx/wizard.h>
#include <wx/ffile.h>
#include <wx/notebook.h>

#include "kurs.h"
#include "main.h"

#include "kurslaus.h"
#include "kladen.h"
#include "klang.h"

#ifndef __MSW

#include "wizlogo2.xpm"
#define BMP_WIZARD_1 wxBitmap(wizlogo2_xpm);

#endif 
//******************************************************
//******************************************************
//* class LEntry
//* Diese Klasse reprsentiert die einzelnen Lektionen
//* innerhalb eines Kurses
//******************************************************
//******************************************************

//********************************************
//* LEntry::LEntry(int lnummer, wxString key)
//********************************************

LEntry::LEntry()
{
  
}

LEntry::LEntry(int anschlaege, int fehler, int promille, int richtig, int apm, int zeit)
{
  m_anschlaege = anschlaege;
  m_fehler = fehler;
  m_promille = promille;
  m_richtig = richtig;
  m_apm = apm;
  m_zeit = zeit;
}

LEntry::~LEntry()
{
  
}

bool LEntry::SetAnschlaege(int anschlaege)
{
  m_anschlaege =anschlaege;
  return true;
}

bool LEntry::SetFehler(int fehler)
{
  m_fehler = fehler;
  return true;
}

bool LEntry::SetPromille(int promille)
{
  m_promille = promille;
  return true;
}

bool LEntry::SetRichtig(int richtig)
{
  m_richtig = richtig;
  return true;
}

bool LEntry::SetApM(int apm)
{
  m_apm = apm;
  return true;
}

bool LEntry::SetZeit(int zeit)
{
  m_zeit = zeit;
  return true;
}


//******************************************************
//* Die Klasse LKrit enthlt die Kriterien fr die einzelnen
//* Lektionen
//******************************************************

LKrit::LKrit(int nummer, int zeit, int promille)
{
  m_nummer = nummer;
  m_zeit = zeit;
  m_promille = promille;
}

bool LKrit::SetNummer(int nummer)
{
  m_nummer = nummer;
  return true;
}

bool LKrit::SetZeit(int zeit)
{
  m_zeit = zeit;
  return true;
}

bool LKrit::SetPromille(int promille)
{
  m_promille = promille;
  return true;
}

wxString LKrit::GetZeit()
{
  char c[10];
  struct tm *m_tm;
   m_tm = localtime(&m_zeit);
   m_tm->tm_hour = m_tm->tm_hour - 1;
   wxString s;
   strftime(c, 10, "%X", m_tm);
   s  << c;
   return s;
}

//******************************************************
//******************************************************
//* Hier folgen nun die einzelnen Wizard Pages als Klassen
//*
//******************************************************
//******************************************************

class KursWaehlenSeite : public wxWizardPageSimple
{
private:
  wxPanel *m_panel;
  wxStaticText *m_text;
  wxListBox *m_box;
  int m_value;
public:
  KursWaehlenSeite(wxWizard *parent) : wxWizardPageSimple(parent)
    {
      m_panel = new wxPanel(this, -1, wxPoint(5, 5), wxSize(300, 200));
      m_text = new wxStaticText(m_panel, -1,  _("Bitte einen Kurs auswhlen:"), wxDefaultPosition, wxSize(300, 20));
      m_box = new wxListBox(m_panel, -1, wxPoint(0, 20), wxSize(300, 180));
      // Kursinformationen auslesen
      wxConfigBase *pConfig = wxConfigBase::Get();
      wxString tlayout = pConfig->Read("/Tastatur/Layout", "german");
      wxString f;
      f <<  L_DIR << "/" << tlayout << "/kurs.index";
      ifstream is(f.c_str());
      char zeile[256];
      if (is)
	{
	  while (!is.eof())
	    {
	      is.getline(zeile, 256, '\n');
	      if (!is.eof())
		m_box->Append(zeile);
	    }
	}
      else
	{
	  //wxString msg;
	  //msg << _("Die Datei kurs.index wurde nicht im Verzeichnis ") << L_DIR
	  //	      << _(" \ngefunden oder konnte nicht geffnet werden!");
	  //wxMessageBox(msg, _("Datei nicht gefunden"), wxICON_EXCLAMATION, this);
	      wxLogError(_("Die Datei %s kann nicht geladen werden"), f.c_str());
	}      
    }

  virtual bool TransferDataFromWindow()
    {
      if (m_box->GetSelection()==-1)
	{
	  wxMessageBox(_("Es mu ein Kurs ausgewhlt werden!"), _("Achtung"), wxICON_WARNING | wxOK, this);
	  return FALSE;
	}
      m_value = m_box->GetSelection();
      return TRUE;
    }

  inline int GetSelection() {return m_value;}
};

class NameEingebenSeite : public wxWizardPageSimple
{
private:
  wxString m_name;
  wxStaticText *m_text;
  wxTextCtrl *m_tctrl;
public:
  NameEingebenSeite(wxWizard *parent) : wxWizardPageSimple(parent)
    {
      m_text = new wxStaticText(this, -1, _("Bitte geben Sie ihren Namen ein:"), wxPoint(5, 50), wxSize(300, 20));
      m_tctrl = new wxTextCtrl(this, -1, "Nobody", wxPoint(5, 75), wxSize(300, 30));
    }
  
  virtual bool TransferDataFromWindow()
    {
      if (m_tctrl->GetValue()=="")
	{
	  wxMessageBox(_("Es mu ein Name eingegeben werden!"), _("Achtung"), wxICON_WARNING | wxOK, this);
	  return FALSE;
	}
      m_name = m_tctrl->GetValue();
      return TRUE;
    }
  inline wxString GetName() {return m_name;}
};

//******************************************************
//******************************************************
//* class Kurs
//* Diese Klasse reprsentiert einen Maschinenschreibkurs
//******************************************************
//******************************************************


//********************************************
//*Kurs::Kurs(wxWindow* parent)
//********************************************

Kurs::Kurs(wxWindow* parent, bool neu=true)
{
  m_parent = parent;
  if (neu)
    {
      if (KursBeginnen()==false)
      {
	throw Abbruch();
      }
    }
  else
    {
      if (KursLaden()==false)
	{
	  throw Abbruch();
	}
    }
}

//********************************************
//*Kurs::~Kurs()
//********************************************

Kurs::~Kurs()
{
  if (m_lektion !=0)
    {
      m_lektion->LektionAbbrechen();
      delete m_lektion;
      m_lektion = 0;
      //((Hauptfenster*)m_parent)->SetLektion(0);
    }
  ((Hauptfenster*)m_parent)->SetLektion(0);
   wxConfigBase *pConfig = wxConfigBase::Get();
  wxString key;
  key << "/Kurs/" << m_name << "_" << m_key << "/created";
  pConfig->Write(key, (long) 1);
  key = "";
  key << "/Kurs/" << m_name << "_" << m_key << "/kursnummer";
  pConfig->Write(key, (long) m_kn);
  //KursSpeichern();
}

//********************************************
//*Kurs::KursBeginnen()
//********************************************

bool Kurs::KursBeginnen()
{
  wxWizard* wizard = new wxWizard(m_parent, -1, _("Neuen Kurs beginnen"), wizlogo2_xpm, wxDefaultPosition);
  // Seite 1 des Wizards erzeugen und mit Items fllen
  KursWaehlenSeite* p1 = new KursWaehlenSeite(wizard);
  // Seite 2 des Wizards erzeugen
 NameEingebenSeite* p2 = new NameEingebenSeite(wizard);
  // Reihenfolge der Seiten festlegen
  wxWizardPageSimple::Chain(p1, p2);
  // Seite 3 erzeugen
  wxWizardPageSimple* p3 = new wxWizardPageSimple(wizard);
  wxStaticText* text3 = new wxStaticText(p3, -1, _("Alle bentigten Angaben sind nun vorhanden. \nWenn Sie nun auf \"Fertig\" klicken, wird \nder Kurs mit der ersten Lektion begonnen"), wxPoint(5, 5), wxSize(300, 200));
  // Reihenfolge der Seiten festlegen
  wxWizardPageSimple::Chain(p2, p3);
  // Wizard ausfhren
  if (!wizard->RunWizard(p1))
    {
      wizard->Destroy();
      return false;
    }
  m_kn = (p1->GetSelection()+1);
  m_name = p2->GetName();
  srand(time(0) + getpid());
  m_key = "";
  m_key << rand();
  wxString f;
  f << m_name << "_" << m_key;
  //wxMessageBox(f, "test", wxOK, m_parent);
  // Kursdatei auslesen:
  wxConfigBase *pConfig = wxConfigBase::Get();
   wxString tlayout = pConfig->Read("/Tastatur/Layout", "german");
   wxString g;
   f = "";
   f <<  L_DIR << "/" << tlayout << "/kurs." << m_kn;
   ifstream is(f.c_str());
   char zeile[256];
   if (is)
     {
       while (!is.eof())
	 {
	   is.getline(zeile, 256, '\n');
	   if (!is.eof())
	     {
	       string s, t, u, v;
	       int i;
	       s = zeile;
	       i = s.find(":");
	       t = s.substr(0, i);
	       s = s.substr((i+1), s.size());
	       i = s.find(":");
	       u = s.substr(0,i);
	       v = s.substr((i+1), s.size());
	       /*std::cout << "Ausgangsstring: " << zeile << endl;
		 std::cout << "1. Teil (Nummer): " << t << endl;
		 std::cout << "2. Teil (Zeit): " << u << endl;
		 std::cout << "3. Teil (Promille): " << v << endl;*/
	       m_kriterien.push_back(LKrit(atoi(t.c_str()), atoi(u.c_str()), atoi(v.c_str())));
	     }  
	 }
     }
   else
     {
       wxString msg;
       //       msg << _("Die Datei kurs.[Nummer] wurde nicht im Verzeichnis ") << L_DIR << "/" << tlayout 
       //	   << _("  \ngefunden oder konnte nicht geffnet werden!");
       //wxMessageBox(msg, _("Datei nicht gefunden"), wxICON_EXCLAMATION, m_parent);
       wxLogError(_("Die Datei %s kann nicht geffnet werden"), f.c_str());
       wizard->Destroy();
       return false;
     }
   // Info Fenster zum Kurs wird angezeigt
   akt_krit = 0;
   KursEinleitung();
   LKrit t = m_kriterien[akt_krit];
   m_lektion = new Lektion(m_parent, t.GetNummer(), this);
   ((Hauptfenster*)m_parent)->SetLektion(m_lektion);
   wizard->Destroy();
   return true;
}

//********************************************
//*Kurs::KursLaden()
//********************************************

bool Kurs::KursLaden()
{
  KLDialog *kd = new KLDialog(m_parent);
  if (kd->ShowModal()==-1) return false;
  wxString key;
  key << "/Kurs/" << kd->GetSelection() ;
  wxConfigBase *pConfig = wxConfigBase::Get();
  pConfig->SetPath(key);
  m_kn = pConfig->Read("kursnummer", -99);
  m_key = (kd->GetSelection()).AfterLast('_');
  m_name = (kd->GetSelection()).BeforeLast('_');
  // Kursdatei auslesen
  wxString tlayout = pConfig->Read("/Tastatur/Layout", "german");
  wxString f, g;
  f = "";
  f <<  L_DIR << "/" << tlayout << "/kurs." << m_kn;
  ifstream is(f.c_str());
  char zeile[256];
  if (is)
    {
      while (!is.eof())
	{
	  is.getline(zeile, 256, '\n');
	  if (!is.eof())
	    {
	      string s, t, u, v;
	      int i;
	      s = zeile;
	      i = s.find(":");
	      t = s.substr(0, i);
	      s = s.substr((i+1), s.size());
	      i = s.find(":");
	      u = s.substr(0,i);
	      v = s.substr((i+1), s.size());
	      m_kriterien.push_back(LKrit(atoi(t.c_str()), atoi(u.c_str()), atoi(v.c_str())));
	    }  
	}
    }
  else
    {
      wxString msg;
      wxLogError(_("Die Datei %s kann nicht geffnet werden"), f.c_str());
      return false;
    }
  
  // bisherige Ergebnisse auslesen
  akt_krit = 0;
  pConfig->SetPath(key);
  wxString temp;
    temp = ""; temp << akt_krit;
  while (pConfig->HasGroup(temp))
    {
      wxString nkey;
      nkey << key << "/" << akt_krit;
      pConfig->SetPath(nkey);
      // Hier werden die Ergebnisse aus der Konfigurationsdatei wieder in m_results geladen, damit festgestellt werden kann,
      // welche Lektion als nchstes geladen werden mu und welche Lektion als nchstes dran ist.
      //std::cout << pConfig->Read("Anschlaege", 0l) << endl;
      m_results.push_back(LEntry(pConfig->Read("Anschlaege", 0l), pConfig->Read("Fehler", 0l), pConfig->Read("Promille", 0l),
			  pConfig->Read("Richtig", 0l), pConfig->Read("ApM", 0l), pConfig->Read("Zeit", 0l)));
      //std::cout << "Gre:" << m_results.size() << endl;
      pConfig->SetPath(key);
      ++akt_krit;
      temp = ""; temp << akt_krit;
      
    }
  kd->Destroy();
  // Die Lektion, die nun dran ist laden.
  if (akt_krit <  m_kriterien.size())
    {
      LKrit t = m_kriterien[akt_krit];
      m_lektion = new Lektion(m_parent, t.GetNummer(), this);
      ((Hauptfenster*)m_parent)->SetLektion(m_lektion);
    }
  else
    {
      Langzeitstatistik();
      return false;
    }

  return true;
}


//********************************************
//*Kurs::KursSpeichern()
//********************************************

bool Kurs::KursSpeichern()
{
  wxConfigBase *pConfig = wxConfigBase::Get();
  wxString key;
  if (m_results.size()==0)
    return true;
  for (int i=0; i<=(m_results.size()-1); ++i)
    {
       key = "";
       key <<  "/Kurs/" + m_name << "_" << m_key << "/" << i << "/";
       //std::cout << key << endl;
       pConfig->SetPath(key);
       pConfig->Write("Anschlaege", (long) m_results[i].GetAnschlaege());
       pConfig->Write("Fehler", (long) m_results[i].GetFehler());
       pConfig->Write("Promille", (long) m_results[i].GetPromille());
       pConfig->Write("Richtig", (long) m_results[i].GetRichtig());
       pConfig->Write("ApM", (long) m_results[i].GetApM());
       pConfig->Write("Zeit", (long) m_results[i].GetZeit());
    }
  return true;
}

//********************************************
//*Kurs::KursAbbrechen()
//********************************************

bool Kurs::KursAbbrechen()
{
  KursSpeichern();
  return true;
}

//*********************************************
//*Kurs::NaechsteLektion()
//*********************************************

bool Kurs::NaechsteLektion()
{
  // Testen ob Lektion erfolgreich bearbeitet wurde
  /*std::cout << akt_krit << endl;
    std::cout << m_kriterien[akt_krit].GetPromille() << endl;
    std::cout << m_kriterien[akt_krit].GetZeit() << endl;*/
  kurslaus* k = new kurslaus(m_parent, m_lektion, m_kriterien[akt_krit]);
  if (k->ShowModal()==wxOK)
    {
      k->Destroy();
      if ((m_lektion->GetFP() > m_kriterien[akt_krit].GetPromille())||((m_kriterien[akt_krit].GetUnixZeit()>0)
								       &&(m_lektion->GetUnixZeit()>m_kriterien[akt_krit].GetUnixZeit())))
	{
	  wxMessageBox( _("Zuviele Fehler, das ganze bitte nochmal!"), _("Stop"));
	}
      else
	{
      // Ergebnis speichern
	  LektionSpeichern();
	  ++akt_krit;
	}
      if (akt_krit < m_kriterien.size())
	{
	  m_lektion->LektionAbbrechen();
	  delete m_lektion;
	  m_lektion = new Lektion(m_parent, m_kriterien[akt_krit].GetNummer(), this);
	  ((Hauptfenster*)m_parent)->SetLektion(m_lektion);
	}
      else
	{
	  // Kurs ist zuende
	  KursEnde();
	  ((Hauptfenster*)m_parent)->KursEnde();
	}
    }
  else
    {
      KursAbbrechen();
      ((Hauptfenster*)m_parent)->KursEnde();
    }
      return true;
}

//************************************************
// Kurs::KursEinleitung()
// Einfhrungstext in den Kurs wird angezeigt
//************************************************

bool Kurs::KursEinleitung()
{
  wxString f,s;
  wxConfigBase *pConfig = wxConfigBase::Get();
  wxString tlayout = pConfig->Read("/Tastatur/Layout", "german");
  f << L_DIR << "/" << tlayout << "/kurs.a" << m_kn;
  //std::cout << f << endl;
  wxFFile file(f);
  if (file.IsOpened())
    {
      file.ReadAll(&s);
    }
  else
    {
      wxLogError(_("Datei %s kann nicht geladen werden"), f.c_str());
    }
  wxMessageBox(s , _("Kurseinleitung"));
  return true;
}

//**********************************************************
//* Kurs::KursEnde()
//* Kurs wurde erfolgreich absolviert
//**********************************************************

bool Kurs::KursEnde()
{
  wxString f,s;
  wxConfigBase *pConfig = wxConfigBase::Get();
  wxString tlayout = pConfig->Read("/Tastatur/Layout", "german");
  f << L_DIR << "/" << tlayout << "/kurs.e" << m_kn;
  wxFFile file(f);
  if (file.IsOpened())
    {
      file.ReadAll(&s);
    }
  else
    {
      wxLogError(_("Datei %s kann nicht geladen werden"), f.c_str());
    }
  wxMessageBox(s, _("Kursende"));
 Langzeitstatistik();
  return true;
}


//**********************************************************
//* Kurs::GetLimits()
//**********************************************************

wxString Kurs::GetLimits()
{
   wxString s;
   s << _("In dieser Lektion sind max. ") << m_kriterien[akt_krit].GetPromille() << _(" Fehlerpromille erlaubt.");
   if (m_kriterien[akt_krit].GetUnixZeit() != 0)
     s << _("\nDas Zeitlimit liegt bei  ") << m_kriterien[akt_krit].GetZeit() << _(". \n\nViel Erfolg!");
  return s;
}

//**********************************************************
//* Kurs::LektionSpeichern();
//**********************************************************

bool Kurs::LektionSpeichern()
{
  LEntry result;
  result.SetAnschlaege(m_lektion->GetRichtig());
  result.SetFehler(m_lektion->GetFehler());
  result.SetPromille(m_lektion->GetFP());
  result.SetRichtig(m_lektion->GetRichtig());
  result.SetApM(m_lektion->GetApM());
  result.SetZeit(m_lektion->GetUnixZeit());
  m_results.push_back(result);
  return true;
}

//***********************************************************
//* Kurs::Langzeitstatistik
//***********************************************************

bool Kurs::Langzeitstatistik()
{
  klang *k = new klang(m_parent, m_results);
  k->ShowModal();
  k->Destroy();
  return true;
}
