

/***************************************************************************
                          lektion.cpp  -  description                              
                             -------------------                                         
    begin                : Mon Dec 27 15:02:03 MET 1999 
                                           
    copyright            : (C) 1999 by Daniel Reith                         
    email                : DanR@gmx.de

	
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "lektion.h"
#include "main.h"
#include "lektionsauswahl.h"
#include "lektionsauswertung.h"

#include "lektionsanweisung.h"


//**************************************************************************
// Konstruktor Lektion::Lektion(int Lektion=0)

//**************************************************************************

Lektion::Lektion(wxWindow* parent, int Lektion=0, Kurs* kurs)
{
  m_richtig = 0;
  m_falsch = 0;
  m_return = 0;
  m_pos = 0;
  m_parent = parent;
  m_kurs = kurs;
  Hauptfenster *haupt = (Hauptfenster*)m_parent;
  m_stoppuhr = new stoppuhr();
  m_geladen=false;
  if (Lektion!=-1)
    {
      LektionLaden(Lektion);
      haupt->GetOutput()->SetSelection(m_pos, m_pos+1);
      haupt->GetOutput()->SetInsertionPoint(m_pos);
    } 
}

//**************************************************************************
// Destruktor Lektion::~Lektion()
//**************************************************************************

Lektion::~Lektion()
{
  // Fhrt bei Fehler zu segfault. Deshalb ausgeklammert
  // if ((m_geladen)&&(!m_kurs))
  // if ((!m_kurs)&&(m_geladen))
    {
      //m_stoppuhr->Stopp();
      //LektionAuswertung();
    }
}

//**************************************************************************
// bool SetLektion(int Lektion) // Lektion laden
//**************************************************************************

bool Lektion::SetLektion(int Lektion)
{
  m_lektion = Lektion;
  wxString s = L_DIR;
  
  wxConfigBase *pConfig = wxConfigBase::Get();
  wxString tlayout = pConfig->Read("/Tastatur/Layout", "german");
   
  s << "/" << tlayout<< "/lektion." << Lektion;
  ((Hauptfenster*)m_parent)->GetOutput()->Clear();
  ((Hauptfenster*)m_parent)->GetOutput()->LoadFile(s);
  ((Hauptfenster*)m_parent)->GetInput()->Clear();
  // Darf nur aktiviert werden, wenn kein Kurs geladen
  if (m_kurs == 0)
    {
      ((Hauptfenster*)m_parent)->GetDateiMenu()->Enable(D_LektionBeenden, TRUE);
    }
  ((Hauptfenster*)m_parent)->GetDateiMenu()->Enable(D_LPause, TRUE);
  m_pos = 0;
  m_fehler = 0;
  m_richtig = 0;
  m_eb = false;
  Lektionsanweisung(Lektion);
  ((Hauptfenster*)m_parent)->GetOutput()->SetSelection(m_pos, m_pos+1);
  ((Hauptfenster*)m_parent)->GetOutput()->SetInsertionPoint(m_pos+1);
  Start(1000);
  m_geladen = true;
  return true;
  
}

//***************************************************************************
// Eingabe(char c)  // hier wird die eingabe geprft
//***************************************************************************

bool Lektion::Eingabe(char c)
{
  char d;
  wxString s= ((Hauptfenster*)m_parent)->GetOutput()->GetValue();

  //  Wieso die nchste Zeile? Im d Char sind die Zeilenumbrche mit
  //  dem Wert 10 im char c sind sie 13. Daher dieser kleine Workaround.
  //  Daniel
  d = s.GetChar(m_pos);
  //  Die nchste if Anweisung ist dazu da, das Linefeed Zeichen dann
  //  einfach zu berspringen.
  if (d==char(182))
    {
      m_pos += 1;
      m_return += 1;
      d = s.GetChar(m_pos);
    };
   if (d==10) d=13;
   if (c == d)
    {
      m_pos+=1;
      ((Hauptfenster*)m_parent)->GetOutput()->SetSelection(m_pos,m_pos+1);
      ((Hauptfenster*)m_parent)->GetOutput()->SetInsertionPoint(m_pos+1);
      // Fehleranzahl aktuallisieren
      wxString s2;
      s2 << m_fehler << "/" << GetAnschlaege();
      ((Hauptfenster*)m_parent)->SetStatusText(s2, 2);
      // nchster Buchstabe im StatusBar
      char c = s.GetChar(m_pos);
      switch(c)
	{
	case 32:
	  s2 = "Leertaste";
	  break;
	case 10:
	  s2 = "Return";
	  break;
	default:
	  s2 = c;
	}
      ((Hauptfenster*)m_parent)->SetStatusText(s2,1);
      return true;
    }
  else
    {
      m_fehler+=1;
      wxString s2;
      s2 << m_fehler << "/" << m_pos;
      ((Hauptfenster*)m_parent)->SetStatusText(s2, 2);
      return false;
    };
}


//***********************************************************
//* Timer fr Stoppuhr
//***********************************************************

void Lektion::Notify()
{
  ((Hauptfenster*)m_parent)->SetStatusText(m_stoppuhr->GetZeit(), 3);
}

//***********************************************************
//* Ende der Lektion erreicht, was passiert jetzt?
//***********************************************************

bool Lektion::LektionEnde()
{
  m_stoppuhr->Stopp();
  if (m_kurs == 0)
    {
      LektionAuswertung();
      LektionLaden(0);
      if (m_geladen==false)
	{
	  ((Hauptfenster*)m_parent)->GetDateiMenu()->Enable(D_LektionBeenden, FALSE);
	  ((Hauptfenster*)m_parent)->GetDateiMenu()->Enable(D_LPause, FALSE);
	  ((Hauptfenster*)m_parent)->GetDateiMenu()->Enable(D_KBeginnen, TRUE);
	  ((Hauptfenster*)m_parent)->GetDateiMenu()->Enable(D_KLaden, TRUE);
	}
    }
  else
    {
      m_kurs->NaechsteLektion();
    }
  return true;
}

//***********************************************************
//* Ich brauch ne Pause
//***********************************************************

bool Lektion::Pause()
{
  if (m_geladen)
    {
      m_stoppuhr->Pause();
      wxMessageBox(_("OK drcken um fortzufahren"), 
		   _("Pause"), wxOK, m_parent);
      m_stoppuhr->Weiter();
    }
  return true;
}

//***********************************************************
//* Lektion abbrechen
//***********************************************************

bool Lektion::LektionAbbrechen()
{
  if (m_geladen)
    {
      Hauptfenster *haupt = (Hauptfenster*)m_parent;
      m_stoppuhr->Stopp();
      if (!m_kurs)
      LektionAuswertung();
      m_geladen = false;
      haupt->GetOutput()->Clear();
      haupt->GetInput()->Clear();
      haupt->SetStatusText(_("Keine Lektion geladen"));
      haupt->SetStatusText("", 1);
      haupt->SetStatusText("", 2);
      haupt->SetStatusText("", 3);
      haupt->GetDateiMenu()->Enable(D_LPause, FALSE);
      haupt->GetDateiMenu()->Enable(D_LektionBeenden, FALSE);
    }
  return true;
}

//***********************************************************
//* Lektionsauswertung
//***********************************************************

bool Lektion::LektionAuswertung()
{
   //Ergebnis Speichern
    ErgebnisSpeichern();
  /*
    //Ergebnis Speichern
    ErgebnisSpeichern();
    wxString msg = "Statistik\nFehler: ";
    msg << m_fehler ;
    msg << "\nRichtig: "; 
    msg << (m_pos - m_fehler);
    msg << "\nZeit: " << m_stoppuhr->GetZeit();
    msg << "\nAnschlge/Minute: " << apm(m_pos, m_stoppuhr->GetSek());
    wxMessageBox(msg,
    "PingoS TippTrainer", wxOK | wxICON_INFORMATION, m_parent);*/
  lauswertung* laus;
  laus = new lauswertung((Hauptfenster*)m_parent, _("Lektionsauswertung"), this);
  laus->ShowModal();
  laus->Destroy();
  return true;
}

//************************************************************
//* Lektion laden
//************************************************************

bool Lektion::LektionLaden(int Lektion)
{
  Hauptfenster *haupt = (Hauptfenster*)m_parent;
  if (Lektion == 0)
    {
      Lektionsauswahl* la;
      
      la = new Lektionsauswahl(haupt, -1, _("Lektionsauswahl"), wxDefaultPosition, wxSize(500, 300));
      la->Center();
      if (la->ShowModal()==99)
	{
	  la->Destroy();
	  m_geladen = false;
	  haupt->GetOutput()->Clear();
	  haupt->GetInput()->Clear();
	  haupt->SetStatusText(_("Keine Lektion geladen"));
	  haupt->SetStatusText("", 1);
	  haupt->SetStatusText("", 2);
	  haupt->SetStatusText("", 3);
	  return false;
	}
      SetLektion(la->GetLektion());
      delete la;
    }
  else
    {
      SetLektion(Lektion);
    }
  m_stoppuhr->Start();
  m_pos=0;
  m_fehler=0;
  return true;
}

//************************************************************
//* Ergebnis der Lektion speichern
//************************************************************

bool Lektion::ErgebnisSpeichern()
{
  wxString s;
  s << "/Lektionen/Lektion" << m_lektion;
  wxConfigBase *pConfig = wxConfigBase::Get();
  pConfig->SetPath(s);
  pConfig->Write("Fehler", (long) m_fehler);
  pConfig->Write("FP", (double) GetFP());
  pConfig->Write("Pos", (long) (m_pos - m_return));
  pConfig->Write("Richtig", (long) (m_richtig));
  pConfig->Write("Zeit",  m_stoppuhr->GetZeit());
  pConfig->Write("apm", (long) apm((m_pos - m_return), m_stoppuhr->GetSek()));
  if (m_eb)
    pConfig->Write("eb",  m_eb);
  return true;
}

//`***********************************************
//* Anschlge pro Minute ermitteln
//***********************************************

int Lektion::apm(int a, int s)
{
  double da = (double) a;
  double ds = (double) s;
  double d = da/ds;
  return int(d * 60);
}


//***********************************************
//*  Lektionsanweisung anzeigen
//***********************************************

bool Lektion::Lektionsanweisung(int l)
{
  wxString s, k;
  s << "Lektion " << l;
  k = "";
  if (m_kurs != 0)
    k = m_kurs->GetLimits();
  lektionsanweisung* la;
  la = new lektionsanweisung(m_parent, l, k, -1, s, wxDefaultPosition, wxSize(500, 300));
  la->Centre();
  la->ShowModal();
  la->Destroy();
  return true;
}

//************************************************
//* m_richtig um eins erhhen
//*************************************************

bool Lektion::Richtig()
{
  ++m_richtig;
  return true;
}

						  
