/***************************************************************************
                          info.cpp  -  description                              
                             -------------------                                         
    begin                : Sun Jan 30 14:40:59 MET 2000 
                                           
    copyright            : (C) 1999 by Daniel Reith                         
    email                : DanR@gmx.de
	
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "info.h"
#include "wx/image.h"
#include <config.h>

enum
{
  C = 211,
  OK = 212
};

BEGIN_EVENT_TABLE(Info_Dialog, wxDialog)
  EVT_BUTTON(OK, Info_Dialog::OnSchliessen)
END_EVENT_TABLE()




//*********************************************************
//* Konstruktor
//*********************************************************

Info_Dialog::Info_Dialog(wxWindow* parent, wxWindowID id, const wxString& title, const wxPoint& pos = wxDefaultPosition, 
const wxSize& size =wxDefaultSize, long style = wxDEFAULT_DIALOG_STYLE, const wxString& name = "dialogBox") : wxDialog(parent, id, title, pos, size, style, name)
{

  SetAutoLayout(TRUE);
#ifdef __WXMSW__
  wxBitmap::AddHandler(new wxPNGFileHandler);
#endif
#ifdef __WXGTK__
  wxImage::AddHandler(new wxPNGHandler);
#endif

  wxString f;
  f << L_DIR << "logo.png";
  logo = new wxBitmap(f , wxBITMAP_TYPE_PNG);

  canvas = new MyCanvas(this,  logo, wxDefaultPosition, wxDefaultSize);
  
  
  wxLayoutConstraints *c1 = new wxLayoutConstraints;
  c1->top.SameAs(this, wxTop, 5);
  c1->left.SameAs(this, wxLeft, 5);
  c1->width.PercentOf(this, wxWidth, 43);
  c1->height.PercentOf(this, wxHeight, 80);
  canvas->SetConstraints(c1);

  info_text = new wxStaticText(this, -1, "", wxDefaultPosition, wxDefaultSize);

  wxLayoutConstraints *c3 = new wxLayoutConstraints;
  c3->top.SameAs(this, wxTop, 5);
  c3->left.SameAs(canvas, wxRight, 0);
  c3->width.PercentOf(this, wxWidth, 59);
  c3->height.PercentOf(this, wxHeight, 80);
  info_text->SetConstraints(c3);

  wxString msg;
  msg << _("PingoS Tipptrainer\n")
      << _("------------------\n")
      << _("Version:\t") << VERSION
      << _("\nhttp://www.pingos.schulnetz.org/tipptrainer\n")
      << _("Verffentlicht unter der GPL 2.0\n")
      << _("\nAutoren:\n")
      << "Andreas Kalbitz \n\t(felix@musik-workshop.de)\n"
      << "Matthias Kleine \n\t(Matthias.Kleine@selflinux.de)\n"
      << "Daniel Reith (DanR@gmx.de)\n"
      << _("\nFeedback bitte an: \n\ttipptrainer@reith.8m.com");
  info_text->SetLabel(msg);
    
  ok = new wxButton(this, OK, _("Schlieen"));

  wxLayoutConstraints *c2 = new wxLayoutConstraints;
  c2->centreX.SameAs(this, wxCentreX);
  c2->top.SameAs(canvas, wxBottom, 10);
  c2->width.PercentOf(this, wxWidth, 30);
  c2->height.PercentOf(this, wxHeight, 9);

  ok->SetConstraints(c2);

  
}

//*********************************************************
//* Destruktor
//*********************************************************

Info_Dialog::~Info_Dialog()
{
  
}

//**********************************************************
//* Fenster schlieen
//**********************************************************

void Info_Dialog::OnSchliessen(wxCommandEvent* event)
{
  EndModal(GetReturnCode());
}


BEGIN_EVENT_TABLE(MyCanvas, wxScrolledWindow)
    EVT_PAINT(MyCanvas::OnPaint)
END_EVENT_TABLE()

MyCanvas::MyCanvas(wxWindow *parent, wxBitmap *b, const wxPoint& pos, const wxSize& size):
 wxScrolledWindow(parent, -1, pos, size)
{
  logo = b;
}

MyCanvas::~MyCanvas()
{
}

void MyCanvas::OnPaint(wxPaintEvent& WXUNUSED(event))
{
  wxPaintDC dc(this);
  wxMemoryDC memDC;
  memDC.SelectObject(* logo);

  dc.Blit(5, 25, logo->GetWidth(), logo->GetHeight(), & memDC, 0, 0, wxCOPY, TRUE);
  
 memDC.SelectObject(wxNullBitmap);
}
