# Copyright (c) 2001-2004 by Intevation GmbH
# Authors:
# Jonathan Coles <jonathan@intevation.de> (2003)
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

"""The About Box"""

__version__ = "$Revision: 1.11.2.4 $"
# $Source: /thubanrepository/thuban/Thuban/UI/about.py,v $
# $Id: about.py,v 1.11.2.4 2004/12/20 15:09:31 jan Exp $

from wxPython.wx import *

from locale import getdefaultlocale

from Thuban import _
from Thuban.version import versions
from Thuban.Model.resource import gdal_support_status

class About(wxDialog):

    def __init__(self, parent):
        wxDialog.__init__(self, parent, -1, _("About Thuban"),
            style = wxDEFAULT_DIALOG_STYLE
                  | wxSYSTEM_MENU
                  | wxMINIMIZE_BOX
                  | wxMAXIMIZE_BOX
                  | wxRESIZE_BORDER,
            size = (400, 250))

        # Note: The source code is in ASCII, so we escape some
        # characters to get byte strings in latin1.
        lead_developer = 'Bernhard Herzog (2001-2004)'
        developers = [ 'Jonathan Coles (2003)',
                       'Frank Koormann (2002-2004)',
                       unicodeToLocale(u'Martin M\xfcller (2003)'),
                       'Jan-Oliver Wagner (2002-2004)' ]
        translators = [ ( _('French'), 'Daniel Calvelo Aros (2003-2004)' ),
                        ( _('German'),
                          unicodeToLocale(u'Bj\xf6rn Broscheit (2003-2004)')),
                        ( _('Hungarian'), 'Norbert Solymosi (2004)'),
                        ( _('Italian'), 'Maurizio Napolitano (2003)'),
                        ( _('Portuguese (Brazilian)'),
                          'Eduardo Patto Kanegae (2004)'),
                        ( _('Russian'), 'Alex Shevlakov (2003-2004)'),
                        ( _('Spanish'), 'Daniel Calvelo Aros (2003-2004)') ]
        other_contributors = [ 'Jonathan Byron (2002)',
                               'Silke Reimer (2003-2004)',
                               'Bernhard Reiter (2001-2004)' ]
        dyn_modules = [ ('wxPython', versions['wxPython']),
                        ('Python',   versions['python']),
                        ('PySQLite', versions['pysqlite']),
                        ('SQLite',  versions['sqlite']),
                        ('GDAL', versions.get('gdal', _('- not available'))),
                        ('psycopg', versions.get('psycopg',
                                                 _('- not available')))]
        direct_modules = [ \
                ('GTK',      versions.get('gtk', _('- not available'))),
                ('proj',     versions['proj']) ]

        text = 'Thuban %s\n\n' % versions['thuban-long']

        text += _('Currently using:\n')

        for name, version in dyn_modules:
            text+= '\t%s %s\n' % (name, version)
        text += '\n'

        if gdal_support_status:
            text += gdal_support_status + "\n\n"

        text += _('Compiled for:\n')

        for name, version in direct_modules:
            text+= '\t%s %s\n' % (name, version)
        text += '\n'

        text += _('Lead Developer:\n')
        text += '\t%s\n\n' % lead_developer

        text += _('Developers:\n')
        for name in developers:
            text += '\t%s\n' % name
        text += '\n'

        text += _('Translators:\n')
        for lang, name in translators:
            text += '\t%s: %s\n' % (lang, name)
        text += '\n'

        text += _('Other Contributors:\n')
        for name in other_contributors:
            text += '\t%s\n' % name
        text += '\n'

        text += \
            _("Questions and comments can be sent to the following addresses:\n"
            "\tGeneral list (public):\n\t\t<thuban-list@intevation.de>\n"
            "\tDevelopers list (public):\n\t\t<thuban-devel@intevation.de>\n"
            "\tThuban team at Intevation:\n\t\t<thuban@intevation.de>\n")

        self.text = text

        text_title = wxStaticText(self, -1, 
            _("Thuban is a program for exploring geographic data.\n\n") +
            "Copyright 2001-2004 Intevation GmbH.\n" +
            _("Thuban is licensed under the GNU GPL"),
                                  style=wxST_NO_AUTORESIZE|wxALIGN_CENTRE)

        textBox = wxTextCtrl(self, -1, text, 
            style=wxTE_READONLY|wxTE_MULTILINE|wxTE_LINEWRAP)
        w, h = (300, 150)
        textBox.SetSizeHints(w, h)
        textBox.SetSize((w, h))

        button_close = wxButton(self, wxID_CANCEL, _("Close"))
        button_close.SetDefault()

        sizer = wxBoxSizer(wxVERTICAL)
        sizer.Add(text_title, 0, wxALL|wxEXPAND|wxADJUST_MINSIZE, 10)
        sizer.Add(textBox, 1, wxALL|wxEXPAND, 10)
        sizer.Add(button_close, 0, wxALL|wxALIGN_RIGHT, 10)

        self.SetAutoLayout(True)
        self.SetSizer(sizer)
        sizer.Fit(self)
        sizer.SetSizeHints(self)
        self.Layout()

        EVT_BUTTON(self, wxID_CANCEL, self.OnCancel)

    def OnCancel(self, event):
        self.EndModal(wxID_CANCEL)


def unicodeToLocale(unicodeStr):
    "Function to convert unicode to the user's locale encoding"
    return unicodeStr.encode(getdefaultlocale()[1])
