# Copyright (c) 2001, 2002, 2003 by Intevation GmbH
# Authors:
#     Markus Rechtien <markus@intevation.de>
#
# This program is free software under the GPL (>=v2)
# Read the file COPYING coming with Thuban for details.

__version__ = "$Revision: 1.1 $"
# $Source: /thubanrepository/thuban/Extensions/svgexport/svgsaver.py,v $
# $Id: svgsaver.py,v 1.1 2004/02/19 13:38:27 bh Exp $


"""
Classes to write a session in SVG format
"""


# Needed wx-toolkit classes
from wxPython.wx import wxFileDialog, wxSAVE, wxOVERWRITE_PROMPT, wxID_OK

# We need os.path
import os

# use _() already now for all strings that may later be translated
from Thuban import _

# Import SVG related classes
from svgmapwriter import VirtualDC, SVGRenderer


def write_to_svg(context):
    '''The main export funtion - Exports the data depending
    on the set properties.
    '''
    canvas = context.mainwindow.canvas
    file = None
    map = canvas.Map()
    
    if hasattr(canvas, "export_path"):
        export_path = canvas.export_path
    else:
        export_path="."
    # Get the file the session shall be written to
    dlg = wxFileDialog(canvas, _("Write SVG"), export_path, "", 
            "Scalable Vector Graphics (*.svg)|*.svg", 
            wxSAVE|wxOVERWRITE_PROMPT)
    
    response = dlg.ShowModal()
    if response == wxID_OK:
        file = dlg.GetPath()
    else: # Do nothing if choice was interrupted.
        return 0
        
    # If the user selected a file
    if file and map is not None:
        canvas.export_path = os.path.dirname(file)
        # Initialize some dimensions and calculate the map bounds
        width, height = canvas.GetSizeTuple()
        llx, lly = canvas.win_to_proj(0, height)
        urx, ury = canvas.win_to_proj(width, 0)
        mapwidth, mapheight = ((urx - llx), (ury - lly))
        mapregion = (llx, lly, mapwidth, mapheight)
        
        # Get all selected layers and shapes that should be written as SVG
        selected_layer = canvas.selection.SelectedLayer()
        selected_shapes = canvas.selection.SelectedShapes()
        dc = VirtualDC(file, (mapwidth, mapheight, ))
        dc.BeginExport()
        # map scale offset region
        renderer = SVGRenderer(dc, map, 1.0, (0 - min(llx, urx),
                0 + max(lly, ury)), mapregion)
        # Render the map
        renderer.RenderMap(selected_layer, selected_shapes)
        #
        dc.EndExport()


# Thuban has named commands which can be registered in the central
# instance registry.
from Thuban.UI.command import registry, Command

# The instance of the main menu of the Thuban application
# See Thuban/UI/menu.py for the API of the Menu class
from Thuban.UI.mainwindow import main_menu

# find the extensions menu (create it anew if not found)
extensions_menu = main_menu.find_menu('extensions')
if extensions_menu is None:
    extensions_menu = main_menu.InsertMenu('extensions', _('E&xtensions'))
    
# create a new command and register it
registry.Add(Command('write_to_svg', _('Write SVG Map'), write_to_svg,
                     helptext = _('Export the a map into a SVG file')))

# finally bind the new command with an entry in the extensions menu
extensions_menu.InsertItem('write_to_svg')
