#ifndef MFILE_H_INCLUDED
#define MFILE_H_INCLUDED

#include "cpl_vsi.h"

typedef struct
{
    void *data;
    vsi_l_offset len;
} MFILEReceiver;


#define CHUNK_SIZE 4096         /* must be a power of 2 */
struct s_chunk
{
    char data[CHUNK_SIZE];       /* actual data                             */
    struct s_chunk *next;        /* pointer to the next chunk               */
    vsi_l_offset offset;         /* offset from the beginning of the file   */
};

typedef struct 
{
    char sig[ 3 ];
    struct s_chunk * head;
    struct s_chunk * cur;
    vsi_l_offset t_offset;    /* total offset from the start of the "array" */
    vsi_l_offset length;      /* length of the "array"                      */
    char eof;
    int ungetc;               /* place to hold the ungetc character         */
    MFILEReceiver *receiver;
} MFILE;

MFILE * MFILEOpen( const char * pszFilename );
vsi_l_offset MFILETell( MFILE * xfp );
void MFILERewind( MFILE * xfp );
void MFILEFlush( MFILE * xfp );
int MFILEEof( MFILE * xfp );
char *MFILEGets( char *pszBuffer, int nBufferSize, MFILE * mfp );
int MFILEGetc( MFILE * mfp );
int MFILEUngetc( int c, MFILE * mfp );
size_t MFILERead( void * pBuffer, size_t nSize, size_t nCount, MFILE * xfp );
size_t MFILEWrite( void * pBuffer, size_t nSize, size_t nCount, MFILE * xfp );
int MFILESeek( MFILE * xfp, vsi_l_offset nOffset, int nWhence );
int MFILEClose( MFILE * xfp );

#endif  /* MFILE_H_INCLUDED */
