/************************************************************************/
/*									*/
/*  Tentative declarations for shpes.					*/
/*									*/
/*  Distances are in EMU's.						*/
/*  12700 EMU/Point.							*/
/*  914400 EMU/Inch.							*/
/*  360000 EMU/cm.							*/
/*									*/
/************************************************************************/

typedef struct DrawingShape
    {
			/************************************************/
			/*  Identifier within document,			*/
			/*  Type of shape,				*/
			/*  Identifier of next. (For text boxes)	*/
			/************************************************/
    int			ds_shplid;
    int			ds_shapeType;
    int			ds_hspNext;

    int			ds_relLeft;
    int			ds_relTop;
    int			ds_relRight;
    int			ds_relBottom;
			/************************************************/
			/*  Internal margins of a text box.		*/
			/************************************************/
    int			ds_dxTextLeft;
    int			ds_dyTextTop;
    int			ds_dxTextRight;
    int			ds_dyTextBottom;

    int			ds_lineWidth;
    int			ds_shapePath;

    unsigned int	ds_fFlipH:1;
    unsigned int	ds_fFlipV:1;
    unsigned int	ds_fRelFlipH:1;
    unsigned int	ds_fRelFlipV:1;
    unsigned int	ds_fLockAspectRatio:1;
    unsigned int	ds_fLine:1;
    unsigned int	ds_fFillOK:1;
    unsigned int	ds_fFilled:1;
    unsigned int	ds_fArrowheadsOK:1;
    unsigned int	ds_fFitShapeToText:1;
    } DrawingShape;

/************************************************************************/
/*									*/
/*  Kinds of shape.							*/
/*									*/
/************************************************************************/

typedef enum ShapeType
    {
    SHPtyFREE= -1,

    SHPtyFREEFORM_OR_NON_AUTOSHAPE= 0,
    SHPtyRECTANGLE= 1,
    SHPtyROUND_RECTANGLE= 2,
    SHPtyELLIPSE= 3,
    SHPtyDIAMOND= 4,
    SHPtyISOSCELES_TRIANGLE= 5,
    SHPtyRIGHT_TRIANGLE= 6,
    SHPtyPARALLELOGRAM= 7,
    SHPtyTRAPEZOID= 8,
    SHPtyHEXAGON= 9,
    SHPtyOCTAGON= 10,
    SHPtyPLUS_SIGN= 11,
    SHPtySTAR= 12,
    SHPtyARROW= 13,
    SHPtyTHICK_ARROW= 14,
    SHPtyHOME_PLATE= 15,
    SHPtyCUBE= 16,
    SHPtyBALLOON= 17,
    SHPtySEAL= 18,
    SHPtyARC= 19,
    SHPtyLINE= 20,
    SHPtyPLAQUE= 21,
    SHPtyCAN= 22,
    SHPtyDONUT= 23,
    SHPtyTEXT_SIMPLE= 24,
    SHPtyTEXT_OCTAGON= 25,
    SHPtyTEXT_HEXAGON= 26,
    SHPtyTEXT_CURVE= 27,
    SHPtyTEXT_WAVE= 28,
    SHPtyTEXT_RING= 29,
    SHPtyTEXT_ON_CURVE= 30,
    SHPtyTEXT_ON_RING= 31,
    SHPtyCALLOUT_1= 41,
    SHPtyCALLOUT_2= 42,
    SHPtyCALLOUT_3= 43,
    SHPtyACCENT_CALLOUT_1= 44,
    SHPtyACCENT_CALLOUT_2= 45,
    SHPtyACCENT_CALLOUT_3= 46,
    SHPtyBORDER_CALLOUT_1= 47,
    SHPtyBORDER_CALLOUT_2= 48,
    SHPtyBORDER_CALLOUT_3= 49,
    SHPtyACCENT_BORDER_CALLOUT_1= 50,
    SHPtyACCENT_BORDER_CALLOUT_2= 51,
    SHPtyACCENT_BORDER_CALLOUT_3= 52,
    SHPtyRIBBON= 53,
    SHPtyRIBBON2= 54,
    SHPtyCHEVRON= 55,
    SHPtyPENTAGON= 56,
    SHPtyNO_SMOKING= 57,
    SHPtySEAL8= 58,
    SHPtySEAL16= 59,
    SHPtySEAL32= 60,
    SHPtyWEDGE_RECT_CALLOUT= 61,
    SHPtyWEDGE_RRECT_CALLOUT= 62,
    SHPtyWEDGE_ELLIPSE_CALLOUT= 63,
    SHPtyWAVE= 64,
    SHPtyFOLDED_CORNER= 65,
    SHPtyLEFT_ARROW= 66,
    SHPtyDOWN_ARROW= 67,
    SHPtyUP_ARROW= 68,
    SHPtyLEFT_RIGHT_ARROW= 69,
    SHPtyUP_DOWN_ARROW= 70,
    SHPtyIRREGULARSEAL1= 71,
    SHPtyIRREGULARSEAL2= 72,
    SHPtyLIGHTNING_BOLT= 73,
    SHPtyHEART= 74,
    SHPtyPICTURE_FRAME= 75,
    SHPtyQUAD_ARROW= 76,
    SHPtyLEFT_ARROW_CALLOUT= 77,
    SHPtyRIGHT_ARROW_CALLOUT= 78,
    SHPtyUP_ARROW_CALLOUT= 79,
    SHPtyDOWN_ARROW_CALLOUT= 80,
    SHPtyLEFT_RIGHT_ARROW_CALLOUT= 81,
    SHPtyUP_DOWN_ARROW_CALLOUT= 82,
    SHPtyQUAD_ARROW_CALLOUT= 83,
    SHPtyBEVEL= 84,
    SHPtyLEFT_BRACKET= 85,
    SHPtyRIGHT_BRACKET= 86,
    SHPtyLEFT_BRACE= 87,
    SHPtyRIGHT_BRACE= 88,
    SHPtyLEFT_UP_ARROW= 89,
    SHPtyBENT_UP_ARROW= 90,
    SHPtyBENT_ARROW= 91,
    SHPtySEAL24= 92,
    SHPtySTRIPED_RIGHT_ARROW= 93,
    SHPtyNOTCHED_RIGHT_ARROW= 94,
    SHPtyBLOCK_ARC= 95,
    SHPtySMILEY_FACE= 96,
    SHPtyVERTICAL_SCROLL= 97,
    SHPtyHORIZONTAL_SCROLL= 98,
    SHPtyCIRCULAR_ARROW= 99,
    SHPtyNOTCHED_CIRCULAR_ARROW= 100,
    SHPtyUTURN_ARROW= 101,
    SHPtyCURVED_RIGHT_ARROW= 102,
    SHPtyCURVED_LEFT_ARROW= 103,
    SHPtyCURVED_UP_ARROW= 104,
    SHPtyCURVED_DOWN_ARROW= 105,
    SHPtyCLOUD_CALLOUT= 106,
    SHPtyELLIPSE_RIBBON= 107,
    SHPtyELLIPSE_RIBBON_2= 108,
    SHPtyFLOW_CHART_PROCESS= 109,
    SHPtyFLOW_CHART_DECISION= 110,
    SHPtyFLOW_CHART_INPUT_OUTPUT= 111,
    SHPtyFLOW_CHART_PREDEFINED_PROCESS= 112,
    SHPtyFLOW_CHART_INTERNAL_STORAGE= 113,
    SHPtyFLOW_CHART_DOCUMENT= 114,
    SHPtyFLOW_CHART_MULTIDOCUMENT= 115,
    SHPtyFLOW_CHART_TERMINATOR= 116,
    SHPtyFLOW_CHART_PREPARATION= 117,
    SHPtyFLOW_CHART_MANUAL_INPUT= 118,
    SHPtyFLOW_CHART_MANUAL_OPERATION= 119,
    SHPtyFLOW_CHART_CONNECTOR= 120,
    SHPtyFLOW_CHART_PUNCHED_CARD= 121,
    SHPtyFLOW_CHART_PUNCHED_TAPE= 122,
    SHPtyFLOW_CHART_SUMMING_JUNCTION= 123,
    SHPtyFLOW_CHART_OR= 124,
    SHPtyFLOW_CHART_COLLATE= 125,
    SHPtyFLOW_CHART_SORT= 126,
    SHPtyFLOW_CHART_EXTRACT= 127,
    SHPtyFLOW_CHART_MERGE= 128,
    SHPtyFLOW_CHART_OFFLINE_STORAGE= 129,
    SHPtyFLOW_CHART_ONLINE_STORAGE= 130,
    SHPtyFLOW_CHART_MAGNETIC_TAPE= 131,
    SHPtyFLOW_CHART_MAGNETIC_DISK= 132,
    SHPtyFLOW_CHART_MAGNETIC_DRUM= 133,
    SHPtyFLOW_CHART_DISPLAY= 134,
    SHPtyFLOW_CHART_DELAY= 135,
    SHPtyTEXT_PLAIN_TEXT= 136,
    SHPtyTEXT_STOP= 137,
    SHPtyTEXT_TRIANGLE= 138,
    SHPtyTEXT_TRIANGLE_INVERTED= 139,
    SHPtyTEXT_CHEVRON= 140,
    SHPtyTEXT_CHEVRON_INVERTED= 141,
    SHPtyTEXT_RING_INSIDE= 142,
    SHPtyTEXT_RING_OUTSIDE= 143,
    SHPtyTEXT_ARCH_UP_CURVE= 144,
    SHPtyTEXT_ARCH_DOWN_CURVE= 145,
    SHPtyTEXT_CIRCLE_CURVE= 146,
    SHPtyTEXT_BUTTON_CURVE= 147,
    SHPtyTEXT_ARCH_UP_POUR= 148,
    SHPtyTEXT_ARCH_DOWN_POUR= 149,
    SHPtyTEXT_CIRCLE_POUR= 150,
    SHPtyTEXT_BUTTON_POUR= 151,
    SHPtyTEXT_CURVE_UP= 152,
    SHPtyTEXT_CURVE_DOWN= 153,
    SHPtyTEXT_CASCADE_UP= 154,
    SHPtyTEXT_CASCADE_DOWN= 155,
    SHPtyTEXT_WAVE1= 156,
    SHPtyTEXT_WAVE2= 157,
    SHPtyTEXT_WAVE3= 158,
    SHPtyTEXT_WAVE4= 159,
    SHPtyTEXT_INFLATE= 160,
    SHPtyTEXT_DEFLATE= 161,
    SHPtyTEXT_INFLATE_BOTTOM= 162,
    SHPtyTEXT_DEFLATE_BOTTOM= 163,
    SHPtyTEXT_INFLATE_TOP= 164,
    SHPtyTEXT_DEFLATE_TOP= 165,
    SHPtyTEXT_DEFLATE_INFLATE= 166,
    SHPtyTEXT_DEFLATE_INFLATE_DEFLATE= 167,
    SHPtyTEXT_FADE_RIGHT= 168,
    SHPtyTEXT_FADE_LEFT= 169,
    SHPtyTEXT_FADE_UP= 170,
    SHPtyTEXT_FADE_DOWN= 171,
    SHPtyTEXT_SLANT_UP= 172,
    SHPtyTEXT_SLANT_DOWN= 173,
    SHPtyTEXT_CAN_UP= 174,
    SHPtyTEXT_CAN_DOWN= 175,
    SHPtyFLOW_CHART_ALTERNATE_PROCESS= 176,
    SHPtyFLOW_CHART_OFF_PAGE_CONNECTOR= 177,
    SHPtyCALLOUT_90= 178,
    SHPtyACCENT_CALLOUT_90= 179,
    SHPtyBORDER_CALLOUT_90= 180,
    SHPtyACCENT_BORDER_CALLOUT_90= 181,
    SHPtyLEFT_RIGHT_UP_ARROW= 182,
    SHPtySUN= 183,
    SHPtyMOON= 184,
    SHPtyBRACKET_PAIR= 185,
    SHPtyBRACE_PAIR= 186,
    SHPtySEAL4= 187,
    SHPtyDOUBLE_WAVE= 188,
    SHPtyHOST_CONTROL= 201,
    SHPtyTEXT_BOX= 202
    } ShapeType;
