/************************************************************************/
/*									*/
/*  Simple io streams, recursive use for hexadecimal data.		*/
/*									*/
/************************************************************************/

#   include	"appUtilConfig.h"

#   include	"sioHex.h"
#   include	<appDebugon.h>


/************************************************************************/
/*									*/
/*  For Hexadecimal decoding.						*/
/*									*/
/************************************************************************/

static const unsigned char	SioHexDigitsU[]= "0123456789ABCDEF";
static const unsigned char	SioHexDigitsL[]= "0123456789abcdef";
static unsigned char		SioHexIndices[256];

/************************************************************************/
/*									*/
/*  Exchange of hexed binary data.					*/
/*									*/
/************************************************************************/


static int sioHexClose( void *	voids )
    { return 0;	}

static int sioInHexReadBytes(	void *		voidsis,
				unsigned char *	buffer,
				int		count )
    {
    SimpleInputStream *	sis= (SimpleInputStream *)voidsis;
    int			done= 0;

    while( done < count )
	{
	int		c;

	c= sioInGetCharacter( sis );

	while( c == ' ' || c == '\r' || c == '\n' )
	    { c= sioInGetCharacter( sis );	}

	if  ( c == EOF )
	    { return done;	}
	else{
	    if  ( SioHexIndices[c] == 0xff )
		{ sioInUngetLastRead( sis ); return done;	}
	    else{ buffer[0]= SioHexIndices[c];			}
	    }

	c= sioInGetCharacter( sis );

	buffer[0] *= 16;

	while( c == ' ' || c == '\r' || c == '\n' )
	    { c= sioInGetCharacter( sis );	}

	if  ( c == EOF )
	    { LDEB(c); return -1;			}

	if  ( SioHexIndices[c] == 0xff )
	    { CDEB(c); return -1;			}
	else{ buffer[0] += SioHexIndices[c];		}

	buffer++; done++;
	}

    return done;
    }


SimpleInputStream * sioInHexOpen(	SimpleInputStream *	sisHex )
    {
    SimpleInputStream *	sis;

    if  ( SioHexIndices[0] == 0 )
	{
	int	i;

	for ( i= 0; i < sizeof(SioHexIndices); i++ )
	    { SioHexIndices[i]= 0xff;	}

	i= 0;
	while( SioHexDigitsU[i] )
	    { SioHexIndices[SioHexDigitsU[i]]= i; i++;	}
	i= 0;
	while( SioHexDigitsL[i] )
	    { SioHexIndices[SioHexDigitsL[i]]= i; i++;	}
	}

    sis= sioInOpen( (void *)sisHex,
			    sioInHexReadBytes, (SIOinSEEK)0, sioHexClose );

    if  ( ! sis )
	{ XDEB(sis); return (SimpleInputStream *)0; }

    return sis;
    }

static int sioOutHexWriteBytes(	void *			voidsos,
				const unsigned char *	buffer,
				int			count )
    {
    SimpleOutputStream *	sos= (SimpleOutputStream *)voidsos;
    int				done= 0;

    while( done < count )
	{
	sioOutPutCharacter( SioHexDigitsL[ ( (*buffer) >> 4 ) & 0x0f ], sos );
	sioOutPutCharacter( SioHexDigitsL[ ( (*buffer) >> 0 ) & 0x0f ], sos );

	buffer++; done++;
	}

    return count;
    }

static int sioHexSeek(		void *			voidsos,
				long			pos )
    {
    SimpleOutputStream *	sos= (SimpleOutputStream *)voidsos;

    if  ( sioOutSeek( sos, 2* pos ) )
	{ LDEB(0); return -1;	}

    return 0;
    }

SimpleOutputStream * sioOutHexOpen(	SimpleOutputStream *	sosHex )
    {
    SimpleOutputStream *	sos;

    sos= sioOutOpen( (void *)sosHex, sioOutHexWriteBytes,
						sioHexSeek, sioHexClose );

    if  ( ! sos )
	{ XDEB(sos); return (SimpleOutputStream *)0; }

    return sos;
    }
