#include "image-loader.h"

void
teatime_image_loader_lighten (GdkPixbuf *src, GdkPixbuf *dest, gint cup, gint size)
{
  gint i, j, rowstride;
  guchar *target_pixels;
  guchar *original_pixels;
  guchar *current_pixel;
  guchar light_val = 16;
  gint bits_per_sample;
  gint chanels;
 
  bits_per_sample = gdk_pixbuf_get_bits_per_sample (src);
  if ( bits_per_sample != 8)
  {
    g_warning (_("Only images with a color depth of 24 or 32 Bit are allowed for the Teatime Aplett\n"
               "The requested images %s* have a depth of %i"), teacups[cup], bits_per_sample);
    return;
  }
  chanels = gdk_pixbuf_get_n_channels (src);
  target_pixels = gdk_pixbuf_get_pixels (dest);
  original_pixels = gdk_pixbuf_get_pixels (src);
  rowstride = gdk_pixbuf_get_rowstride (src);
  for (i = 0; i < size; i++)
  {
    for (j = 0; j < size; j++)
    {
      current_pixel = original_pixels + i*rowstride + j*chanels;

      *(target_pixels + i*rowstride + j*chanels) = MIN( light_val + (*(current_pixel)), 255);
      *(target_pixels + i*rowstride + j*chanels + 1) = MIN( light_val + (*(current_pixel + 1)), 255);
      *(target_pixels + i*rowstride + j*chanels + 2) = MIN( light_val + (*(current_pixel + 2)), 255);
      if (chanels == 4)
        *(target_pixels + i*rowstride + j*chanels + 3) = *(current_pixel + 3);
    }
  }
}

static const gchar*
teatime_get_pixmap_path ()
{
  static gchar *path = NULL;
  const gchar* const* dirs = g_get_system_data_dirs ();
  while (*dirs)
  {
    gchar *p = g_strconcat (*dirs, "pixmaps/teatime/", NULL);
    if (g_file_test (p, G_FILE_TEST_IS_DIR))
    {
      path = p;
      break;
    }
    g_free (p);
    *dirs++;
  }
  return (const gchar*)path;
}


gboolean
teatime_image_loader_load_applet_images (Teatime *teatime)
{
  GError *error = NULL;
  gint i;
  gchar *filename;
  GdkPixbuf *tmp1 = NULL;
  GdkPixbuf *tmp2 = NULL;
  const gchar* pixpath = teatime_get_pixmap_path ();

  teatime->icon_path = g_strdup_printf ("%s%s_empty.png", pixpath, teacups[teatime->properties.cup]);

  if (teatime->cup_empty)
    tmp1 = teatime->cup_empty;
    
  tmp2 = gdk_pixbuf_new_from_file (teatime->icon_path, &error);
  if (error)
  {
    g_warning (G_STRLOC ": cannot open %s: %s", teatime->icon_path, error);
    g_error_free (error);
    return FALSE;
  }

  teatime->cup_empty = gdk_pixbuf_scale_simple (tmp2,
                                                teatime->size, teatime->size,
                                                GDK_INTERP_HYPER);
  g_object_unref (G_OBJECT (tmp2));
  tmp2 = gdk_pixbuf_copy (teatime->cup_empty);
  if (tmp1)
    g_object_unref (G_OBJECT (tmp1));
  
  tmp1 = teatime->cup_empty_hl;
  teatime_image_loader_lighten (teatime->cup_empty,
           tmp2,
           teatime->properties.cup,
           teatime->size);
  teatime->cup_empty_hl = tmp2;
  if (tmp1)
    g_object_unref (G_OBJECT (tmp1));

  for (i=0; i<FRAMES; i++)
  {
    tmp1 = NULL;
    tmp2 = NULL;
    filename = g_strdup_printf ("%s%s_full_%i.png", pixpath,
                                teacups[teatime->properties.cup], i);
    if (teatime->cup_full[i])
      tmp1 = teatime->cup_full[i];
    tmp2 = gdk_pixbuf_new_from_file (filename,
                                     &error);
    if (error)
    {
      g_warning (G_STRLOC ": cannot open %s: %s", filename, error);
      g_error_free (error);
      return FALSE;
    }
    g_free (filename);
    teatime->cup_full[i] = gdk_pixbuf_scale_simple (tmp2,
                                                    teatime->size, teatime->size,
                                                    GDK_INTERP_HYPER);
    g_object_unref (G_OBJECT (tmp2));
    tmp2 = gdk_pixbuf_copy (teatime->cup_full[i]);     
    if (tmp1)
      g_object_unref (G_OBJECT (tmp1));
      
    tmp1 = teatime->cup_full_hl[i];
    teatime_image_loader_lighten (teatime->cup_full[i],
             tmp2,
             teatime->properties.cup,
             teatime->size);
    teatime->cup_full_hl[i] = tmp2;
    if (tmp1)
      g_object_unref (G_OBJECT (tmp1));
  }
  return TRUE;
}

gboolean
teatime_image_loader_load_popup_images (Teatime *teatime)
{    
  GError *error = NULL;
  gint i;
  gchar *filename;
  const gchar* pixpath = teatime_get_pixmap_path ();
  
  for (i=0; i<ROT_FRAMES; i++)
  {
    gchar *filename;
    GdkPixbuf *pixbuf;
    GdkPixmap *pixmap;
      
    filename = g_strdup_printf ("%scup%02i.png", pixpath, i);
    pixbuf = gdk_pixbuf_new_from_file (filename, &error);
    if (error)
    {
      g_warning (G_STRLOC ": cannot open %s: %s", filename, error);
      g_free (filename);
      g_error_free (error);
      return FALSE;
    }
    g_free (filename);
    gdk_pixbuf_render_pixmap_and_mask (pixbuf,
                                       &pixmap,
                                       &teatime->popup.bitmap[i],
                                       128);
    g_object_unref (G_OBJECT (pixbuf));
    teatime->popup.image[i] = gtk_image_new_from_pixmap (pixmap,
                                                         teatime->popup.bitmap[i]);
  }
  return TRUE;
}

gboolean
teatime_image_loader_load_pref_images (Teatime *teatime)
{
  GError *error = NULL;
  gint i;
  gchar *filename;
  const gchar* pixpath = teatime_get_pixmap_path ();
  
  for (i=0; i<TEACUPS; i++)
  {
    gchar *filename;
    GdkPixbuf *pixbuf;
    GdkPixmap *pixmap;
      
    filename = g_strdup_printf ("%s%s_full_0.png", pixpath, teacups[i]);

    teatime->properties.teacups[i] = gdk_pixbuf_new_from_file (filename, &error);
    if (error)
    {
      g_warning (G_STRLOC ": cannot open %s: %s", filename, error);
      g_free (filename);
      g_error_free (error);
      return FALSE;
    }
  g_free (filename);
  }
  return TRUE;
}


