/*
 *	tardy - a tar post-processor
 *	Copyright (C) 1998, 1999 Peter Miller;
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.
 *
 * MANIFEST: functions to manipulate file input stdins
 */

#include <ac/unistd.h>

#include <file/input/stdin.h>


file_input_stdin::~file_input_stdin()
{
	/* nothing to do */
}


file_input_stdin::file_input_stdin()
{
	/* nothing to do */
}


file_input_stdin::file_input_stdin(const file_input_stdin &)
{
	/* nothing to do */
}


file_input_stdin &
file_input_stdin::operator = (const file_input_stdin &)
{
	/* nothing to do */
	return *this;
}


int
file_input_stdin::read(void *buffer, int maximum_length)
	const
{
	int nbytes = ::read(0, buffer, maximum_length);
	if (nbytes < 0)
		nfatal("read");
	return nbytes;
}


const char *
file_input_stdin::filename()
	const
{
	return "standard input";
}
