/*
   Time-stamp: <97/08/11 18:40:56 yusuf>

   $Id: sel_backup.c,v 1.43 1997/08/11 12:32:05 yusuf Exp $	

*/

#ifndef lint
static char vcid[] = "$Id: sel_backup.c,v 1.43 1997/08/11 12:32:05 yusuf Exp $";
#endif /* lint */



#include "taper.h"
#include "backup.h"
#include <pwd.h>
#include <grp.h>

select_details  file_sd, select_sd, exclude_sd;
int dir_left_width;

_s8 for_backup(char *s)
{
	/* Checks to see if 's' should be incldued in the backup.
	   Takes into account selections, exclusion and preferences.

	   Returns TRUE if should include
	           FALSE if shuodn't */

    struct selected_entry *se;
    _s32 c;
    _s8 is_sel;
    
    
    se = sel_files;				 /* see if this entry has been selected */
    is_sel = FALSE;
    for (c=0; c<no_sel; c++) {
	if (!strcmp(s, se->i.name)) {
	    is_sel = TRUE;
	    break;
	}
	if (strlen(se->i.name) <= strlen(s)) /* check that whole directory not selected */
	    if (!strncmp(s, se->i.name, strlen(se->i.name))) 
		if (S_ISDIR(se->i.f.mode)) { /* only if a directory */
		    is_sel = TRUE;
		    break;
		}
	se++;
    }
    if (is_sel == FALSE) return FALSE;	 /* not selected */
    if (exclude_archive(s)) return FALSE;	 /* excluded from preferences */
    se = excluded_files;
    for (c=0; c<no_exclude; c++) {
	if (!strcmp(s, se->i.name))		 /* excluded */
	    return FALSE;
	if (strlen(se->i.name) <= strlen(s))
	    if (!strncmp(s, se->i.name, strlen(se->i.name))) 
		if (S_ISDIR(se->i.f.mode))  /* only if a directory */
		    return FALSE;
	se++;
    }
    return TRUE;
}


void backup_asterix_line(WINDOW *win, _s32 ent_num, int line)
{
    struct direntry *entry;
    char       s2[MAX_FNAME];

    entry = directory + ent_num;
    strcpy(s2, global_cur_dir); 
    if (*s2)
      if (s2[strlen(s2)-1] != '/')
      strcat(s2, "/");
    strcat(s2, entry->entry.d_name);
    if (S_ISDIR(entry->info.st_mode))
      strcat(s2, "/");
    mvwaddch(files, line+1, top_left_width-3, ((for_backup(s2) == FALSE) ? ' ' : '*'));
}


void backup_asterix_dir(WINDOW *win, _s32 start, char *p_scroll) {
/* Prints an asterix next to selected entries in the directory */    
    int        cur_line=1;
    _s32       cur_ent;
    
    cur_ent=start;
    while (cur_line < screen_ylen_files-3) {
	backup_asterix_line(win, cur_ent++, cur_line++);
	if (start+cur_line > directory_count)	 /* check that not at end of dir */
	  break;
    }
    wrefresh(win);
}


void backup_print_dir_line(WINDOW *win, _s32 ent_num, int line, char ref) {
/* Prints one entry in a directory at line 'line'  
 * Returns the size of the directory entry in bytes */
    
    struct direntry *entry;
    
    entry = directory + ent_num;
    print_dir_line(win, entry, line, ref, dir_left_width);
    backup_asterix_line(win, ent_num, line);
    centre(bottom, 0, entry->entry.d_name, COLOR_BOTTOM); wrefresh(bottom);
}


void backup_print_dir(WINDOW *win, _s32 start, char *p_scroll) {
/* This function prints the current directory into the left hand
 * window. It starts printing the directory at entry 'start'.
 * 
 * cur_dir is the name of the current directory, which is printed
 * at the top line of the screen
 * 
 * Format of an entry is:
 *   *name rwxrwxrwx 99999K
 * 
 * where * = ' ', '/' or '@' depending on file type 
*/
    int        cur_line=1;
    _s32       cur_ent;
    _s32       dsize=0;
    char       s[MAX_FNAME];
    struct direntry *entry;
    
    my_werase(win, COLOR_DIRECTORY);
    cur_ent=start;
    while (cur_line < dir_screen_ylen-2) {
	backup_print_dir_line(win, cur_ent, cur_line, FALSE);/* print line */
	cur_line++;				 /* increment */
	cur_ent++;
	if (start+cur_line > directory_count) /* check that not at end of dir */
	    break;
    }
    *p_scroll = 0;
    print_scroll_bar(win, directory_count, &dir_sd, win->_maxy,
		     win->_maxx, p_scroll);
    wattron(win, A_UNDERLINE); 
    entry=directory;				 /* calculate size of directory */
    for (cur_line=1; cur_line<=directory_count;cur_line++) {
	if (S_ISREG(entry->info.st_mode))	
	  dsize += entry->info.st_size;		 /* only reg files have a size */
	entry++;
    }
    convert(s, dsize);				 /* print dir size at right */
    mvwaddstr(win, 1, win->_maxx-strlen(s)-1, s);
    if (strlen(global_cur_dir) > win->_maxx-strlen(s)-2) {
	strcpy(s, &global_cur_dir[strlen(global_cur_dir)-(win->_maxx-strlen(s)-1)+2]);
	s[0] = '~';
    }
    else
      strcpy(s, global_cur_dir);
    mvwaddstr(win, 1, 1, s);
    wattroff(win, A_UNDERLINE);
}

void backup_print_selected_line(WINDOW *win, _s32 entry, int line, char ref) {
    
    struct selected_entry *s;
    char   s1[50], s2[200], s3[MAX_FNAME];

    s = sel_files + entry;
    switch(s->selected) {
       case 1:
	   sprintf(s2, "F   %9s %s ", (size_dirs) ? pr_size(s1, s->i.f.size) : "",
		   trunc_filename(s->i.name, s3, win->_maxx-24));
	break;
       case 2:
       case 3:
  	  sprintf(s2, "F ( %9s %s)", (size_dirs) ? pr_size(s1, s->i.f.size) : "",
		  trunc_filename(s->i.name, s3, win->_maxx-24));
	break;
    }
    if (s->incremental) *s2 = 'I';
    mvwaddstr(win, line+1, 5, s2);
    centre(bottom, 0, s->i.name, COLOR_BOTTOM); wrefresh(bottom);
    if (ref)
      wrefresh(win);
}


void backup_print_selected_size(WINDOW *win)
{
    char  s1[100], s[50];
    
    sprintf(s1, "Selected files %s", (size_dirs) ? pr_size(s, total_selected) : "N/A");
    wattron(win, A_UNDERLINE); 
    mvwaddstr(win, 1, 3, s1);
    wattroff(win, A_UNDERLINE);
}

void backup_print_selected(WINDOW *win, _s32 top_sel, char *p_scroll) {
    _s32   cur;

    my_werase(win, COLOR_SELECTED);
    backup_print_selected_size(win);
    cur=1;
    while ((cur < screen_ylen_selection-2) && (top_sel+cur-1 < no_sel)) {
	backup_print_selected_line(win, top_sel+cur-1, cur, FALSE);
	cur++;
    }
    *p_scroll = 0;
    print_scroll_bar(win, no_sel, &select_sd, win->_maxy,
		     win->_maxx, p_scroll);
    wrefresh(win);
}


void backup_print_exclude_size(WINDOW *win)
{
    char  s1[100], s[50];
    
    sprintf(s1, "Excluded files %s", (size_dirs) ? pr_size(s, total_excluded) : "N/A");
    wattron(win, A_UNDERLINE); 
    mvwaddstr(win, 1, 3, s1);
    wattroff(win, A_UNDERLINE);
}


void backup_print_exclude_line(WINDOW *win, _s32 entry, int line, char ref) {
    
    struct selected_entry *s, *se;
    _s32 c;
    char   s1[50], s2[200], s3[MAX_FNAME];

    s = excluded_files + entry;
    switch(s->selected) {
       case 1:
	   sprintf(s2, "    %9s %s ", (size_dirs) ? pr_size(s1, s->i.f.size) : "",
		   trunc_filename(s->i.name, s3, win->_maxx-24));
	break;
       case 2:
       case 3:
  	  sprintf(s2, "  ( %9s %s)", (size_dirs) ? pr_size(s1, s->i.f.size) : "",
		  trunc_filename(s->i.name, s3, win->_maxx-24));
	break;
    }
    se = sel_files;				 /* see if this is excluded */
    for (c=0; c<no_sel; c++) {
	if (!strcmp(se->i.name, s->i.name)) {
	    *s2 = '*';
	    break;
	}
	if (strlen(se->i.name) <= strlen(s->i.name)) /* check that whole directory not selected */
	    if (!strncmp(s->i.name, se->i.name, strlen(se->i.name))) 
		if (S_ISDIR(se->i.f.mode)) { /* only if a directory */
		    *s2 = '*';
		    break;
		}
	se++;
    }
    mvwaddstr(win, line+1, 5, s2);
    centre(bottom, 0, s->i.name, COLOR_BOTTOM); wrefresh(bottom);
    if (ref)
      wrefresh(win);
}


void backup_print_exclude(WINDOW *win, _s32 top_sel, char *p_scroll) {
    _s32   cur;

    my_werase(win, COLOR_EXCLUDED);
    backup_print_exclude_size(win);
    cur=1;
    while ((cur < screen_ylen_selection-2) && (top_sel+cur-1 < no_exclude)) {
	backup_print_exclude_line(win, top_sel+cur-1, cur, FALSE);
	cur++;
    }
    *p_scroll = 0;
    print_scroll_bar(win, no_exclude, &exclude_sd, win->_maxy,
		     win->_maxx, p_scroll);
    wrefresh(win);
}


_s32 sz;
_errstat sel_backup_dpd(char *full_path, struct stat *b)
{
    sz += b->st_size;
    return 0;
}
_s32 get_dirsize(WINDOW *mes, int ln, char *full_dir, char inc)
{
/* gets the size of the directory and all it's contents
   if inc == 1, then incremental size is used
 * 
 * any errors received are ignored
*/

    sz = 0;
    if (process_dir(mes, ln, full_dir, inc, sel_backup_dpd, FALSE) == -1)
      return -1;
    return sz;
}


_errstat recalculate_size(struct selected_entry *se, int printbox, _s8 inc_or_exc)
{
/* Returns -1 if user aborted the recalc */    
    _s32 old_size, sz;
    WINDOW *s_box=NULL;
    char   s[MAX_FNAME];

    if (!size_dirs) return 0;
    old_size = se->i.f.size;
    strcpy(s, "Sizing "); strcat(s, se->i.name);
    if (printbox && !no_windows) s_box=status_box(s_box, s, 1, TRUE, 1);
    sz = get_dirsize(s_box, 1, se->i.name, se->incremental);   
    if (printbox) close_statusbox(s_box);
    if (sz != -1) { 				 /* aborted directory sizing */
	se->i.f.size = sz;
	if (inc_or_exc == ENTRY_INCLUDE) 
	    total_selected += se->i.f.size-old_size;
	else
	    total_excluded += se->i.f.size-old_size;
	return 0;
    }
    return -1;
}


int select_entry_1(struct direntry *entry, char *s)
{
/* Returns 1 if added the entry,
 * Returns 0 if entry existed */
    struct selected_entry *se, *se1;
    _s32   c=0;
	  
    se = sel_files;
    while (c < no_sel)  {
	if (!strcmp(s, se->i.name)) {
	    bmessage_box("File already selected.", MB_OK);
	    return 0;
	}
	c++; se++;
    }
    if (exclude_archive(s)) {
	bmessage_box("This file is on the file exclusion list", MB_OK);
	return 0;
    }

    no_sel++;
    sel_files = my_realloc(sel_files, no_sel*sizeof(struct selected_entry));
    se = sel_files+no_sel-1;

    se->i.f.act_size = 0;
    se->i.f.dev = entry->info.st_dev;		
    se->i.f.uid  = entry->info.st_uid;
    se->i.f.gid = entry->info.st_gid;
    se->i.f.mode = entry->info.st_mode;
    se->i.f.org_mode = entry->org_info.st_mode;
    se->i.f.atime = entry->info.st_atime;
    se->i.f.ctime = entry->info.st_ctime;
    se->i.f.mtime  = entry->info.st_mtime;
    se->i.f.name_len = make4len(s);
    se->selected = 1;
    strcpy(se->i.name, s);
    se->incremental = incremental;

    se->i.f.size = 0;				 /* this will be calculated below */
    if (recalculate_size(se, 1, ENTRY_INCLUDE) == -1) {
	no_sel--;
	return 0;
    }
    if (!S_ISDIR(se->i.f.mode)) {
	se1 = sel_files;			 /* make sure that this */
	for (c=0; c<no_sel; c++) {		 /* file is not going to  */
	    if (!strcmp(se1->i.name, se->i.name))
	      continue;
	    if ( (strlen(se1->i.name) < strlen(se->i.name)) &&   /* be indirectly */
		(se1->i.name[strlen(se1->i.name)-1] == '/') )   /* selected */
	      if (!strncmp(se1->i.name, se->i.name, strlen(se1->i.name))) {
		  se->selected = 3;
		  total_selected -= se->i.f.size;
		  return 1;
	      }
	    se1++;
	}
	return 1;
    }
    se1 = sel_files;				 
    for (c=0; c<no_sel; c++) {			 /* now go through all selected */
	if (strlen(se->i.name) < strlen(se1->i.name)) /* files checking for duplicate selections */
	  if (!strncmp(se1->i.name, se->i.name, strlen(se->i.name))) {
	    switch(se1->selected) {
	       case 0:
		se1->selected = 2; break;
	       case 1:
		se1->selected = 3; break;
	    }
	    total_selected -= se1->i.f.size;	 /* don't double size the entry */
	}
	se1++;
    }
    return 1;
}


int select_entry_plain(_s32 cur_entry) {
/* Adds the 'cur_entry' entry into the select files. If a directory,
 * confirms with user that the whole subdirectory tree is to be
 * included
 * 
 * Returns 1 if entry added, 0 otherwise
*/
    struct direntry  *entry;
    char   s[MAX_FNAME];

    entry = directory + cur_entry;
    if (!strcmp(entry->entry.d_name, "..")) {
	beep();
	return 0;
    }
    if (dir_selection)
      if (S_ISDIR(entry->info.st_mode)) 
        if (!bmessage_box("Is a directory. Confirm?", MB_YESNO))
          return 0;
    strcpy(s, global_cur_dir); 
    if (s[strlen(s)-1] != '/')
      strcat(s, "/"); 
    strcat(s, entry->entry.d_name);
    if (S_ISDIR(entry->info.st_mode))
      if (s[strlen(s)-1] != '/')
	strcat(s, "/"); 
    return select_entry_1(entry, s);
}


int select_entry_regexp(_s32 cur_entry)
{
    /* User wants to filter this with a reg exp */
    struct direntry  *entry;
    char   rg[MAX_REGEXP];
    
    entry = directory + cur_entry;
    if (!strcmp(entry->entry.d_name, "..")) {
	beep();
	return 0;
    }
    if (!S_ISDIR(entry->info.st_mode))
	select_entry_plain(cur_entry); /* only regexp directories */
    
    get_string(win_main, rg, MAX_REGEXP, "Enter regexp");
    return 0;
}



int exclude_entry_1(struct direntry *entry, char *s)
{
/* Returns 1 if added the entry,
 * Returns 0 if entry existed */
    struct selected_entry *se, *se1;
    _s32   c=0;
	  
    se = excluded_files;
    while (c < no_exclude)  {
	if (!strcmp(s, se->i.name)) {
	    bmessage_box("File already excluded.", MB_OK);
	    return 0;
	}
	c++; se++;
    }
    if (exclude_archive(s)) {
	bmessage_box("This file is on the file exclusion list", MB_OK);
	return 0;
    }

    no_exclude++;
    excluded_files = my_realloc(excluded_files, no_exclude*sizeof(struct selected_entry));
    se = excluded_files+no_exclude-1;

    se->i.f.act_size = 0;
    se->i.f.dev = entry->info.st_dev;		
    se->i.f.uid  = entry->info.st_uid;
    se->i.f.gid = entry->info.st_gid;
    se->i.f.mode = entry->info.st_mode;
    se->i.f.org_mode = entry->org_info.st_mode;
    se->i.f.atime = entry->info.st_atime;
    se->i.f.ctime = entry->info.st_ctime;
    se->i.f.mtime  = entry->info.st_mtime;
    se->i.f.name_len = make4len(s);
    se->selected = 1;
    strcpy(se->i.name, s);
    se->incremental = incremental;

    se->i.f.size = 0;				 /* this will be calculated below */
    if (recalculate_size(se, 1, ENTRY_EXCLUDE) == -1) {
	no_exclude--;
	return 0;
    }
    if (!S_ISDIR(se->i.f.mode)) {
	se1 = excluded_files;			 /* make sure that this */
	for (c=0; c<no_exclude; c++) {		 /* file is not going to  */
	    if (!strcmp(se1->i.name, se->i.name))
	      continue;
	    if ( (strlen(se1->i.name) < strlen(se->i.name)) &&   /* be indirectly */
		(se1->i.name[strlen(se1->i.name)-1] == '/') )   /* selected */
	      if (!strncmp(se1->i.name, se->i.name, strlen(se1->i.name))) {
		  se->selected = 3;
		  total_excluded -= se->i.f.size;
		  return 1;
	      }
	    se1++;
	}
	return 1;
    }
    se1 = excluded_files;				 
    for (c=0; c<no_exclude; c++) {			 /* now go through all selected */
	if (strlen(se->i.name) < strlen(se1->i.name)) /* files checking for duplicate selections */
	  if (!strncmp(se1->i.name, se->i.name, strlen(se->i.name))) {
	    switch(se1->selected) {
	       case 0:
		se1->selected = 2; break;
	       case 1:
		se1->selected = 3; break;
	    }
	    total_excluded -= se1->i.f.size;	 /* don't double size the entry */
	}
	se1++;
    }
    return 1;
}


int exclude_entry_plain(_s32 cur_entry)
{
    /* User wants to exclude this from backup */
    struct direntry  *entry;
    char   s[MAX_FNAME];

    entry = directory + cur_entry;
    if (!strcmp(entry->entry.d_name, "..")) {
	beep();
	return 0;
    }
    if (dir_selection)
      if (S_ISDIR(entry->info.st_mode)) 
        if (!bmessage_box("Is a directory. Confirm?", MB_YESNO))
          return 0;
    strcpy(s, global_cur_dir); 
    if (s[strlen(s)-1] != '/')
      strcat(s, "/"); 
    strcat(s, entry->entry.d_name);
    if (S_ISDIR(entry->info.st_mode))
      if (s[strlen(s)-1] != '/')
	strcat(s, "/"); 
    return exclude_entry_1(entry, s);
}


int exclude_entry_regexp(_s32 cur_entry)
{
    /* User wants to filter this with a reg exp */
    struct direntry  *entry;
    char   rg[MAX_REGEXP];
    
    entry = directory + cur_entry;
    if (!strcmp(entry->entry.d_name, "..")) {
	beep();
	return 0;
    }
    if (!S_ISDIR(entry->info.st_mode))
	exclude_entry_plain(cur_entry); /* only regexp directories */
    
    get_string(win_main, rg, MAX_REGEXP, "Enter regexp");
    return 0;
}


void backup_update_exclude(void)
{
/* Goes through archive and works out indirect selections 
   for sel_backup */

    _s32 c, c1;
    struct selected_entry *cur_ent, *se;

    cur_ent = excluded_files;			 /* clear current selection */
    total_excluded = 0;				 /* information */
    for (c=0; c<no_exclude; c++) {			 
	switch(cur_ent->selected) {
	   case 2:
	    cur_ent->selected=0; break;
	   case 3:
	    cur_ent->selected=1; break;
	}
	cur_ent++;
    }

    cur_ent = excluded_files;
    for (c=0; c<no_exclude; c++) {
	if ((cur_ent->selected == 1) || (cur_ent->selected == 4)) /* update total_selected size */
	    total_excluded += cur_ent->i.f.size;
	if (S_ISDIR(cur_ent->i.f.mode)) {	 /* only bother if directory */
	    se=excluded_files;
	    for (c1=0; c1<no_exclude; c1++) {	 /* loop through looking for */
		if (c1 != c) {		 /* dependencies */
		    if (strlen(cur_ent->i.name) <= strlen(se->i.name))
			if (!strncmp(cur_ent->i.name, se->i.name, strlen(cur_ent->i.name)))
			    switch(se->selected) {	 /* matches */
			    case 0:
				se->selected = 2; break;
			    case 1:
				se->selected = 3; break;
			    case 4:
				se->selected = 5; break;
			    }
		}
		se++;
	    }
	}
	cur_ent++;
    }
}



void backup_update_selected(void)
{
/* Goes through archive and works out indirect selections 
   for sel_backup */

    _s32 c, c1;
    struct selected_entry *cur_ent, *se;

    cur_ent = sel_files;			 /* clear current selection */
    total_selected = 0;				 /* information */
    for (c=0; c<no_sel; c++) {			 
	switch(cur_ent->selected) {
	   case 2:
	    cur_ent->selected=0; break;
	   case 3:
	    cur_ent->selected=1; break;
	}
	cur_ent++;
    }

    cur_ent = sel_files;
    for (c=0; c<no_sel; c++) {
	if ((cur_ent->selected == 1) || (cur_ent->selected == 4)) /* update total_selected size */
	    total_selected += cur_ent->i.f.size;
	if (S_ISDIR(cur_ent->i.f.mode)) {	 /* only bother if directory */
	    se=sel_files;
	    for (c1=0; c1<no_sel; c1++) {	 /* loop through looking for */
		if (c1 != c) {		 /* dependencies */
		    if (strlen(cur_ent->i.name) <= strlen(se->i.name))
			if (!strncmp(cur_ent->i.name, se->i.name, strlen(cur_ent->i.name)))
			    switch(se->selected) {	 /* matches */
			    case 0:
				se->selected = 2; break;
			    case 1:
				se->selected = 3; break;
			    case 4:
				se->selected = 5; break;
			    }
		}
		se++;
	    }
	}
	cur_ent++;
    }
}



int backup_toggle_selected(_s32 cur_entry)
{
/* Toggles selection between incremental & non-incremental mode */

    struct selected_entry *se;

    se = sel_files+cur_entry;
    se->incremental = !se->incremental;
    if (recalculate_size(se, 1, ENTRY_INCLUDE) == -1)
      se->incremental = !se->incremental;	 /* user aborted - restore */
    backup_print_selected_size(selection);
    return 0;
}


void back_ed(select_details *sd)
{
    /* Prints details about an entry */

    struct direntry *entry;
    char  lns[][150]={"Name          : ",
			"File type     : ",
			"Size          : ",
			"",
			"Permissions   : ",
		        "Owner         : ",
			"Group         : ",
			"",
			"Last modified : ",
			"Last access   : ",
			""};

    char s[200];
    struct passwd *p;
    struct group *g;

    entry = directory + sd->cur_entry;
    strcat(lns[0], global_cur_dir); 
    if (*lns[0])
	if (lns[0][strlen(lns[0])-1] != '/')
	    strcat(lns[0], "/");
    strcat(lns[0], entry->entry.d_name);
    if (S_ISDIR(entry->info.st_mode))
	strcat(lns[0], "/");
    if (S_ISDIR(entry->info.st_mode))
	strcat(lns[1], "Directory");
    if (S_ISREG(entry->info.st_mode))
	strcat(lns[1], "Regular File");
    if (S_ISLNK(entry->info.st_mode))
	strcat(lns[1], "Link");
    if (S_ISCHR(entry->info.st_mode))
	strcat(lns[1], "Character device");
    if (S_ISBLK(entry->info.st_mode))
	strcat(lns[1], "Block device");
    if (S_ISSOCK(entry->info.st_mode))
	strcat(lns[1], "Socket");
    if (S_ISFIFO(entry->info.st_mode))
	strcat(lns[1], "FIFO");
    (S_ISREG(entry->info.st_mode)) ? strcat(lns[2], (convert(s, entry->info.st_size))) :
	                             strcat(lns[2], "-");
    strcat(lns[4], (make_permstring(s, entry->info.st_mode)));

    p = getpwuid(entry->info.st_uid); strcat(lns[5], p->pw_name);
    g = getgrgid(entry->info.st_gid); strcat(lns[6], g->gr_name);

    strcat(lns[8], ctime(&entry->info.st_mtime)); lns[8][strlen(lns[8])-1] = 0;
    strcat(lns[9], ctime(&entry->info.st_atime)); lns[9][strlen(lns[9])-1] = 0;
    multi_message_box(lns, 11, MB_OK, FALSE);
}


void backup_del_cur_selected_entry_engine(_s32 entry)
{
    int c;
    mode_t mode;


    mode = (sel_files+entry)->i.f.mode;
    no_sel--;
    for (c=entry; c<no_sel; c++)
	*(sel_files+c) = *(sel_files+c+1);
    backup_update_selected();
    backup_print_selected_size(selection);
}
    
void backup_del_cur_selected_entry(select_details *sd, _s32 *no_sel)
{
    backup_del_cur_selected_entry_engine(sd->cur_entry);
}
    



void backup_del_cur_exclude_entry_engine(_s32 entry)
{
    int c;
    mode_t mode;


    mode = (excluded_files+entry)->i.f.mode;
    no_exclude--;
    for (c=entry; c<no_exclude; c++)
	*(excluded_files+c) = *(excluded_files+c+1);
    backup_update_exclude();
    backup_print_exclude_size(selection);
}
    
void backup_del_cur_exclude_entry(select_details *sd, _s32 *no_sel)
{
    backup_del_cur_exclude_entry_engine(sd->cur_entry);
}
    



void backup_save_backupset(int in_backup)
{
    backrest_save_backupset(1);
}
  

void backup_restore_backupset(void)
{
    char ln[MAX_FNAME];
    FILE *f;
    struct direntry entry;
    char x[MAX_FNAME];
    char *x1;
    int x2;
    _s8 inc_or_exc;

    x2 = dir_screen_ylen;
    getcwd(x, sizeof(x));
    x1 = global_cur_dir;
    f = backrest_restore_backupset(NULL);
    global_cur_dir = x1;
    chdir(x);
    dir_screen_ylen = x2;
    strcpy(global_cur_dir, x);
    if (f==NULL) 
	return;
    while (!feof(f)) {
	if (get_line(ln, f) == NULL) break;	 /* EOF */
	if ((*ln != 'E') && (*ln != 'I')) {
	    do_exit(ERROR_ILLEGALBACKUPSET);
	    break;
	}
	inc_or_exc = (*ln == 'I') ? ENTRY_INCLUDE : ENTRY_EXCLUDE;
	if (get_line(ln, f) == NULL) break;
	if (chk_sel_excl(ln)) {
	    strcat(ln, " already selected");
	    bmessage_box(ln, MB_OK);
	    break;
	}
	else {
	    if (get_statinfo(ln, &entry.info) != -1) {/* ignore if error */
		if (inc_or_exc == ENTRY_INCLUDE)
		    select_entry_1(&entry, ln);
		else
		    exclude_entry_1(&entry, ln);
	    }
	}
    }
    fclose(f);
}

int backup_select_vol(_s32 entry)
{
/* Tag an entry in the volume window */    
    _s32 c=0;
    struct direntry c_entry;
    char *s;
    char s1[MAX_FNAME];
    _s8 inc_or_exc;
    
    s = vol_details;				 /* find appropriate */
    while (c++<entry)				 /* line in vol_details buffer */
      while (*s++);

    if (!strncmp(s, "Volume ", strlen("Volume ")) ||   /* don't use this */
	!strncmp(s, "Contains ", strlen("Contains ")) ||
	!strncmp(s, "Backed up at ", strlen("Backed up at ")) ) 
	    return 0;

    strcpy(s1, s);
    inc_or_exc = (*s1 == '!') ? ENTRY_EXCLUDE : ENTRY_INCLUDE;
    if (inc_or_exc == ENTRY_EXCLUDE)		 /* remove preceeding ! */
	strcpy(s1, s+1);
    if (lstat(s1, &c_entry.info) != -1) {	 /* ignore if error */
	if (inc_or_exc == ENTRY_EXCLUDE)
	    return exclude_entry_1(&c_entry, s1);
	else
	    return select_entry_1(&c_entry, s1);
    }
    if (errno == ENOENT) {
	sprintf(s1, "%s doesn't exist", s);
	bmessage_box(s1, MB_OK);
    }
    return 0;
}

void backup_unselect_dir(select_details *sd, _s32 *dummy)
{
    struct direntry *entry;
    char       s2[MAX_FNAME];
    struct selected_entry *se;
    int    c;
    char   c1=' ';

    entry = directory + sd->cur_entry;
    strcpy(s2, global_cur_dir);        /* make full pathname */
    if (*s2)
      if (s2[strlen(s2)-1] != '/')
      strcat(s2, "/");
    strcat(s2, entry->entry.d_name);
    if (S_ISDIR(entry->info.st_mode))
      strcat(s2, "/");
    se = sel_files;		       /* see if this entry has been selected */
    for (c=0; c<no_sel; c++) {
	if (!strcmp(s2, se->i.name)) {
	    c1 = '*';		       /* file is selected */
	    break;
	}
	if (strlen(se->i.name) <= strlen(s2))/* check that whole directory not selected */
	  if (!strncmp(s2, se->i.name, strlen(se->i.name))) {
	      c1 = '!';		       /* file is indirectly selected */
	      break;
	  }
	se++;
    }
    if (!S_ISDIR(entry->info.st_mode)) /* see if it will be excluded */
      if (exclude_archive(s2))
        c1 = ' ';
    switch(c1) {
     case ' ':
	bmessage_box("File not selected", MB_OK);
	break;
     case '!':
	bmessage_box("Indirectly selected. Use exclude", MB_OK);
	break;
     case '*':
	backup_del_cur_selected_entry_engine(c);/* delete entry */
	break;
    }
}




void add_root(struct direntry **dir, _s32 *dircount)
{
/*  Makes sure that a '..' directory entry exists and if it
    doesn't, adds it

    Returns nothing

*/
  _s32 c=0;
  struct direntry *d;


  d = *dir;
  while (c<*dircount) {
    if (!strcmp(d->entry.d_name, "..")) return;	 /* OK  */
    c++;
    d++;
  }
  /* no .. entry - add one */
  
  *dir = my_realloc((void *) *dir, sizeof(struct direntry)    
		    * ((*dircount)+1));		 /* make memory */
  for (c=*dircount-1; c>=0; c--)		 /* add this entry at top */
    *(*dir+c+1) = *(*dir+c);
  strcpy((*dir)->entry.d_name, "..");		 /* add the .. entry */
  (*dir)->org_info.st_mode = S_IFDIR;
  (*dircount)++;
}


int backup_select_files(char *cur_dir) {
/* Returns 0 if quit
 * Returns 1 if wants to backup
*/
    int   ret;
    char  p=0;
    char  old_dir[MAX_FNAME];
    _s32  c, oe;
    char ssearch[MAX_FNAME];
    struct stat statb;

    *ssearch=0;
    dir_left_width = top_left_width;		 /* for directory routines */
    dir_screen_ylen = screen_ylen_files;
    directory_count = 0;
    global_cur_dir = cur_dir;			 /* to allow global use */
    if (read_dir(cur_dir, "", NULL,
		 &directory, &directory_count) == -1) return -1; /* read in directory */
    clear_sd(&dir_sd);
    clear_sd(&select_sd);
    clear_sd(&exclude_sd);
    clear_sd(&vol_sd);

    backup_print_selected(selection, select_sd.top_entry, &p); /* print selections  */
    backup_print_exclude(exclude, exclude_sd.top_entry, &p); /* print selections  */
    p=0;
    print_on_vol_dir(on_vol, vol_sd.top_entry, &p);	/* print files currenty on volume */

    while (1) {
	ret = select_box(files, &directory_count, &dir_sd,
			 backup_print_dir, backup_print_dir_line,
			 select_entry_plain, select_entry_regexp, 
			 backup_unselect_dir, backrest_paint, back_ed,
			 selection, &no_sel, &select_sd, backup_print_selected,
			 exclude, &no_exclude, &exclude_sd, backup_print_exclude,
			 NULL, NULL,
			 "Select file/directory for backup", 
			 backup_save_backupset, 
			 backup_restore_backupset, TRUE, TRUE,
			 exclude_entry_plain, exclude_entry_regexp, "Exclude file/directory from backup");
	switch(ret) {
	 case SELECT_ABORT:
	    return 0;
	 case SELECT_FINISHED:
	    return 1;
	case SELECT_SEARCH:
		if (get_string(win_main, ssearch, sizeof(ssearch), "Enter entry to search for")) {
		    oe=dir_sd.cur_entry+1;	 /* don't search current */
		    c=oe;
		    while (c<directory_count) {
			if (strstr((directory+c)->entry.d_name, ssearch))
			    break;
			c++;
		    }
		    if (c<directory_count) {
			adjust_cur_entry(files, &dir_sd, backup_print_dir, &p, &directory_count, c);
			break;
		    }
		    if (oe) 
			if (message_box("Continue searching from beginning", MB_YESNO)) {
			    c=0;
			    while (c<oe) {
				if (strstr((directory+c)->entry.d_name, ssearch))
				    break;
				c++;
			    }
			    if (c<oe)
				adjust_cur_entry(files, &dir_sd, backup_print_dir, &p, &directory_count, c);
			    else
				message_box("Not found", MB_OK);
			}
		}
		backrest_paint();
		break;
	 case SELECT_TAB:
	    if (no_sel) 
	      ret =select_box(selection, &no_sel, &select_sd,
			      backup_print_selected, 
			      backup_print_selected_line, backup_toggle_selected,
			      backup_toggle_selected,
			      backup_del_cur_selected_entry, backrest_paint, NULL,
			      selection, &no_sel, &select_sd,
			      backup_print_selected,
			      exclude, &no_exclude, &exclude_sd,
			      backup_print_exclude,
			      backup_asterix_dir, &dir_sd,
			      "Change to/from incremental backup",
			      backup_save_backupset, 
			      backup_restore_backupset, FALSE, FALSE,
			      NULL, NULL, NULL);
	    switch(ret) {
	     case SELECT_ABORT:
		return 0;
	     case SELECT_FINISHED:
		return 1;
	     case SELECT_TAB:
		if (no_vol_details)		 /* if nothing in vol, will  */
		  ret = select_box(on_vol, &no_vol_details, &vol_sd,   /* fall through as SELECT_TAB */
				   print_on_vol_dir,
				   print_on_voldir_line, backup_select_vol,
				   backup_select_vol, NULL,
				   backrest_paint, NULL,
				   selection, &no_sel,
				   &select_sd, backup_print_selected,
				   exclude, &no_exclude, &exclude_sd, backup_print_exclude,
				   NULL, NULL, "Backup file/directory",
				   backup_save_backupset, 
				   backup_restore_backupset, FALSE, FALSE,
				   NULL, NULL, NULL);
		switch(ret) {
		 case SELECT_ABORT:
		    return 0;
		 case SELECT_FINISHED:
		    return 1;
		case SELECT_TAB:
		    if (no_exclude) 
			ret =select_box(exclude, &no_exclude, &exclude_sd,
					backup_print_exclude, 
					backup_print_exclude_line, NULL,
					NULL,
					backup_del_cur_exclude_entry, backrest_paint, NULL,
					selection, &no_sel,
					&select_sd, backup_print_selected,
					exclude, &no_exclude,
					&exclude_sd, backup_print_exclude,
					backup_asterix_dir, &dir_sd,
					"",
					backup_save_backupset, 
					backup_restore_backupset, FALSE, FALSE,
					NULL, NULL, NULL);
		    switch(ret) {
		    case SELECT_ABORT:
			return 0;
		    case SELECT_FINISHED:
			return 1;
		    default:
			break;
		    }
		}
	    }
	    break; 
	 case SELECT_ENTER:
	    if (S_ISDIR((dir_sd.cur_entry+directory)->org_info.st_mode)) {
		*old_dir = 0;
		if (!strcmp((directory+dir_sd.cur_entry)->entry.d_name, "..")) {
		  if (strcmp(cur_dir, "/"))
		      strcpy(old_dir, cur_dir);
		  else {			 /* top dir only */
		    directory = my_realloc(directory, sizeof(struct direntry));
		    strcpy(directory->entry.d_name, ""); /* add the .. entry */
		    directory->org_info.st_mode = S_IFDIR;
		    directory_count = 1;
		    strcpy(cur_dir, ""); strcpy(old_dir, "..");
		    goto madedir;
		  }
		}
		strcat(cur_dir, "/");
		strcat(cur_dir, (directory+dir_sd.cur_entry)->entry.d_name);
		ret = read_dir(cur_dir, "", NULL,
			       &directory, &directory_count);
		add_root(&directory, &directory_count);
		if (ret == -1) return -1;
		if (ret == 0)
		  getcwd(cur_dir, MAX_FNAME);		
		else {
		    clear_sd(&dir_sd);
		    if (old_dir)
		      find_correct_sd(old_dir,&dir_sd, directory_count,
				      directory);
		}
	    madedir:;
		p=0;
		backup_print_dir(files, dir_sd.top_entry, &p);
		p=0;
		backup_print_selected(selection, select_sd.top_entry, &p); 
	    }
	    break;
	case SELECT_GOTO:
		if (get_string(win_main, ssearch, sizeof(ssearch), "Enter directory to go to")) 
		    if ((stat(ssearch, &statb) == -1) || !S_ISDIR(statb.st_mode)) 
			message_box("Unable to find directory", MB_OK);
		    else {
			strcpy(old_dir, cur_dir);
			strcpy(cur_dir, ssearch);
			ret = read_dir(cur_dir, "", NULL,
				       &directory, &directory_count);
			add_root(&directory, &directory_count);
			if (ret == -1) return -1;
			if (ret == 0)
			    getcwd(cur_dir, MAX_FNAME);		
			else 
			    clear_sd(&dir_sd);
			backrest_paint();
			goto madedir;
		    }
		backrest_paint();
		break;
	default:
	    break;
	}
    }
    return 0; /* never get here */
}
